class DefaultEventhandlers;	// External class reference

class CfgPatches
{
	class JSDF_Type73APC
	{
		units[] = {"Type73APC"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {"JSDF"};
	};
};
class WeaponFireGun;	// External class reference
class WeaponCloudsGun;	// External class reference
class WeaponFireMGun;	// External class reference
class WeaponCloudsMGun;	// External class reference

class FDustEffects_none {};

class CfgVehicles
{
	class Land;				// External class reference
	class LandVehicle 			: Land {};
	class Tank 				: LandVehicle {};
	class JSDF_Tank 			: Tank
	{
		class Turrets;			// External class reference
		class NewTurret;		// External class reference
		class MainTurret;		// External class reference
		class ViewOptics;		// External class reference
		class CommanderOptics;		// External class reference
		class HitPoints;		// External class reference
		class AnimationSources;		// External class reference
		class Sounds;			// External class reference
	};
	class JSDF_APC 				: JSDF_Tank {};

	class JSDF_Type73APC 			: JSDF_APC
	{
		scope 				= 2;
		faction 			= JGSDF;
		displayName 			= Type73 APC;
		model 				= "\jsdf_vla\t73APC\JGSDF_Type73APC_B2";
		icon 				= "\jsdf_vla\t73APC\icomap_t73APC_ca.paa";
		picture 			= "\jsdf_vla\t73APC\ico_t73APC_ca.paa";
		mapSize 			= 9;
		accuracy 			= 0.7;
		threat[] 			= {1, 1, 0.3};
		armor 				= 130;
		damageResistance 		= 0.01168;
		cost 				= 4000000;

		irScanRangeMin			= 0;
		irScanRangeMax			= 0;

		maxSpeed 			= 60;
		transportSoldier 		= 9;

		tracksSpeed 			= 2.5;

		forceHideDriver			= 0;
		driverForceOptics 		= 0;
		driverAction 			= "BMP3_Driver_OUT";
		driverInAction 			= "BMP3_Driver";
		memoryPointsGetInDriver 	= "pos cargo";
		memoryPointsGetInDriverDir 	= "pos cargo dir";
		class Turrets: Turrets
		{
			class Gunner_Turret			: NewTurret
			{
				proxyType			= CPGunner;
				proxyIndex			= 1;
				gunnerName			= gunner;
				primaryGunner			= 1;
				primaryObserver			= 0;

				body				="obsTurret";
				gun				="obsGun";
				animationSourceBody		="obsTurret";
				animationSourceGun		="obsGun";
				animationSourceHatch		="hatchGunner";

				memoryPointGun			="obsgun_muzzle";
				gunBeg				="obsgun_muzzle";
				gunEnd				="obsgun_chamber";
				selectionFireAnim		="zasleh_1";

				minElev= -11;	maxElev=+55;	initElev=0;
				minTurn=-360;	maxTurn=+360;	initTurn=0;

				weapons[]			= {M2};
				magazines[]			= {100Rnd_127x99_M2,100Rnd_127x99_M2,100Rnd_127x99_M2,100Rnd_127x99_M2};//105*8

				stabilizedInAxes 		= 0;
				lockWhenDriverOut		= 0;
				outGunnerMayFire		= 1;
				inGunnerMayFire			= 1;
				forceHideGunner			= 0;
				viewGunnerInExternal		= 1;
				gunnerForceOptics		= 0;
				gunnerAction			= BMP2_GunnerOut;
				gunnerInAction			= BMP2_Gunner;
				gunnerOpticsModel		="\ca\Tracked\optika_M1A1_commander";
				memoryPointGunnerOptics		="Gunnerview";
				memoryPointsGetInGunner		="pos cargo";
				memoryPointsGetInGunnerDir	="pos cargo dir";
				class ViewOptics
				{
					initAngleX=0;	minAngleX= -30;	maxAngleX=+30;
					initAngleY=0;	minAngleY=-100; maxAngleY=+100;
					initFov=0.42;	minFov=0.22; 	maxFov=0.64;
				};
				class ViewGunner
				{
					initAngleX=0;	minAngleX= -60; maxAngleX=+60;
					initAngleY=0;	minAngleY=-100; maxAngleY=+100;
					initFov=0.42;	minFov=0.22; 	maxFov=0.64;
				};
			};
			class Gunner_Front_Turret		: NewTurret
			{
				canHideGunner 			= 1;
				proxyType			= CPGunner;
				proxyIndex			= 2;
				gunnerName			= frontgunner;
				primaryGunner			= 2;
				primaryObserver			= 1;

				body				="MGunTurret";
				gun				="MGun";
				animationSourceBody		="MGunTurret";
				animationSourceGun		="MGun";
				animationSourceHatch		="hatchGunner2";
				gunBeg				="MGun_muzzle";
				gunEnd				="MGun_chamber";

				minElev=-10; maxElev=+10; initElev=0;
				minTurn=-30; maxTurn=+30; initTurn=0;

				weapons[]			= {M1919_veh};
				magazines[]			= {4500Rnd_7_62x63};
				startEngine			= 0;
				stabilizedInAxes 		= 0;
				lockWhenDriverOut		= 0;

				commanding			= 0;
				outGunnerMayFire		= 0;
				inGunnerMayFire			= 1;
				forceHideGunner			= 0;
				viewGunnerInExternal		= 1;
				gunnerForceOptics		= 0;

				gunnerAction			= T72_GunnerOut;
				gunnerInAction			= T72_Gunner;
				gunnerOpticsModel		="\ca\Tracked\optika_M1A1_commander";
				memoryPointGunnerOptics		="Gunner2view";
				memoryPointsGetInGunner		="pos cargo";
				memoryPointsGetInGunnerDir	="pos cargo dir";
				class ViewOptics
				{
					initAngleX=0; 	minAngleX=-30; 	maxAngleX=+30;
					initAngleY=0; 	minAngleY=-100; maxAngleY=+100;
					initFov=0.42; 	minFov=0.22; 	maxFov=0.64;
				};
				class ViewGunner
				{
					initAngleX=0; 	minAngleX=-60; 	maxAngleX=+60;
					initAngleY=0; 	minAngleY=-100; maxAngleY=+100;
					initFov=0.42; 	minFov=0.22; 	maxFov=0.64;
				};
			};
			class CommanderOptics			: NewTurret
			{
				proxyType			= CPCommander;
				proxyIndex			= 1;
				gunnerName			= commander;
				primaryGunner			= 0;
				primaryObserver			= 1;

				body				="";
				gun				="";
				animationSourceBody		="";
				animationSourceGun		="";
				animationSourceHatch		="hatchCommander";

				soundServo[]			={"", db-50, 1.0};
				startEngine			= 0;

				gunBeg				="";
				gunEnd				="";

				minElev=  -4; 	maxElev= +20; 	initElev=0;
				minTurn=-360; 	maxTurn=+360; 	initTurn=0;

				commanding			= 2;
				outGunnerMayFire		= 1;
				inGunnerMayFire			= 1;
				viewGunnerInExternal		= 1;

				gunnerAction			= T72_CommanderOut;
				gunnerInAction			= T72_Commander;
				gunnerOpticsModel		="\ca\Tracked\optika_tank_driver";
				gunnerOutOpticsModel		= \ca\Weapons\optika_empty;
				gunnerOutOpticsColor[]		= {0, 0, 0, 1};
				gunnerOutForceOptics		= 0;
				gunnerOutOpticsShowCursor 	= 0;
				memoryPointGunnerOutOptics	="commander_weapon_view";
				memoryPointGunnerOptics		="commanderview";
				memoryPointsGetInGunner		="pos cargo";
				memoryPointsGetInGunnerDir	="pos cargo dir";
				memoryPointGun			="";
				selectionFireAnim		="";
				class ViewOptics
				{
					initAngleX=0; minAngleX=-30; maxAngleX=+30;
					initAngleY=0; minAngleY=-100; maxAngleY=+100;
					initFov=0.42; minFov=0.22; maxFov=0.64;
				};
				class ViewGunner
				{
					initAngleX=5; minAngleX=-30; maxAngleX=+30;
					initAngleY=0; minAngleY=0; maxAngleY=0;
					initFov=0.42; minFov=0.22; maxFov=0.64;
				};
			};
		};
		class Sounds_t73APC 	: Sounds
		{
			class Engine
			{
				sound[] = {"\jsdf_vla\t73APC\t73AV_eng.wss", 1.77828, 1.0, 1000};
				frequency = "(randomizer*0.05+0.8)*rpm";
				volume = "engineOn*camPos*(rpm factor[0.4, 0.9])";
			};
		};
		
		class Library
		{
			libTextDesc = Type73 APC;
		};
	};
};
