class DefaultEventhandlers;	// External class reference

class CfgPatches
{
	class JSDF_Type60APC
	{
		units[] = {"Type60APC"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {"JSDF"};
	};
};
class WeaponFireGun;	// External class reference
class WeaponCloudsGun;	// External class reference
class WeaponFireMGun;	// External class reference
class WeaponCloudsMGun;	// External class reference

class ViewGunner_JSDF_AV_base {};
class ViewOptics_JSDF_AV_base {};

class FDustEffects_none {};

class CfgVehicles
{
	class Land;				// External class reference
	class LandVehicle 			: Land {};
	class Tank 				: LandVehicle {};
	class JSDF_Tank 			: Tank
	{
		class Turrets;			// External class reference
		class NewTurret;		// External class reference
		class MainTurret;		// External class reference
		class ViewOptics;		// External class reference
		class CommanderOptics;		// External class reference
		class HitPoints;		// External class reference
		class AnimationSources;		// External class reference
		class Sounds;			// External class reference
	};
	class JSDF_APC 				: JSDF_Tank {};
	class JSDF_Type60APC 			: JSDF_APC
	{
		scope 				= 2;
		faction 			= JGSDF;
		displayName 			= Type60 APC;
		model 				= "\jsdf_vla\t60apc\JGSDF_Type60APC_0";
		icon 				= "\jsdf_vla\t60apc\icomap_t60APC_ca.paa";
		picture 			= "\jsdf_vla\t60apc\ico_t60APC_ca.paa";
		mapSize 			= 9;
		accuracy 			= 0.7;
		threat[] 			= {1, 1, 0.3};
		armor 				= 210;
		damageResistance 		= 0.01168;
		cost 				= 4000000;

		irScanRangeMin			= 0;
		irScanRangeMax			= 0;

		maxSpeed 			= 40;
		transportSoldier 		= 7;

		tracksSpeed 			= 2.8;
		wheelCircumference 		= 2.0;
//		hiddenSelections[] 		= {"Camo1", "Camo2"};
//		hiddenSelectionsTextures[] 	= {"\ca\tracked2\aav\data\aav_ext_co.paa", "\ca\tracked2\aav\data\aav_ext2_co.paa"};

		forceHideDriver			= 0;
		driverForceOptics 		= 0;
		driverAction 			= "BMP3_Driver_OUT";
		driverInAction 			= "BMP3_Driver";
		memoryPointsGetInDriver 	= "pos cargo";
		memoryPointsGetInDriverDir 	= "pos cargo dir";
//		proxyType			= CPGunner;
//		proxyIndex			= 1;

		class Turrets: Turrets
		{
			class Gunner_Turret			: NewTurret
			{
				proxyType			= CPGunner;
				proxyIndex			= 1;
				gunnerName			= gunner;
				primaryGunner			= 1;
				primaryObserver			= 0;

				body				="obsTurret";
				gun				="obsGun";
				animationSourceBody		="obsTurret";
				animationSourceGun		="obsGun";
				animationSourceHatch		="hatchGunner";

				memoryPointGun			="obsgun_muzzle";
				gunBeg				="obsgun_muzzle";
				gunEnd				="obsgun_chamber";
				selectionFireAnim		="zasleh_1";

				minElev= -11;	maxElev= +55; 	initElev=0;
				minTurn=-360;	maxTurn=+360; 	initTurn=0;

				weapons[]			= {M2};
				magazines[]			= {100Rnd_127x99_M2,100Rnd_127x99_M2,100Rnd_127x99_M2,100Rnd_127x99_M2};//105*8
				startEngine			= 0;

				stabilizedInAxes 		= 0;
				lockWhenDriverOut		= 0;
				outGunnerMayFire		= 1;
				inGunnerMayFire			= 0;
				forceHideGunner			= 0;
				viewGunnerInExternal		= 1;
				gunnerForceOptics		= 0;
				gunnerAction			= BMP2_GunnerOut;
				gunnerInAction			= BMP2_Gunner;
				gunnerOpticsModel		="\ca\Tracked\optika_M1A1_commander";
				memoryPointGunnerOptics		="Gunnerview";
				memoryPointsGetInGunner		="pos cargo";
				memoryPointsGetInGunnerDir	="pos cargo dir";
				class ViewOptics		: ViewOptics_JSDF_AV_base {};
				class ViewGunner		: ViewGunner_JSDF_AV_base {};
			};
			class Gunner_Front_Turret		: NewTurret
			{
				canHideGunner 			= 1;
				proxyType			= CPGunner;
				proxyIndex			= 2;
				gunnerName			= frontgunner;
				primaryGunner			= 2;
				primaryObserver			= 1;

				body				="MGunTurret";
				gun				="MGun";
				animationSourceBody		="MGunTurret";
				animationSourceGun		="MGun";
				animationSourceHatch		="hatchGunner2";
				gunBeg				="MGun_muzzle";
				gunEnd				="MGun_chamber";

				minElev=-10; maxElev=+10; initElev=0;
				minTurn=-30; maxTurn=+30; initTurn=0;

				weapons[]			= {M1919_veh};
				magazines[]			= {250Rnd_7_62x63, 250Rnd_7_62x63, 250Rnd_7_62x63, 250Rnd_7_62x63, 250Rnd_7_62x63, 250Rnd_7_62x63};//250*6
				startEngine			= 0;
				stabilizedInAxes 		= 0;
				lockWhenDriverOut		= 0;

				commanding			= 0;
				outGunnerMayFire		= 0;
				inGunnerMayFire			= 1;
				forceHideGunner			= 0;
				viewGunnerInExternal		= 1;
				gunnerForceOptics		= 0;

				gunnerAction			= T72_GunnerOut;
				gunnerInAction			= T72_Gunner;
				gunnerOpticsModel		="\ca\Tracked\optika_M1A1_commander";
				memoryPointGunnerOptics		="Gunner2view";
				memoryPointsGetInGunner		="pos cargo";
				memoryPointsGetInGunnerDir	="pos cargo dir";
				class ViewOptics		: ViewOptics_JSDF_AV_base {};
				class ViewGunner		: ViewGunner_JSDF_AV_base {};
			};
			class CommanderOptics			: NewTurret
			{
				proxyType			= CPCommander;
				proxyIndex			= 1;
				gunnerName			= commander;
				primaryGunner			= 0;
				primaryObserver			= 1;

				body				="";
				gun				="";
				animationSourceBody		="";
				animationSourceGun		="";
				animationSourceHatch		="hatchCommander";

				soundServo[]			={"", db-50, 1.0};
				startEngine			= 0;

				gunBeg				="";
				gunEnd				="";

				minElev=-4; maxElev=+20; initElev=0;
				minTurn=-360; maxTurn=+360; initTurn=0;

				commanding			= 2;
				outGunnerMayFire		= 1;
				inGunnerMayFire			= 1;
				viewGunnerInExternal		= 1;

				gunnerAction			= T72_CommanderOut;
				gunnerInAction			= T72_Commander;
				gunnerOpticsModel		="\ca\Tracked\optika_tank_driver";
				gunnerOutOpticsModel		= \ca\Weapons\optika_empty;
				gunnerOutOpticsColor[]		= {0, 0, 0, 1};
				gunnerOutForceOptics		= 0;
				gunnerOutOpticsShowCursor 	= 0;
				memoryPointGunnerOutOptics	="commander_weapon_view";
				memoryPointGunnerOptics		="commanderview";
				memoryPointsGetInGunner		="pos cargo";
				memoryPointsGetInGunnerDir	="pos cargo dir";
				memoryPointGun			="";
				selectionFireAnim		="";
				class ViewOptics		: ViewOptics_JSDF_AV_base {};
				class ViewGunner		: ViewGunner_JSDF_AV_base {};
			};
		};
		class Sounds_t60APC 	: Sounds
		{
			class Engine
			{
				sound[] = {"\jsdf_vla\t60apc\JSDF_t60AV_eng.wss", 1.77828, 1.0, 1000};
				frequency = "(randomizer*0.05+0.8)*rpm";
				volume = "engineOn*camPos*(rpm factor[0.4, 0.9])";
			};
		};
		class Damage
		{
			tex[] = {};
			mat[] = {"ca\tracked2\aav\data\aav_ext.rvmat", "ca\tracked2\aav\data\aav_ext_damage.rvmat", "ca\tracked2\aav\data\aav_ext_destruct.rvmat", "ca\tracked2\aav\data\aav_ext2.rvmat", "ca\tracked2\aav\data\aav_ext2_damage.rvmat", "ca\tracked2\aav\data\aav_ext2_destruct.rvmat", "ca\tracked2\aav\data\aav_tracks.rvmat", "ca\tracked2\aav\data\aav_tracks_damage.rvmat", "ca\tracked2\aav\data\aav_tracks_destruct.rvmat"};
		};
		
		class Library
		{
			libTextDesc = $STR_LIB_AAVP7A1;
		};
	};
};
