class CfgVehicles {
	class Land;	// External class reference
	
	class LandVehicle : Land {
		class NewTurret;	// External class reference
		class ViewOptics;	// External class reference
		class ViewPilot;	// External class reference
		class HeadLimits;	// External class reference
		class Sounds;	// External class reference
	};
	
	class TK : LandVehicle
	{
		class Sounds : Sounds
		{
			class Engine;	// External class reference
			class Movement;	// External class reference
		};

		driverOpticsModel = "\ca\Tracked\optika_tank_driver";

		commanderCanSee = 31;
		gunnerCanSee = 30;

		getInAction = "GetInMedium";
		getOutAction = "GetOutMedium";
		cargoGetInAction[] = {"GetInLow"};
		cargoGetOutAction[] = {"GetOutLow"};

		audible = 18;
		sensitivityEar = 0.0075 /3;
		armorStructural = 2;
		class AnimationSources;	// External class reference
		
		class HitPoints {
			class HitHull {
				armor = 1;
				material = -1;
				name = "NEtelo";
				visual = "telo";
				passThrough = 1;
			};
			
			class HitLTrack {
				armor = 0.15;
				material = -1;
				name = "pas_L";
				visual = "pas_L";
				passThrough = 0.3;
			};
			
			class HitRTrack {
				armor = 0.15;
				material = -1;
				name = "pas_P";
				visual = "pas_P";
				passThrough = 0.3;
			};
			
			class HitEngine {
				armor = 0.35;
				material = -1;
				name = "motor";
				visual = "motor";
				passThrough = 0.2;
			};
		};
		weapons[] = {};
		magazines[] = {};
		
		class Turrets
		{
			class MainTurret : NewTurret
			{
				gunnerAction = "ManActTestDriverOut";
				gunnerGetInAction = "GetInHigh";
				gunnerGetOutAction = "GetOutHigh";
				memoryPointsGetInGunner = "pos gunner";
				memoryPointsGetInGunnerDir = "pos gunner dir";

				gunnerOpticsModel = "\ca\Tracked\optika_tank_gunner";
				gunnerOutOpticsModel = "\ca\Weapons\optika_empty";

				gunBeg = "usti hlavne";
				gunEnd = "konec hlavne";

				viewGunnerInExternal = 1;
				primaryGunner = 1;

				gunnerOpticsEffect[] = {"TankGunnerOptics2", "OpticsBlur1", "OpticsCHAbera1"};
				gunnerOutOpticsEffect[] = {};

				
				class HitPoints {
					class HitTurret {
						armor = 1;
						material = -1;
						name = "vez";
						visual = "vez";
						passThrough = 1;
					};
					
					class HitGun {
						armor = 0.3;
						material = -1;
						name = "zbran";
						visual = "zbran";
						passThrough = 0;
					};
				};
				
				class Turrets
				{
					class CommanderOptics : NewTurret
					{
						proxyType = "CPCommander";
						proxyIndex = 1;
						gunnerName = $STR_POSITION_COMMANDER;
						primaryGunner = 0;
						primaryObserver = 1;
						stabilizedInAxes = "StabilizedInAxesNone";
						body = "obsTurret";
						gun = "obsGun";
						animationSourceBody = "obsTurret";
						animationSourceGun = "obsGun";
						animationSourceHatch = "hatchCommander";
						soundServo[] = {"\ca\sounds\vehicles\servos\turret-1", 0.01, 1.0, 10};
						gunBeg = "";
						gunEnd = "";
						minElev = -4;
						maxElev = 20;
						initElev = 0;
						minTurn = -360;
						maxTurn = 360;
						initTurn = 0;
						commanding = 2;
						outGunnerMayFire = 1;
						inGunnerMayFire = 1;
						viewGunnerInExternal = 0;
						gunnerOpticsModel = "\ca\Tracked\optika_tank_driver";
						gunnerOutOpticsModel = "\ca\Weapons\optika_empty";
						gunnerOutOpticsColor[] = {0, 0, 0, 1};
						gunnerOutForceOptics = 0;
						gunnerOutOpticsShowCursor = 0;
						gunnerOpticsEffect[] = {};
						gunnerOutOpticsEffect[] = {};
						memoryPointGunnerOutOptics = "commander_weapon_view";
						memoryPointGunnerOptics = "commanderview";
						memoryPointsGetInGunner = "pos commander";
						memoryPointsGetInGunnerDir = "pos commander dir";
						gunnerGetInAction = "GetInHigh";
						gunnerGetOutAction = "GetOutHigh";
						memoryPointGun = "gun_muzzle";
						selectionFireAnim = "zasleh_1";
						
						class ViewOptics {
							initAngleX = 0;
							minAngleX = -30;
							maxAngleX = 30;
							initAngleY = 0;
							minAngleY = -100;
							maxAngleY = 100;
							initFov = 0.155;
							minFov = 0.0625;
							maxFov = 0.466;
						};
						
						class ViewGunner {
							initAngleX = 5;
							minAngleX = -65;
							maxAngleX = 85;
							initAngleY = 0;
							minAngleY = -150;
							maxAngleY = 150;
							initFov = 0.7;
							minFov = 0.25;
							maxFov = 1.1;
						};
					};
				};
			};
		};
		soundDammage[] = {"\ca\Tracked\Data\Sound\alarm_loop1", 0.000316228, 1};
		supplyRadius = 1.5;
		
		class ViewOptics : ViewOptics {
			initAngleX = 0;
			minAngleX = -30;
			maxAngleX = 30;
			initAngleY = 0;
			minAngleY = -100;
			maxAngleY = 100;
			initFov = 0.466;
			minFov = 0.466;
			maxFov = 0.466;
		};
		smokeLauncherGrenadeCount = 6;
		smokeLauncherVelocity = 15;
		smokeLauncherOnTurret = 1;
		smokeLauncherAngle = 120;
	};

	class TK_Base : TK
	{

		wheelCircumference = 2.312;
		accuracy = 0.2;

		armor = 690;
		damageResistance = 0.00544;
		armorStructural = 2;
		cost = 1000000;

		maxSpeed = 60;

		forceHideDriver = 1;
		driverForceOptics = 1;
		driverAction = "T72_DriverOut";
		driverInAction = "T72_Driver";
		
		type = 1;
		threat[] = {0.9, 0.8, 0.2};
		
		class Turrets : Turrets {
			class MainTurret : MainTurret {
				gunnerAction = "T72_GunnerOut";
				gunnerInAction = "T72_Gunner";
				gunnerGetInAction = "GetInMedium";
				gunnerGetOutAction = "GetOutMedium";
				weapons[] = {D81, PKT};
				magazines[] = {"23Rnd_125mmSABOT_T72", "22Rnd_125mmHE_T72", "2000Rnd_762x54_PKT"};
				soundServo[] = {"\ca\Weapons\Data\Sound\gun_elevate2", 0.01, 1.0, 10};
				gunnerOpticsModel = "\ca\weapons\2Dscope_T72gun8";
				gunnerOutOpticsModel = "";
				gunnerOpticsEffect[] = {"TankGunnerOptics1", "OpticsBlur2", "OpticsCHAbera3"};
				minElev = -6;
				maxElev = 14;
				initElev = 0;
				LODTurnedOut = 1000;
				
				class ViewOptics {
					initAngleX = 0;
					minAngleX = -30;
					maxAngleX = 30;
					initAngleY = 0;
					minAngleY = -100;
					maxAngleY = 100;
					initFov = 0.2;
					minFov = 0.058;
					maxFov = 0.2;
				};
				
				class Turrets : Turrets {
					class CommanderOptics : CommanderOptics {
						weapons[] = {DSHKM, "SmokeLauncher"};
						magazines[] = {"150Rnd_127x107_DSHKM", "150Rnd_127x107_DSHKM", "150Rnd_127x107_DSHKM", "150Rnd_127x107_DSHKM", "SmokeLauncherMag", "SmokeLauncherMag"};
						gunBeg = "gun_muzzle";
						gunEnd = "gun_chamber";
						body = "ObsTurret";
						gun = "ObsGun";
						gunnerAction = "T72_CommanderOut";
						gunnerInAction = "T72_Commander";
						gunnerGetInAction = "GetInMedium";
						gunnerGetOutAction = "GetOutMedium";
						minElev = -25;
						maxElev = 60;
						initElev = 0;
						minTurn = -360;
						maxTurn = 360;
						initTurn = 0;
						soundServo[] = {"\ca\Weapons\Data\Sound\gun_elevate2", 0.0177828, 1.0, 10};
						outGunnerMayFire = 1;
						inGunnerMayFire = 1;
						gunnerOpticsModel = "\ca\weapons\2Dscope_RUAA5";
						gunnerOpticsEffect[] = {"TankGunnerOptics1", "OpticsBlur2", "OpticsCHAbera3"};
						
						class ViewOptics : ViewOptics {
							initFov = 0.093;
							minFov = 0.093;
							maxFov = 0.093;
						};
						startEngine = 0;
						LODTurnedOut = 1000;
					};
				};
			};
		};
	};
	

	
	class TK_NoLoader : TK
	{

		accuracy = 0.25;

		armor = 850;
		armorStructural = 2;
		damageResistance = 0.00547;

		memoryPointCargoLight = "";

		maxSpeed = 60;
		driverAction = "Abrams_DriverOut";
		driverInAction = "Abrams_Driver";
		driverForceOptics = 1;
		driverOpticsModel = "\ca\Tracked\optika_tank_driver_west";
		typicalCargo[] = {"USMC_Soldier_Crew", "USMC_Soldier_Crew", "USMC_Soldier_Crew"};
		
		class Turrets : Turrets
		{
			class MainTurret : MainTurret
			{
				gunnerAction = "Abrams_Gunner";
				gunnerInAction = "Abrams_Gunner";
				weapons[] = {M256, "M240_veh"};
				magazines[] = {"20Rnd_120mmSABOT_M1A2", "20Rnd_120mmHE_M1A2", "1200Rnd_762x51_M240"};
				soundServo[] = {"\ca\sounds\vehicles\servos\turret-2", 0.0316228, 1.0, 30};
				forceHideGunner = 1;
				gunnerOpticsModel = "\ca\Weapons\2Dscope_M1gun10.p3d";
				gunnerOpticsEffect[] = {"TankGunnerOptics1"};
				gunnerOutOpticsEffect[] = {};
				
				class Turrets : Turrets {
					class CommanderOptics : CommanderOptics {
						gunBeg = "gun_muzzle";
						gunEnd = "gun_chamber";
						minElev = -25;
						maxElev = 60;
						initElev = 0;
						minTurn = -360;
						maxTurn = 360;
						initTurn = 0;
						weapons[] = {"M2", "SmokeLauncher"};
						soundServo[] = {"\ca\sounds\vehicles\servos\turret-1", 0.01, 1.0, 30};
						magazines[] = {"100Rnd_127x99_M2", "100Rnd_127x99_M2", "100Rnd_127x99_M2", "100Rnd_127x99_M2", "100Rnd_127x99_M2", "SmokeLauncherMag", "SmokeLauncherMag"};
						outGunnerMayFire = 1;
						inGunnerMayFire = 1;
						gunnerAction = "Abrams_CommanderOut";
						gunnerInAction = "Abrams_Commander";
						gunnerOpticsModel = "\ca\Tracked\optika_M1A1_commander";
						gunnerOpticsEffect[] = {"TankCommanderOptics1"};
						
						class ViewOptics : ViewOptics {
							initFov = 0.466;
							minFov = 0.029;
							maxFov = 0.466;
						};
						startEngine = 0;
					};
				};
			};
		};
	};
	
	class TK_Loader : TK_NoLoader
	{

		forceHideDriver = 1;
		driverAction = "Abrams_Driver";
		driverInAction = "Abrams_Driver";
		hideProxyInCombat = 0;
		animationSourceHatch = "";
		
		class Turrets : Turrets {
			class MainTurret : MainTurret {
				proxyType = "CPGunner";
				proxyIndex = 2;
				
				class Turrets : Turrets {
					class CommanderOptics : CommanderOptics {
						gunnerAction = "Abrams_CommanderOUT";
						gunnerInAction = "Abrams_Commander";
						gunnerOpticsModel = "\ca\Weapons\2Dscope_RWS";
						outGunnerMayFire = 0;
						
						class ViewOptics : ViewOptics {
							initFov = 0.466;
							minFov = 0.029;
							maxFov = 0.466;
						};
						stabilizedInAxes = "StabilizedInAxesBoth";
					};
					
					class LoaderTurret : NewTurret {
						proxyType = "CPGunner";
						proxyIndex = 1;
						gunnerName = "$STR_GN_M1A2_LoaderTurret";
						body = "LoaderTurret";
						gun = "LoaderGun";
						animationSourceBody = "LoaderTurret";
						animationSourceGun = "LoaderGun";
						animationSourceHatch = "loaderHatch";
						stabilizedInAxes = "StabilizedInAxesNone";
						LODTurnedOut = 1000;
						LODTurnedIn = 1000;
						
						class HitPoints {
							class HitLoaderTurret {
								armor = 0.9;
								material = -1;
								name = "loader_turret";
								visual = "loader_turret";
								passThrough = 1;
							};
						};
						gunnerAction = "HMMWV_Gunner04";
						gunnerInAction = "HMMWV_Gunner04";
						memoryPointGun = "usti hlavne loader";
						gunBeg = "usti hlavne loader";
						gunEnd = "konec hlavne loader";
						memoryPointGunnerOptics = "loaderview";
						memoryPointGunnerOutOptics = "loaderview";
						gunnerOpticsModel = "\ca\weapons\optika_empty";
						gunnerOutOpticsModel = "\ca\weapons\optika_empty";
						gunnerForceOptics = 0;
						canHideGunner = 0;
						minElev = -25;
						maxElev = 25;
						initElev = 0;
						minTurn = -180;
						maxTurn = 180;
						initTurn = 0;
						weapons[] = {"M240_veh"};
						magazines[] = {"100Rnd_762x51_M240", "100Rnd_762x51_M240", "100Rnd_762x51_M240", "100Rnd_762x51_M240"};
						outGunnerMayFire = 1;
						inGunnerMayFire = 1;
						commanding = -1;
						selectionFireAnim = "zasleh_2";
						startengine = 0;
						
						class Turrets {};
					};
				};
			};
		};
	};
};
