	class Tank 		: LandVehicle
	{
		class Sounds 		: Sounds
		{
			class Engine;				// External class reference
			class Movement;				// External class reference
		};
		driverOpticsModel 	= "\ca\Tracked\optika_tank_driver";
		commanderCanSee 	= 31;
		gunnerCanSee 		= 30;
		getInAction 		= "GetInMedium";
		getOutAction 		= "GetOutMedium";
		cargoGetInAction[] 	= {"GetInLow"};
		cargoGetOutAction[] 	= {"GetOutLow"};
		audible 		= 18;
		sensitivityEar 		= 0.0075 /3;
		armorStructural 	= 2;
		class AnimationSources;				// External class reference
		
		class HitPoints
		{
			class HitHull 	{armor = 1;	material = -1;	name = "NEtelo";	visual = "telo";	passThrough = 1;	};
			class HitLTrack {armor = 0.15;	material = -1;	name = "pas_L";		visual = "pas_L";	passThrough = 0.3;	};
			class HitRTrack {armor = 0.15;	material = -1;	name = "pas_P";		visual = "pas_P";	passThrough = 0.3;	};
			class HitEngine {armor = 0.35;	material = -1;	name = "motor";		visual = "motor";	passThrough = 0.2;	};
		};
		weapons[] = {};
		magazines[] = {};
		
		class Turrets
		{
			class MainTurret : NewTurret
			{
				gunnerAction = "ManActTestDriverOut";
				gunnerOpticsModel = "\ca\Tracked\optika_tank_gunner";
				gunnerOutOpticsModel = "\ca\Weapons\optika_empty";
				gunBeg = "usti hlavne";
				gunEnd = "konec hlavne";
				memoryPointsGetInGunner = "pos gunner";
				memoryPointsGetInGunnerDir = "pos gunner dir";
				gunnerGetInAction = "GetInHigh";
				gunnerGetOutAction = "GetOutHigh";
				viewGunnerInExternal = 0;
				primaryGunner = 1;
				gunnerOpticsEffect[] = {"TankGunnerOptics2", "OpticsBlur1", "OpticsCHAbera1"};
				gunnerOutOpticsEffect[] = {};
				
				class HitPoints
				{
					class HitTurret {armor = 1;	material = -1;	name = "vez";	visual = "vez";		passThrough = 1;	};
					class HitGun 	{armor = 0.3;	material = -1;	name = "zbran";	visual = "zbran";	passThrough = 0;	};
				};
				
				class Turrets
				{
					class CommanderOptics : NewTurret
					{
						proxyType = "CPCommander";
						proxyIndex = 1;
						gunnerName = $STR_POSITION_COMMANDER;
						primaryGunner = 0;
						primaryObserver = 1;
						stabilizedInAxes = "StabilizedInAxesNone";
						body = "obsTurret";
						gun = "obsGun";
						animationSourceBody = "obsTurret";
						animationSourceGun = "obsGun";
						animationSourceHatch = "hatchCommander";
						soundServo[] = {"\ca\sounds\vehicles\servos\turret-1", 0.01, 1.0, 10};
						gunBeg = "";
						gunEnd = "";
						minElev = -4;
						maxElev = 20;
						initElev = 0;
						minTurn = -360;
						maxTurn = 360;
						initTurn = 0;
						commanding = 2;
						outGunnerMayFire = 1;
						inGunnerMayFire = 1;
						viewGunnerInExternal = 0;
						gunnerOpticsModel = "\ca\Tracked\optika_tank_driver";
						gunnerOutOpticsModel = "\ca\Weapons\optika_empty";
						gunnerOutOpticsColor[] = {0, 0, 0, 1};
						gunnerOutForceOptics = 0;
						gunnerOutOpticsShowCursor = 0;
						gunnerOpticsEffect[] = {};
						gunnerOutOpticsEffect[] = {};
						memoryPointGunnerOutOptics = "commander_weapon_view";
						memoryPointGunnerOptics = "commanderview";
						memoryPointsGetInGunner = "pos commander";
						memoryPointsGetInGunnerDir = "pos commander dir";
						gunnerGetInAction = "GetInHigh";
						gunnerGetOutAction = "GetOutHigh";
						memoryPointGun = "gun_muzzle";
						selectionFireAnim = "zasleh_1";
						
						class ViewOptics
						{
							initAngleX = 0;		minAngleX = -30;	maxAngleX = 30;
							initAngleY = 0;		minAngleY = -100;	maxAngleY = 100;
							initFov = 0.155;	minFov = 0.0625;	maxFov = 0.466;
						};
						
						class ViewGunner
						{
							initAngleX = 5;		minAngleX = -65;	maxAngleX = 85;
							initAngleY = 0;		minAngleY = -150;	maxAngleY = 150;
							initFov = 0.7;		minFov = 0.25;		maxFov = 1.1;
						};
					};
				};
			};
		};
		soundDammage[] = {"\ca\Tracked\Data\Sound\alarm_loop1", 0.000316228, 1};
		supplyRadius = 1.5;
		
		class ViewOptics : ViewOptics
		{
			initAngleX = 0;		minAngleX = -30;	maxAngleX = 30;
			initAngleY = 0;		minAngleY = -100;	maxAngleY = 100;
			initFov = 0.466;	minFov = 0.466;		maxFov = 0.466;
		};
		
		class Eventhandlers 		: DefaultEventhandlers {};

		smokeLauncherGrenadeCount 	= 6;
		smokeLauncherVelocity 		= 15;
		smokeLauncherOnTurret 		= 1;
		smokeLauncherAngle 		= 120;
	};
	class JSDF_Tank 			: Tank
	{
		scope 				= 0;
		side 				= 1;
		faction 			= JSDF;
		vehicleClass 			= "Armored";
		canFloat 			= 0;
		supplyRadius 			= 2;

		crew 				= "USMC_Soldier_Crew";

		viewDriverShadow 		= 1;
		viewGunnerShadow 		= 1;
		viewCargoShadow 		= 1;
		viewCargoShadowDiff 		= 0.05;
		viewDriverShadowDiff 		= 0.05;
		viewGunnerShadowDiff 		= 0.05;
		
		
		class Exhausts
		{
			class Exhaust	{effect = "ExhaustsEffectBig";	position = "exhaust";	direction = "exhaust_dir";	};
			class Exhaust1 : Exhaust {			position = "exhaust_1";	direction = "exhaust_1_dir";	};
			class Exhaust2 : Exhaust {			position = "exhaust_2";	direction = "exhaust_2_dir";	};
		};

		insideSoundCoef = 0.9;
		soundGear[] = {"", 5.62341e-005, 1};
		soundGetIn[] = {"ca\SOUNDS\Vehicles\Tracked\T72\int\int-tank-diesel-door-1", 0.562341, 1};
		soundGetOut[] = {"ca\SOUNDS\Vehicles\Tracked\T72\ext\ext-tank-diesel-door-1", 0.562341, 1, 60};
		soundEngineOnInt[] = {"ca\sounds\Vehicles\Tracked\T72\int\int-tank-diesel-start-2", 1.0, 1.0};
		soundEngineOnExt[] = {"ca\SOUNDS\Vehicles\Tracked\T72\ext\ext-tank-diesel-start-2", 2.51189, 1.0, 500};
		soundEngineOffInt[] = {"ca\sounds\vehicles\Tracked\T72\int\int-tank-diesel-stop-1", 1.0, 1.0};
		soundEngineOffExt[] = {"ca\sounds\vehicles\Tracked\T72\ext\ext-tank-diesel-stop-1", 1.0, 0.8, 500};
		buildCrash0[] = {"Ca\sounds\Vehicles\Crash\tank_building_01", 0.707946, 1, 150};
		buildCrash1[] = {"Ca\sounds\Vehicles\Crash\tank_building_02", 0.707946, 1, 150};
		buildCrash2[] = {"Ca\sounds\Vehicles\Crash\tank_building_03", 0.707946, 1, 150};
		buildCrash3[] = {"Ca\sounds\Vehicles\Crash\tank_building_04", 0.707946, 1, 150};
		soundBuildingCrash[] = {"buildCrash0", 0.25, "buildCrash1", 0.25, "buildCrash2", 0.25, "buildCrash3", 0.25};
		WoodCrash0[] = {"Ca\sounds\Vehicles\Crash\tank_wood_01", 0.707946, 1, 150};
		WoodCrash1[] = {"Ca\sounds\Vehicles\Crash\tank_wood_02", 0.707946, 1, 150};
		WoodCrash2[] = {"Ca\sounds\Vehicles\Crash\tank_wood_03", 0.707946, 1, 150};
		WoodCrash3[] = {"Ca\sounds\Vehicles\Crash\tank_wood_04", 0.707946, 1, 150};
		soundWoodCrash[] = {"woodCrash0", 0.25, "woodCrash1", 0.25, "woodCrash2", 0.25, "woodCrash3", 0.25};
		ArmorCrash0[] = {"Ca\sounds\Vehicles\Crash\tank_vehicle_01", 0.707946, 1, 150};
		ArmorCrash1[] = {"Ca\sounds\Vehicles\Crash\tank_vehicle_02", 0.707946, 1, 150};
		ArmorCrash2[] = {"Ca\sounds\Vehicles\Crash\tank_vehicle_03", 0.707946, 1, 150};
		ArmorCrash3[] = {"Ca\sounds\Vehicles\Crash\tank_vehicle_04", 0.707946, 1, 150};
		soundArmorCrash[] = {"ArmorCrash0", 0.25, "ArmorCrash1", 0.25, "ArmorCrash2", 0.25, "ArmorCrash3", 0.25};
		
		class SoundEvents {
			class AccelerationIn {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int-tank-diesel-acceleration-1", 1.77828, 1.0};
				limit = 0.15;
				expression = "engineOn*(1-camPos)*2*gmeterZ*((speed factor[1.5, 5]) min (speed factor[5, 1.5]))";
			};
			
			class AccelerationOut {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext-tank-diesel-acceleration-1", 1.77828, 1.0, 650};
				limit = 0.15;
				expression = "engineOn*camPos*2*gmeterZ*((speed factor[1.5, 5]) min (speed factor[5, 1.5]))";
			};
		};
		
		class Sounds {
			class Engine {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext-tank-diesel-engine3", 1.77828, 1.0, 1000};
				frequency = "(randomizer*0.05+0.8)*rpm";
				volume = "engineOn*camPos*(rpm factor[0.4, 0.9])";
			};
			
			class IdleOut {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext-tank-diesel-engine3", 0.562341, 1.0, 300};
				frequency = "1";
				volume = "engineOn*camPos*(rpm factor[0.6, 0.15])";
			};
			
			class NoiseOut {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\noise2", 1.0, 1.0, 150};
				frequency = "1";
				volume = "camPos*(angVelocity max 0.04)*(speed factor[4, 15])";
			};
			
			class ThreadsOutH0 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_hard_01", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*(1-grass)*((rpm factor[0.3, 0.6]) min (rpm factor[0.6, 0.3]))";
			};
			
			class ThreadsOutH1 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_hard_02", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*(1-grass)*((rpm factor[0.5, 0.8]) min (rpm factor[0.8, 0.5]))";
			};
			
			class ThreadsOutH2 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_hard_03", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*(1-grass)*((rpm factor[0.65, 0.9]) min (rpm factor[0.9, 0.65]))";
			};
			
			class ThreadsOutH3 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_hard_04", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*(1-grass)*((rpm factor[0.8, 1.2]) min (rpm factor[1.2, 0.8]))";
			};
			
			class ThreadsOutH4 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_hard_05", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*(1-grass)*((rpm factor[1, 2.0]) min (rpm factor[2.0, 1]))";
			};
			
			class ThreadsOutS0 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_soft_01", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*grass*((rpm factor[0.3, 0.6]) min (rpm factor[0.6, 0.3]))";
			};
			
			class ThreadsOutS1 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_soft_02", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*grass*((rpm factor[0.5, 0.8]) min (rpm factor[0.8, 0.5]))";
			};
			
			class ThreadsOutS2 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_soft_03", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*grass*((rpm factor[0.65, 0.9]) min (rpm factor[0.9, 0.65]))";
			};
			
			class ThreadsOutS3 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_soft_04", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*grass*((rpm factor[0.8, 1.2]) min (rpm factor[1.2, 0.8]))";
			};
			
			class ThreadsOutS4 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_soft_05", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*grass*((rpm factor[1, 2.0]) min (rpm factor[2.0, 1]))";
			};
			
			class Movement {
				sound[] = {"", 1.0, 1.0};
				frequency = "0";
				volume = "0";
			};
			
			class EngineIn {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int-tank-diesel-engine3", 1.0, 1.0};
				frequency = "(randomizer*0.05+0.8)*rpm";
				volume = "engineOn*(1-camPos)*(rpm factor[0.4, 1])";
			};
			
			class IdleIn {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int-tank-diesel-engine3", 1.77828, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*(rpm factor[0.6, 0.15])";
			};
			
			class NoiseIn {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\noise2", 0.158489, 1.0};
				frequency = "1";
				volume = "(1-camPos)*(angVelocity max 0.04)*(speed factor[4, 15])";
			};
			
			class ThreadsInH0 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_hard_01", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*(1-grass)*((rpm factor[0.3, 0.6]) min (rpm factor[0.6, 0.3]))";
			};
			
			class ThreadsInH1 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_hard_02", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*(1-grass)*((rpm factor[0.5, 0.8]) min (rpm factor[0.8, 0.5]))";
			};
			
			class ThreadsInH2 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_hard_03", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*(1-grass)*((rpm factor[0.65, 0.9]) min (rpm factor[0.9, 0.65]))";
			};
			
			class ThreadsInH3 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_hard_04", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*(1-grass)*((rpm factor[0.8, 1.2]) min (rpm factor[1.2, 0.8]))";
			};
			
			class ThreadsInH4 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_hard_05", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*(1-grass)*((rpm factor[1, 2.0]) min (rpm factor[2.0, 1]))";
			};
			
			class ThreadsInS0 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_soft_01", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*grass*((rpm factor[0.3, 0.6]) min (rpm factor[0.6, 0.3]))";
			};
			
			class ThreadsInS1 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_soft_02", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*grass*((rpm factor[0.5, 0.8]) min (rpm factor[0.8, 0.5]))";
			};
			
			class ThreadsInS2 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_soft_03", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*grass*((rpm factor[0.65, 0.9]) min (rpm factor[0.9, 0.65]))";
			};
			
			class ThreadsInS3 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_soft_04", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*grass*((rpm factor[0.8, 1.2]) min (rpm factor[1.2, 0.8]))";
			};
			
			class ThreadsInS4 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_soft_05", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*grass*((rpm factor[1, 2.0]) min (rpm factor[2.0, 1]))";
			};
		};
	};
	
	class JSDF_APC 				: JSDF_Tank
	{
		cargoAction[] 			= {"Stryker_Cargo01"};
		typicalCargo[] 			= {"USMC_Soldier_Crew", "USMC_Soldier_Crew", "USMC_Soldier_Crew"};
		transportSoldier 		= 19;

		getInAction 			= "GetInHigh";
		getOutAction 			= "GetOutHigh";
		commanderUsesPilotView 		= 1;

		fireDustEffect 			= "FDustEffects_none";
		insideSoundCoef 		= 0.9;
		soundCrash[] 			= {"\ca\Tracked\Data\Sound\crash1", 10.0, 1};
		soundGear[] 			= {"", 5.62341e-005, 1};
		soundGetIn[] 			= {"ca\SOUNDS\Vehicles\Tracked\Other\int\int-tracked-getin-01", 0.562341, 1};
		soundGetOut[] 			= {"ca\SOUNDS\Vehicles\Tracked\Other\ext\ext-tracked-getout-01", 0.562341, 1, 60};
		soundEngineOnInt[] 		= {"ca\sounds\Vehicles\Tracked\Other\int\int-tracked-start-01", 0.794328, 1.0};
		soundEngineOnExt[] 		= {"ca\SOUNDS\Vehicles\Tracked\Other\ext\ext-tracked-start-01", 0.794328, 1.0, 400};
		soundEngineOffInt[] 		= {"ca\sounds\vehicles\Tracked\Other\int\int-tracked-stop-02.wss", 0.794328, 1.0};
		soundEngineOffExt[] 		= {"ca\sounds\vehicles\Tracked\Other\ext\ext-tracked-stop-02.wss", 0.794328, 0.8, 400};
		buildCrash0[] 			= {"Ca\sounds\Vehicles\Crash\tank_building_01", 0.707946, 1, 150};
		buildCrash1[] 			= {"Ca\sounds\Vehicles\Crash\tank_building_02", 0.707946, 1, 150};
		buildCrash2[] 			= {"Ca\sounds\Vehicles\Crash\tank_building_03", 0.707946, 1, 150};
		buildCrash3[] 			= {"Ca\sounds\Vehicles\Crash\tank_building_04", 0.707946, 1, 150};
		soundBuildingCrash[] 		= {"buildCrash0", 0.25, "buildCrash1", 0.25, "buildCrash2", 0.25, "buildCrash3", 0.25};
		WoodCrash0[] 			= {"Ca\sounds\Vehicles\Crash\tank_wood_01", 0.707946, 1, 150};
		WoodCrash1[] 			= {"Ca\sounds\Vehicles\Crash\tank_wood_02", 0.707946, 1, 150};
		WoodCrash2[] 			= {"Ca\sounds\Vehicles\Crash\tank_wood_03", 0.707946, 1, 150};
		WoodCrash3[] 			= {"Ca\sounds\Vehicles\Crash\tank_wood_04", 0.707946, 1, 150};
		soundWoodCrash[] 		= {"woodCrash0", 0.25, "woodCrash1", 0.25, "woodCrash2", 0.25, "woodCrash3", 0.25};
		ArmorCrash0[] 			= {"Ca\sounds\Vehicles\Crash\tank_vehicle_01", 0.707946, 1, 150};
		ArmorCrash1[] 			= {"Ca\sounds\Vehicles\Crash\tank_vehicle_02", 0.707946, 1, 150};
		ArmorCrash2[] 			= {"Ca\sounds\Vehicles\Crash\tank_vehicle_03", 0.707946, 1, 150};
		ArmorCrash3[] 			= {"Ca\sounds\Vehicles\Crash\tank_vehicle_04", 0.707946, 1, 150};
		soundArmorCrash[] 		= {"ArmorCrash0", 0.25, "ArmorCrash1", 0.25, "ArmorCrash2", 0.25, "ArmorCrash3", 0.25};
		
		class SoundEvents
		{
			class AccelerationIn
			{
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\int\int-tracked-acce-02", 1.25893, 1.0};
				limit = 0.15;
				expression = "engineOn*(1-camPos)*2*gmeterZ*((speed factor[1.5, 5]) min (speed factor[5, 1.5]))";
			};
			
			class AccelerationOut
			{
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\ext\ext-tracked-acce-02", 1.25893, 1.0, 700};
				limit = 0.15;
				expression = "engineOn*camPos*2*gmeterZ*((speed factor[1.5, 5]) min (speed factor[5, 1.5]))";
			};
		};
		
		class Sounds
		{
			class Engine {frequency = "(randomizer*0.05+0.8)*rpm";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\ext\ext-tracked-engine-03", 1.41254, 1.0, 1000};
				volume = "engineOn*camPos*(rpm factor[0.6, 0.9])";
			};
			class IdleOut {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\ext\ext-tracked-idle-02", 0.562341, 1.0, 350};
				volume = "engineOn*camPos*(rpm factor[0.7, 0.2])";
			};
			class NoiseOut {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\ext\noise2", 1.0, 1.0, 150};
				volume = "camPos*(angVelocity max 0.04)*(speed factor[4, 15])";
			};
			class ThreadsOutH0	{frequency = "1";
				sound[]	= {"ca\sounds\Vehicles\Tracked\Other\ext\ext_diesel_treads_hard_01", 1.0, 1.0, 400};
				volume	= "engineOn*camPos*(1-grass)*((rpm factor[0.3, 0.6]) min (rpm factor[0.6, 0.3]))";
			};
			class ThreadsOutH1 {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\ext\ext_diesel_treads_hard_02", 1.25893, 1.0, 400};
				volume	= "engineOn*camPos*(1-grass)*((rpm factor[0.5, 0.8]) min (rpm factor[0.8, 0.5]))";
			};
			class ThreadsOutH2 {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\ext\ext_diesel_treads_hard_03", 1.41254, 1.0, 400};
				volume	= "engineOn*camPos*(1-grass)*((rpm factor[0.65, 0.9]) min (rpm factor[0.9, 0.65]))";
			};
			class ThreadsOutH3 {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\ext\ext_diesel_treads_hard_04", 1.58489, 1.0, 400};
				volume = "engineOn*camPos*(1-grass)*((rpm factor[0.8, 1.2]) min (rpm factor[1.2, 0.8]))";
			};
			class ThreadsOutH4 {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\ext\ext_diesel_treads_hard_05", 1.77828, 1.0, 400};
				volume = "engineOn*camPos*(1-grass)*((rpm factor[1, 2.0]) min (rpm factor[2.0, 1]))";
			};
			class ThreadsOutS0 {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\ext\ext_diesel_treads_soft_01", 1.0, 1.0, 300};
				volume = "engineOn*camPos*grass*((rpm factor[0.3, 0.6]) min (rpm factor[0.6, 0.3]))";
			};
			class ThreadsOutS1 {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\ext\ext_diesel_treads_soft_02", 1.12202, 1.0, 300};
				volume = "engineOn*camPos*grass*((rpm factor[0.5, 0.8]) min (rpm factor[0.8, 0.5]))";
			};
			class ThreadsOutS2 {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\ext\ext_diesel_treads_soft_03", 1.25893, 1.0, 300};
				volume = "engineOn*camPos*grass*((rpm factor[0.65, 0.9]) min (rpm factor[0.9, 0.65]))";
			};
			class ThreadsOutS3 {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\ext\ext_diesel_treads_soft_04", 1.41254, 1.0, 300};
				volume = "engineOn*camPos*grass*((rpm factor[0.8, 1.2]) min (rpm factor[1.2, 0.8]))";
			};
			class ThreadsOutS4 {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\ext\ext_diesel_treads_soft_05", 1.77828, 1.0, 300};
				volume = "engineOn*camPos*grass*((rpm factor[1, 2.0]) min (rpm factor[2.0, 1]))";
			};
			class Movement {frequency = "0";
				sound[] = {"", 1.0, 1.0};
				volume = "0";
			};
			class EngineIn {frequency = "(randomizer*0.05+0.8)*rpm";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\int\int-tracked-engine-03", 1.0, 1.0};
				volume = "engineOn*(1-camPos)*(rpm factor[0.4, 1])";
			};
			class IdleIn {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\int\int-tracked-idle-02", 0.630957, 1.0};
				volume = "engineOn*(1-camPos)*(rpm factor[0.6, 0.15])";
			};
			class NoiseIn {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\int\noise2", 0.199526, 1.0};
				volume = "(1-camPos)*(angVelocity max 0.04)*(speed factor[4, 15])";
			};
			class ThreadsInH0 {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\int\int_diesel_treads_hard_01", 1.0, 1.0};
				volume = "engineOn*(1-camPos)*(1-grass)*((rpm factor[0.3, 0.6]) min (rpm factor[0.6, 0.3]))";
			};
			class ThreadsInH1 {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\int\int_diesel_treads_hard_02", 1.12202, 1.0};
				volume = "engineOn*(1-camPos)*(1-grass)*((rpm factor[0.5, 0.8]) min (rpm factor[0.8, 0.5]))";
			};
			class ThreadsInH2 {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\int\int_diesel_treads_hard_03", 1.25893, 1.0};
				volume = "engineOn*(1-camPos)*(1-grass)*((rpm factor[0.65, 0.9]) min (rpm factor[0.9, 0.65]))";
			};
			class ThreadsInH3 {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\int\int_diesel_treads_hard_04", 1.41254, 1.0};
				volume = "engineOn*(1-camPos)*(1-grass)*((rpm factor[0.8, 1.2]) min (rpm factor[1.2, 0.8]))";
			};
			class ThreadsInH4 {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\int\int_diesel_treads_hard_05", 1.58489, 1.0};
				volume = "engineOn*(1-camPos)*(1-grass)*((rpm factor[1, 2.0]) min (rpm factor[2.0, 1]))";
			};
			class ThreadsInS0 {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\int\int_diesel_treads_soft_01", 1.0, 1.0};
				volume = "engineOn*(1-camPos)*grass*((rpm factor[0.3, 0.6]) min (rpm factor[0.6, 0.3]))";
			};
			class ThreadsInS1 {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\int\int_diesel_treads_soft_02", 1.12202, 1.0};
				volume = "engineOn*(1-camPos)*grass*((rpm factor[0.5, 0.8]) min (rpm factor[0.8, 0.5]))";
			};
			class ThreadsInS2 {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\int\int_diesel_treads_soft_03", 1.25893, 1.0};
				volume = "engineOn*(1-camPos)*grass*((rpm factor[0.65, 0.9]) min (rpm factor[0.9, 0.65]))";
			};
			class ThreadsInS3 {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\int\int_diesel_treads_soft_04", 1.41254, 1.0};
				volume = "engineOn*(1-camPos)*grass*((rpm factor[0.8, 1.2]) min (rpm factor[1.2, 0.8]))";
			};
			class ThreadsInS4 {frequency = "1";
				sound[] = {"ca\sounds\Vehicles\Tracked\Other\int\int_diesel_treads_soft_05", 1.58489, 1.0};
				volume = "engineOn*(1-camPos)*grass*((rpm factor[1, 2.0]) min (rpm factor[2.0, 1]))";
			};
		};
		
		class Library
		{
			libTextDesc = "APC";
		};
	};
