#include "basicDefines.hpp"
#include "CrewAnimations.hpp"
#include "CfgRecoils.hpp"
#include "CfgAmmo.hpp"
#include "CfgVehicles.hpp"
#include "CfgMagazines.hpp"

//#include "MissileEffects.hpp"

class CfgPatches
{
	class JSDF_Weapons
	{
		units[] = {};
		weapons[] =
		{

		};
		requiredVersion = 0.10;
		requiredAddons[] = {"CAData","CA_Anims_Char"};
	};
};
class MissileManualEffects_TOW
{
	class Light1
	{
		simulation = "light";
		type = "RocketLight";
		position[] = {0, 0, 0};
		intensity = 0.00;
		interval = 0;
		lifeTime = 0;
	};
	class MissileManualEffects01
	{
		simulation = "particles";
		type = "MissileManualEffects1";
		position[] = {0, 0, 0};

		intensity = 0;
		interval = 0;
		lifeTime = 0;
	};
};

class MissileEffects_TOW
{
	class Light1
	{
		simulation = "light";
		type = "RocketLight";
		position[] = {0, 0, 0};
		intensity = 0.00;
		interval = 0;
		lifeTime = 0;
	};
	class MissileEffects01
	{
		simulation = "particles";
		type = "MissileEffects1";
		position[] = {0, 0, 0};

		intensity = 0;
		interval = 0;
		lifeTime = 0;
	};
};

class cfgWeapons
{
	class Default;
	class PistolCore;
	class RifleCore;
	class MGunCore;
	class LauncherCore;
	class GrenadeCore;
	class CannonCore;
	class MGun: MGunCore // default
	{
		type=WeaponHardMounted;

		cursor= \ca\Weapons\Data\w_weapon_mg;
		cursoraim= \ca\Weapons\Data\w_weapon_mg;

		displayName = $STR_DN_MGUN;
		nameSound="mgun";
		reloadTime=0.25;
		autoFire = 1;
		reloadAction = ManActReloadMagazine;
		sound[]={\ca\Weapons\Data\Sound\M60_SS,db0,1};
		soundContinuous=false;
		reloadSound[]={,1,1};
		initSpeed=900;
		flash=gunfire;
		flashSize=0.5;
		optics = false;

	};
	class Launcher: LauncherCore
	{
		cursorAim = \ca\Weapons\Data\clear_empty;
		cursor = LawCursor;

		autoAimEnabled=false;
		opticsDisablePeripherialVision = true;

		magazines[]={};

		value = 10;
		nameSound="atlauncher";
		magazineReloadTime=12;
		reloadTime=0;
		sound[]={\ca\Weapons\Data\Sound\at7_RocketLauncher_Shot1,db-40,1};
		initSpeed=30;
		canLock=LockNo;

		reloadAction = ManActReloadAT;
		autoReload = false;

		ffMagnitude=0.1;
		ffFrequency=1;
		ffCount=1;
		recoil=LAWSingle;
		aiRateOfFire=10.0; // delay between shots at given distance
		aiRateOfFireDistance=500; // at shorter distance delay goes lineary to zero
		optics = true;
		primary=false;

		opticsZoomMin=0.22;
		opticsZoomMax=0.95;   //same as default initFOV for 1st person view
		opticsZoomInit=0.42;

		distanceZoomMin=100;
		distanceZoomMax=100;

		UiPicture="\CA\weapons\data\Ico\i_at_CA.paa";
	};
	#include "Launchers.hpp"
	//Hand weapons
	//************************************************************************//
	class Binocular : Default
	{
		opticsDisablePeripherialVision = true;
		scope = public;

		model="\ca\weapons\dalekohled_proxy";
		modelOptics="\ca\weapons\optika_dalekohled";
		picture="\CA\weapons\data\equip\w_binocular_ca.paa";

		value = 5;

		type = WeaponSlotBinocular;
		displayName = $STR_DN_BINOCULAR;
		nameSound="binoculars";
		reloadTime=0.0;
		sound[]={,0,1};
		canLock=LockNo;

		optics = true;
		forceOptics = true;
		useAsBinocular = true;

		primary = false;
		opticsZoomMin=0.085;
		opticsZoomMax=0.085;

		magazines[] = {};
		class Library {libTextDesc = $STR_LIB_BINOCULAR;};
	};
	class Laserdesignator: Binocular
	{
		model="\ca\weapons\soflam";
		modelOptics="\ca\weapons\optika_SOFLAM";
		displayName = $STR_DN_LASER_DESIGNATOR;
		picture="\Ca\weapons\Data\Equip\W_SOFLAM_CA.paa";
		magazines[] = {Laserbatteries};
		cursorAim = \ca\Weapons\Data\cursor_target_locked_ca.paa;
		showSwitchAction = true;
    // force optics only in internal view, external need not use them
		forceOptics = 2;
	};
	#include "vehicleWeapons.hpp"
};
//CfgNonAIVehicles moved to cfgVehicles.hpp
