	class Rifle: RifleCore
	{
		autoFire = 1;
		reloadAction = ManActReloadMagazine;
		soundContinuous=false;
		optics = false;

		scope = protected;
		cursor = RifleCursor;
		cursorAim = \ca\Weapons\Data\w_weapon_S;
		value = 4;
		displayName=$STR_DN_RIFLE;
		nameSound="rifle";
		reloadTime=0.15;
		modelOptics="-";
		sound[]={""};
		drySound[]={\ca\Weapons\Data\Sound\M16_cock_v1,db-70,1};
		reloadSound[]={,1,1};
		reloadMagazineSound[]={\ca\Weapons\Data\Sound\m4_reload,db-30,1};
		opticsFlare = false;
		autoReload = false;
		aiDispersionCoefX=2.0;
		aiDispersionCoefY=2.0;
		opticsZoomMin=0.22;
		opticsZoomMax=0.95;
		opticsZoomInit=0.42;
		distanceZoomMin=300;
		distanceZoomMax=300;
		maxLeadSpeed=23; // max estimated speed km/h
		canLock=LockNo;
		flash=gunfire;
		flashSize=0.5;
		dispersion=0.0001;
		recoil=assaultRifleBase;
		recoilProne=assaultRifleBase;

		ffMagnitude=0.5;
		ffFrequency=11;
		ffCount=3;
	};
	class AK74: Rifle
	{
		scope = public;

		value = 0;

		model="\ca\weapons\AK_74_proxy";
		displayName = $STR_DN_AK74;
		picture="\CA\weapons\data\equip\w_ak74_ca.paa";
		UiPicture="\CA\weapons\data\Ico\i_regular_CA.paa";

		optics = true;

		drySound[]={\ca\Weapons\Data\Sound\AK47_dry_v1,db-70,1};	// empty magazine
		reloadMagazineSound[]={\ca\Weapons\Data\Sound\AK47_fill_v3,db-45,1};
		modes[] = {Single, Burst, FullAuto};
		magazines[] = {30Rnd_545x39_AK,30Rnd_545x39_AKSD};
		class Single : Mode_SemiAuto
		{
			sound[]={\ca\Weapons\Data\Sound\AK74_1_SS_A,db20,1};
			reloadTime=0.1;
			recoil=AK74Recoil;
			recoilProne=AK74Recoil;
			dispersion=0.0025;
			minRange=2;minRangeProbab=0.10;
			midRange=250;midRangeProbab=0.7;
			maxRange=400;maxRangeProbab=0.04;
		};
		class Burst : Mode_Burst
		{
			sound[]={\ca\Weapons\Data\Sound\AK74_1_SS_A,db20,1}; //AK74_1_BS_A
			soundBurst = false;
			reloadTime=0.1;
			ffCount=3;
			recoil=AK74Recoil;
			recoilProne=AK74Recoil;
			dispersion=0.007;
			minRange=2;minRangeProbab=0.10;
			midRange=60;midRangeProbab=0.7;
			maxRange=100;maxRangeProbab=0.05;
			showToPlayer = false;
		};
		class FullAuto : Mode_FullAuto
		{

			sound[]={\ca\Weapons\Data\Sound\AK74_1_SS_A,db20,1};
			reloadTime=0.1;
			ffCount=30;
			recoil=AK74Recoil;
			recoilProne=AK74Recoil;
			dispersion=0.005;
			minRange=2;minRangeProbab=0.10;
			midRange=30;midRangeProbab=0.7;
			maxRange=60;maxRangeProbab=0.05;
		};
		class Library {libTextDesc = $STR_LIB_AK74;};
	};
	class AK74GL: AK74
	{
		displayName=$STR_DN_AK74GL; //TODO: stringtable
		model="\ca\Weapons\ak_74_granatomet_proxy";
		picture="\CA\weapons\data\equip\w_ak74gp25_ca.paa";
		UiPicture="\CA\weapons\data\Ico\i_regular_CA.paa";
		muzzles[] = {AK74Muzzle, GP25Muzzle};

		dexterity = 1.5; // 4.8kg

		class AK74Muzzle: AK74 {};
		class GP25Muzzle: GrenadeLauncher
		{
			displayName=$STR_DN_GP25;
			reloadMagazineSound[]={\ca\Weapons\Data\Sound\flare_reload,db-70,1};
			magazines[]={1Rnd_HE_GP25,FlareWhite_GP25,FlareGreen_GP25,FlareRed_GP25,FlareYellow_GP25};
			magazineReloadTime=0;
			reloadTime=0.1;
			optics = true;
			modelOptics="-";
			cameraDir="GL look";
			memoryPointCamera="GL eye";
			opticsZoomMin=0.22;
			opticsZoomMax=0.95;
			opticsZoomInit=0.42;
		};
		class Library {libTextDesc = $STR_DN_AK74_GRENADE;};
	};
	class AKS74U: AK74
	{

		model="\ca\weapons\AKs74u";
		picture="\CA\weapons\data\equip\w_aks74u_ca.paa";
		UiPicture="\CA\weapons\data\Ico\i_regular_CA.paa";
		value = 1;

		dexterity = 1.78; //2.71kg

		class Single : Single
		{
			sound[]={\ca\Weapons\Data\Sound\AK47_2_SS_A,db20,1};
			dispersion=0.0035;
		};
		class Burst : Burst
		{
			sound[]={\ca\Weapons\Data\Sound\AK47_2_SS_A,db20,1};
			dispersion=0.007;
		};
		class FullAuto : FullAuto
		{
			sound[]={\ca\Weapons\Data\Sound\AK47_2_SS_A,db20,1};
			dispersion=0.006;
		};

		displayName=$STR_DN_AKS74_U;

		class Library {libTextDesc = $STR_LIB_AKS74_U;};
	};
	class AKS74UN: AKS74U
	{
		fireLightDuration = 0.000;
		fireLightIntensity = 0.000;

		// tweek aiming in patch 1.02
		distanceZoomMin=100;
		distanceZoomMax=100;

		dexterity = 1.8;

		model="\ca\weapons\AKs74un";
		picture="\CA\weapons\data\equip\w_aks74un_ca.paa";
		UiPicture="\CA\weapons\data\Ico\i_regular_CA.paa";

		class Single : Single
		{
			sound[]={\ca\Weapons\Data\Sound\AKSD_1,db-10,1};
			dispersion=0.0035;
		};
		class Burst : Burst
		{
			sound[]={\ca\Weapons\Data\Sound\AKSD_1,db-10,1};
			dispersion=0.007;
		};
		class FullAuto : FullAuto
		{
			sound[]={\ca\Weapons\Data\Sound\AKSD_1,db-10,1};
			dispersion=0.006;
		};

		displayName=$STR_DN_AKS74_UN;
		drySound[]={\ca\Weapons\Data\Sound\AK47_dry_v1,db-80,1};	// empty magazine
		reloadMagazineSound[]={\ca\Weapons\Data\Sound\AK47_fill_v3,db-65,1};

		class Library {libTextDesc = $STR_LIB_AKS74_UN;};

	};
	class G36a: Rifle
	{
		scope=public;
		model=\ca\Weapons\G36;
		modelOptics=\ca\Weapons\G36_optics;
		picture="\CA\weapons\data\equip\w_g36_ca.paa";
		UiPicture="\CA\weapons\data\Ico\i_regular_CA.paa";
		optics=true;
		opticsZoomMin=0.0833;
		opticsZoomMax=0.0833;

		distanceZoomMin=300;
		distanceZoomMax=300;

		dexterity = 1.66;

		displayName=$STR_DN_G36;
		drySound[]={\ca\Weapons\Data\Sound\G36_dry_v1, db-70,1};
		magazines[]={30Rnd_556x45_G36};

		modes[]={Single,Burst,Fullauto};
		class Single : Mode_SemiAuto
		{
			sound[]={\ca\Weapons\Data\Sound\G36_1_SS_A,db15,1};
			reloadTime=0.1;
			recoil=assaultRifleBase;
			recoilProne=assaultRifleBase;

			dispersion=0.0012;
			minRange=2;minRangeProbab=0.10;
			midRange=250;midRangeProbab=0.7;
			maxRange=400;maxRangeProbab=0.05;

		};
		class Burst : Mode_Burst
		{
			sound[]={\ca\Weapons\Data\Sound\G36_1_SS_A,db15,1}; //G36_1_BS_A
			soundBurst = false;
			reloadTime=0.1;
			ffCount=3;
			recoil=assaultRifleBase;
			recoilProne=assaultRifleBase;

			dispersion=0.005;
		};
		class FullAuto : Mode_FullAuto
		{
			sound[]={\ca\Weapons\Data\Sound\G36_1_SS_A,db15,1};
			soundContinuous=0;
			reloadTime=0.1;
			recoil=assaultRifleBase;
			recoilProne=assaultRifleBase;

			dispersion=0.0035;
		};
		class Library {libTextDesc = $STR_LIB_G36;};
	};
//TODO: G36C a G36K potrebuji poradne nastavit hodnoty, zatim jsou jen v prototypu.
	class G36C : G36a
	{
		scope = public;

		dexterity = 1.7;

		model = \ca\Weapons\G36_C;
		displayName=$STR_DN_G36C;
		picture="\CA\weapons\data\equip\w_g36c_ca.paa";
		UiPicture="\CA\weapons\data\Ico\i_regular_CA.paa";
		class Single : Single
		{
			dispersion=0.003;
			minRange=2;minRangeProbab=0.10;
			midRange=150;midRangeProbab=0.7;
			maxRange=300;maxRangeProbab=0.05;
		};
		class Burst : Burst
		{
			dispersion=0.006;
			minRange=2;minRangeProbab=0.10;
			midRange=60;midRangeProbab=0.7;
			maxRange=100;maxRangeProbab=0.05;
		};
		class FullAuto : FullAuto
		{
			dispersion=0.005;
			minRange=2;minRangeProbab=0.10;
			midRange=20;midRangeProbab=0.7;
			maxRange=60;maxRangeProbab=0.05;
		};
	};
	class G36K : G36a
	{
		scope = public;
		model = \ca\Weapons\G36_K;
		displayName=$STR_DN_G36K;
		picture="\CA\weapons\data\equip\w_g36k_ca.paa";
		UiPicture="\CA\weapons\data\Ico\i_regular_CA.paa";
		class Single : Single
		{
			dispersion=0.002;
			minRange=2;minRangeProbab=0.10;
			midRange=250;midRangeProbab=0.7;
			maxRange=350;maxRangeProbab=0.05;
		};
		class Burst : Burst
		{
			dispersion=0.005;
			minRange=2;minRangeProbab=0.10;
			midRange=80;midRangeProbab=0.7;
			maxRange=120;maxRangeProbab=0.05;
		};
		class FullAuto : FullAuto
		{
			dispersion=0.004;
			minRange=2;minRangeProbab=0.10;
			midRange=25;midRangeProbab=0.7;
			maxRange=70;maxRangeProbab=0.05;
		};
	};
	class M16A2: Rifle
	{
		scope = public;
		value = 0;

		model="\ca\weapons\m16_proxy";
//		modelOptics="\ca\weapons\optika_m16";
		optics = true;

		dexterity = 1.64;

		displayName = $STR_DN_M16A2;
		picture="\CA\weapons\data\equip\w_m16_ca.paa";
		UiPicture="\CA\weapons\data\Ico\i_regular_CA.paa";
		drySound[]={\ca\Weapons\Data\Sound\M16_cock_v1,db-70,1};	// empty magazine
		reloadMagazineSound[]={\ca\Weapons\Data\Sound\M16_reload_v1,db-40,1};

		magazines[] = {20Rnd_556x45_Stanag, 30Rnd_556x45_Stanag, 30Rnd_556x45_StanagSD};

		modes[] = {Single, Burst};
		class Single : Mode_SemiAuto
		{
			sound[]={\ca\Weapons\Data\Sound\M16_3_SS_A,db18,1};		// pokus
			reloadTime=0.15; //puvodne 0.07
			recoil=assaultRifleBase;
			recoilProne=assaultRifleBase;

			dispersion=0.0015;
			minRange=2;minRangeProbab=0.10;
			midRange=250;midRangeProbab=0.7;
			maxRange=400;maxRangeProbab=0.05;
		};
		class Burst : Mode_Burst
		{
			sound[]={\ca\Weapons\Data\Sound\M16_3_SS_A,db20,1}; //M16_3_BS_Aa
			soundBurst = false;
			recoil=assaultRifleBase;
			recoilProne=assaultRifleBase;

			dispersion=0.004;
		};
		class Library {libTextDesc = $STR_LIB_M16;};
	};
	class M16A2GL: M16A2
	{
		displayName=$STR_DN_M16A2GL;
		model="\ca\Weapons\m16_granatomet_proxy.p3d";
		muzzles[] = {M16Muzzle, M203Muzzle};
		picture="\CA\weapons\data\equip\w_m16m203_ca.paa";
		UiPicture="\CA\weapons\data\Ico\i_regular_CA.paa";

		dexterity = 1.46;

		class M16Muzzle: M16A2 {};
		class M203Muzzle: GrenadeLauncher
		{
			displayName=$STR_DN_M203;
			magazines[] = {1Rnd_HE_M203,FlareWhite_M203,FlareGreen_M203,FlareRed_M203,FlareYellow_M203};
			sound[]={\ca\Weapons\Data\Sound\Grenade_launch1_A,db-20,1};
			reloadMagazineSound[]={\ca\Weapons\Data\Sound\flare_reload,db-70,1};
			magazineReloadTime=0;
			reloadTime=0.1;
			optics = true;
			modelOptics="-";
			cameraDir="GL look";
			memoryPointCamera="GL eye";
			opticsZoomMin=0.22;
			opticsZoomMax=0.95;
			opticsZoomInit=0.42;
		};
	};
	class M24 : Rifle
	{
		scope = public;

		model="\ca\weapons\M24_green";
		picture="\CA\weapons\data\equip\w_m24_green_ca.paa";
		UiPicture="\CA\weapons\data\Ico\i_sniper_CA.paa";

		dexterity = 1.35;

		displayName = $STR_DN_M24;

		modelOptics = "\ca\weapons\optika_sniperw";
		opticsFlare = true;
		opticsDisablePeripherialVision = true;
		opticsZoomMin=0.025;
		opticsZoomMax=0.025;
		distanceZoomMin=300;
		distanceZoomMax=300;

		soundContinuous=false;

		sound[]={\ca\Weapons\Data\Sound\M24_single_shot_v1_A,db20,1};
		drySound[]={\ca\Weapons\Data\Sound\M21_dry_v1,db-70,1};
		reloadMagazineSound[]={\ca\Weapons\Data\Sound\M24_reload_v5a,db-50,1};

		minRange=2;minRangeProbab=0.10;
		midRange=400;midRangeProbab=0.7;
		maxRange=700;maxRangeProbab=0.05;
		dispersion=0.0001;

		magazines[]={5Rnd_762x51_M24};

		reloadTime=2;
		backgroundReload = true;
		recoil=assaultRifleBase;
		recoilProne=assaultRifleBase;

		value = NEVER_DESTROY;

		aiRateOfFire=10.0;
		aiRateOfFireDistance=800;

		class Library {libTextDesc = $STR_LIB_M24;};
	};
	class M240: Rifle
	{
		scope = public;
		model="\ca\weapons\M240";
		picture="\CA\weapons\data\equip\w_m240_ca.paa";
		UiPicture="\CA\weapons\data\Ico\i_mg_CA.paa";
		displayName = $STR_DN_M240;

		cursor = MGCursor;
		cursoraim= \ca\Weapons\Data\w_lock;

		modes[] = {manual, close, short, medium, far};
		class manual: Mode_FullAuto
		{
			reloadTime = 0.075;
			recoil=M240Recoil;
			recoilProne=M240RecoilProne;
			dispersion=0.0038;
			sound[]={\ca\Weapons\Data\Sound\M240_1,db15,1};
			soundContinuous = 0;
			soundBurst = false;
			minRange=1;minRangeProbab=0.30;
			midRange=5;midRangeProbab=0.58;
			maxRange=10;maxRangeProbab=0.04;
			showToPlayer = true;
		}
		class close: manual
		{

			burst = 10;
			aiRateOfFire = 0.5;
			aiRateOfFireDistance = 50;
			minRange=10;minRangeProbab=0.05;
			midRange=20;midRangeProbab=0.58;
			maxRange=50;maxRangeProbab=0.04;
			showToPlayer = false;
		};
		class short: close
		{
			burst = 6;
			aiRateOfFire = 2;
			aiRateOfFireDistance = 200;
			minRange=50;minRangeProbab=0.05;
			midRange=100;midRangeProbab=0.58;
			maxRange=200;maxRangeProbab=0.04;

		};
		class medium: close
		{
			burst = 8;
			aiRateOfFire = 4;
			aiRateOfFireDistance = 400;
			minRange=200;minRangeProbab=0.05;
			midRange=300;midRangeProbab=0.58;
			maxRange=400;maxRangeProbab=0.04;

		};
		class far: close
		{
			burst = 7;
			aiRateOfFire = 7;
			aiRateOfFireDistance = 600;
			minRange=400;minRangeProbab=0.05;
			midRange=500;midRangeProbab=0.4;
			maxRange=600;maxRangeProbab=0.01;

		};
		aiDispersionCoefY=7.0;
		aiDispersionCoefX=7.0;

		dexterity = 0.57;

		type = WeaponSlotPrimary + WeaponSlotSecondary;



		reloadMagazineSound[]={\ca\Weapons\Data\Sound\M60gun_reload,db-70,1};

		magazines[]={100Rnd_762x51_M240};
	};
	class M249: Rifle
	{
		scope = public;
		model="\ca\weapons\M249";
		picture="\CA\weapons\data\equip\w_m249_ca.paa";
		UiPicture="\CA\weapons\data\Ico\i_mg_CA.paa";
		displayName = $STR_DN_M249;
		cursor = MGCursor;
		cursoraim= \ca\Weapons\Data\w_lock;

		modes[] = {manual, close, short, medium, far};
		class manual: Mode_FullAuto
		{
			reloadTime = 0.07;
			recoil=M249Recoil;
			recoilProne=M249RecoilProne;
			dispersion=0.004;
			sound[]={\ca\Weapons\Data\Sound\M249_1a,db20,1};
			soundContinuous = 0;
			soundBurst = false;
			minRange=1;minRangeProbab=0.30;
			midRange=5;midRangeProbab=0.58;
			maxRange=10;maxRangeProbab=0.04;
			showToPlayer = true;
		}
		class close: manual
		{

			burst = 10;
			aiRateOfFire = 0.5;
			aiRateOfFireDistance = 50;
			minRange=10;minRangeProbab=0.05;
			midRange=20;midRangeProbab=0.58;
			maxRange=50;maxRangeProbab=0.04;
			showToPlayer = false;
		};
		class short: close
		{
			burst = 6;
			aiRateOfFire = 2;
			aiRateOfFireDistance = 200;
			minRange=50;minRangeProbab=0.05;
			midRange=100;midRangeProbab=0.58;
			maxRange=200;maxRangeProbab=0.04;

		};
		class medium: close
		{
			burst = 8;
			aiRateOfFire = 4;
			aiRateOfFireDistance = 400;
			minRange=200;minRangeProbab=0.05;
			midRange=300;midRangeProbab=0.58;
			maxRange=400;maxRangeProbab=0.04;

		};
		class far: close
		{
			burst = 7;
			aiRateOfFire = 7;
			aiRateOfFireDistance = 600;
			minRange=400;minRangeProbab=0.05;
			midRange=500;midRangeProbab=0.4;
			maxRange=600;maxRangeProbab=0.01;

		};

		aiDispersionCoefY=7.0;
		aiDispersionCoefX=7.0;

		dexterity = 1.21;

		type = WeaponSlotPrimary + WeaponSlotSecondary;

		reloadMagazineSound[]={\ca\Weapons\Data\Sound\M60gun_reload,db-70,1};

		magazines[]={200Rnd_556x45_M249,20Rnd_556x45_Stanag, 30Rnd_556x45_Stanag, 30Rnd_556x45_StanagSD};
		class Library {libTextDesc = $STR_LIB_M249;};
	};
	class M4: Rifle
	{
		scope = public;
		picture="\ca\Weapons\Data\equip\w_m4_ca.paa";
		UiPicture="\CA\weapons\data\Ico\i_regular_CA.paa";

		dexterity = 1.8;

		model="\ca\Weapons\M4_Ironsight";
		optics = true;
		opticsDisablePeripherialVision = true;
		value = 2;
		displayName=$STR_DN_M4;
		drySound[]={\ca\Weapons\Data\Sound\XMS_dry_v2,db-70,1};
		reloadMagazineSound[]={\ca\Weapons\Data\Sound\M4_reload,db-70,1};
		magazines[] = {20Rnd_556x45_Stanag, 30Rnd_556x45_Stanag, 30Rnd_556x45_StanagSD};
		modes[] = {Single, Burst};

		class Single: Mode_SemiAuto
		{
			sound[]={\ca\Weapons\Data\Sound\M4_2_SS_B,db15,1};
			reloadTime=0.09;
			recoil=M4Recoil;
			recoilProne=M4Recoil;
			dispersion=0.0025;
			minRange=2;minRangeProbab=0.10;
			midRange=150;midRangeProbab=0.7;
			maxRange=400;maxRangeProbab=0.05;
		};
		class Burst : Mode_Burst
		{
			sound[]={\ca\Weapons\Data\Sound\M4_2_SS_B,db15,1}; //M4_2_BS_B
			soundBurst = false;
			reloadTime=0.09;
			recoil=M4Recoil;
			recoilProne=M4Recoil;
			dispersion=0.005;
			minRange=2;minRangeProbab=0.10;
			midRange=60;midRangeProbab=0.7;
			maxRange=100;maxRangeProbab=0.05;
		};
		class FullAuto: Mode_FullAuto
		{

			sound[]={\ca\Weapons\Data\Sound\M4_2_SS_B,db15,1};
			reloadTime=0.09;
			recoil=M4Recoil;
			recoilProne=M4Recoil;
			dispersion=0.004;
			minRange=2;minRangeProbab=0.10;
			midRange=30;midRangeProbab=0.7;
			maxRange=60;maxRangeProbab=0.05;
		};
		class Library {libTextDesc = $STR_LIB_M4;};
	};
	class M4AIM: M4
	{
		displayName=$STR_DN_M4_AIM; //TODO: stringtable
		model="\ca\Weapons\M4_Aimpoint";
		//modelOptics="\ca\Weapons\optika_Aimpoint";
		distanceZoomMin=100;
		distanceZoomMax=100;
		picture="\CA\weapons\data\equip\w_m4aim_ca.paa";
		UiPicture="\CA\weapons\data\Ico\i_regular_CA.paa";
		class Library {libTextDesc = $STR_LIB_M4;};
	};
	class M4SPR: M4
	{
		displayName=$STR_DN_M4_SPR;

		dexterity = 1.48;

		model="\ca\Weapons\M4_SPR";
		modelOptics="\ca\Weapons\optika_sniperw";
		picture="\CA\weapons\data\equip\w_spr_ca.paa";
		UiPicture="\CA\weapons\data\Ico\i_regular_CA.paa";


		opticsZoomMin=0.0277; distanceZoomMin=400;
		opticsZoomMax=0.0833; distanceZoomMax=120;

		magazines[]={20Rnd_556x45_Stanag, 30Rnd_556x45_Stanag, 30Rnd_556x45_StanagSD};
		modes[] = {Single};


		class Single: Single
		{
			sound[]={\ca\Weapons\Data\Sound\M4_2_SS_B,db15,1};  //puvodne byl prevzat zvuk z M16 rifle
			dispersion=0.0009;
			minRange=2;minRangeProbab=0.10;
			midRange=250;midRangeProbab=0.7;
			maxRange=500;maxRangeProbab=0.05;
		};
		class Library {libTextDesc = $STR_LIB_M4_SPR;};
	};
	class M4A1: M4
	{
		displayName=$STR_DN_M4A1;
		modes[] = {Single,FullAuto};
		class Library {libTextDesc = $STR_LIB_M4A1;};
	};
	class M4GL: M4
	{
		displayName=$STR_DN_M4_GL; //TODO: stringtable
		model="\ca\Weapons\M4_GL_ACOG";
		picture="\CA\weapons\data\equip\w_m4gl_acog_ca.paa";
		UiPicture="\CA\weapons\data\Ico\i_regular_CA.paa";
		muzzles[] = {M4Muzzle, M203Muzzle};

		dexterity = 1.59;

		class M4Muzzle: M4
		{
			modelOptics="\ca\Weapons\optika_ACOG";
			opticsZoomMin=0.0625; opticsZoomMax=0.0625;
			distanceZoomMin=100; distanceZoomMax=100;
		};
		class M203Muzzle: GrenadeLauncher
		{
			displayName=$STR_DN_M203;
			magazines[] = {1Rnd_HE_M203,FlareWhite_M203,FlareGreen_M203,FlareRed_M203,FlareYellow_M203};
			sound[]={\ca\Weapons\Data\Sound\Grenade_launch2_A,db-5,1};
			reloadMagazineSound[]={\ca\Weapons\Data\Sound\flare_reload,db-70,1};
			magazineReloadTime=0;
			reloadTime=0.1;
			optics = true;
			modelOptics="-";
			cameraDir="GL look";
			memoryPointCamera="GL eye";
			opticsZoomMin=0.22;
			opticsZoomMax=0.95;
			opticsZoomInit=0.42;
		};
		class Library {libTextDesc = $STR_LIB_M4;};
	};
	class M4A1GL: M4GL
	{
		displayName=$STR_DN_M4A1_GL; //TODO: stringtable
		class Library {libTextDesc = $STR_LIB_M4A1;};
		modes[] = {Single, FullAuto};
	};
	class M4A1SD: M4AIM
	{
		fireLightDuration = 0.000;
		fireLightIntensity = 0.000;
		displayName=$STR_DN_M4A1_SD;
		model="\ca\Weapons\M4_SD_Aimpoint";
//		modelOptics="\ca\Weapons\optika_Aimpoint";
		picture="\CA\weapons\data\equip\w_m4SD_aim_ca.paa";
		UiPicture="\CA\weapons\data\Ico\i_regular_CA.paa";
		modes[] = {Single, FullAuto};
		class Single : Single
		{
			sound[]={\ca\Weapons\Data\Sound\MP5_single5,db-40,1};
		};
		class FullAuto : FullAuto
		{
			sound[]={\ca\Weapons\Data\Sound\MP5_single5,db-37,1}; //puvodne MP5-LOOP2
		};
		class Library {libTextDesc = $STR_LIB_M4A1;};
	};
	class MP5SD : Rifle
	{
		scope = public;

		fireLightDuration = 0.000;
		fireLightIntensity = 0.000;

		dexterity = 1.75;

		model="\ca\weapons\HKM5_SD6";
		picture="\CA\weapons\data\equip\W_HKM5_SD6_CA.paa";
		UiPicture="\CA\weapons\data\Ico\i_regular_CA.paa";

		magazines[]={30Rnd_9x19_MP5SD,30Rnd_9x19_MP5};

		displayName = $STR_DN_MP5SD;
		drySound[]={\ca\Weapons\Data\Sound\M16_cock_v1,db-70,1};
		reloadMagazineSound[]={\ca\Weapons\Data\Sound\MP5_reload,db-60,1};
		distanceZoomMin=50;
		distanceZoomMax=50;

		value = NEVER_DESTROY;

		initSpeed=400;
		modes[] = {Single, Burst, FullAuto};
		class Single : Mode_SemiAuto
		{
			sound[]={\ca\Weapons\Data\Sound\MP5_silenced_SS,db-40,1}; //puvodne MP5_single3
			reloadTime=0.07;
			recoil=subMachineGunBase;
			recoilProne=subMachineGunBase;

			dispersion=0.006;
			minRange=2;minRangeProbab=0.10;
			midRange=40;midRangeProbab=0.7;
			maxRange=150;maxRangeProbab=0.05;
		};
		class Burst: Mode_Burst
		{
			sound[]={\ca\Weapons\Data\Sound\MP5_silenced_SS,db-40,1};
			soundContinuous=0;
			soundBurst = false;
			reloadTime=0.1;
			ffCount=1;
			recoil=subMachineGunBase;
			recoilProne=subMachineGunBase;

			dispersion=0.006;
			minRange=2;minRangeProbab=0.10;
			midRange=30;midRangeProbab=0.7;
			maxRange=60;maxRangeProbab=0.05;
		};
		class FullAuto : Mode_FullAuto
		{
			sound[]={\ca\Weapons\Data\Sound\MP5_silenced_SS,db-40,1}; //puvodne loop2
			soundContinuous=0;
			reloadTime=0.1;
			ffCount=1;
			recoil=subMachineGunBase;
			recoilProne=subMachineGunBase;
			aiRateOfFire=0.001;

			dispersion=0.007;
			minRange=2;minRangeProbab=0.20;
			midRange=20;midRangeProbab=0.7;
			maxRange=40;maxRangeProbab=0.05;
		};
		class Library {libTextDesc = $STR_LIB_MP5;};
	};
	class MP5A5 : MP5SD
	{
		model="\ca\weapons\HKM5_A5";
		displayName = $STR_DN_MP5A5;
		picture="\CA\weapons\data\equip\W_HKM5_A5_CA.paa";
		UiPicture="\CA\weapons\data\Ico\i_regular_CA.paa";

		dexterity = 1.8;
		fireLightDuration = 0.05;
		fireLightIntensity = 0.012;

		class Single : Single
		{
			sound[]={\ca\Weapons\Data\Sound\MP5_2,db10,1}; //puvodne MP5_single3
		};
		class Burst: Burst
		{
			sound[]={\ca\Weapons\Data\Sound\MP5_2,db10,1};
		};
		class FullAuto : FullAuto
		{
			sound[]={\ca\Weapons\Data\Sound\MP5_2,db10,1}; //puvodne loop2
		};
		class Library {libTextDesc = $STR_LIB_MP5A5;};
	};
	class PK: Rifle
	{
		scope = public;

		model="\ca\weapons\PK_MG_proxy";
		displayName = $STR_DN_PK;

		dexterity = 0.96;
		picture="\CA\weapons\data\equip\w_pk_ca.paa";
		UiPicture="\CA\weapons\data\Ico\i_mg_CA.paa";
		cursor = MGCursor;
		cursoraim= \ca\Weapons\Data\w_lock;

		modes[] = {manual, close, short, medium, far};
		class manual: Mode_FullAuto
		{
			reloadTime = 0.09;
			recoil=PKMRecoil;
			recoilProne=PKMRecoilProne;
			dispersion=0.005;
			sound[]={\ca\Weapons\Data\Sound\PK_1a_SS,db20,1};
			soundContinuous = 0;
			soundBurst = false;
			minRange=1;minRangeProbab=0.30;
			midRange=5;midRangeProbab=0.58;
			maxRange=10;maxRangeProbab=0.04;
			showToPlayer = true;
		}
		class close: manual
		{

			burst = 10;
			aiRateOfFire = 0.5;
			aiRateOfFireDistance = 50;
			minRange=10;minRangeProbab=0.05;
			midRange=20;midRangeProbab=0.58;
			maxRange=50;maxRangeProbab=0.04;
			showToPlayer = false;
		};
		class short: close
		{
			burst = 6;
			aiRateOfFire = 2;
			aiRateOfFireDistance = 200;
			minRange=50;minRangeProbab=0.05;
			midRange=100;midRangeProbab=0.58;
			maxRange=200;maxRangeProbab=0.04;

		};
		class medium: close
		{
			burst = 8;
			aiRateOfFire = 4;
			aiRateOfFireDistance = 400;
			minRange=200;minRangeProbab=0.05;
			midRange=300;midRangeProbab=0.58;
			maxRange=400;maxRangeProbab=0.04;

		};
		class far: close
		{
			burst = 7;
			aiRateOfFire = 7;
			aiRateOfFireDistance = 600;
			minRange=400;minRangeProbab=0.05;
			midRange=500;midRangeProbab=0.4;
			maxRange=600;maxRangeProbab=0.01;

		};

		aiDispersionCoefY=7.0;
		aiDispersionCoefX=7.0;

		type = WeaponSlotPrimary + WeaponSlotSecondary;

		magazines[]={100Rnd_762x54_PK};
		class Library {libTextDesc = $STR_LIB_PK;};
	};
	class SVD: Rifle
	{
		scope = public;

		model="\ca\weapons\SVD_dragunov_proxy";

		dexterity = 1.57;

		displayName = $STR_DN_SVD;

		modelOptics = "\ca\weapons\optika_snpiere";
		picture="\CA\weapons\data\equip\w_SVD_ca.paa";
		UiPicture="\CA\weapons\data\Ico\i_sniper_CA.paa";

		opticsFlare = true;
		opticsDisablePeripherialVision = true;
		opticsZoomMin=0.0625;
		opticsZoomMax=0.0625;
		distanceZoomMin=200;
		distanceZoomMax=200;

		sound[]={\ca\Weapons\Data\Sound\svd_single_shot_v1_B,db20,1};
		reloadMagazineSound[]={\ca\Weapons\Data\Sound\M21_reload_v4,db-30,1};

		dispersion=0.0005;
		minRange=2;minRangeProbab=0.10;
		midRange=500;midRangeProbab=0.7;
		maxRange=700;maxRangeProbab=0.05;

		reloadTime=0.1;
		autoFire = 0;

		value = NEVER_DESTROY;

		aiRateOfFire=10.0;
		aiRateOfFireDistance=800;


		magazines[]={10Rnd_762x54_SVD};

		class Library {libTextDesc = $STR_LIB_SVD;};
	};



