class CfgDestructPos
{
	scope=protected;
	class DelayedDestruction;
	class DelayedDestructionAmmo : DelayedDestruction
	{
		// we can use lifetime here if desired
		timeBeforeHiding = "21";
		hideDuration = "10";
	};
};

class CfgVehicles
{
	class All;
	class Strategic;
	class Land;
	class LandVehicle: Land
	{
		class ViewPilot;
		class NewTurret;
	};
	class StaticWeapon: LandVehicle
	{
		vehicleClass = "Static";
		driverOpticsModel = "\ca\weapons\optika_empty";

		selectionClan = "clan";
		selectionDashboard = "podsvit pristroju";
		selectionShowDamage = "poskozeni";

		selectionBackLights = "light_back";
		bounding = "usti hlavne";

		alphaTracks = 0.7;
		textureTrackWheel = 0;
		selectionLeftOffset = "";
		selectionRightOffset = "";
		memoryPointTrack1L = "";
		memoryPointTrack1R = "";
		memoryPointTrack2L = "";
		memoryPointTrack2R = "";

		selectionFireAnim = "zasleh";
		fireDustEffect = "FDustEffects";

		class DestructionEffects {};

		memoryPointMissile[] = {"spice rakety", "usti hlavne"};
		memoryPointMissileDir[] = {"konec rakety", "konec hlavne"};
		memoryPointCargoLight = "cargo light";
		gunnerCanSee = CanSeeEye+CanSeeEar+CanSeePeripheral;
		gunnerHasFlares = false;
		class Turrets
		{
			class MainTurret: NewTurret
			{
				memoryPointsGetInGunner= "pos_gunner";
				memoryPointsGetInGunnerDir= "pos_gunner_dir";
				memoryPointGunnerOptics= "gunnerview";
				memoryPointGun= "usti hlavne";
				outGunnerMayFire = 1;
				gunnerOpticsModel = \ca\Weapons\optika_empty;
				minTurn=-180; maxTurn=+180; initTurn=0;
				minElev=-7; maxElev=+70; initElev=0;
				castGunnerShadow = 1;
				ejectDeadGunner = 1;
				class ViewOptics
				{
					initAngleX=0; minAngleX=-30; maxAngleX=+30;
					initAngleY=0; minAngleY=-100; maxAngleY=+100;
					initFov=0.42; minFov=0.22; maxFov=0.64;
				};
			};
		};

		damperSize = 1.4;
		damperForce = .8;
		gearBox[]={-1,0,+1};

		soundEnviron[] = {"", db0, 0.7};
		soundEngine[] = {"", db20, 1};
		soundCrash[] = {"", db-5, 1};
		soundGear[] = {"", db-70, 1};
		soundDammage[] = {"", db-40, 1};
		getInAction=GetInMedium;
		getOutAction = GetOutMedium;

		class Wounds
		{
			tex[]={};
			mat[]={};
		};
		icon = iconTank;
		mapSize = 5;

		displayName=$STR_DN_TANK;
		nameSound="tank";
		accuracy=0.12;

		getInRadius = 3.5;

		fuelCapacity=0;

		irScanRangeMin=500;
		irScanRangeMax=4000;
		irScanToEyeFactor=1;

		armor=20;
		armorStructural=2.0;

		class HitEngine {armor=0.8;material=60;name=motor;passThrough=1;};
		class HitHull {armor=1;material=50;name=telo;passThrough=1;};
		class HitTurret {armor=0.8;material=51;name=vez;passThrough=1;};
		class HitGun {armor=0.6;material=52;name=zbran;passThrough=1;};
		class HitLTrack {armor=0.6;material=53;name=pas_L;passThrough=1;};
		class HitRTrack {armor=0.6;material=54;name=pas_P;passThrough=1;};


		extCameraPosition[]={0,1.5,-9};

		class ViewPilot: ViewPilot
		{
			initAngleX=7; minAngleX=-15; maxAngleX=+25;
			initAngleY=0; minAngleY=-90; maxAngleY=+90;
		};
		cost=1000000;

		steerAheadSimul=0.4;
		steerAheadPlan=0.6;

		predictTurnSimul=1.2;
		predictTurnPlan=1.8;

		hasGunner=1;
		hasCommander=0;
		ejectDeadDriver = 1;
		ejectDeadCargo = 1;
		hasDriver = 0;
		nightVision=0;

		driverAction = ManActCargo;
		driverInAction = ManActCargo;
		simulation=tank;

		// static weapons usually have no occlusion
		occludeSoundsWhenIn = db-0;
		obstructSoundsWhenIn = db-0;

		formationX=10;
		formationZ=10;
		precision=1;
		brakeDistance=0;

		maxSpeed=0;
		canFloat=0;
		weapons[]={FakeWeapon};
		magazines[]={FakeWeapon};
		type=1;
		threat[]={0.7, 1, 0.3};

		camouflage = 1;
		audible = 1;

		hideProxyInCombat = 0;

		driverOpticsColor[] = {0, 0, 0, 1};

		class CargoLight
		{
			color[] = {0, 0, 0, 0};
			ambient[] = {0.6, 0, 0.15, 1};
			brightness = 0.007;
		};
		transportMaxMagazines = 0;
		transportMaxWeapons = 0;
		class Reflectors {};
		secondaryExplosion=0;

	};
	#include "AmmoBoxes.hpp"
	class SearchLight: StaticWeapon
	{
  		scope = 2;
		side = 1;
		crew = "SoldierWB";
		model="\ca\Weapons\searchlight_manual";
		picture="\ca\Weapons\data\ico\searchlight_manual_CA.paa";
		icon= "\Ca\weapons\Data\map_ico\icomap_searchlight_manual_CA.paa";
		mapSize = 4;
		nameSound="light";
		typicalCargo[]={SoldierWB};
		displayName=$STR_DN_SEARCHLIGHT;
		gunnerHasFlares = true;
		class Turrets: Turrets
		{
			class MainTurret: MainTurret
			{
			  weapons[]={SEARCHLIGHT};
				minElev=-10;
				minTurn=-180; maxTurn=+180; initTurn=0;
				gunnerAction = "searchlight_Gunner";
			};
		};
	  	class Reflectors
		{
			class main_reflector
			{
			color[] = {0.8, 0.8, 0.9, 1.0};
				ambient[] = {0.1, 0.1, 0.1, 1.0};
				position = "light";
				direction = "lightEnd";
				hitpoint = "light";
				selection = "light";
				size = 1.0;
				brightness = 5.0;
			};
		};
		class Library {libTextDesc = $STR_LIB_SEARCHLIGHT;};
	};
	class ThingEffect;
	class FxCartridge: ThingEffect
	{
		model = "\ca\weapons\nabojnice";
		displayName=$STR_DN_FX_CARTRIDGE;

		submerged = -0; // initial submersion, <0 inital delaty
		submergeSpeed = 0;
		timeToLive = 5; // always disappear after certain period of time

		disappearAtContact=true;
	};
	class FxCartridge_Small: ThingEffect
	{
		model = "\ca\weapons\nabojnice_small";
		displayName=$STR_DN_FX_CARTRIDGE;

		submerged = -0; // initial submersion, <0 inital delaty
		submergeSpeed = 0;
		timeToLive = 5; // always disappear after certain period of time

		disappearAtContact=true;
	};
	class LaserTarget: All
	{
		icon="\ca\data\data\Unknown_object";

		displayName = $STR_DN_LASER_TARGET;
		nameSound="laserdesignator";
		model = "\ca\Weapons\laserTgt.p3d";
		picture="\ca\Weapons\data\ico\i_regular_CA.paa";
		weapons[]={M2}; // make AI consider it "combat" enemy
		magazines[]={};

		//threat[] VSoft, VArmor, VAir
		threat[]={0.2, 0.5, 1.0};

		//model = "terc";
		simulation="laserTarget";
	};
	class LaserTargetBase: LaserTarget	{};
	class LaserTargetCBase: LaserTargetBase	{scope = protected;	side = TCivilian;	};
	class LaserTargetWBase: LaserTargetBase	{scope = protected;	side = TEast;	};
	class LaserTargetEBase: LaserTargetBase	{scope = protected;	side = TWest;	};
	class LaserTargetC: LaserTargetCBase	{accuracy=1000;	weapons[]={};	magazines[]={};	};
	class LaserTargetW: LaserTargetWBase	{accuracy=1000;	weapons[]={};	magazines[]={};	};
	class LaserTargetE: LaserTargetEBase	{accuracy=1000;	weapons[]={};	magazines[]={};	};

	class Logic: All
	{
		icon = "\ca\weapons\data\iconLogic";
		model = "\ca\weapons\empty";
		picture = pictureLogic;
	};
};

class CfgNonAIVehicles
{

	class ProxyWeapon {};
	class ProxySecWeapon {};

	class ProxyTOW_Proxy: 		ProxyWeapon {model = \JSDF_H\_w\TOW_proxy;	simulation = "maverickweapon";};
	class ProxyAIM92_Proxy: 	ProxyWeapon {model = \JSDF_H\_w\FIM92A_proxy;	simulation = "maverickweapon";};

};
