#define mag_xx(a,b) class _xx_##a {magazine = a; count = b;}
#define weap_xx(a,b) class _xx_##a {weapon = a; count = b;}

#define DefaultWestMagazines(x) \
	class TransportMagazines \
	{ \
		mag_xx(30Rnd_556x45_Stanag,30*x); \
		mag_xx(200Rnd_556x45_M249,6*x); \
		mag_xx(HandGrenadeTimed,10*x); \
		mag_xx(5Rnd_762x51_M24,10*x); \
		mag_xx(15rnd_9x19_M9,15*x); \
		mag_xx(FlareWhite_M203,6*x); \
		mag_xx(FlareRed_M203,6*x); \
		mag_xx(FlareGreen_M203,6*x); \
		mag_xx(FlareYellow_M203,6*x); \
		mag_xx(Smokeshell,6*x); \
		mag_xx(SmokeshellRed,6*x); \
		mag_xx(SmokeshellGreen,6*x); \
		mag_xx(Mine,4*x); \
		mag_xx(M136,3*x); \
		mag_xx(1rnd_HE_M203,3*x); \
	};

#define DefaultEastMagazines(x) \
	class TransportMagazines \
	{ \
		mag_xx(30Rnd_545x39_AK,30*x); \
		mag_xx(100Rnd_762x54_PK,10*x); \
		mag_xx(8Rnd_9x18_Makarov,20*x); \
		mag_xx(HandGrenade,10*x); \
		mag_xx(10Rnd_762x54_SVD,10*x); \
		mag_xx(FlareWhite_GP25,6*x); \
		mag_xx(FlareRed_GP25,6*x); \
		mag_xx(FlareGreen_GP25,6*x); \
		mag_xx(FlareYellow_GP25,6*x); \
		mag_xx(Smokeshell,6*x); \
		mag_xx(SmokeshellRed,6*x); \
		mag_xx(SmokeshellGreen,6*x); \
		mag_xx(MineE,4*x); \
		mag_xx(PG7V,3*x); \
		mag_xx(1rnd_HE_GP25,3*x); \
	};

#define DefaultGuerMagazines(x) \
	class TransportMagazines \
	{ \
		mag_xx(30Rnd_556x45_Stanag,30*x); \
		mag_xx(HandGrenade,10*x); \
		mag_xx(200Rnd_556x45_M249,6*x); \
		mag_xx(30Rnd_9x19_MP5,10*x); \
		mag_xx(15rnd_9x19_M9,15*x); \
		mag_xx(FlareWhite_M203,6*x); \
		mag_xx(FlareRed_M203,6*x); \
		mag_xx(FlareGreen_M203,6*x); \
		mag_xx(FlareYellow_M203,6*x); \
		mag_xx(Smokeshell,6*x); \
		mag_xx(SmokeshellRed,6*x); \
		mag_xx(SmokeshellGreen,6*x); \
		mag_xx(Mine,4*x); \
		mag_xx(M136,3*x); \
		mag_xx(1rnd_HE_M203,3*x); \
	};

class ReammoBox: Strategic
{
	animated = false;
	scope=protected;

	icon="\Ca\weapons\Data\map_ico\icomap_ammo_CA.paa";
	model = "\ca\weapons\ABox.p3d";

	displayName=$STR_DN_AMMO_CRATES;
	nameSound="ammocrate";
	accuracy=0.20;
	typicalCargo[]={};

	vehicleClass="Ammo";
	destrType=DestructBuilding;

	class DestructionEffects
	{

		class Light1
		{
			simulation = "light";
			type = "ObjectDestructionLight";
			position = "destructionEffect1";

			intensity = 0.001;
			interval = 1;
			lifeTime = 3;
		};
		class Sound
		{
			simulation = "sound";
			type = "Fire";
			position = "destructionEffect1";
			intensity = 0.15;
			interval = 1;
			lifeTime = 3;
		};
		class Fire1
		{
			simulation = "particles";
			type = "ObjectDestructionFire";
			position = "destructionEffect1";

			intensity = 0.15;
			interval = 1;
			lifeTime = 3;
		};
		class Fire2
		{
			simulation = "particles";
			type = "ObjectDestructionFire";
			position = "destructionEffect1";

			intensity = 0.15;
			interval = 1;
			lifeTime = 3;
		};
		class Smoke1
		{
			simulation = "particles";
			type = "ObjectDestructionSmoke";
			position = "destructionEffect1";

			intensity = 0.15;
			interval = 1;
			lifeTime = 3.2;
		};
		class Smoke2
		{
			simulation = "particles";
			type = "ObjectDestructionSmoke2";
			position = "destructionEffect1";

			intensity = 0.15;
			interval = 1;
			lifeTime = 3.4;
		};
		class Smoke3
		{
			simulation = "particles";
			type = "ObjectDestructionSmoke3";
			position = "destructionEffect1";

			intensity = 0.125;
			interval = 1;
			lifeTime = 3.5;
		};
		class HouseDestr
		{
			simulation = "destroy";
			type = "DelayedDestructionAmmo";
			// for destroy parameters do not matter
			position = "";
			intensity = 1;
			interval = 1;
			lifeTime = 1;
		};
	};

	transportMaxWeapons = 5000;
	transportMaxMagazines = 20000;

	transportAmmo = 0;
	transportRepair = 0;
	transportFuel = 0;

	supplyRadius = 1.4;

	cost=0;
	armor=200;
	mapSize = 2.0;
};
class WeaponHolder : ReammoBox
{
	scope = protected;
	model = "\ca\weapons\dummyweapon.p3d";
	accuracy = 0.20;
	class TransportMagazines {};
	forceSupply = true;
	showWeaponCargo = true;
	transportMaxMagazines = 1e9;	// unlimited
	transportMaxWeapons = 1e9;	// unlimited
	displayName=;
	destrType=DestructNo;
};

//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
//*-*-*-*-*-*-US Ammo boxes-*-*-*-*-*-*-*/
//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

class AmmoBoxWest: ReammoBox
{
	scope = public;
	accuracy = 1000;
	displayName=$STR_DN_AMMO_CRATES_WEST;
	class TransportMagazines
	{
		mag_xx(30Rnd_556x45_Stanag,100);
		mag_xx(200Rnd_556x45_M249,40);
		mag_xx(100Rnd_762x51_M240,40);
		mag_xx(15Rnd_9x19_M9,20);
		mag_xx(HandGrenadeTimed,30);
		mag_xx(1rnd_HE_M203,20);
		mag_xx(FlareWhite_M203,6);
		mag_xx(FlareRed_M203,6);
		mag_xx(FlareGreen_M203,6);
		mag_xx(FlareYellow_M203,6);
	};
	class TransportWeapons
	{
		weap_xx(M4,4);
	};
};
class WeaponBoxWest: AmmoBoxWest
{
	model = "\ca\Weapons\hromada_beden.p3d";
	displayName=$STR_DN_AMMO_CRATES_WP_WEST;
	class TransportMagazines
	{
		mag_xx(30Rnd_556x45_Stanag,200);
		mag_xx(15Rnd_9x19_M9,50);
		mag_xx(200Rnd_556x45_M249,50);
		mag_xx(100Rnd_762x51_M240,50);
		mag_xx(HandGrenadeTimed,30);
		mag_xx(M136,10);
		mag_xx(1rnd_HE_M203,20);
		mag_xx(FlareWhite_M203,6);
		mag_xx(FlareRed_M203,6);
		mag_xx(FlareGreen_M203,6);
		mag_xx(FlareYellow_M203,6);
		mag_xx(PipeBomb,3);
	};
	class TransportWeapons
	{
		weap_xx(M9,10);
		weap_xx(M4,4);
		weap_xx(M4GL,4);
		weap_xx(M4SPR,4);
		weap_xx(M249,4);
		weap_xx(M4AIM,1);
		weap_xx(M136,1);
	};
};
class SpecialBoxWest: AmmoBoxWest
{
	model = "\ca\weapons\ABox.p3d";
	displayName=$STR_DN_AMMO_CRATES_SP_WEST;
	class TransportMagazines
	{
		mag_xx(30Rnd_556x45_Stanag,200);
		mag_xx(200Rnd_556x45_M249,40);
		mag_xx(5Rnd_762x51_M24,20);
		mag_xx(15Rnd_9x19_M9,50);
		mag_xx(30Rnd_556x45_G36,40);
		mag_xx(HandGrenadeTimed,30);
		mag_xx(M136,10);
		mag_xx(1rnd_HE_M203,20);
		mag_xx(FlareWhite_M203,6);
		mag_xx(FlareRed_M203,6);
		mag_xx(FlareGreen_M203,6);
		mag_xx(FlareYellow_M203,6);
		mag_xx(Stinger,5);
		mag_xx(PipeBomb,8);
	};
	class TransportWeapons
	{
		weap_xx(M9SD,10);
		weap_xx(M4A1,4);
		weap_xx(M4A1GL,4);
		weap_xx(M4SPR,4);
		weap_xx(M249,4);
		weap_xx(M136,3);
		weap_xx(G36A,2);
		weap_xx(G36C,2);
		weap_xx(G36K,2);
		weap_xx(M4A1SD,2);
		weap_xx(M4AIM,6);
		weap_xx(M24,2);
		weap_xx(Stinger,2);
	};
};

//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
//*-*-*-*-*-*SLA Ammo boxes-*-*-*-*-*-*-*/
//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

class AmmoBoxEast: ReammoBox
{
	scope = public;
	accuracy = 1000;
	model = "\ca\weapons\ABoxR.p3d";
	displayName=$STR_DN_AMMO_CRATES_EAST;
	class TransportMagazines
	{
		mag_xx(30Rnd_545x39_AK,100);
		mag_xx(100Rnd_762x54_PK,100);
		mag_xx(8Rnd_9x18_Makarov,20);
		mag_xx(HandGrenade,30);
		mag_xx(PG7V,4);
		mag_xx(1rnd_HE_GP25,20);
		mag_xx(FlareWhite_GP25,6);
		mag_xx(FlareRed_GP25,6);
		mag_xx(FlareGreen_GP25,6);
		mag_xx(FlareYellow_GP25,6);
	};
	class TransportWeapons
	{
		weap_xx(AK74,4);
	};
};

class WeaponBoxEast: AmmoBoxEast
{
	model = "\ca\Weapons\hromada_beden.p3d";
	displayName=$STR_DN_AMMO_CRATES_WP_EAST;
	class TransportMagazines
	{
		mag_xx(30Rnd_545x39_AK,200);
		mag_xx(8Rnd_9x18_Makarov,50);
		mag_xx(100Rnd_762x54_PK,200);
		mag_xx(30Rnd_545x39_AKSD,100);
		mag_xx(HandGrenade,30);
		mag_xx(PG7V,10);
		mag_xx(1rnd_HE_M203,20);
		mag_xx(FlareWhite_GP25,6);
		mag_xx(FlareRed_GP25,6);
		mag_xx(FlareGreen_GP25,6);
		mag_xx(FlareYellow_GP25,6);
		mag_xx(PipeBomb,3);
	};
	class TransportWeapons
	{
		weap_xx(Makarov,10);
		weap_xx(AK74,10);
		weap_xx(AKS74U,4);
		weap_xx(AK74GL,4);
		weap_xx(PK,2);
		weap_xx(AKS74UN,1);
		weap_xx(RPG7V,1);
	};
};

class SpecialBoxEast: AmmoBoxEast
{
	model = "\ca\weapons\ABoxR.p3d";
	displayName=$STR_DN_AMMO_CRATES_SP_EAST;
	class TransportMagazines
	{
		mag_xx(30Rnd_545x39_AK,200);
		mag_xx(8Rnd_9x18_Makarov,50);
		mag_xx(100Rnd_762x54_PK,200);
		mag_xx(30Rnd_545x39_AKSD,100);
		mag_xx(10Rnd_762x54_SVD,20);
		mag_xx(HandGrenade,30);
		mag_xx(1rnd_HE_GP25,20);
		mag_xx(FlareWhite_GP25,6);
		mag_xx(FlareRed_GP25,6);
		mag_xx(FlareGreen_GP25,6);
		mag_xx(FlareYellow_GP25,6);
		mag_xx(PG7V,10);
		mag_xx(Strela,10);
		mag_xx(PipeBomb,8);
	};
	class TransportWeapons
	{
		weap_xx(Makarov,10);
		weap_xx(AK74,10);
		weap_xx(AKS74U,4);
		weap_xx(AK74GL,4);
		weap_xx(PK,4);
		weap_xx(AKS74UN,4);
		weap_xx(RPG7V,2);
		weap_xx(Strela,2);
		weap_xx(SVD,1);
	};
};


//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
//*-*-*-*South Army Ammo boxes-*-*-*-*-*-/
//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

class AmmoBoxGuer: ReammoBox
{
	scope = public;
	accuracy = 1000;
	displayName=$STR_DN_AMMO_CRATES_GUER;
	model = "\ca\weapons\ABoxR.p3d";
	class TransportMagazines
	{
		mag_xx(30Rnd_556x45_Stanag,100);
		mag_xx(100Rnd_762x51_M240,40);
		mag_xx(15Rnd_9x19_M9,20);
		mag_xx(HandGrenadeTimed,30);
		mag_xx(M136,4);
		mag_xx(1rnd_HE_M203,20);
		mag_xx(FlareWhite_M203,6);
		mag_xx(FlareRed_M203,6);
		mag_xx(FlareGreen_M203,6);
		mag_xx(FlareYellow_M203,6);
		mag_xx(PipeBomb,3);
	};
	class TransportWeapons
	{
		weap_xx(M16A2,4);
	};
};

class WeaponBoxGuer: AmmoBoxGuer
{
	displayName=$STR_DN_AMMO_CRATES_WP_GUER;
	model = "\ca\Weapons\hromada_beden.p3d";
	class TransportMagazines
	{
		mag_xx(100Rnd_762x51_M240,40);
		mag_xx(15Rnd_9x19_M9,20);
		mag_xx(M136,4);
		mag_xx(1rnd_HE_M203,20);
		mag_xx(FlareWhite_M203,6);
		mag_xx(FlareRed_M203,6);
		mag_xx(FlareGreen_M203,6);
		mag_xx(FlareYellow_M203,6);
		mag_xx(PipeBomb,3);
	};
	class TransportWeapons
	{
		weap_xx(M16A2,10);
		weap_xx(M240,5);
		weap_xx(M16A2GL,5);
		weap_xx(M136,3);
		weap_xx(M9,2);
	};
};

class SpecialBoxGuer: AmmoBoxGuer {displayName=$STR_DN_AMMO_CRATES_SP_GUER;}; //TODO: FILL IT

