class CfgPatches
{
	class JSDF_LAV
	{
		units[]			={"JSDF_LAMV"};
		weapons[]		={};
		requiredAddons[]	={};
		requiredVersion		=1.900000;
	};
};

class CfgModels
{
        class Default{};
	class Vehicle:Default{};
	class JSDF_LandVehicle:Vehicle{};

        class JASDF_LAV:		JSDF_LandVehicle{};
        class JGSDF_LAV:		JSDF_LandVehicle{};
        class JGSDF_LAV_w:		JSDF_LandVehicle{};
        class JGSDF_IRSG_LAV:		JSDF_LandVehicle{};
	
        class JASDF_LAV_MINIMI:		JSDF_LandVehicle{};
        class JGSDF_LAV_MINIMI:		JSDF_LandVehicle{};
        class JGSDF_LAV_MINIMI_w:	JSDF_LandVehicle{};
        class JGSDF_IRSG_LAV_MINIMI:	JSDF_LandVehicle{};
};

class WeaponCloudsGun{};
class WeaponCloudsMGun:WeaponCloudsGun{};

class CfgVehicles
{
	class All{};
	class AllVehicles:	All{};
	class Land:		AllVehicles{};
	class LandVehicle:	Land{};
	class JSDF_LandVehicle:	LandVehicle{};
	
	///////////////////////////////////////////////////////////////////////////LAMV
	class JSDF_LAV_base	:	JSDF_LandVehicle
	{
		scope			=0;
		side			=1;
		vehicleclass		="LandVehicle/JSDF";
		displayName		="LAV";
		nameSound		="Car";
		
		icon			=\JSDF_LAV\LAMV\icon_LAV;
		picture			=\JSDF_LAV\LAMV\pic_LAV;
		model			=\JSDF_LAV\LAMV\JSDF_LAV;
		soundEngine[]		={"\JSDF_LAV\LAMV\JSDF_LAV_Eng",0.15,1};

		mapSize			=5.5;
		hiddenSelections[]	={"no0","no1","no2","no3","no4","no5","no6","noA","noB","noC"};
		
		crew			="BOHSoldierNew";
		driverAction		="ManActJSDF_LAVDriver";
		cargoAction[]		={"ManActJSDF_LAVcargo"};
		transportSoldier	=3;
		castDriverShadow	=0;
		castCargoShadow		=0;
		hideWeaponsDriver	=1;
		hideWeaponsCargo	=1;
		
		maxSpeed		=100;
		type			=VArmor;
		transportMaxMagazines	=50;
		transportMaxWeapons	=10;
		
		wheelCircumference	=5.0;
		turnCoef		=3.0; 
		terrainCoef		=2.0;
		
		armor			=100;
		armorBody		=1.2;
		armorFuel		=1.2;
		armorLights		=0.4;
		armorWheels		=1.2;
		armorGlass		=1.2;
		dammageHalf[]		={};
		dammageFull[]		={};
		
		class HitEngine		{armor=1.2;	material=50;	name="engine";	passThrough=1;};
		
		class IndicatorSpeed
		{
			selection="ukaz_rychlo";
			axis="osa_rychlo";
			angle=-300;
			min=0;
			max = 170/ 3.6;
		};
		class IndicatorRPM
		{
			selection = "ukaz_rpm";
			axis = "osa_rpm";
			angle = -236.6;
			min = 0;
			max = 1.2;
		};
		class TransportMagazines
		{
			class _xx_Type89		{magazine="JSDF_556_30Mag";	count="8*1";};
			class _xx_Type64		{magazine="JSDF_Type64R_Mag";	count="8*1";};
			class _xx_JSDF_9mmP_Mag		{magazine="JSDF_9mmP_Mag";	count="8*1";};
			class _xx_JSDF_9mmMP_Mag	{magazine="JSDF_9mmMP_Mag";	count="8*1";};
			class _xx_HandGrenade		{magazine="HandGrenade";	count="8*1";};
		};
		class EventHandlers
		{
			init = "_this exec {\BOHCONFIG\Soldiers\CrewCheck.sqs};[_this select 0] exec ""\JSDF_LAV\scripts\LAV_no.sqs""";
			killed = "[_this select 0,0,-4] exec {\BOHCONFIG\scripts\BOH_FireSmoke.sqs};";
		};
	};
	class JSDF_LAV_MINIMI_base:	JSDF_LAV_base
	{
		displayName		="LAV/MINIMI";
		picture			=\JSDF_LAV\LAMV\pic_LAVm;
		model			=\JSDF_LAV\LAMV\JSDF_LAV_MINIMI;
		
		hasGunner		=1;
		driverIsCommander	=1;
		driverAction		="ManActJSDF_LAVDriver";
		gunnerAction		="ManActJSDF_LAVGunner";
		cargoAction[]		={"ManActJSDF_LAVcargo"};
		transportSoldier	=3;
		castDriverShadow	=0;
		castGunnerShadow	=1;
		castCargoShadow		=0;
		hideWeaponsDriver	=1;
		hideWeaponsGunner	=1;
		hideWeaponsCargo	=1;
		ejectDeadGunner		=0;
		
		weapons[]		={"JSDF_MINIMI_Car"};
		magazines[]		={"JSDF_MINIMI_Mag","JSDF_MINIMI_Mag","JSDF_MINIMI_Mag","JSDF_MINIMI_Mag","JSDF_MINIMI_Mag"};
		
		class Turret
		{
			gunAxis="osa hlavne";
			turretAxis="osa veze";
			soundServo[]={};
			gunBeg="usti hlavne";
			gunEnd="konec hlavne";
			minElev=-15;
			maxElev=30;
			minTurn=-360;
			maxTurn=360;
			body="OtocVez";
			gun="OtocHlaven";
		};
		class ViewGunner
		{
			initAngleX=5;	minAngleX=-30;	maxAngleX=30;
			initAngleY=0;	minAngleY=-25;	maxAngleY=25;
			initFov=0.7;	minFov=0.5;	maxFov=0.9;
		};
	};

	class JGSDF_LAV:JSDF_LAV_base
	{
		scope			=2;
		displayName		="JGSDF LAV";
		model			=\JSDF_LAV\LAMV\JGSDF_LAV;
	};
	class JGSDF_LAV_MINIMI:JSDF_LAV_MINIMI_base
	{
		scope			=2;
		displayName		="JGSDF LAV/MINIMI";
		model			=\JSDF_LAV\LAMV\JGSDF_LAV_MINIMI;
	};
	class JGSDF_LAV_w:JGSDF_LAV
	{
		vehicleclass		="Winter LandVehicle/JSDF";
		model			=\JSDF_LAV\LAMV\JGSDF_LAV_w;
	};
	class JGSDF_LAV_MINIMI_w:JGSDF_LAV_MINIMI
	{
		vehicleclass		="Winter LandVehicle/JSDF";
		model			=\JSDF_LAV\LAMV\JGSDF_LAV_MINIMI_w;
	};
	class JASDF_LAV		:	JGSDF_LAV
	{
		displayName		="JASDF LAV";
		picture			=\JSDF_LAV\LAMV\pic_LAVa;
		model			=\JSDF_LAV\LAMV\JASDF_LAV;
		crew			="BOHJasdfSol";
		class EventHandlers
		{
			init = "_this exec {\BOHCONFIG\Soldiers\CrewCheck.sqs};[_this select 0] exec ""\JSDF V\scripts\no_JASDF.sqs""";
			killed = "[_this select 0,0,-4] exec {\BOHCONFIG\scripts\BOH_FireSmoke.sqs};";
		};
	};
	class JASDF_LAV_MINIMI	:	JGSDF_LAV_MINIMI
	{
		displayName		="JASDF LAV/MINIMI";
		picture			=\JSDF_LAV\LAMV\pic_LAVam;
		model			=\JSDF_LAV\LAMV\JASDF_LAV_MINIMI;
		crew			="BOHJasdfSol";
		class EventHandlers
		{
			init = "_this exec {\BOHCONFIG\Soldiers\CrewCheck.sqs};[_this select 0] exec ""\JSDF V\scripts\no_JASDF.sqs""";
			killed = "[_this select 0,0,-4] exec {\BOHCONFIG\scripts\BOH_FireSmoke.sqs};";
		};
	};
	class IRSG_JGSDF_LAV	:	JGSDF_LAV
	{
		vehicleclass		="IRSG";
		displayName		="JGSDF LAV";
		picture			=\JSDF_LAV\LAMV\pic_LAVi;
		model			=\JSDF_LAV\LAMV\JGSDF_IRSG_LAV;
		crew			="BOHSoldierI";
	};
	class IRSG_JGSDF_LAV_MINIMI:	JGSDF_LAV_MINIMI
	{
		vehicleclass		="IRSG";
		displayName		="JGSDF LAV/MINIMI";
		picture			=\JSDF_LAV\LAMV\pic_LAVim;
		model			=\JSDF_LAV\LAMV\JGSDF_IRSG_LAV_MINIMI;
		crew			="BOHSoldierI";
	};
};
class CfgVehicleActions
{
	JSDF_LAVDriver=		"JSDF_LAVDriver";
	JSDF_LAVGunner=		"JSDF_LAVGunner";
	JSDF_LAVCargo=		"JSDF_LAVCargo";
};

class CfgMovesMC
{
	class Default {};
	class DefaultDie: Default {};

	class States
	{
		class Driver: Default {};

		#define VEH_DIE_CONN(Name,anim,time) \
			class Name##Dying: DefaultDie \
			{ \
				actions = NoActions; \
				file=anim##smrt.rtm; \
				speed=-time; \
				looped=false; \
				soundEnabled=false; \
				connectFrom[]={Name,1}; \
			}; \
			class Name##Dead: Name##Dying \
			{ \
				actions = DeadActions; \
				file=anim##smrt2.rtm; \
				speed=SPEED_STATIC; \
				terminal = true; \
				connectFrom[]={Name##Dying,1}; \
				connectTo[]={DeadState,1}; \
			}
		#define VEHIN_MOVES_VAR(Name,anim,vartime) \
			class Name: Driver \
			{ \
				file=anim##stat.rtm; \
				speed=SPEED_STATIC; \
				looped=true; \
				variantsAI[]= {Name##V1,0.7,Name};\
				interpolateWith[]={Name##V1,0.5};\
				equivalentTo=Name; \
				interpolationSpeed=1; \
				connectTo[]={Name##Dying,1}; \
			} \
			class Name##V1: Name \
			{ \
				file=anim.rtm; \
				speed=-vartime; \
				looped=true; \
			}
		#define VEHIN_MOVES_VAR_NODEAD(Name,anim,vartime) \
			class Name: Driver \
			{ \
				file=anim##stat.rtm; \
				speed=SPEED_STATIC; \
				looped=true; \
				variantsAI[]= {Name##V1,0.7,Name};\
				interpolateWith[]={Name##V1,0.5};\
				equivalentTo=Name; \
				interpolationSpeed=1; \
			} \
			class Name##V1: Name \
			{ \
				file=anim.rtm; \
				speed=-vartime; \
				looped=true; \
			}
		#define VEH_MOVES_VAR(Name,anim,time,vartime) \
			VEHIN_MOVES_VAR(Name,anim,vartime); \
			VEH_DIE_CONN(Name,anim,time)

		VEH_MOVES_VAR(JSDF_LAVDriver,		\JSDF_LAV\LAMV\JSDF_LAVdriver,	1, 4);
		VEH_MOVES_VAR(JSDF_LAVGunner,		\JSDF_LAV\LAMV\JSDF_LAVgunner,	1, 4);
		VEH_MOVES_VAR(JSDF_LAVCargo,		\JSDF_LAV\LAMV\JSDF_LAVcargo,	1, 4);
	};
};