class CfgPatches
{
	class JSDF_VLA_t96WAPC
	{
		units[] = {t96WAPC};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {"CAWheeled2", "CACharacters2", "CAWeapons"};
	};
};

class CfgVehicles
{
	class Land;	// External class reference
	
	class LandVehicle : Land {
		class HitPoints;	// External class reference
	};
	
	class car : LandVehicle {
		class HitPoints {
			class HitLFWheel;	// External class reference
			class HitLBWheel;	// External class reference
			class HitLMWheel;	// External class reference
			class HitLF2Wheel;	// External class reference
			class HitRFWheel;	// External class reference
			class HitRBWheel;	// External class reference
			class HitRMWheel;	// External class reference
			class HitRF2Wheel;	// External class reference
		};
		class NewTurret;	// External class reference
		
		class Turrets {
			class MainTurret : NewTurret {
				class HitPoints;	// External class reference
			};
		};
		class ViewPilot;	// External class reference
		class AnimationSources;	// External class reference
	};
	
	class Wheeled_APC : car {};
	
	class t96WAPC_Base : Wheeled_APC {
		wheelCircumference = 3.277;
		side = 1;
		faction = JGSDF;
		model = "\JSDF_VLA\t96WAPC\JGSDF_Type96WAPC_B0";
		displayName = Type96 WAPC;
		
		class Library {
			libTextDesc = $STR_LIB_LAV25;
		};
		vehicleClass = "Armored";
		picture = "\Ca\wheeled2\data\UI\Picture_LAV25_CA.paa";
		Icon = "\Ca\wheeled2\data\UI\Icon_LAV25_CA.paa";
		mapSize = 7;
		canFloat = 1;
		maxSpeed = 100;
		fuelCapacity = 300;
		unitInfoType = "UnitInfoShip";
		hideProxyInCombat = 1;
		threat[] = {0.5, 0.5, 0.5};
		armor = 150;
		damageResistance = 0.02432;
		crewVulnerable = 0;
		
		class HitPoints : HitPoints {
			class HitEngine {
				armor = 2;
				material = -1;
				name = "";
				visual = "";
				passThrough = 0.5;
			};
			
			class HitFuel {
				armor = 1;
				material = -1;
				name = "";
				visual = "";
				passThrough = 0;
			};
			
			class HitLFWheel : HitLFWheel {
				armor = 0.4;
				passThrough = 0.4;
			};
			
			class HitLBWheel : HitLBWheel {
				armor = 0.4;
				passThrough = 0.4;
			};
			
			class HitLMWheel : HitLMWheel {
				armor = 0.4;
				passThrough = 0.4;
			};
			
			class HitLF2Wheel : HitLF2Wheel {
				armor = 0.4;
				passThrough = 0.4;
			};
			
			class HitRFWheel : HitRFWheel {
				armor = 0.4;
				passThrough = 0.4;
			};
			
			class HitRBWheel : HitRBWheel {
				armor = 0.4;
				passThrough = 0.4;
			};
			
			class HitRMWheel : HitRMWheel {
				armor = 0.4;
				passThrough = 0.4;
			};
			
			class HitRF2Wheel : HitRF2Wheel {
				armor = 0.4;
				passThrough = 0.4;
			};
			
			class HitBody {
				armor = 1;
				material = 51;
				name = "zbytek";
				visual = "";
				passThrough = 1;
			};
		};
		
		class Damage {
			tex[] = {};
			mat[] = {"ca\wheeled2\LAV25\Data\lav_glass_green.rvmat", "ca\wheeled2\LAV25\Data\lav_glass_green_damage.rvmat", "ca\wheeled2\LAV25\Data\lav_glass_green_destruct.rvmat", "ca\wheeled2\LAV25\Data\lav_glass_red.rvmat", "ca\wheeled2\LAV25\Data\lav_glass_red_damage.rvmat", "ca\wheeled2\LAV25\Data\lav_glass_red_destruct.rvmat", "ca\wheeled2\LAV25\Data\lav_hq.rvmat", "ca\wheeled2\LAV25\Data\lav_hq_damage.rvmat", "ca\wheeled2\LAV25\Data\lav_hq_destruct.rvmat", "ca\wheeled2\LAV25\Data\lav_int_0.rvmat", "ca\wheeled2\LAV25\Data\lav_int_0_damage.rvmat", "ca\wheeled2\LAV25\Data\lav_int_0_destruct.rvmat", "ca\wheeled2\LAV25\Data\lav_int_1.rvmat", "ca\wheeled2\LAV25\Data\lav_int_1_damage.rvmat", "ca\wheeled2\LAV25\Data\lav_int_1_destruct.rvmat", "ca\wheeled2\LAV25\Data\lav_int_2.rvmat", "ca\wheeled2\LAV25\Data\lav_int_2_damage.rvmat", "ca\wheeled2\LAV25\Data\lav_int_2_destruct.rvmat", "ca\wheeled2\LAV25\Data\lavalfa.rvmat", "ca\wheeled2\LAV25\Data\lavalfa_damage.rvmat", "ca\wheeled2\LAV25\Data\lavalfa_destruct.rvmat", "ca\wheeled2\LAV25\Data\lavbody.rvmat", "ca\wheeled2\LAV25\Data\lavbody_damage.rvmat", "ca\wheeled2\LAV25\Data\lavbody_destruct.rvmat", "ca\wheeled2\LAV25\Data\lavbody2.rvmat", "ca\wheeled2\LAV25\Data\lavbody2_damage.rvmat", "ca\wheeled2\LAV25\Data\lavbody2_destruct.rvmat"};
		};
		hiddenSelections[] = {"Camo1", "Camo2"};
		hiddenSelectionsTextures[] = {"ca\wheeled2\lav25\data\lavbody_co.paa", "\ca\wheeled2\lav25\data\lavbody2_co.paa"};
		insideSoundCoef = 0.9;
		soundGear[] = {"", 5.62341e-005, 1};
		soundGetIn[] = {"\ca\sounds\vehicles\Wheeled\Armored_Vehicle\ext\ext-AV-getin", 1.0, 1};
		soundGetOut[] = {"\ca\sounds\vehicles\Wheeled\Armored_Vehicle\ext\ext-AV-getout", 1.0, 1, 50};
		soundEngineOnInt[] = {"\ca\sounds\Vehicles\Wheeled\Armored_Vehicle\int\int-AV-start-02", 1.0, 1.0};
		soundEngineOnExt[] = {"\ca\SOUNDS\Vehicles\Wheeled\Armored_Vehicle\ext\ext-AV-start-02", 1.0, 1.0, 300};
		soundEngineOffInt[] = {"\ca\sounds\vehicles\Wheeled\Armored_Vehicle\int\int-AV-stop-02", 1.0, 1.0};
		soundEngineOffExt[] = {"\ca\sounds\vehicles\Wheeled\Armored_Vehicle\ext\ext-AV-stop-02", 1.0, 1.0, 300};
		buildCrash0[] = {"Ca\sounds\Vehicles\Crash\tank_building_01", 0.707946, 1, 150};
		buildCrash1[] = {"Ca\sounds\Vehicles\Crash\tank_building_02", 0.707946, 1, 150};
		buildCrash2[] = {"Ca\sounds\Vehicles\Crash\tank_building_03", 0.707946, 1, 150};
		buildCrash3[] = {"Ca\sounds\Vehicles\Crash\tank_building_04", 0.707946, 1, 150};
		soundBuildingCrash[] = {"buildCrash0", 0.25, "buildCrash1", 0.25, "buildCrash2", 0.25, "buildCrash3", 0.25};
		WoodCrash0[] = {"Ca\sounds\Vehicles\Crash\tank_wood_01", 0.707946, 1, 150};
		WoodCrash1[] = {"Ca\sounds\Vehicles\Crash\tank_wood_02", 0.707946, 1, 150};
		WoodCrash2[] = {"Ca\sounds\Vehicles\Crash\tank_wood_03", 0.707946, 1, 150};
		WoodCrash3[] = {"Ca\sounds\Vehicles\Crash\tank_wood_04", 0.707946, 1, 150};
		soundWoodCrash[] = {"woodCrash0", 0.25, "woodCrash1", 0.25, "woodCrash2", 0.25, "woodCrash3", 0.25};
		ArmorCrash0[] = {"Ca\sounds\Vehicles\Crash\tank_vehicle_01", 0.707946, 1, 150};
		ArmorCrash1[] = {"Ca\sounds\Vehicles\Crash\tank_vehicle_02", 0.707946, 1, 150};
		ArmorCrash2[] = {"Ca\sounds\Vehicles\Crash\tank_vehicle_03", 0.707946, 1, 150};
		ArmorCrash3[] = {"Ca\sounds\Vehicles\Crash\tank_vehicle_04", 0.707946, 1, 150};
		soundArmorCrash[] = {"ArmorCrash0", 0.25, "ArmorCrash1", 0.25, "ArmorCrash2", 0.25, "ArmorCrash3", 0.25};
		
		class SoundEvents {
			class AccelerationIn {
				sound[] = {"\ca\SOUNDS\Vehicles\Wheeled\Armored_Vehicle\int\int-AV-acce-01", 1.0, 1.0};
				limit = 0.15;
				expression = "engineOn*(1-camPos)*2*gmeterZ*((speed factor[1.5, 5]) min (speed factor[5, 1.5]))";
			};
			
			class AccelerationOut {
				sound[] = {"\ca\SOUNDS\Vehicles\Wheeled\Armored_Vehicle\ext\ext-AV-acce-01", 1.0, 1.0, 350};
				limit = 0.15;
				expression = "engineOn*camPos*2*gmeterZ*((speed factor[1.5, 5]) min (speed factor[5, 1.5]))";
			};
		};
		
		class Sounds {
			class Engine {
				sound[] = {"\ca\sounds\Vehicles\Wheeled\Armored_Vehicle\ext\ext-AV-engine-02low", 2.51189, 1.0, 450};
				frequency = "(randomizer*0.05+0.95)*rpm";
				volume = "engineOn*camPos*(thrust factor[0.7, 0.2])";
			};
			
			class EngineHighOut {
				sound[] = {"\ca\sounds\Vehicles\Wheeled\Armored_Vehicle\ext\ext-AV-engine-02high", 2.51189, 1.0, 550};
				frequency = "(randomizer*0.05+0.95)*rpm";
				volume = "engineOn*camPos*(thrust factor[0.5, 0.9])";
			};
			
			class IdleOut {
				sound[] = {"\ca\SOUNDS\Vehicles\Wheeled\Armored_Vehicle\ext\ext-AV-idle-02", 1.0, 1.0, 350};
				frequency = "1";
				volume = "engineOn*camPos*(rpm factor[0.4, 0])";
			};
			
			class TiresRockOut {
				sound[] = {"\ca\SOUNDS\Vehicles\Wheeled\Tires\ext\ext-tires-rock2", 0.316228, 1.0, 50};
				frequency = "1";
				volume = "camPos*rock*(speed factor[2, 20])";
			};
			
			class TiresSandOut {
				sound[] = {"\ca\SOUNDS\Vehicles\Wheeled\Tires\ext\ext-tires-sand2", 0.316228, 1.0, 50};
				frequency = "1";
				volume = "camPos*sand*(speed factor[2, 20])";
			};
			
			class TiresGrassOut {
				sound[] = {"\ca\SOUNDS\Vehicles\Wheeled\Tires\ext\ext-tires-grass3", 0.316228, 1.0, 50};
				frequency = "1";
				volume = "camPos*grass*(speed factor[2, 20])";
			};
			
			class TiresMudOut {
				sound[] = {"\ca\SOUNDS\Vehicles\Wheeled\Tires\ext\ext-tires-mud2", 0.316228, 1.0, 50};
				frequency = "1";
				volume = "camPos*mud*(speed factor[2, 20])";
			};
			
			class TiresGravelOut {
				sound[] = {"\ca\SOUNDS\Vehicles\Wheeled\Tires\ext\ext-tires-gravel2", 0.316228, 1.0, 50};
				frequency = "1";
				volume = "camPos*gravel*(speed factor[2, 20])";
			};
			
			class TiresAsphaltOut {
				sound[] = {"\ca\SOUNDS\Vehicles\Wheeled\Tires\ext\ext-tires-asphalt3", 0.316228, 1.0, 50};
				frequency = "1";
				volume = "camPos*asphalt*(speed factor[2, 20])";
			};
			
			class NoiseOut {
				sound[] = {"\ca\SOUNDS\Vehicles\Wheeled\Noises\ext\noise3", 0.316228, 1.0, 50};
				frequency = "1";
				volume = "camPos*(damper0 max 0.04)*(speed factor[0, 8])";
			};
			
			class EngineLowIn {
				sound[] = {"\ca\SOUNDS\Vehicles\Wheeled\Armored_Vehicle\int\int-AV-engine-02low", 1.0, 1.0};
				frequency = "(randomizer*0.05+0.95)*rpm";
				volume = "((engineOn*thrust) factor[0.65, 0.2])*(1-camPos)";
			};
			
			class EngineHighIn {
				sound[] = {"\ca\SOUNDS\Vehicles\Wheeled\Armored_Vehicle\int\int-AV-engine-02high", 1.0, 0.8};
				frequency = "(randomizer*0.05+0.95)*rpm";
				volume = "((engineOn*thrust) factor[0.55, 1.0])*(1-camPos)";
			};
			
			class IdleIn {
				sound[] = {"\ca\sounds\Vehicles\Wheeled\Armored_Vehicle\int\int-AV-idle-02", 0.398107, 1.0};
				frequency = "1";
				volume = "engineOn*(rpm factor[0.4, 0])*(1-camPos)";
			};
			
			class TiresRockIn {
				sound[] = {"\ca\SOUNDS\Vehicles\Wheeled\Tires\int\int-tires-rock2", 0.0562341, 1.0};
				frequency = "1";
				volume = "(1-camPos)*rock*(speed factor[2, 20])";
			};
			
			class TiresSandIn {
				sound[] = {"\ca\SOUNDS\Vehicles\Wheeled\Tires\int\int-tires-sand2", 0.0562341, 1.0};
				frequency = "1";
				volume = "(1-camPos)*sand*(speed factor[2, 20])";
			};
			
			class TiresGrassIn {
				sound[] = {"\ca\SOUNDS\Vehicles\Wheeled\Tires\int\int-tires-grass3", 0.0562341, 1.0};
				frequency = "1";
				volume = "(1-camPos)*grass*(speed factor[2, 20])";
			};
			
			class TiresMudIn {
				sound[] = {"\ca\SOUNDS\Vehicles\Wheeled\Tires\int\int-tires-mud2", 0.0562341, 1.0};
				frequency = "1";
				volume = "(1-camPos)*mud*(speed factor[2, 20])";
			};
			
			class TiresGravelIn {
				sound[] = {"\ca\SOUNDS\Vehicles\Wheeled\Tires\int\int-tires-gravel2", 0.0562341, 1.0};
				frequency = "1";
				volume = "(1-camPos)*gravel*(speed factor[2, 20])";
			};
			
			class TiresAsphaltIn {
				sound[] = {"\ca\SOUNDS\Vehicles\Wheeled\Tires\int\int-tires-asphalt3", 0.0562341, 1.0};
				frequency = "1";
				volume = "(1-camPos)*asphalt*(speed factor[2, 20])";
			};
			
			class NoiseIn {
				sound[] = {"\ca\SOUNDS\Vehicles\Wheeled\Noises\int\noise4", 0.316228, 1.0};
				frequency = "1";
				volume = "(damper0 max 0.04)*(speed factor[0, 8])*(1-camPos)";
			};
			
			class Movement {
				sound = "soundEnviron";
				frequency = "1";
				volume = "0";
			};
		};
		turnCoef = 4.0;
		steerAheadSimul = 0.6;
		steerAheadPlan = 0.4;
		enableGPS = 1;
		commanderCanSee = 31;
		gunnerCanSee = 30;
		forceHideDriver = 0;
		gunnerHasFlares = 1;
		weapons[] = {};
		magazines[] = {};
		driverForceOptics = 1;
		driverOpticsModel = "\ca\Tracked\optika_tank_driver_west";
		memoryPointdriverOptics = "driverview";
		
		class ViewOptics {
			initAngleX = 0;
			minAngleX = -30;
			maxAngleX = 30;
			initAngleY = 0;
			minAngleY = -100;
			maxAngleY = 100;
			initFov = 0.466;
			minFov = 0.466;
			maxFov = 0.466;
		};
		
		class ViewPilot {
			initAngleX = 10;
			minAngleX = -65;
			maxAngleX = 85;
			initAngleY = 20;
			minAngleY = -150;
			maxAngleY = 150;
			initFov = 0.7;
			minFov = 0.25;
			maxFov = 1.4;
		};
		
		class Turrets : Turrets {
			class MainTurret : MainTurret {
				weapons[] = {M242, "M240_veh"};
				magazines[] = {"210Rnd_25mm_M242_APDS", "210Rnd_25mm_M242_HEI", "1200Rnd_762x51_M240"};
				soundServo[] = {"\ca\Weapons\Data\Sound\gun_elevate", 0.0177828, 1.0, 15};
				minElev = -4.5;
				maxElev = 74;
				minTurn = -360;
				maxTurn = 360;
				gunnerAction = "LAV25_Gunner_out";
				gunnerInAction = "LAV25_Gunner";
				forceHideGunner = 0;
				gunnerOpticsModel = "\ca\weapons\2Dscope_LAV_7";
				gunnerOutOpticsModel = "";
				memoryPointGun = "machinegun";
				gunBeg = "muzzle_1";
				gunEnd = "chamber_1";
				body = "MainTurret";
				gun = "MainGun";
				animationSourceBody = "MainTurret";
				animationSourceGun = "MainGun";
				gunnerForceOptics = 1;
				outGunnerMayFire = 0;
				startEngine = 1;
				primaryGunner = 4;
				
				class HitPoints : HitPoints {
					class HitTurret {
						armor = 0.8;
						material = -1;
						name = "vez";
						visual = "vez";
						passThrough = 1;
					};
				};
				selectionFireAnim = "zasleh_1";
				
				class ViewGunner {
					initAngleX = 5;
					minAngleX = -65;
					maxAngleX = 85;
					initAngleY = 0;
					minAngleY = -150;
					maxAngleY = 150;
					initFov = 0.7;
					minFov = 0.25;
					maxFov = 1.1;
				};
				
				class ViewOptics {
					initAngleX = 0;
					minAngleX = -30;
					maxAngleX = 30;
					initAngleY = 0;
					minAngleY = -100;
					maxAngleY = 100;
					initFov = 0.2;
					minFov = 0.058;
					maxFov = 0.2;
				};
				
				class Turrets {
					class CommanderOptics : NewTurret {
						proxyType = "CPCommander";
						proxyIndex = 1;
						gunnerName = $STR_POSITION_COMMANDER;
						primaryGunner = 0;
						primaryObserver = 1;
						gunnerOpticsShowCursor = 0;
						body = "obsTurret";
						gun = "obsGun";
						animationSourceBody = "obsTurret";
						animationSourceGun = "obsGun";
						animationSourceHatch = "hatchCommander";
						soundServo[] = {"", 0.00316228, 1.0};
						startEngine = 0;
						gunBeg = "";
						gunEnd = "";
						minElev = -4;
						maxElev = 20;
						initElev = 0;
						minTurn = -360;
						maxTurn = 360;
						initTurn = 0;
						commanding = 2;
						viewGunnerInExternal = 0;
						gunnerOpticsModel = "\ca\weapons\2Dscope_com2";
						gunnerOutOpticsModel = "";
						gunnerOutOpticsColor[] = {0, 0, 0, 1};
						gunnerOutForceOptics = 0;
						gunnerOutOpticsShowCursor = 0;
						memoryPointGunnerOutOptics = "commander_weapon_view";
						memoryPointGunnerOptics = "commanderview";
						memoryPointsGetInGunner = "pos driver";
						memoryPointsGetInGunnerDir = "pos driver dir";
						
						class ViewGunner {
							initAngleX = 5;
							minAngleX = -65;
							maxAngleX = 85;
							initAngleY = 0;
							minAngleY = -150;
							maxAngleY = 150;
							initFov = 0.7;
							minFov = 0.25;
							maxFov = 1.1;
						};
						
						class ViewOptics {
							initAngleX = 0;
							minAngleX = -30;
							maxAngleX = 30;
							initAngleY = 0;
							minAngleY = -100;
							maxAngleY = 100;
							initFov = 0.155;
							minFov = 0.067;
							maxFov = 0.155;
						};
						gunnerInAction = "LAV25_Commander";
						gunnerAction = "LAV25_Commander_Out";
						outGunnerMayFire = 1;
						weapons[] = {"SmokeLauncher"};
						magazines[] = {"SmokeLauncherMag", "SmokeLauncherMag"};
						stabilizedInAxes = 0;
					};
				};
			};
		};
		crew = "USMC_Soldier_Crew";
		transportSoldier = 6;
		typicalCargo[] = {"USMC_Soldier_Crew", "USMC_Soldier_Crew", "USMC_Soldier_Crew"};
		DriverAction = "LAV25_Driver_OUT";
		driverInAction = "LAV25_Driver_OUT";
		cargoAction[] = {"Stryker_Cargo01"};
		viewCargoShadow = 1;
		viewCargoShadowDiff = 0.05;
		viewDriverShadowDiff = 0.05;
		viewGunnerShadowDiff = 0.05;
		transportAmmo = 0;
		supplyRadius = 1.7;
		transportMaxMagazines = 100;
		transportMaxWeapons = 10;
		smokeLauncherGrenadeCount = 4;
		smokeLauncherVelocity = 14;
		smokeLauncherOnTurret = 1;
		smokeLauncherAngle = 90;
	};
	
	class t96WAPC : t96WAPC_Base {
		scope = 2;
		
		class AnimationSources : AnimationSources
		{
			class recoil_source
			{
				source = "reload";
				weapon = M242;
			};
			class Antena1
			{
				source = "user";
				animPeriod = 4;
				initPhase = 0;
			};
			
			class Antena2 : Antena1 {};
			
			class Antena3 : Antena1 {};
			
			class ReloadAnim {
				source = "reload";
				weapon = "M240_veh";
			};
			
			class ReloadMagazine {
				source = "reloadmagazine";
				weapon = "M240_veh";
			};
			
			class Revolving {
				source = "revolving";
				weapon = "M240_veh";
			};
		};
	};
};