class CfgPatches
{
	class JSDF_AirH_V114
	{
		units[] = {"JASDF_CH47J", "JASDF_CH47J_L", "JGSDF_CH47J", "JGSDF_CH47JA"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {};
	};
};

class CfgVehicles
{
	class AllVehicles;
	class Air 				: AllVehicles
	{
		class Sounds;			// External class reference
	};
	class JSDF_AirH 			: Air
	{
		class Turrets
		{
			class MainTurret;	// External class reference
		};
		class NewTurret;		// External class reference
		class ViewPilot;		// External class reference
		class AnimationSources;		// External class reference
		
		class Sounds : Sounds
		{
			class Engine;		// External class reference
			class Movement;		// External class reference
		};
		class HitPoints
		{
			class HitGlass1;	// External class reference
			class HitGlass2;	// External class reference
			class HitGlass3;	// External class reference
			class HitGlass4;	// External class reference
			class HitGlass5;	// External class reference
			class HitHRotor;	// External class reference
		};
	};
	class JSDF_V114_Base			: JSDF_AirH
	{
		mainRotorSpeed 			= 1.2;
		backRotorSpeed 			= 1.2;

		cost 				= 10000000;
		displayName 			= CH-47;
		model 				= "\ca\air\ah1z";
		picture 			= "\ca\air\data\ico\ah1z_CA.paa";
		mapSize 			= 15.5;
		Icon 				= "\ca\air\data\map_ico\icomap_ah1z_CA.paa";

		threat[] 			= {0.3, 0.1, 0.1};
		accuracy 			= 1000;

		maxSpeed 			= 315;
		weapons[] 			= {};
		magazines[] 			= {};
		laserScanner 			= 0;

		hasGunner			= 0;
		hasCommander			= 0;
		transportSoldier 		= 35;
		getInAction 			= "GetInHigh";
		getOutAction 			= "GetOutHigh";
		driverCompartments 		= 1;
		driverInAction 			=  "UH60_Pilot";
		driverAction 			=  "UH60_Pilot";
		cargoAction[] 			= {"UH60_Pilot", "Mi17_Cargo02"};
		cargoCompartments[] 		= {2, 4};
		cargoIsCoDriver[] 		= {1, 0};
		typicalCargo[] 			= {"USMC_Soldier_Pilot", "USMC_Soldier_Pilot"};

		armor 				= 60;
		damageResistance 		= 0.00593;

		class Sounds
		{
			class Engine
			{
				sound[] 	= {"JSDF_AirH\V114\CH47_eng.wss", db10, 1.0, 800};
				frequency 	= "rotorSpeed";
				volume 		= "camPos*((rotorSpeed-0.72)*4)";
			};
		};
		class Reflectors
		{
			class Left
			{
				color[] 	= {1.0, 0.5, 0.3, 1.0};
				ambient[] 	= {0.2, 0.2, 0.2, 1.0};
				position 	= "light_front_L";
				direction 	= "light_front_L_dir";
				hitpoint 	= "light_front_L";
				selection 	= "light_front_L";
				size 		= 0.5;
				brightness 	= 0.5;
			};
			class Right		: Left
			{
				position 	= "light_front_R";
				direction 	= "light_front_R_dir";
				hitpoint 	= "light_front_R";
				selection 	= "light_front_R";
			};
		};
		aggregateReflectors[] 		= {{"Left", "Right"}};

		class AnimationSources
		{
			class cargo_ramp_slide	{source="user";	animPeriod= 3 ;	};
			class cargo_ramp	{source="user";	animPeriod= 7.5;};
		};
		class UserActions
		{
			class cargo_ramp_down
			{
				displayName	="cargo_ramp down";
				condition	="(this animationphase ""cargo_ramp"" < 1) and (alive this)";
				statement 	= "this animate [""cargo_ramp"",1];this animate [""cargo_ramp_slide"",1];";
				position	="cargo_ramp";
				radius		= 5;
				onlyForPlayer	= 0;
			};
			class cargo_ramp_up		:cargo_ramp_down
			{
				displayName	="cargo_ramp up";
				condition 	="(this animationphase ""cargo_ramp"" > 0) and (alive this)";
				statement 	= "this animate [""cargo_ramp"",0];";
			};
			class cargo_ramp_slide_up	:cargo_ramp_down
			{
				displayName	="cargo_ramp slide up";
				condition	="(this animationphase ""cargo_ramp"" == 0) and (alive this) and (this animationphase ""cargo_ramp_slide"" > 0)";
				statement 	= "this animate [""cargo_ramp_slide"",0];";
			};
			class cargo_ramp_slide_down	:cargo_ramp_down
			{
				displayName	="cargo_ramp slide down";
				condition	="(this animationphase ""cargo_ramp"" == 0) and (alive this) and (this animationphase ""cargo_ramp_slide"" < 1)";
				statement 	= "this animate [""cargo_ramp_slide"",1];";
			};
		};
	};	
	class JGSDF_CH47J 			: JSDF_V114_Base
	{
		scope 				= 2;
		faction 			= JGSDF;
		displayName 			= CH-47J;
		model 				= "\JSDF_AirH\V114\JGSDF_CH47J";
		maxSpeed 			= 250;
	};
	class JGSDF_CH47JA 			: JGSDF_CH47J
	{
		displayName 			= CH-47JA;
		model 				= "\JSDF_AirH\V114\JGSDF_CH47JA";
	};
};
