class CfgPatches
{
	class JSDF_AirH_S80
	{
		units[]={"JMSDF_MH53E","mk105minesweeper"};
		weapons[]={};
		requiredAddons[] = {};
		requiredVersion = 1.00;	
	};
};
class CfgVehicles
{
	class AllVehicles;
//////////////////////////////////////////////////////////////////////////////////////////////////
	class Ship: AllVehicles {};
	class mk105minesweeper : Ship
	{
		scope = 1;
		maxSpeed = 0;
		fuelCapacity = 0;
		hasGunner = false;
		hasCommander = false;
		hasDriver = false;
		weapons[] = {};
		magazines[] = {};
		irTarget = false;
		cost = 100;
		threat[] = {0, 0, 0};
		mapSize = 0.1;
		icon = "";
		class MarkerLights {
			class WhiteBlinking {
				name = "bily pozicni blik";
				color[] = {1.0, 1.0, 1.0, 1};
				ambient[] = {0.1, 0.1, 0.1, 1};
				brightness = 0.02;
				blinking = true;
			};
		};
		side = TGuerrila;
		vehicleclass=warship_w;
		displayName="mk105 mine sweeper";
		model = "\jsdf_airh\s80\mk105";
		canfloat = 1;
	};
	class mk105empty : mk105minesweeper
	{
		model = "\jsdf_airh\s80\mk105_empty";
	};
//////////////////////////////////////////////////////////////////////////////////////////////////
	class Air 				: AllVehicles
	{
		class Sounds;			// External class reference
	};
	class JSDF_AirH 			: Air
	{
		class Turrets
		{
			class MainTurret;	// External class reference
		};
		class NewTurret;		// External class reference
		class ViewPilot;		// External class reference
		class AnimationSources;		// External class reference
		
		class Sounds : Sounds
		{
			class Engine;		// External class reference
			class Movement;		// External class reference
		};
		class HitPoints
		{
			class HitGlass1;	// External class reference
			class HitGlass2;	// External class reference
			class HitGlass3;	// External class reference
			class HitGlass4;	// External class reference
			class HitGlass5;	// External class reference
			class HitHRotor;	// External class reference
		};
	};
	class JMSDF_MH53E 			: JSDF_AirH
	{
		scope 				= 2;
		side 				= 1;
		faction 			= JMSDF;
		displayName 			= "MH-53E";
		icon				="\jsdf_airh\s80\ico\mh53e_MAP_ICO.paa";
		picture				="\jsdf_airh\s80\ico\mh53e_ICO.paa";
		model 				="\jsdf_airh\s80\JMSDF_MH53E";
		extCameraPosition[] 		= {0, 3.0, -25};

		maxSpeed			=315;
		mainRotorSpeed 			= 0.5;
		backRotorSpeed 			= 1.0;
		gearRetracting 			= 1;
		gearUpTime 			= 4.5;
		gearDownTime 			= 3;
		lightOnGear 			= 1;

		driverInAction 			= "UH60_Pilot";
		driverAction 			= "UH60_Pilot";
		cargoAction[] 			= {"UH60_Cargo01", "UH60_Cargo02"};
		transportSoldier 		= 19;
		hasGunner 			= 1;
		hiddenselections[]  		= {"rope_body"};
		soundDammage[] 			= {"\jsdf_airh\s80\sounds\re_chopperdammage1.ogg", 3.0, 1, 200};
		soundCrash[] 			= {"\jsdf_airh\s80\sounds\aircrash1.wss", 3.0, 1, 1000};
		soundWaterCrash[] 		= {"\jsdf_airh\s80\sounds\airwaterhit.wss", 2.0, 1, 500};
		soundGetIn[] 			= {"\jsdf_airh\s80\sounds\go_in.wss", db0, 1};
		soundGetOut[] 			= {"\jsdf_airh\s80\sounds\go_out.wss", db6.9, 1, 60};
		soundEnviron[] 			= {"", db-30, 1.0};
		soundEngineOnInt[] 		= {"\jsdf_airh\s80\sounds\engine_start_int.wss", 0.572341, 1.0};
		soundEngineOnExt[] 		= {"\jsdf_airh\s80\sounds\engine_start_out.wss", 0.798328, 1.0, 600};
		soundEngineOffInt[] 		= {"\jsdf_airh\s80\sounds\engine_stop_int", 0.572341, 1.0};
		soundEngineOffExt[] 		= {"\jsdf_airh\s80\sounds\engine_stop_out.wss", 0.795328, 1.0, 600};
		class Sounds
		{
			class Engine {
				sound[] = {"\jsdf_airh\s80\sounds\MH53_out_eng.ogg", 2.93872, 1.0, 1800};
				frequency = "rotorSpeed";
				volume = "camPos*((rotorSpeed-0.72)*4)";
			};

			class EngineIn {
				sound[] = {"ca\sounds\air\uh1y\int\int-fly-mode7", db10, 1.0};
				frequency = "rotorSpeed";
				volume = "(1-camPos)*((rotorSpeed-0.75)*4)";
			};

			class RotorLowOut {
				sound[] = {"ca\sounds\air\uh1y\int\int-rotor-single5b", 2.51189, 1.0, 1400};
				frequency = "rotorSpeed";
				volume = "camPos*(0 max (rotorSpeed-0.1))";
				cone[] = {1.6, 3.14, 2.0, 0.5};
			};
			
			class RotorHighOut {
				sound[] = {"ca\sounds\air\uh1y\int\int-rotor-single5a", 2.51189, 1.0, 1600};
				frequency = "rotorSpeed";
				volume = "camPos*10*(0 max (rotorThrust-0.9))";
				cone[] = {1.6, 3.14, 2.0, 0.5};
			};

			class RotorLowIn {
				sound[] = {"\jsdf_airh\s80\sounds\CH53EX3.ogg", db10, 1.0};
				frequency = "rotorSpeed";
				volume = "2*(1-camPos)*((rotorSpeed factor[0.3, 1.1]) min (rotorSpeed factor[1.1, 0.3]))";
			};
			
			class RotorHighIn {
				sound[] = {"\jsdf_airh\s80\sounds\CH53EX3.ogg", db10, 1.0};
				frequency = "rotorSpeed";
				volume = "(1-camPos)*3*(rotorThrust-0.9)";
			};
			class WindNoiseOut {
				sound[] = {"\jsdf_airh\s80\sounds\CH53_wind.wss", 4.50, 2.0, 260};
				frequency = "(0.1+(1.2*(speed factor[1, 150])))";
				volume = "camPos*(speed factor[1, 150])";
			};			

			class WindNoiseIn {
				sound[] = {"\jsdf_airh\s80\sounds\CH53_wind.wss", 3.50, 2.0};
				frequency = "(0.1+(1.2*(speed factor[1, 150])))";
				volume = "(1-camPos)*(speed factor[1, 150])";
			};
		};
		destrType = "DestructEngine";
		class HitEngine {armor=0.25;material=51;name="motor";visual="motor";passThrough=1;};
		class HitAvionics {armor=0.15;material=51;name="elektronika";visual="elektronika";passThrough=0;};
		class HitVRotor {armor=0.3;material=51;name="mala vrtule";visual="mala vrtule";passThrough=0;};
		class HitHRotor {armor=0.2;material=51;name="velka vrtule";visual="velka vrtule";passThrough=0;};
		dammageHalf[] = {"\jsdf_airh\s80\glass.paa", "\jsdf_airh\s80\broke_glass.paa"};
		dammageFull[] = {"\jsdf_airh\s80\glass.paa", "\jsdf_airh\s80\broken_glass.paa"};
		class Damage
		{
			tex[]={};
			mat[]={"jsdf_airh\s80\body_super.rvmat","jsdf_airh\s80\body_super_damage.rvmat","jsdf_airh\s80\body_super_destruct.rvmat","jsdf_airh\s80\inside.rvmat","jsdf_airh\s80\inside_damage.rvmat","jsdf_airh\s80\inside_destruct.rvmat"};
		};
		class Turrets {};
     		class AnimationSources 
		{
			class cargo_ramp	{source="user";	animPeriod = 4;};
			class cargo_ramp_frame	{source="user";	animPeriod = 1.2;};

			class ropeX		{animPeriod = 0.05;};
			class ropeY 		: ropeX {};
			class ropeZ 		: ropeX {};

			class rotor_main_blade1	{animPeriod = 1;};
			class rotor_main_blade2 : rotor_main_blade1 {};
			class rotor_main_blade3 : rotor_main_blade1 {};
			class rotor_main_blade5 : rotor_main_blade1 {};
			class rotor_main_blade6 : rotor_main_blade1 {};
			class rotor_main_blade7 : rotor_main_blade1 {};
			class tail_boom_fold 	: rotor_main_blade1 {};
		};
		class UserActions
		{
			class cargo_ramp_down
			{
				displayName	="cargo_ramp down";
				condition	="(this animationphase ""cargo_ramp"" < 1) and (alive this)";
				statement 	= "this animate [""cargo_ramp"",1];this animate [""cargo_ramp_frame"",1];";
				position	="cargo_ramp";
				radius		= 10;//0.5
				onlyForPlayer	= 0;
			};
			class cargo_ramp_up		:cargo_ramp_down
			{
				displayName	="cargo_ramp up";
				condition 	="(this animationphase ""cargo_ramp"" > 0) and (alive this)";
				statement 	= "this animate [""cargo_ramp"",0];this animate [""cargo_ramp_frame"",0];";
			};
			class minesweepON
			{
				displayName ="mine sweep ON";
				position = "zamerny";
				radius =3;
				condition = "(this getVariable ""sweep"") == ""OFF""";
				statement = "this setVariable [""sweep"",""ON"",true];[this] exec ""\jsdf_airh\s80\script\minesweep.sqs"";";
				onlyforplayer = false;
			};
			class minesweepOFF
			{
				displayName ="mine sweep OFF";
				position = "zamerny";
				radius =3;
				condition = "(this getVariable ""sweep"") == ""ON""";
				statement = "this setVariable [""sweep"",""OFF"",true];";
				onlyforplayer = false;
			};
			class spread
			{
				displayName 	="spread rotor-blade";
				condition 	="this animationphase ""rotor_main_blade1"" == 1 and (!isEngineOn this) and (speed this < 1)";
				statement 	="[this] exec ""\jsdf_airh\s80\script\MH53spread.sqs""";
				onlyforplayer 	= false;
				position 	="zamerny";
				radius 		= 3;
			};
		};
		class Reflectors
		{
			class Left
			{
				color[] 	= {1.0, 0.5, 0.3, 1.0};
				ambient[] 	= {0.2, 0.2, 0.2, 1.0};
				position 	= "light_front_L";
				direction 	= "light_front_L_dir";
				hitpoint 	= "hit_light_front_L";
				selection 	= "light_front_L";
				size 		= 0.5;
				brightness 	= 0.5;
			};
			class Right		: Left
			{
				position 	= "light_front_R";
				direction 	= "light_front_R_dir";
				hitpoint 	= "hit_light_front_R_hit";
				selection 	= "light_front_R";
			};
		};
		aggregateReflectors[] 		= {{"Left", "Right"}};
		class EventHandlers
		{
			init = "[_this select 0] exec ""\jsdf_airh\s80\script\init.sqs"";";
//			init = "[_this select 0] exec ""\jsdf_airh\s80\script\MH53gear.sqs"";[_this select 0] exec ""\jsdf_airh\s80\script\init.sqs"";";
		};
		class Library {libTextDesc = "JMSDF MH53E";};
	};
};