class CfgPatches
{
	class JSDF_AirH_S70
	{
		units[] = {"JGSDF_UH60JA", "JMSDF_UH60J", "JMSDF_SH60J", "JMSDF_SH60K", "JASDF_UH60J"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {};
	};
};

class CfgVehicles
{
	class AllVehicles;
	class Air 				: AllVehicles
	{
		class Sounds;			// External class reference
	};
	class JSDF_AirH 			: Air
	{
		class Turrets
		{
			class MainTurret;	// External class reference
		};
		class NewTurret;		// External class reference
		class ViewPilot;		// External class reference
		class AnimationSources;		// External class reference
		
		class Sounds : Sounds
		{
			class Engine;		// External class reference
			class Movement;		// External class reference
		};
		class HitPoints
		{
			class HitGlass1;	// External class reference
			class HitGlass2;	// External class reference
			class HitGlass3;	// External class reference
			class HitGlass4;	// External class reference
			class HitGlass5;	// External class reference
			class HitHRotor;	// External class reference
		};
	};
	class JSDF_UH60_Base 			: JSDF_AirH
	{
		cost 				= 10000000;
		displayName 			= "$STR_DN_UH60_Base";
		model 				= "\ca\air\Mh_60mg";
		mapSize 			= 17;
		picture 			= "\ca\air\data\ico\MH_60mg_CA.paa";
		Icon 				= "\ca\air\data\map_ico\icomap_MH60mg_CA.paa";
		accuracy 			= 1.5;						// accuracy needed to recognize type of this target

		maxSpeed 			= 270;	// max speed on level road, km/h
		armor 				= 35;
		damageResistance 		= 0.00242;

		mainRotorSpeed 			=-1.0;
		backRotorSpeed 			= 2.0;

		soundGetIn[] 			= {"\ca\Sound\Air\Noises\heli_door_01", db-10, 1};
		soundGetOut[] 			= {"\ca\Sound\Air\Noises\heli_door_01", db-10, 1, 30};
		soundEnviron[] 			= {"", db-30, 1.0};
		soundDammage[] 			= {"\ca\Air\Data\Sound\alarm_loop1", 0.001, 1};
		soundEngineOnInt[] 		= {"ca\sounds\Air\UH1Y\int\int-start-final", 0.1, 1.0};
		soundEngineOnExt[] 		= {"ca\sounds\Air\UH1Y\ext\ext-motor-start", 1.0, 1.0, 800};
		soundEngineOffInt[] 		= {"ca\sounds\Air\UH1Y\int\int-stop-final", 0.1, 1.0};
		soundEngineOffExt[] 		= {"ca\sounds\Air\UH1Y\ext\ext-motor-stop", 1.0, 1.0, 800};
		
		class Sounds
		{
			class Engine
			{
				sound[] = {"ca\sounds\air\uh1y\ext\ext-fly-mode2", 2.51189, 1.0, 900};
				frequency = "rotorSpeed";
				volume = "camPos*((rotorSpeed-0.72)*4)";
			};
			
			class RotorLowOut
			{
				sound[] = {"ca\sounds\air\uh1y\int\int-rotor-single5b", 2.51189, 1.0, 1400};
				frequency = "rotorSpeed";
				volume = "camPos*(0 max (rotorSpeed-0.1))";
				cone[] = {1.6, 3.14, 2.0, 0.5};
			};
			
			class RotorHighOut
			{
				sound[] = {"ca\sounds\air\uh1y\int\int-rotor-single5a", 2.51189, 1.0, 1600};
				frequency = "rotorSpeed";
				volume = "camPos*10*(0 max (rotorThrust-0.9))";
				cone[] = {1.6, 3.14, 2.0, 0.5};
			};
			
			class EngineIn
			{
				sound[] = {"ca\sounds\air\uh1y\int\int-fly-mode7", db10, 1.0};
				frequency = "rotorSpeed";
				volume = "(1-camPos)*((rotorSpeed-0.75)*4)";
			};
			
			class RotorLowIn
			{
				sound[] = {"ca\sounds\air\uh1y\int\int-rotor-single5b", db10, 1.0};
				frequency = "rotorSpeed";
				volume = "2*(1-camPos)*((rotorSpeed factor[0.3, 1.1]) min (rotorSpeed factor[1.1, 0.3]))";
			};
			
			class RotorHighIn
			{
				sound[] = {"ca\sounds\air\uh1y\int\int-rotor-single5a", db10, 1.0};
				frequency = "rotorSpeed";
				volume = "(1-camPos)*3*(rotorThrust-0.9)";
			};
		};

		driverInAction 			= "UH60_Pilot";
		driverAction 			= "UH60_Pilot";
		cargoAction[] 			= {"UH60_Cargo01", "UH1Y_Cargo02", "UH1Y_Cargo01", "UH1Y_Cargo01", "UH1Y_Cargo01", "UH60_Cargo02"};
		driverCompartments 		= "Compartment1";
		cargoCompartments[] 		= {"Compartment2"};
		cargoIsCoDriver[] 		= {1, 0, 0};
		typicalCargo[] 			= {"USMC_Soldier_Pilot", "USMC_Soldier_Pilot", "USMC_Soldier_Pilot"};
		forceHideDriver 		= true;
		castDriverShadow 		= true;
		castCargoShadow 		= true;
		enableSweep 			= false;
		supplyRadius 			= 2.5;

		initCargoAngleY 		= 10;
		minCargoAngleY 			= -60;
		maxCargoAngleY 			= 120;

		type = VAir;
		threat[] 			= {0.3, 1, 0.4};	// threat (VSoft, VArmor, VAir), how threatening vehicle is to unit types

		weapons[] 			= {};
		magazines[] 			= {};
		transportMaxMagazines 		= 150;
		transportMaxWeapons 		= 30;
		transportAmmo 			= 0;
		transportSoldier 		= 13;


		class Reflectors
		{
			class Left
			{
				color[] 	= {1.0, 0.5, 0.3, 1.0};
				ambient[] 	= {0.2, 0.2, 0.2, 1.0};
				position 	= "light_front_L";
				direction 	= "light_front_L_dir";
				hitpoint 	= "light_front_L";
				selection 	= "light_front_L";
				size 		= 0.5;
				brightness 	= 0.5;
			};
			class Right		: Left
			{
				position 	= "light_front_R";
				direction 	= "light_front_R_dir";
				hitpoint 	= "light_front_R";
				selection 	= "light_front_R";
			};
		};
		aggregateReflectors[] 		= {{"Left", "Right"}};
		
		class Damage
		{
			tex[] = {};
			mat[] = {"ca\air\Data\uh60_skla.rvmat", "ca\air\Data\uh60_skla_damage.rvmat", "ca\air\Data\uh60_skla_damage.rvmat", "ca\air\Data\uh60_skla_in.rvmat", "ca\air\Data\uh60_skla_in_damage.rvmat", "ca\air\Data\uh60_skla_in_damage.rvmat", "ca\air\Data\materialy\uh60_01.rvmat", "ca\air\Data\materialy\uh60_01_damage.rvmat", "ca\air\Data\materialy\uh60_01_destruct.rvmat"};
		};
		class Library
		{
			libTextDesc = $STR_LIB_MH60S;
		};
	};
	class JGSDF_UH60JA 			: JSDF_UH60_Base
	{
		scope 				= 2;
		faction 			= JGSDF;
		displayName 			= UH-60JA;
		model 				= "\JSDF_AirH\S70\JGSDF_UH60JA";
	};
	class JMSDF_SH60J 			: JSDF_UH60_Base
	{
		scope 				= 2;
		faction 			= JMSDF;
		displayName 			="SH60J";
		model 				= "\JSDF_AirH\S70\JMSDF_SH60J";

		class Library {libTextDesc = "JMSDF SH60J";};

		transportSoldier 		= 1;
		hasGunner 			= true;
		driverIsCommander 		= 1;
		maxSpeed 			= 270;
		mainRotorSpeed 			= -1;
		hiddenselections[]		= {"bangou_1","bangou_2","bangou_3"};


		class EventHandlers 
		{
		init = "[_this select 0] exec ""\jsdf_airh\_script\SH60J_no.sqs"";";
		};
		class AnimationSources
		{
			class cargo_door_R	{source="user"; animPeriod = 1.5;};
		};
		class UserActions
		{
			class doorOpen
			{
				displayName	="Open Door";
				condition	="(this animationphase ""cargo_door_R"" < 1) and (alive this)";
				statement 	= "this animate [""cargo_door_R"",1];";
				position	="cargo_door_R";
				radius		= 1;
				onlyForPlayer	= 0;
			};
			class doorClose		:doorOpen
			{
				displayName	="Close Door";
				condition 	="(this animationphase ""cargo_door_R"" > 0) and (alive this)";
				statement 	= "this animate [""cargo_door_R"",0];";
			};
		};
		class Turrets
		{
			class MainTurret 	: NewTurret
			{
				body 			= "";
				gun 			= "";
				commanding 		= -1;
				memoryPointsGetInGunner	= "pos_driver";
				gunnerAction 		= "UH60_Pilot";
				castGunnerShadow 	= 1;
				viewGunnerShadow 	= 1;
			};
		};
	};
};
