class CfgPatches
{
	class JSDF_AirH_S61
	{
		units[] = {"JMSDF_HSS2", "JMSDF_HSS2A", "JMSDF_HSS2B", "JMSDF_S61A", "JMSDF_S61A1", "JMSDF_S61AH"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {};
	};
};

class CfgVehicles
{
	class AllVehicles;
	class Air 				: AllVehicles
	{
		class Sounds;			// External class reference
	};
	class Helicopter 			: Air
	{
		class Turrets
		{
			class MainTurret;	// External class reference
		};
		class NewTurret;		// External class reference
		class ViewPilot;		// External class reference
		class AnimationSources;		// External class reference
		
		class Sounds : Sounds
		{
			class Engine;		// External class reference
			class Movement;		// External class reference
		};
		class HitPoints
		{
			class HitGlass1;	// External class reference
			class HitGlass2;	// External class reference
			class HitGlass3;	// External class reference
			class HitGlass4;	// External class reference
			class HitGlass5;	// External class reference
			class HitHRotor;	// External class reference
		};
	};
	class JSDF_AirH				: Helicopter{};

	class JSDF_S61_Base			: JSDF_AirH
	{
		side 				= 1;
		faction 			= JMSDF;
		cost 				= 10000000;
		displayName 			= S-61;
		model 				= "\ca\air\ah1z";
		picture 			= "\ca\air\data\ico\ah1z_CA.paa";
		mapSize 			= 15.5;
		Icon 				= "\ca\air\data\map_ico\icomap_ah1z_CA.paa";

		threat[] 			= {0.3, 0.1, 0.1};
		accuracy 			= 1000;

		maxSpeed 			= 267;
		weapons[] 			= {};
		magazines[] 			= {};
		laserScanner 			= 1;

		mainRotorSpeed 			= 0.5;
		backRotorSpeed 			= 1.0;
		gearRetracting 			= 1;
		gearUpTime 			= 5.5;
		gearDownTime 			= 2;
		lightOnGear 			= 1;

		crew 				= "USMC_Soldier_Pilot";
		getInAction 			= "GetInHigh";
		getOutAction 			= "GetOutHigh";
		driverCompartments 		= "Compartment1";
		cargoCompartments[] 		= {"Compartment1"};
		typicalCargo[] 			= {"USMC_Soldier_Pilot", "USMC_Soldier_Pilot"};

		soundGetIn[] 			= {"ca\sounds\air\noises\heli_door_01", db-10, 1};
		soundGetOut[] 			= {"ca\sounds\air\noises\heli_door_01", db-10, 1, 50};
		soundDammage[] 			= {"ca\sounds\air\noises\alarm_loop1", 0.001, 1};

		soundEngineOnInt[] 		= {"jsdf_airh\s61\s61_eng_on_in",	0.03, 1.0	};
		soundEngineOnExt[] 		= {"jsdf_airh\s61\s61_eng_on",		1.8,  1.0, 700	};
		soundEngineOffInt[] 		= {"jsdf_airh\s61\s61_eng_off_in",	0.03, 1.0	};
		soundEngineOffExt[] 		= {"jsdf_airh\s61\s61_eng_off",		1.8,  1.0, 700	};
		class Sounds
		{
			class Engine
			{
				sound[] 	= {"jsdf_airh\s61\s61_eng", db10, 1.0, 800};
				frequency 	= "rotorSpeed";
				volume 		= "camPos*((rotorSpeed-0.72)*4)";
			};			
			class EngineIn
			{
				sound[] 	= {"jsdf_airh\s61\s61_eng_in", db5, 1.0};
				frequency 	= "rotorSpeed";
				volume 		= "(1-camPos)*((rotorSpeed-0.75)*4)";
			};
			
			class RotorLowIn
			{
				sound[] 	= {"", db5, 1.0};
				frequency 	= "rotorSpeed";
				volume 		= "2*(1-camPos)*((rotorSpeed factor[0.3, 1.1]) min (rotorSpeed factor[1.1, 0.3]))";
			};
			class RotorLowOut
			{
				sound[] 	= {"", db10, 1.0, 1500};
				frequency 	= "rotorSpeed";
				volume 		= "camPos*(0 max (rotorSpeed-0.1))";
				cone[] 		= {1.8, 3.14, 2.0, 0.9};
			};
			
			class RotorHighIn
			{
				sound[] 	= {"", db5, 1.0};
				frequency 	= "rotorSpeed";
				volume 		= "(1-camPos)*3*(rotorThrust-0.9)";
			};
			class RotorHighOut
			{
				sound[] 	= {"", db10, 1.0, 1800};
				frequency 	= "rotorSpeed";
				volume 		= "camPos*10*(0 max (rotorThrust-0.95))";
				cone[] 		= {1.8, 3.14, 2.0, 0.9};
			};
		};
		class AnimationSources
		{
			class cargo_ramp_R	{source="user"; animPeriod = 2.0;};
			class cargo_door_L	{source="user"; animPeriod = 1.5;};
		};
		class UserActions
		{
			class rampOpen
			{
				displayName	="Open Ramp";
				condition	="(this animationphase ""cargo_ramp_R"" < 1) and (alive this)";
				statement 	="[this] exec ""JSDF_AirH\S61\scripts\cargo_ramp_R_op.sqs""";
				position	="pos_cargo_ramp_R";
				radius		= 5;
				onlyForPlayer	= 0;
			};
			class rampClose		:rampOpen
			{
				displayName	="Close Ramp";
				condition 	="(this animationphase ""cargo_ramp_R"" > 0) and (alive this)";
				statement 	="[this] exec ""JSDF_AirH\S61\scripts\cargo_ramp_R_cl.sqs""";
			};
			class doorOpen		:rampOpen
			{
				displayName	="Open Door";
				condition	="(this animationphase ""cargo_door_L"" < 1) and (alive this)";
				statement 	= "this animate [""cargo_door_L"",1];";
				position	="pos_cargo_door_L";
			};
			class doorClose		:doorOpen
			{
				displayName	="Close Door";
				condition 	="(this animationphase ""cargo_door_L"" > 0) and (alive this)";
				statement 	= "this animate [""cargo_door_L"",0];";
			};
		};
		armor 				= 60;
		damageResistance 		= 0.00593;
		class HitPoints 		: HitPoints
		{
			class HitGlass2 		: HitGlass2 {armor = 0.5;};
			class HitGlass3 		: HitGlass3 {armor = 0.5;};
			class HitGlass4 		: HitGlass4 {armor = 0.5;};
			class HitGlass5 		: HitGlass5 {armor = 0.5;};
		};

		destrType 	= "DestructWreck";
		dammageHalf[] 	= {"\Ca\air\data\ah1z_monitor_glass_ca.paa", "\Ca\air\data\ah1z_monitor_glass_destr_co.paa"};
		dammageFull[] 	= {"\Ca\air\data\ah1z_monitor_glass_ca.paa", "\Ca\air\data\ah1z_monitor_glass_destr_co.paa"};
		class Damage
		{
			tex[] 	= {};
			mat[] 	= {"ca\air\data\ah1z_body.rvmat", "ca\air\data\ah1z_body_damage.rvmat", "ca\air\data\ah1z_body_destruct.rvmat", "ca\air\data\ah1z_glass.rvmat", "ca\air\data\ah1z_glass_damage.rvmat", "ca\air\data\ah1z_glass_damage.rvmat", "ca\air\data\ah1z_glass_in.rvmat", "ca\air\data\ah1z_glass_in_damage.rvmat", "ca\air\data\ah1z_glass_in_damage.rvmat", "ca\air\data\ah1z_cockpit.rvmat", "ca\air\data\ah1z_cockpit.rvmat", "ca\air\data\ah1z_cockpit_destruct.rvmat", "ca\air\data\ah1z_engines.rvmat", "ca\air\data\ah1z_engines_damage.rvmat", "ca\air\data\ah1z_engines_destruct.rvmat", "Ca\air\data\ah1z_monitors.rvmat", "Ca\air\data\ah1z_monitors.rvmat", "Ca\air\data\ah1z_monitors_destruct.rvmat"};
		};
		
		class Library
		{
			libTextDesc = S61;
		};
	};	
	class JMSDF_S61A 			: JSDF_S61_Base
	{
		scope 				= 2;
		displayName 			= S-61A;
		model 				= "\JSDF_AirH\S61\JMSDF_S61A";
		maxSpeed 			= 250;
	};
	class JMSDF_S61A1 			: JMSDF_S61A
	{
		scope 				= 0;
		displayName 			= S-61A-1;
		model 				= "\JSDF_AirH\S61\JMSDF_S61A1";
		maxSpeed 			= 267;
	};
	class JMSDF_S61AH 			: JSDF_S61_Base
	{
		displayName 			= S-61AH;
		model 				= "\JSDF_AirH\S61\JMSDF_S61AH";
		maxSpeed 			= 250;//8944_267
	};

	class JMSDF_HSS2 			: JSDF_S61_Base
	{
		displayName 			= HSS-2;
		model 				= "\JSDF_AirH\S61\JMSDF_HSS2";
	};
	class JMSDF_HSS2A 			: JMSDF_HSS2
	{
		displayName 			= HSS-2A;
		model 				= "\JSDF_AirH\S61\JMSDF_HSS2A";
	};
	class JMSDF_HSS2B 			: JMSDF_HSS2A
	{
		displayName 			= HSS-2B;
		model 				= "\JSDF_AirH\S61\JMSDF_HSS2B";
	};
};
