class CfgPatches
{
	class JSDF_AirH_S55
	{
		units[] = {"JASDF_H19C", "JGSDF_H19C", "JGSDF_H19CA", "JMSDF_S55", "JMSDF_S55A"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {};
	};
};
class CfgVehicles
{
	class AllVehicles;
	class Air 				: AllVehicles
	{
		class Sounds;			// External class reference
	};
	class JSDF_AirH 			: Air
	{
		class Turrets
		{
			class MainTurret;	// External class reference
		};
		class NewTurret;		// External class reference
		class ViewPilot;		// External class reference
		class AnimationSources;		// External class reference
		
		class Sounds : Sounds
		{
			class Engine;		// External class reference
			class Movement;		// External class reference
		};
		class HitPoints
		{
			class HitGlass1;	// External class reference
			class HitGlass2;	// External class reference
			class HitGlass3;	// External class reference
			class HitGlass4;	// External class reference
			class HitGlass5;	// External class reference
			class HitHRotor;	// External class reference
		};
	};
	class JSDF_S55_Base			: JSDF_AirH
	{
		mainRotorSpeed 			= 1.2;
		backRotorSpeed 			= 1.2;

		cost 				= 10000000;
		displayName 			= S-55;
		model 				= "\ca\air\ah1z";
		picture 			= "\ca\air\data\ico\ah1z_CA.paa";
		Icon 				= "\ca\air\data\map_ico\icomap_ah1z_CA.paa";
		mapSize 			= 15.5;

		threat[] 			= {0.3, 0.1, 0.1};
		accuracy 			= 1000;

		maxSpeed 			= 195;
		weapons[] 			= {};
		magazines[] 			= {};
		laserScanner 			= 0;

		hasGunner			= 0;
		hasCommander			= 0;
		transportSoldier 		= 21;
		getInAction 			= "GetInHigh";
		getOutAction 			= "GetOutHigh";
		driverCompartments 		= 1;
		driverInAction 			=  "UH60_Pilot";
		driverAction 			=  "UH60_Pilot";
		cargoAction[] 			= {"UH60_Pilot", "Mi17_Cargo02"};
		cargoCompartments[] 		= {2, 4};
		cargoIsCoDriver[] 		= {1, 0};
		typicalCargo[] 			= {"USMC_Soldier_Pilot", "USMC_Soldier_Pilot"};

		class Sounds
		{
			class Engine
			{
				sound[] 	= {"JSDF_AirH\S55\S55_eng.wss", db10, 1.0, 800};
				frequency 	= "rotorSpeed";
				volume 		= "camPos*((rotorSpeed-0.72)*4)";
			};
		};
		class Reflectors
		{
			class Left
			{
				color[] 	= {1.0, 0.5, 0.3, 1.0};
				ambient[] 	= {0.2, 0.2, 0.2, 1.0};
				position 	= "light_front_L";
				direction 	= "light_front_L_dir";
				hitpoint 	= "light_front_L";
				selection 	= "light_front_L";
				size 		= 0.5;
				brightness 	= 0.5;
			};
			class Right		: Left
			{
				position 	= "light_front_R";
				direction 	= "light_front_R_dir";
				hitpoint 	= "light_front_R";
				selection 	= "light_front_R";
			};
		};
		aggregateReflectors[] 		= {{"Left", "Right"}};

		armor 				= 60;
		damageResistance 		= 0.00593;
	};
	class JASDF_H19C 			: JSDF_S55_Base
	{
		faction 			= JASDF;
		displayName 			= H-19C;
		model 				= "\JSDF_AirH\S55\JASDF_H19C";
	};
	class JGSDF_H19C 			: JSDF_S55_Base
	{
		faction 			= JGSDF;
		displayName 			= H-19C (S55);
		model 				= "\JSDF_AirH\S55\JGSDF_H19C";
	};
	class JGSDF_H19CA 			: JGSDF_H19C
	{
		displayName 			= H-19C (S55A);
		model 				= "\JSDF_AirH\S55\JGSDF_H19CA";
	};
	class JMSDF_S55 			: JSDF_S55_Base
	{
		faction 			= JMSDF;
		displayName 			= S-55;
		model 				= "\JSDF_AirH\S55\JMSDF_S55";
	};
	class JMSDF_S55A 			: JMSDF_S55
	{
		displayName 			= S-55A;
		model 				= "\JSDF_AirH\S55\JMSDF_S55A";
	};
};
