class CfgPatches
{
	class JSDF_AirH_OH1
	{
		units[] = {"JGSDF_XOH1", "JGSDF_OH1"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {};
	};
};

class CfgVehicles
{
	class AllVehicles;
	class Air 				: AllVehicles
	{
		class Sounds;			// External class reference
	};
	class JSDF_AirH 			: Air
	{
		class Turrets
		{
			class MainTurret;	// External class reference
		};
		class NewTurret;		// External class reference
		class ViewPilot;		// External class reference
		class AnimationSources;		// External class reference
		
		class Sounds : Sounds
		{
			class Engine;		// External class reference
			class Movement;		// External class reference
		};
		class HitPoints
		{
			class HitGlass1;	// External class reference
			class HitGlass2;	// External class reference
			class HitGlass3;	// External class reference
			class HitGlass4;	// External class reference
			class HitGlass5;	// External class reference
			class HitHRotor;	// External class reference
		};
	};
	class JSDF_OH1_Base		: JSDF_AirH
	{
		mainRotorSpeed 			= 1.0;
		backRotorSpeed 			= 1.5;

		cost 				= 10000000;
		displayName 			= OH-1;
		model 				= "\ca\air\ah1z";
		picture 			= "\ca\air\data\ico\ah1z_CA.paa";
		mapSize 			= 15.5;
		Icon 				= "\ca\air\data\map_ico\icomap_ah1z_CA.paa";

		threat[] 			= {0.3, 0.1, 0.1};
		accuracy 			= 1000;

		maxSpeed 			= 315;
		weapons[] 			= {};
		magazines[] 			= {};
		laserScanner 			= 1;

		hasGunner			= 1;
		hasCommander			= 0;
		transportSoldier 		= 0;
		getInAction 			= "GetInHigh";
		getOutAction 			= "GetOutHigh";
		driverCompartments 		= 1;
		driverInAction 			=  "UH60_Pilot";
		driverAction 			=  "UH60_Pilot";
		cargoAction[] 			= {"UH60_Pilot", "Mi17_Cargo02"};
		cargoCompartments[] 		= {2, 4};
		cargoIsCoDriver[] 		= {1, 0};

		class Turrets 				: Turrets
		{
			class MainTurret 			: MainTurret
			{
				gunnerCompartments 		= "Compartment2";
				weapons[] 			= {"Laserdesignator_mounted", 	"SidewinderLaucher_AH1Z"};
				magazines[] 			= {"Laserbatteries",		"2Rnd_Sidewinder_AH1Z"};
				memoryPointGun 			= "machinegun";
				enableManualFire 		= 1;
				minElev 	= -60;
				maxElev 	= 10;
				initElev 	= 0;
				minTurn 	= -70;
				maxTurn 	= 70;
				initTurn 	= 0;
				
				class ViewOptics
				{
					initAngleX = 0;
					minAngleX = -30;
					maxAngleX = 30;
					initAngleY = 0;
					minAngleY = -100;
					maxAngleY = 100;
					initFov = 0.155;
					minFov = 0.047;
					maxFov = 0.155;
				};
			};
		};

		class Sounds
		{
			class Engine
			{
				sound[] 	= {"jsdf_airh\oh1\oh1_eng.wss", 2.51189, 1.0, 900};
				frequency 	= "rotorSpeed";
				volume 		= "camPos*((rotorSpeed-0.72)*4)";
			};
			class EngineIn
			{
				sound[] 	= {"jsdf_airh\oh1\oh1_eng_in.wss", db10, 1.0};
				frequency 	= "rotorSpeed";
				volume 		= "(1-camPos)*((rotorSpeed-0.75)*4)";
			};
			class RotorLowOut
			{
				sound[] 	= {"ca\sounds\air\AH64\ext-rotor-ah64d_A", 3.16228, 1.0, 1300};
				frequency 	= "rotorSpeed";
				volume 		= "camPos*(0 max (rotorSpeed-0.1))";
				cone[] 		= {1.8, 3.14, 2.0, 0.9};
			};
			class RotorHighOut
			{
				sound[] 	= {"ca\sounds\air\AH64\ext-rotor-ah64d_B", 3.16228, 1.0, 1800};
				frequency 	= "rotorSpeed";
				volume 		= "camPos*10*(0 max (rotorThrust-0.95))";
				cone[] 		= {1.8, 3.14, 2.0, 0.9};
			};
			class RotorLowIn
			{
				sound[] 	= {"ca\sounds\air\AH64\ext-rotor-ah64d_A", 1.0, 1.0};
				frequency 	= "rotorSpeed";
				volume 		= "2*(1-camPos)*((rotorSpeed factor[0.3, 1.1]) min (rotorSpeed factor[1.1, 0.3]))";
			};
			class RotorHighIn
			{
				sound[] 	= {"ca\sounds\air\AH64\ext-rotor-ah64d_B", 1.77828, 1.0};
				frequency 	= "rotorSpeed";
				volume 		= "(1-camPos)*3*(rotorThrust-0.9)";
			};
		};
		class Reflectors
		{
			class Front
			{
				color[] 	= {1.0, 0.7, 0.5, 1.0};
				ambient[] 	= {0.1, 0.1, 0.1, 1.0};
				position 	= "light_front";
				direction 	= "light_front_dir";
				hitpoint 	= "light_front";
				selection 	= "light_front";
				size 		= 0.5;
				brightness 	= 2.5;
			};
		};
		aggregateReflectors[] 		= {{"Front"}};

		armor 				= 60;
		damageResistance 		= 0.00593;
	};	
	class JGSDF_OH1 			: JSDF_OH1_Base
	{
		scope 				= 2;
		faction 			= JGSDF;
		displayName 			= OH-1;
		model 				= "\JSDF_AirH\OH1\JGSDF_OH1";
	};
};
