class CfgPatches
{
	class JSDF_AirH_Hughes269
	{
		units[] = {"JGSDF_TH55J"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {};
	};
};

class CfgVehicles
{
	class AllVehicles;
	class Air 				: AllVehicles
	{
		class Sounds;			// External class reference
	};
	class JSDF_AirH 			: Air
	{
		class Turrets
		{
			class MainTurret;	// External class reference
		};
		class NewTurret;		// External class reference
		class ViewPilot;		// External class reference
		class AnimationSources;		// External class reference
		
		class Sounds : Sounds
		{
			class Engine;		// External class reference
			class Movement;		// External class reference
		};
		class HitPoints
		{
			class HitGlass1;	// External class reference
			class HitGlass2;	// External class reference
			class HitGlass3;	// External class reference
			class HitGlass4;	// External class reference
			class HitGlass5;	// External class reference
			class HitHRotor;	// External class reference
		};
	};
	class JSDF_Hughes269_Base		: JSDF_AirH
	{
		mainRotorSpeed 			= 1.0;
		backRotorSpeed 			= 1.5;

		cost 				= 10000000;
		displayName 			= TH-55J;
		model 				= "\ca\air\ah1z";
		picture 			= "\ca\air\data\ico\ah1z_CA.paa";
		mapSize 			= 15.5;
		Icon 				= "\ca\air\data\map_ico\icomap_ah1z_CA.paa";

		threat[] 			= {0.3, 0.1, 0.1};
		accuracy 			= 1000;

		maxSpeed 			= 315;
		weapons[] 			= {};
		magazines[] 			= {};
		laserScanner 			= 0;

		hasGunner			= 0;
		hasCommander			= 0;
		transportSoldier 		= 4;
		getInAction 			= "GetInLow";
		getOutAction 			= "GetOutLow";
		driverCompartments 		= 1;
		driverInAction 			=  "UH60_Pilot";
		driverAction 			=  "UH60_Pilot";
		cargoAction[] 			= {"UH60_Pilot", "Mi17_Cargo02"};
		cargoCompartments[] 		= {2, 4};
		cargoIsCoDriver[] 		= {1, 0};
		typicalCargo[] 			= {"USMC_Soldier_Pilot", "USMC_Soldier_Pilot"};

		class Reflectors
		{
			class Front
			{
				color[] 	= {1.0, 0.7, 0.5, 1.0};
				ambient[] 	= {0.1, 0.1, 0.1, 1.0};
				position 	= "light_front";
				direction 	= "light_front_dir";
				hitpoint 	= "light_front";
				selection 	= "light_front";
				size 		= 0.75;
				brightness 	= 1.5;
			};
		};
		aggregateReflectors[] 		= {{"Front"}};

		armor 				= 60;
		damageResistance 		= 0.00593;
	};	
	class JGSDF_TH55J 			: JSDF_Hughes269_Base
	{
		scope 				= 2;
		faction 			= JGSDF;
		displayName 			= TH-55J;
		model 				= "\JSDF_AirH\Hughes269\JGSDF_TH55J";
		maxSpeed 			= 250;
	};
};
