class CfgVehicles
{
	class AllVehicles;	// External class reference
	
	class Air 				: AllVehicles
	{
		accuracy			= 0;		// accuracy needed to recognize type of this target
		flareVelocity 			= 100;
		class NewTurret;				// External class reference
		class ViewPilot;				// External class reference
		class AnimationSources;				// External class reference
	};


		memoryPointMissile[] = {"spice rakety", "usti hlavne"};
		memoryPointMissileDir[] = {"konec rakety", "konec hlavne"};

	class JSDF_AirH 			: Air
	{
		scope 				= 0;
		side 				= 1;
		faction 			= JSDF;
		type 				= VAir;
		vehicleClass 			= "Air";
		accuracy 			= 0.5;		// accuracy needed to recognize type of this target

		weapons[] 			= {};
		magazines[] 			= {};
		irScanRangeMin 			= 0;
		irScanRangeMax 			= 0;
		nightVision 			= 0;
		attendant 			= 0;

		supplyRadius 			= 1.2;
		camouflage 			= 100;		// how dificult to spot - bigger - better spotable
		audible 			= 30;		// audible - bigger - better heard

		crew 				= "USMC_Soldier_Pilot";
		crewVulnerable 			= 1;
		getInAction 			= "GetInHigh";
		getOutAction 			= "GetOutHigh";
		gunnerGetInAction 		= "GetInHigh";
		gunnerGetOutAction 		= "GetOutHigh";
		cargoGetInAction[] 		= {"GetInLow"};
		cargoGetOutAction[] 		= {"GetOutLow"};
		typicalCargo[] 			= {"USMC_Soldier_Pilot", "USMC_Soldier_Pilot"};
		driverInAction 			= "UH60_Pilot";
		driverAction 			= "UH60_Pilot";

		selectionFireAnim 		= "muzzleflash";
		selectionRotorStill 		= "Rotor_Static";
		selectionRotorMove 		= "Rotor_Blurred";
		selectionHRotorStill 		= "Rotor_main_Static";
		selectionHRotorMove 		= "Rotor_main_Blurred";
		selectionVRotorStill 		= "Rotor_tail_Static";
		selectionVRotorMove 		= "Rotor_tail_Blurred";
		selectionBackLights 		= "light";
		selectionBrakeLights 		= "light_stop";
		selectionDashboard 		= "light_panel";

		memoryPointsGetInDriver 	= "pos_driver";
		memoryPointsGetInDriverDir 	= "pos_driver_dir";
		memoryPointsGetInCoDriver 	= "pos_codriver";
		memoryPointsGetInCoDriverDir 	= "pos_codriver_dir";
		memoryPointsGetInGunner 	= "pos_gunner";
		memoryPointsGetInGunnerDir 	= "pos_gunner_dir";
		memoryPointsGetInCargo	 	= "pos_cargo";
		memoryPointsGetInCargoDir	= "pos_cargo_dir";
//		memoryPointsGetInCargo[] 	= {"pos_codriver", 	"pos_cargo"};
//		memoryPointsGetInCargoDir[] 	= {"pos_codriver_dir", 	"pos_cargo_dir"};
		getInRadius 			= 0.5;

		memoryPointDriverOptics[] 	= {"driverview", "pilot"};
		memoryPointGunnerOptics 	= "gunnerview";
		memoryPointGun 			= "pos_gun";
//		memoryPointMissile[] 		= {"spice rakety", "usti hlavne"};
//		memoryPointMissileDir[] 	= {"konec rakety", "konec hlavne"};
		memoryPointLMissile 		= "pos_Missile_L";
		memoryPointRMissile 		= "pos_Missile_R";
		memoryPointLRocket 		= "pos_Rocket_L";
		memoryPointRRocket 		= "pos_Rocket_R";

		leftDustEffect 			= "LDustEffects";
		rightDustEffect 		= "RDustEffects";
		leftWaterEffect 		= "LWaterEffects";
		rightWaterEffect 		= "RWaterEffects";

		class Exhausts
		{
			class Exhaust
			{
				position 	= "exhaust";
				direction 	= "exhaust_dir";
				effect 		= "ExhaustsEffect";
			};
		};
		class Reflectors
		{
			class Front
			{
				color[] 	= {1.0, 0.5, 0.3, 1.0};
				ambient[] 	= {0.2, 0.2, 0.2, 1.0};
				position 	= "light_front";
				direction 	= "light_front_dir";
				hitpoint 	= "light_front";
				selection 	= "light_front";
				size 		= 0.5;
				brightness 	= 1.0;
			};
		};
		aggregateReflectors[] 		= {{"Front"}};
		class MarkerLights
		{
			class RedStill		{name = "light_position_Red";		color[] = {0.20, 0.02, 0.02, 1};	ambient[] = {0.30, 0.03, 0.03, 1};	brightness = 0.01;	blinking = 0;	};
			class RedBlinking	{name = "light_position_Red_blik";	color[] = {1.00, 0.05, 0.05, 1};	ambient[] = {0.20, 0.02, 0.02, 1};	brightness = 0.01;	blinking = 1;	};
			class GreenStill	{name = "light_position_Green";		color[] = {0.02, 0.20, 0.10, 1};	ambient[] = {0.03, 0.30, 0.03, 1};	brightness = 0.01;	blinking = 0;	};
			class WhiteStill	{name = "light_position";		color[] = {0.20, 0.20, 0.20, 1};	ambient[] = {0.03, 0.03, 0.03, 1};	brightness = 0.01;	blinking = 0;	};
			class WhiteBlinking	{name = "light_position_blik";		color[] = {1.00, 1.00, 1.00, 1};	ambient[] = {0.20, 0.20, 0.20, 1};	brightness = 0.01;	blinking = 1;	};
		};
		armorStructural 		= 4;
		class HitPoints
		{
			class HitHull		{armor = 1;	material = 51;	name = "hull";			visual = "hull";		passThrough = 1;	};
			class HitTail		{armor = 1;	material = 51;	name = "hull_tail";		visual = "hull_tail";		passThrough = 1;	};
			class HitEngine		{armor = 0.25;	material = 51;	name = "engine";		visual = "engine";		passThrough = 1;	};
			class HitAvionics	{armor = 0.15;	material = 51;	name = "avionics";		visual = "avionics";		passThrough = 1;	};
			class HitVRotor		{armor = 0.3;	material = 51;	name = "rotor_main";		visual = "rotor_main";		passThrough = 1;	};
			class HitHRotor		{armor = 0.2;	material = 51;	name = "rotor_tail";		visual = "rotor_tail";		passThrough = 1;	};
			class HitMissiles	{armor = 0.1;	material = 51;	name = "missile";		visual = "missile";		passThrough = 0.5;	};

			class Hit_light_F	{armor = 0.001;	material = -1;	name = "light_front";		visual= "";			passThrough = 0;	convexComponent = "light_front";	};
			class Hit_light_FL	{armor = 0.001;	material = -1;	name = "light_front_L";		visual= "";			passThrough = 0;	convexComponent = "light_front_L";	};
			class Hit_light_FR	{armor = 0.001;	material = -1;	name = "light_front_R";		visual= "";			passThrough = 0;	convexComponent = "light_front_R";	};

			class HitRGlass 	{armor = 0.1;	material = 51;	name = "Glass R";		visual = "Glass R";		passThrough = 0;	};
			class HitLGlass 	{armor = 0.1;	material = 51;	name = "Glass L";		visual = "Glass L";		passThrough = 0;	};
			class HitGlass1 	{armor = 2;	material = -1;	name = "glass1";		visual = "glass1";		passThrough = 0;	};
			class HitGlass2		{armor = 2;	material = -1;	name = "glass2";		visual = "glass2";		passThrough = 0;	};
			class HitGlass3		{armor = 2;	material = -1;	name = "glass3";		visual = "glass3";		passThrough = 0;	};
			class HitGlass4		{armor = 2;	material = -1;	name = "glass4";		visual = "glass4";		passThrough = 0;	};
			class HitGlass5 	{armor = 2;	material = -1;	name = "glass5";		visual = "glass5";		passThrough = 0;	};
			class HitGlass6 	{armor = 2;	material = -1;	name = "glass6";		visual = "glass6";		passThrough = 0;	};
		};
		class AnimationSources 		: AnimationSources
		{
			class HitGlass1 			{hitpoint = "HitGlass1";	source = "Hit";	raw = 1;	};
			class HitGlass2 	: HitGlass1 	{hitpoint = "HitGlass2";	};
			class HitGlass3 	: HitGlass1 	{hitpoint = "HitGlass3";	};
			class HitGlass4 	: HitGlass1 	{hitpoint = "HitGlass4";	};
			class HitGlass5 	: HitGlass1 	{hitpoint = "HitGlass5";	};
			class HitGlass6 	: HitGlass1 	{hitpoint = "HitGlass6";	};
		};
		dammageHalf[] 			= {};
		dammageFull[] 			= {};
		destrType 			= "DestructWreck";
		secondaryExplosion 		= -0.1;

		class Turrets
		{
			class MainTurret : NewTurret
			{
				commanding 			= -1;
				selectionFireAnim 		= "zasleh";
				body 				= "gun_main_turret";
				gun 				= "gun_main";
				gunBeg 				= "pos_gun_dir";
				gunEnd 				= "pos_gun";
				memoryPointGun 			= "pos_gun";
				memoryPointGunnerOptics 	= "pos_gunne_rview";
				memoryPointsGetInGunner 	= "pos_gunner";
				memoryPointsGetInGunnerDir 	= "pos_gunner_dir";
				castGunnerShadow 		= 1;
				viewGunnerShadow 		= 1;
				gunnerGetInAction 		= "GetInHigh";
				gunnerGetOutAction 		= "GetOutHigh";
				gunnerAction 			= "AH1Z_Gunner";
				gunnerInAction 			= "AH1Z_Gunner";
				gunnerOpticsModel 		= "\ca\air\optika_AH1Z";
				gunnerOpticsEffect[] 		= {"TankCommanderOptics1", BWTV};
				gunnerForceOptics 		= 0;
				enableManualFire 		= 0;
				outGunnerMayFire 		= 1;
				
				class HitPoints
				{
					class HitTurret	{armor = 0.2;	material = 51;	name = "vez";	visual = "vez";		passThrough = 0.3;	};
					class HitGun 	{armor = 0.2;	material = 51;	name = "zbran";	visual = "zbran";	passThrough = 0.1;	};
				};
			};
		};
		soundGetIn[] 			= {"ca\sounds\air\noises\heli_door_01", db-10, 1};
		soundGetOut[] 			= {"ca\sounds\air\noises\heli_door_01", db-10, 1, 50};
		soundDammage[] 			= {"ca\sounds\air\noises\alarm_loop1", 0.001, 1};
		soundEngineOnInt[] 		= {"ca\sounds\Air\UH1Y\int\int-start-final", 0.0316228, 1.0};
		soundEngineOnExt[] 		= {"ca\sounds\Air\UH1Y\ext\ext-motor-start", 1.77828, 1.0, 700};
		soundEngineOffInt[] 		= {"ca\sounds\Air\UH1Y\int\int-stop-final", 0.0316228, 1.0};
		soundEngineOffExt[] 		= {"ca\sounds\Air\UH1Y\ext\ext-motor-stop", 1.77828, 1.0, 700};

		class Sounds
		{
			class Engine {
				sound[] 	= {"ca\sounds\air\ah1\ext\ext-ah1z-engine-01", db10, 1.0, 800};
				frequency 	= "rotorSpeed";
				volume 		= "camPos*((rotorSpeed-0.72)*4)";
			};
			
			class RotorLowOut {
				sound[] 	= {"ca\sounds\air\uh1y\int\int-rotor-single5b", db10, 1.0, 1500};
				frequency 	= "rotorSpeed";
				volume 		= "camPos*(0 max (rotorSpeed-0.1))";
				cone[] 		= {1.8, 3.14, 2.0, 0.9};
			};
			
			class RotorHighOut {
				sound[] 	= {"ca\sounds\air\uh1y\int\int-rotor-single5a", db10, 1.0, 1800};
				frequency 	= "rotorSpeed";
				volume 		= "camPos*10*(0 max (rotorThrust-0.95))";
				cone[] 		= {1.8, 3.14, 2.0, 0.9};
			};
			
			class EngineIn {
				sound[] 	= {"ca\sounds\air\uh1y\int\int-fly-mode7", db5, 1.0};
				frequency 	= "rotorSpeed";
				volume 		= "(1-camPos)*((rotorSpeed-0.75)*4)";
			};
			
			class RotorLowIn {
				sound[] 	= {"ca\sounds\air\uh1y\int\int-rotor-single5b", db5, 1.0};
				frequency 	= "rotorSpeed";
				volume 		= "2*(1-camPos)*((rotorSpeed factor[0.3, 1.1]) min (rotorSpeed factor[1.1, 0.3]))";
			};
			
			class RotorHighIn {
				sound[] 	= {"ca\sounds\air\uh1y\int\int-rotor-single5a", db5, 1.0};
				frequency 	= "rotorSpeed";
				volume 		= "(1-camPos)*3*(rotorThrust-0.9)";
			};
		};
		
		class Eventhandlers 		: DefaultEventhandlers {};
		class DestructionEffects {};
	};
};