class CfgPatches
{
	class JSDF_AirH_AH1
	{
		units[] = {"JGSDF_AH1S"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {"JSDF_W"};
	};
};

class CfgVehicles
{
	class AllVehicles;
	class Air 				: AllVehicles
	{
		class Sounds;			// External class reference
	};
	class Helicopter 			: Air
	{
		class Turrets
		{
			class MainTurret;	// External class reference
		};
		class NewTurret;		// External class reference
		class ViewPilot;		// External class reference
		class AnimationSources;		// External class reference
		
		class Sounds : Sounds
		{
			class Engine;		// External class reference
			class Movement;		// External class reference
		};
		class HitPoints
		{
			class HitGlass1;	// External class reference
			class HitGlass2;	// External class reference
			class HitGlass3;	// External class reference
			class HitGlass4;	// External class reference
			class HitGlass5;	// External class reference
			class HitHRotor;	// External class reference
		};
	};
	class JSDF_AirH				: Helicopter{};

	class JSDF_AH1_Base			: JSDF_AirH
	{
		cost 				= 10000000;
		side 				= 1;
		faction 			= JGSDF;
		accuracy 			= 1000;
		displayName 			= $STR_DN_AH1Z;
		model 				= "\ca\air\ah1z";
		picture 			= "\ca\air\data\ico\ah1z_CA.paa";
		mapSize 			= 15.5;
		Icon 				= "\ca\air\data\map_ico\icomap_ah1z_CA.paa";

		mainRotorSpeed 			= 1.0;
		backRotorSpeed 			= 1.9;

		crew 				= "USMC_Soldier_Pilot";
		driverCompartments 		= "Compartment1";
		driverAction 			= "AH1Z_Pilot";
		typicalCargo[] 			= {"USMC_Soldier_Pilot", "USMC_Soldier_Pilot"};

		maxSpeed 			= 270;
		armor 				= 60;
		damageResistance 		= 0.00593;
		weapons[] 			= {};
		magazines[] 			= {};
		laserScanner 			= 1;
		threat[] 			= {0.3, 1, 0.8};
		
		class Turrets 			: Turrets
		{
			class MainTurret 		: MainTurret
			{
				gunnerCompartments 		= "Compartment2";
				gunnerAction 			= "AH1Z_Gunner";
				gunnerInAction 			= "AH1Z_Gunner";
				weapons[] 			= {"JSDF_AAG_M197_AH1",		"HellfireLauncher",	"JSDF_W_M261x2"};
				magazines[] 			= {"JSDF_AAG_20mm_AH1_HE",	"8Rnd_Hellfire",	"JSDF_M_70mmFFARx38"};
				gunnerOpticsModel 		= "\ca\air\optika_AH1Z";
				gunnerOpticsEffect[] 		= {"TankCommanderOptics1", BWTV};
				enableManualFire 		= 1;
				
				minElev = -60;	maxElev = 10;	initElev = 0;
				minTurn = -70;	maxTurn = 70;	initTurn = 0;

				class ViewOptics
				{
					initAngleX = 0;		minAngleX =  -30;	maxAngleX =  30;
					initAngleY = 0;		minAngleY = -100;	maxAngleY = 100;
					initFov	   = 0.155;	minFov 	  = 0.047;	maxFov 	  = 0.155;
				};
			};
		};
		soundGetIn[] 			= {"ca\sounds\air\noises\heli_door_01", db-10, 1};
		soundGetOut[] 			= {"ca\sounds\air\noises\heli_door_01", db-10, 1, 50};
		soundDammage[] 			= {"ca\sounds\air\noises\alarm_loop1", 0.001, 1};
		soundEngineOnInt[] 		= {"ca\sounds\Air\UH1Y\int\int-start-final", 0.0316228, 1.0};
		soundEngineOnExt[] 		= {"ca\sounds\Air\UH1Y\ext\ext-motor-start", 1.77828, 1.0, 700};
		soundEngineOffInt[] 		= {"ca\sounds\Air\UH1Y\int\int-stop-final", 0.0316228, 1.0};
		soundEngineOffExt[] 		= {"ca\sounds\Air\UH1Y\ext\ext-motor-stop", 1.77828, 1.0, 700};
		class Sounds
		{
			class Engine {
				sound[] 	= {"ca\sounds\air\ah1\ext\ext-ah1z-engine-01", db10, 1.0, 800};
				frequency 	= "rotorSpeed";
				volume 		= "camPos*((rotorSpeed-0.72)*4)";
			};
			
			class RotorLowOut {
				sound[] 	= {"ca\sounds\air\uh1y\int\int-rotor-single5b", db10, 1.0, 1500};
				frequency 	= "rotorSpeed";
				volume 		= "camPos*(0 max (rotorSpeed-0.1))";
				cone[] 		= {1.8, 3.14, 2.0, 0.9};
			};
			
			class RotorHighOut {
				sound[] 	= {"ca\sounds\air\uh1y\int\int-rotor-single5a", db10, 1.0, 1800};
				frequency 	= "rotorSpeed";
				volume 		= "camPos*10*(0 max (rotorThrust-0.95))";
				cone[] 		= {1.8, 3.14, 2.0, 0.9};
			};
			
			class EngineIn {
				sound[] 	= {"ca\sounds\air\uh1y\int\int-fly-mode7", db5, 1.0};
				frequency 	= "rotorSpeed";
				volume 		= "(1-camPos)*((rotorSpeed-0.75)*4)";
			};
			
			class RotorLowIn {
				sound[] 	= {"ca\sounds\air\uh1y\int\int-rotor-single5b", db5, 1.0};
				frequency 	= "rotorSpeed";
				volume 		= "2*(1-camPos)*((rotorSpeed factor[0.3, 1.1]) min (rotorSpeed factor[1.1, 0.3]))";
			};
			
			class RotorHighIn {
				sound[] 	= {"ca\sounds\air\uh1y\int\int-rotor-single5a", db5, 1.0};
				frequency 	= "rotorSpeed";
				volume 		= "(1-camPos)*3*(rotorThrust-0.9)";
			};
		};
		class AnimationSources 		: AnimationSources
		{
			class revolving_M197					{source = "revolving";	weapon = JSDF_AAG_M197_AH1;};
			class mainRotor_folded 					{source = "user";	animPeriod = 0.001;	initPhase = 1;	};
			class mainRotor_unfolded 	: mainRotor_folded 	{initPhase = 0;	};
			class rotorShaft_unfolded 	: mainRotor_unfolded 	{};
		};

		class HitPoints 		: HitPoints
		{
			class HitGlass2 		: HitGlass2 {armor = 0.5;};
			class HitGlass3 		: HitGlass3 {armor = 0.5;};
			class HitGlass4 		: HitGlass4 {armor = 0.5;};
			class HitGlass5 		: HitGlass5 {armor = 0.5;};
		};
		dammageHalf[] 	= {"\Ca\air\data\ah1z_monitor_glass_ca.paa", "\Ca\air\data\ah1z_monitor_glass_destr_co.paa"};
		dammageFull[] 	= {"\Ca\air\data\ah1z_monitor_glass_ca.paa", "\Ca\air\data\ah1z_monitor_glass_destr_co.paa"};
		class Damage
		{
			tex[] 	= {};
			mat[] 	= {"ca\air\data\ah1z_body.rvmat", "ca\air\data\ah1z_body_damage.rvmat", "ca\air\data\ah1z_body_destruct.rvmat", "ca\air\data\ah1z_glass.rvmat", "ca\air\data\ah1z_glass_damage.rvmat", "ca\air\data\ah1z_glass_damage.rvmat", "ca\air\data\ah1z_glass_in.rvmat", "ca\air\data\ah1z_glass_in_damage.rvmat", "ca\air\data\ah1z_glass_in_damage.rvmat", "ca\air\data\ah1z_cockpit.rvmat", "ca\air\data\ah1z_cockpit.rvmat", "ca\air\data\ah1z_cockpit_destruct.rvmat", "ca\air\data\ah1z_engines.rvmat", "ca\air\data\ah1z_engines_damage.rvmat", "ca\air\data\ah1z_engines_destruct.rvmat", "Ca\air\data\ah1z_monitors.rvmat", "Ca\air\data\ah1z_monitors.rvmat", "Ca\air\data\ah1z_monitors_destruct.rvmat"};
		};
		
		class Library
		{
			libTextDesc = $STR_LIB_AH1Z;
		};
	};	
	class JSDF_AH1S 			: JSDF_AH1_Base
	{
		scope 				= 2;
		displayName 			= AH-1S;
		model 				= "\JSDF_AirH\Bell209\JGSDF_AH1S";
	};
};
