class CfgPatches
{
	class JSDF_AirH_UH1
	{
		units[] = {"JGSDF_UH1B", "JGSDF_UH1H", "JGSDF_UH1J"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {};
	};
};
class CfgVehicles
{
	class AllVehicles;
	class Air 				: AllVehicles
	{
		class Sounds;			// External class reference
	};
	class Helicopter 			: Air
	{
		class Turrets
		{
			class MainTurret;	// External class reference
		};
		class NewTurret;		// External class reference
		class ViewPilot;		// External class reference
		class AnimationSources;		// External class reference
		
		class Sounds : Sounds
		{
			class Engine;		// External class reference
			class Movement;		// External class reference
		};
		class HitPoints
		{
			class HitGlass1;	// External class reference
			class HitGlass2;	// External class reference
			class HitGlass3;	// External class reference
			class HitGlass4;	// External class reference
			class HitGlass5;	// External class reference
			class HitHRotor;	// External class reference
		};
	};
	class JSDF_AirH				: Helicopter{};
	
	class JSDF_UH1_base			: JSDF_AirH
	{
		faction 			= JGSDF;
		model 				= "\ca\air2\UH1Y\UH1Y.p3d";
		picture 			= "\ca\air2\data\UI\picture_UH1Y_CA.paa";
		icon 				= "\ca\air2\data\UI\icon_UH1Y_CA.paa";
		mapSize 			= 15;
		displayName 			= HU-1;

		maxSpeed 			= 293;
		mainRotorSpeed 			= 1.2;
		backRotorSpeed 			= 2.1;
		armor 				= 30;
		damageResistance 		= 0.00244;
		minFireTime 			= 30;
		threat[] 			= {1, 0.05, 0.05};

		crew 				= "USMC_Soldier_Pilot";
		driverCompartments 		= 1;
		cargoCompartments[] 		= {2};
		driverAction 			= "UH1Y_Pilot";
		driverInAction 			= "UH1Y_Pilot";
		cargoAction[] 			= {"UH1Y_Cargo02", "UH1Y_Cargo03", "UH1Y_Cargo03", "UH1Y_Cargo02", "UH1Y_Cargo01", "UH1Y_Cargo01", "UH1Y_Cargo01"};
		cargoIsCoDriver[] 		= {1, 0};
		driverCanSee 			= 31;
		gunnerCanSee 			= 31;
		gunnerUsesPilotView 		= 1;
		gunnerOpticsModel 		= "";
		transportSoldier 		= 7;
		transportAmmo 			= 0;
		transportMaxMagazines 		= 150;
		transportMaxWeapons 		= 30;
		initCargoAngleY 		= 10;
		minCargoAngleY 			= -60;
		maxCargoAngleY 			= 120;
		class ViewPilot : ViewPilot
		{
			initFov = 1;
			minFov = 0.3;
			maxFov = 1.2;
			initAngleX = 0;
			minAngleX = -65;
			maxAngleX = 85;
			initAngleY = 0;
			minAngleY = -150;
			maxAngleY = 150;
		};		
/*
		class Turrets : Turrets
		{
			class MainTurret : MainTurret
			{
				body = "mainTurret";
				gun = "mainGun";
				minElev = -60;
				maxElev = 30;
				initElev = 0;
				minTurn = -5;
				maxTurn = 185;
				initTurn = 0;
				soundServo[] = {"", 0.01, 1.0};
				animationSourceHatch = "";
				stabilizedInAxes = "StabilizedInAxesNone";
				gunBeg = "muzzle_1";
				gunEnd = "chamber_1";
				weapons[] = {M2};
				magazines[] = {"100Rnd_127x99_M2", "100Rnd_127x99_M2", "100Rnd_127x99_M2", "100Rnd_127x99_M2", "100Rnd_127x99_M2", "100Rnd_127x99_M2"};
				gunnerName = $STR_POSITION_CREWCHIEF;
				gunnerOpticsModel = "\ca\weapons\optika_empty";
				gunnerOutOpticsShowCursor = 1;
				gunnerOpticsShowCursor = 1;
				gunnerAction = "UH1Y_Gunner";
				gunnerInAction = "UH1Y_Gunner";
				commanding = -2;
				primaryGunner = 1;
				
				class ViewOptics {
					initAngleX = 0;
					minAngleX = -30;
					maxAngleX = 30;
					initAngleY = 0;
					minAngleY = -100;
					maxAngleY = 100;
					initFov = 0.7;
					minFov = 0.25;
					maxFov = 1.1;
				};
				gunnerCompartments = 2;
			};
			
			class RightDoorGun : MainTurret
			{
				body = "Turret2";
				gun = "Gun_2";
				animationSourceBody = "Turret_2";
				animationSourceGun = "Gun_2";
				stabilizedInAxes = "StabilizedInAxesNone";
				selectionFireAnim = "zasleh_1";
				proxyIndex = 2;
				gunnerName = $STR_POSITION_DOORGUNNER;
				commanding = -3;
				minTurn = -180;
				maxTurn = 0;
				initTurn = 0;
				weapons[] = {M134_2};
				gunBeg = "muzzle_2";
				gunEnd = "chamber_2";
				primaryGunner = 0;
				memoryPointGun = "machinegun_2";
				memoryPointGunnerOptics = "gunnerview_2";
			};
			
			class CoPilotObs : MainTurret
			{
				stabilizedInAxes = "StabilizedInAxesBoth";
				proxyIndex = 3;
				gunnerName = "$STR_GN_UH1Y_CoPilotObs";
				gunnerAction = "UH1Y_Gunner02";
				gunnerInAction = "UH1Y_Gunner02";
				body = "ObsTurret";
				gun = "ObsGun";
				animationSourceBody = "ObsTurret";
				animationSourceGun = "ObsGun";
				outGunnerMayFire = 1;
				gunBeg = "gun_end";
				gunEnd = "gun_begin";
				memoryPointGun = "gun_end";
				commanding = -1;
				weapons[] = {"Laserdesignator_mounted"};
				magazines[] = {"Laserbatteries"};
				primaryGunner = 0;
				minElev = -80;
				maxElev = 25;
				initElev = 0;
				minTurn = -180;
				maxTurn = 180;
				initTurn = 0;
				gunnerOpticsModel = "\ca\weapons\optika_SOFLAM";
				memoryPointGunnerOptics = "commanderview";
				gunnerForceOptics = 0;
				gunnerOpticsShowCursor = 0;
				
				class ViewOptics {
					initAngleX = 0;
					minAngleX = -30;
					maxAngleX = 30;
					initAngleY = 0;
					minAngleY = -100;
					maxAngleY = 100;
					initFov = 0.8;
					minFov = 0.0083;
					maxFov = 0.8;
				};
				gunnerCompartments = 2;
				startEngine = 0;
				soundServo[] = {"", 0.01, 1.0};
				memoryPointsGetInGunner = "pos_codriver";
				memoryPointsGetInGunnerDir = "pos_codriver_dir";
				selectionFireAnim = "";
				castGunnerShadow = 1;
				viewGunnerShadow = 1;
			};
		};
*/
		
		class AnimationSources : AnimationSources
		{
			class Gatling_1
			{
				source = "revolving";
				weapon = M134;
			};
			
			class Gatling_2
			{
				source = "revolving";
				weapon = M134_2;
			};
			
			class HUDAction
			{
				source = "user";
				animPeriod = 2;
				initPhase = 1;
			};
			
			class HUDAction_1
			{
				source = "user";
				animPeriod = 0.1;
				initPhase = 1;
			};
			
			class mainRotor_folded
			{
				source = "user";
				animPeriod = 0.001;
				initPhase = 1;
			};
			
			class mainRotor_unfolded : mainRotor_folded
			{
				initPhase = 0;
			};
		};
/*
		class UserActions
		{
			class HUDoff {
				displayName = $STR_AM_HUDON;
				displayNameDefault = "HUD on";
				position = "zamerny";
				radius = 1;
				onlyForPlayer = 1;
				condition = "(player==driver this)and(this animationphase ""HUDAction"" !=1)";
				statement = "this animate [""HUDAction"",1];this animate [""HUDAction_1"",1]";
			};
			
			class HUDon
			{
				displayName = $STR_AM_HUDOFF;
				displayNameDefault = "HUD off";
				position = "zamerny";
				radius = 1;
				onlyForPlayer = 1;
				condition = "(player==driver this)and(this animationphase ""HUDAction"" !=0)";
				statement = "this animate [""HUDAction"",0];this animate [""HUDAction_1"",0]";
			};
		};
*/
		soundGetIn[] 		= {"\ca\Sound\Air\Noises\heli_door_01", 0.316228, 1};
		soundGetOut[] 		= {"\ca\Sound\Air\Noises\heli_door_01", 0.316228, 1, 40};
		soundEnviron[] 		= {"", 0.0316228, 1.0};
		soundDammage[] 		= {"Ca\sounds\Air\Noises\alarm_loop1", 0.316228, 1};
		soundEngineOnInt[] 	= {"ca\sounds\Air\UH1Y\int\int-start-final", 0.446684, 1.0};
		soundEngineOnExt[] 	= {"ca\sounds\Air\UH1Y\ext\ext-motor-start", 0.446684, 1.0, 700};
		soundEngineOffInt[] 	= {"ca\sounds\Air\UH1Y\int\int-stop-final", 0.446684, 1.0};
		soundEngineOffExt[] 	= {"ca\sounds\Air\UH1Y\ext\ext-motor-stop", 0.446684, 1.0, 700};
		
		class Sounds : Sounds
		{
			class Engine : Engine
			{
				sound[] = {"JSDF_AirH\Bell204\UH1B_eng.wss", 2.51189, 1.0, 800};
				frequency = "rotorSpeed";
				volume = "camPos*((rotorSpeed-0.72)*4)";
			};
			
			class RotorLowOut
			{
				sound[] = {"ca\sounds\air\uh1y\int\int-rotor-single5b", 2.51189, 1.0, 1400};
				frequency = "rotorSpeed";
				volume = "camPos*(0 max (rotorSpeed-0.1))";
				cone[] = {1.6, 3.14, 2.0, 0.5};
			};
			
			class RotorHighOut
			{
				sound[] = {"ca\sounds\air\uh1y\int\int-rotor-single5a", 2.51189, 1.0, 1600};
				frequency = "rotorSpeed";
				volume = "camPos*10*(0 max (rotorThrust-0.9))";
				cone[] = {1.6, 3.14, 2.0, 0.5};
			};
			
			class EngineIn
			{
				sound[] = {"ca\sounds\air\uh1y\int\int-fly-mode7", 1.0, 1.0};
				frequency = "rotorSpeed";
				volume = "(1-camPos)*((rotorSpeed-0.75)*4)";
			};
			
			class RotorLowIn
			{
				sound[] = {"ca\sounds\air\uh1y\int\int-rotor-single5b", 1.0, 1.0};
				frequency = "rotorSpeed";
				volume = "2*(1-camPos)*((rotorSpeed factor[0.3, 1.1]) min (rotorSpeed factor[1.1, 0.3]))";
			};
			
			class RotorHighIn
			{
				sound[] = {"ca\sounds\air\uh1y\int\int-rotor-single5a", 1.0, 1.0};
				frequency = "rotorSpeed";
				volume = "(1-camPos)*3*(rotorThrust-0.9)";
			};
		};
		dammageHalf[] = {};
		dammageFull[] = {};
		
		class Damage
		{
			tex[] = {};
			mat[] =	{

"ca\air2\uh1y\data\uh1y_sklo.rvmat",
"ca\air2\uh1y\data\uh1y_sklo_damage.rvmat",
"ca\air2\uh1y\data\uh1y_sklo_damage.rvmat",

"ca\air2\uh1y\data\uh1y_sklo_in.rvmat",
"ca\air2\uh1y\data\uh1y_sklo_in_damage.rvmat",
"ca\air2\uh1y\data\uh1y_sklo_in_damage.rvmat", 

"ca\air2\uh1y\data\uh1y_ext.rvmat",
"ca\air2\uh1y\data\uh1y_ext_damage.rvmat",
"ca\air2\uh1y\data\uh1y_ext_destruct.rvmat",

"ca\air2\uh1y\data\uh1y_int.rvmat", 
"ca\air2\uh1y\data\uh1y_int_damage.rvmat",
"ca\air2\uh1y\data\uh1y_int_destruct.rvmat", 

"ca\air2\uh1y\data\launcher.rvmat",
"ca\air2\uh1y\data\launcher.rvmat", 
"ca\air2\uh1y\data\launcher_destruct.rvmat",

"ca\air2\uh1y\data\uh1y_cockpit.rvmat", 
"ca\air2\uh1y\data\uh1y_cockpit_damage.rvmat",
"ca\air2\uh1y\data\uh1y_cockpit_destruct.rvmat"

				};
		};
		
		class Library
		{
			libTextDesc = $STR_LIB_UH1Y;
		};

	};
	class JSDF_UH1B 			: JSDF_UH1_Base
	{
		scope 				= 2;
		displayName 			= UH-1B;
		model 				= "\JSDF_AirH\Bell204\JGSDF_UH1B";
	};
	class JSDF_UH1B_OD 			: JSDF_UH1B	{scope = 1;	model= "\JSDF_AirH\Bell204\JGSDF_UH1B_OD";	};
	class JSDF_UH1B_OG 			: JSDF_UH1B	{scope = 1;	model= "\JSDF_AirH\Bell204\JGSDF_UH1B_OG";	};
	class JSDF_UH1B_OK 			: JSDF_UH1B	{scope = 1;	model= "\JSDF_AirH\Bell204\JGSDF_UH1B_OK";	};

	class JSDF_UH1H 			: JSDF_UH1_Base
	{
		scope 				= 2;
		displayName 			= UH-1H;
		model 				= "\JSDF_AirH\Bell204\JGSDF_UH1H";
	};
	class JSDF_UH1H_OD 			: JSDF_UH1H	{scope = 1;	model= "\JSDF_AirH\Bell204\JGSDF_UH1H_OD";	};
	class JSDF_UH1H_OG 			: JSDF_UH1H	{scope = 1;	model= "\JSDF_AirH\Bell204\JGSDF_UH1H_OG";	};
	class JSDF_UH1H_OK 			: JSDF_UH1H	{scope = 1;	model= "\JSDF_AirH\Bell204\JGSDF_UH1H_OK";	};

	class JSDF_UH1J 			: JSDF_UH1_Base
	{
		scope 				= 2;
		displayName 			= UH-1J;
		model 				= "\JSDF_AirH\Bell204\JGSDF_UH1J";
	};
};
