class CfgPatches
{
	class JSDF_AirH_AH64
	{
		units[] = {"JGSDF_AH64D"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {"JSDF_W"};
	};
};

class CfgVehicles
{
	class AllVehicles;
	class Air 				: AllVehicles
	{
		class Sounds;			// External class reference
	};
	class Helicopter 			: Air
	{
		class Turrets
		{
			class MainTurret;	// External class reference
		};
		class NewTurret;		// External class reference
		class ViewPilot;		// External class reference
		class AnimationSources;		// External class reference
		
		class Sounds : Sounds
		{
			class Engine;		// External class reference
			class Movement;		// External class reference
		};
		class HitPoints
		{
			class HitGlass1;	// External class reference
			class HitGlass2;	// External class reference
			class HitGlass3;	// External class reference
			class HitGlass4;	// External class reference
			class HitGlass5;	// External class reference
			class HitHRotor;	// External class reference
		};
	};
	class JSDF_AirH				: Helicopter{};

	class JSDF_AH64_Base			: JSDF_AirH
	{
		faction 			= JGSDF;
		accuracy 			= 1000;
		cost 				= 10000000;
		model 				= "\ca\air\ah1z";
		picture 			= "jsdf_airh\ah64\_pic_ah64d_ca.paa";
		mapSize 			= 16;
		Icon 				= "jsdf_airh\ah64\_Icon_ah64d_ca.paa";
		displayName 			= AH-64;

		driverAction 			= "AH64_Pilot";
		driverCompartments 		= "Compartment1";
		typicalCargo[] 			= {"USMC_Soldier_Pilot", "USMC_Soldier_Pilot"};

		body 				= "sensor2_turret";
		gun 				= "sensor2";

		class Sounds
		{
			class Engine
			{
				sound[] 	= {"JSDF_AirH\AH64\AH64_eng.wss", db10, 1.0, 800};
				frequency 	= "rotorSpeed";
				volume 		= "camPos*((rotorSpeed-0.72)*4)";
			};
			class EngineIn
			{
				sound[] 	= {"ca\sounds\air\AH64\int-fly-ah64d", 1.77828, 1.0};
				frequency 	= "rotorSpeed";
				volume 		= "(1-camPos)*((rotorSpeed-0.75)*4)";
			};
			class RotorLowOut
			{
				sound[] = {"ca\sounds\air\AH64\ext-rotor-ah64d_A", 3.16228, 1.0, 1300};
				frequency = "rotorSpeed";
				volume = "camPos*(0 max (rotorSpeed-0.1))";
				cone[] = {1.8, 3.14, 2.0, 0.9};
			};
			class RotorHighOut
			{
				sound[] = {"ca\sounds\air\AH64\ext-rotor-ah64d_B", 3.16228, 1.0, 1800};
				frequency = "rotorSpeed";
				volume = "camPos*10*(0 max (rotorThrust-0.95))";
				cone[] = {1.8, 3.14, 2.0, 0.9};
			};
			class RotorLowIn {
				sound[] = {"ca\sounds\air\AH64\ext-rotor-ah64d_A", 1.0, 1.0};
				frequency = "rotorSpeed";
				volume = "2*(1-camPos)*((rotorSpeed factor[0.3, 1.1]) min (rotorSpeed factor[1.1, 0.3]))";
			};
			class RotorHighIn {
				sound[] = {"ca\sounds\air\AH64\ext-rotor-ah64d_B", 1.77828, 1.0};
				frequency = "rotorSpeed";
				volume = "(1-camPos)*3*(rotorThrust-0.9)";
			};
		};
		armor 				= 60;
		damageResistance 		= 0.00593;
		maxSpeed 			= 293;
		weapons[] 			= {};
		magazines[] 			= {};
		laserScanner 			= 1;
		threat[] 			= {0.3, 1, 0.8};
		
		class Turrets 			: Turrets
		{
			class MainTurret 		: MainTurret
			{
				gunnerAction 			= "AH64_Gunner";
				gunnerInAction 			= "AH64_Gunner";
				gunnerCompartments 		= "Compartment2";
				stabilizedInAxes 		=  3;
				weapons[] 			= {"JSDF_AAG_M230_AH64", 	"JSDF_W_M229x2", 	"JSDF_W_M261x2",	"JSDF_W_ATAS"};
				magazines[] 			= {"JSDF_AAG_M230_HEI_T",	"JSDF_M_AGM_114Lx8",	"JSDF_M_70mmFFARx38", 	"JSDF_M_ATAS"};
				memoryPointsGetInGunner 	= "pos_gunner";
				memoryPointsGetInGunnerDir 	= "pos_gunner_dir";
				gunnerGetInAction 		= "GetInHigh";
				gunnerGetOutAction 		= "GetOutHigh";
				gunnerOpticsModel 		= "\ca\air\optika_AH1Z";
				gunnerOpticsEffect[] 		= {"TankCommanderOptics1", BWTV};
				enableManualFire 		= 1;
				
				minElev = -60;	maxElev = 15;	initElev = 0;
				minTurn =-120;	maxTurn =120;	initTurn = 0;

				class ViewOptics
				{
					initAngleX = 0;		minAngleX =  -30;	maxAngleX =  30;
					initAngleY = 0;		minAngleY = -100;	maxAngleY = 100;
					initFov	   = 0.155;	minFov 	  = 0.047;	maxFov 	  = 0.155;
				};
			};
		};
		class Reflectors
		{
			class Front
			{
				color[] 	= {1.0, 0.7, 0.5, 1.0};
				ambient[] 	= {0.1, 0.1, 0.1, 1.0};
				position 	= "light_front";
				direction 	= "light_front_dir";
				hitpoint 	= "light_front";
				selection 	= "light_front";
				size 		= 0.5;
				brightness 	= 2.5;
			};
		};
		aggregateReflectors[] 		= {{"Front"}};
		class Library
		{
			libTextDesc = LIB_AH64;
		};
	};
	class JSDF_AH64D 			: JSDF_AH64_Base
	{
		scope 				= 2;
		displayName 			= AH-64D;
		model 				= "\JSDF_AirH\AH64\JGSDF_AH64D";
	};
	class JSDF_AH64D_16 			: JSDF_AH64D
	{
		scope 				= 0;
		displayName 			= AH-64D(16);
		class Turrets 			: Turrets
		{
			class MainTurret 		: MainTurret
			{
				weapons[] 			= {"JSDF_AAG_M230_AH64",	"M229_AH64",	"StingerLaucher"	};
				magazines[] 			= {"JSDF_AAG_M230_HEI_T",	"M_AGM_AH64x2",	"4Rnd_Stinger"		};
			};
		};
	};
};
