#include "basicDefines.hpp"
#include "CrewAnimations.hpp"
class CfgPatches
{
	class JSDF_Air
	{
		units[] =
		{
			"P3C"
		};
		weapons[] = {};
		requiredVersion = 0.10;
		requiredAddons[] = {"CACharacters","CAWeapons","CA_Anims_Char"};
	};
};
class CfgVehicleClasses
{
	access = ReadAndCreate;
	class JSDF_Air	{displayName = Air(J.S.D.F.);	};
	class JGSDF_Air	{displayName = Air(J.G.S.D.F.);	};
	class JMSDF_Air	{displayName = Air(J.M.S.D.F.);	};
	class JASDF_Air	{displayName = Air(J.A.S.D.F.);	};
};

class AirplaneHUD
{
	class Pos10Vector;
	class bones
	{
		class AGLMove1;
		class AGLMove2;
		class ASLMove1;
		class ASLMove2;
		class VertSpeed;
		class SpdMove2;
		class ILS;
		class WeaponAim;
		class Target;
		class TargetDistanceMissile;
		class TargetDistanceMGun;
		class Level0;
		class LevelP5;
		class LevelM5;
		class LevelP10;
		class LevelM10;
		class LevelP15;
		class LevelM15;
		class Velocity;
		class PlaneW;
	};
	class Draw
  	{
  		class Altitude;
  		class DimmedBase
  		{
  			class AltitudeBase;
  		};
  		class Speed;
  		class SpeedNumber;
  		class PlaneW
  		{
  			class LineHL;
  			class Velocity;
  		};
  		class MGun
  		{
  			class Circle;
  		};
  		class Missile
  		{
  			class Circle;
  			class Target;
  		};
  		class Horizont
  		{
  			class Dimmed
  			{
  				class Level0;
  			};
  			class LevelP5;
  			class LevelM5;
  			class LevelP10;
  			class LevelM10;
  			class LevelP15;
  			class LevelM15;
  		};
  		class ILS
  		{
  			class Glideslope
  			{
  				class ILS;
  			};
  			class AOABracket;
  		};
  	};
};
class CfgCoreData
{
	cobraLight = "ca\air\cobraSvetlo.p3d";
	marker = "ca\air\obrysove svetlo.p3d";
};

class CfgVehicles
{
	class AllVehicles;
	class Air: AllVehicles
	{
		class NewTurret;
		class ViewPilot;
	};
	class Plane : Air
	{
		type = 2;
		memoryPointGun = "kulomet";
		soundEngine[] = {"\ca\Air\Data\Sound\a10_eng22_1", db30, 0.8};
		soundEnviron[] = {"\ca\Air\Data\Sound\noise", db-30, 1.0};
		soundServo[] = {"\ca\Air\Data\Sound\gun_elevate", db-20, 0.4};
		soundDammage[] = {"\ca\Air\Data\Sound\alarm_loop1", db-40, 1};

		nameSound = "plane";
		getInAction=GetInHigh;
		getOutAction = GetOutHigh;
		class ViewPilot: ViewPilot
		{
			initFov=0.8; minFov=0.3; maxFov=1.2;
			initAngleX=10; minAngleX=-45; maxAngleX=+85;
			initAngleY=0; minAngleY=-150; maxAngleY=+150;
		};

		supplyRadius = 1.2;
		accuracy=0.02;
		camouflage=100;
		audible=40;

		class EventHandlers {};
		class HitHull {armor=1;material=50;name="telo";visual="trup";passThrough=1;};
		class MFD
		{
			class HUD: AirplaneHUD
			{
				borderLeft = 0.09;
				borderRight = 0.02;
				borderTop = 0.02;
				borderBottom = 0.1;
				class pos10vector: pos10vector {};
				class bones: bones
				{
					class AGLMove1;
					class AGLMove2;
					class ASLMove1;
					class ASLMove2;
					class VertSpeed;
					class SpdMove2;
					class ILS;
					class WeaponAim;
					class Target;
					class TargetDistanceMissile;
					class TargetDistanceMGun;
					class Level0;
					class LevelP5;
					class LevelM5;
					class LevelP10;
					class LevelM10;
					class LevelP15;
					class LevelM15;
					class Velocity;
					class PlaneW;
				};
				class Draw: Draw
				{
					class Altitude;
			  		class DimmedBase: DimmedBase
			  		{
			  			class AltitudeBase;
			  		};
			  		class Speed;
			  		class SpeedNumber;
			  		class PlaneW: PlaneW
			  		{
			  			class LineHL;
			  			class Velocity;
			  		};
			  		class MGun: MGun
			  		{
			  			class Circle;
			  		};
			  		class Missile: Missile
			  		{
			  			class Circle;
			  			class Target;
			  		};
			  		class Horizont: Horizont
		  		{
			  			class Dimmed: Dimmed
			  			{
			  				class Level0;
			  			};
			  			class LevelP5;
			  			class LevelM5;
			  			class LevelP10;
			  			class LevelM10;
			  			class LevelP15;
			  			class LevelM15;
			  		};
			  		class ILS: ILS
			  		{
			  			class Glideslope: Glideslope
			  			{
			  				class ILS;
			  			};
			  			class AOABracket;
			  		};
				};
			};
		};
	};
	class JSDF_Plane : Plane
	{
		side				= TWest;
		nameSound			="aircraft";
		vehicleClass			= JSDF_Air;
		memoryPointGun			="Gun";

//		weapons[]={BombLauncher,GAU12};
//		magazines[]={300Rnd_25mm_GAU12,6Rnd_GBU12_AV8B};

		class EventHandlers
		{
			init		="[_this select 0] exec ""\jsdf_scripts\_init\_unit.sqs""";
			fired		="[_this] exec ""\jsdf_scripts\_fired\_weapons.sqs"";[_this select 0] exec ""\jsdf_scripts\_fired\_unit.sqs""";
		};
	};
	class JMSDF_P3C : JSDF_Plane
	{

		scope				=public;
		crew				= SoldierWPilot;

		vehicleClass			= JMSDF_Air;
		displayName			= P-3C test;
		model				="\jmsdf_p3c\jmsdf_p3c.p3d";
		picture				="\ca\air\data\ico\av8b_CA.paa";
		Icon				="\ca\air\data\map_ico\icomap_AV8B_CA.paa";
		mapSize				= 10;
		accuracy			=0.30;
		cost				=20000000;
		typicalCargo[]			={SoldierWPilot};

		driverAction			= AV8B_Pilot;

  		irScanRangeMin			= 3500;
		laserScanner			= 0;


		armor				= 35;
		damageResistance		= 0.01246;
		armorStructured			= 1;

		gearRetracting			= 1;
		cabinOpening			= 1;
		flaps				= 1;
		airBrake			= 1;
		vtol				= 0;
		lightOnGear			= 1;

		maxSpeed			= 745;	// max speed on level road, km/h
		precision			= 200;
		brakeDistance			= 500;	// vehicle movement precision
		steerAheadSimul			= 1.0;
		steerAheadPlan			= 2.0;
		wheelSteeringSensitivity	= 1.0;
		gearUpTime			= 1.5;
		gearDownTime			= 1.5;
		aileronSensitivity		= 0.85;
		elevatorSensitivity		= 0.92;
		flapsFrictionCoef		= 0.6;
		envelope[]			= {0.0, 0.2, 1.2, 3.0, 5.1, 7.0, 7.3, 7.6, 7.8, 8.0, 8.0, 8.0, 8.0, 8.0, 7.8, 7.6, 7.3, 6.7, 5.0, 2.7, 1.6, 0.8, 0.5};
		landingAoa			= 10*3.1415/180;
		landingSpeed			= 300;
		ejectSpeed[]			= {0, 40, 0};
		ejectDamageLimit 		= 0.45;

/*
			0.0  0.1@0.2  0.3  0.4  0.5  0.6  0.7  0.8  0.9  1.0  1.1  1.2  1.3  1.4  1.5  1.6  1.7  1.8  1.9  2.0  2.1  2.2// rel. speed
			0.0, 0.2, 0.9, 2.1, 2.5, 3.3, 3.5, 3.2, 2.5, 2.0, 1.5, 1.0, 0.9, 0.7, 0.5 // default lift
			0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0
			0.0, 0.1, 0.5, 1.5, 3.1, 4.3, 4.9, 5.0, 4.4, 2.8, 1.6, 0.8, 0.0  // A-10
			0.0, 0.2, 1.2, 3.0, 5.1, 7.0, 7.3, 6.7, 5.0, 2.7, 1.6, 0.8, 0.0  // AV-8
			0.0, 0.2, 1.2, 3.0, 5.1, 7.0, 7.3, 7.6, 7.8, 8.0, 8.0, 8.0, 8.0, 8.0, 7.8, 7.6, 7.3, 6.7, 5.0, 2.7, 1.6, 0.8, 0.5  // F-15
*/


		weapons[]		={};
		magazines[]		={};
		gunAimDown		= 0.07;

		soundGetIn[]		={\ca\air\Data\Sound\heli_door1,db-20,1};
		soundGetOut[]		={\ca\air\Data\Sound\heli_door1,db-20,1};
		soundEngine[]		={"\ca\Air\Data\Sound\a10_eng22_1", db30, 0.8};
		insideSoundCoef		= 0.2;
		fov			= 0.5;

		type			=2;
		threat[]		={1, 1, 0.7};

		hiddenselections[]	={};

		dammageHalf[]=		{};
		dammageFull[]=		{};
		class Damage
		{
			tex[]={};
			mat[]={};
		};
		class Reflectors
		{
			class Left
			{
				color[] = {0.8, 0.8, 1.0, 1.0};
				ambient[] = {0.07, 0.07, 0.07, 1.0};
				position = "light_1_pos";
				direction = "light_1_dir";
				hitpoint = "L svetlo";
				selection = "L svetlo";
				size = 1;
				brightness = 1.0;
			};
		};
		class Library
		{
		  	libTextDesc = $STR_LIB_AV8B;
		};
	};
};
