/*
class WeaponFireGun;
class WeaponFireMGun;
class WeaponCloudsGun;
class WeaponCloudsMGun;
*/
class ViewGunner_JSDF_AV_base {};
class ViewOptics_JSDF_AV_base {};
class FDustEffects_none {};

class CfgPatches
{
	class JSDF_VLA_SUB
	{
		units[] = {"JGSDF_VLA_SUB"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {};
	};
};
class CfgVehicles
{
	class Land;
	class LandVehicle 			: Land
	{
		class NewTurret;
		class ViewPilot;
		class Sounds;
	};
	class JSDF_VLA	 			: LandVehicle
	{
		class Turrets			{class MainTurret;};
		class FGunner;
		class MGunner;
		class Commander;
		class ViewPilot;
		class AnimationSources;
		
		class Sounds : Sounds
		{
			class Engine;
			class Movement;
		};
		class HitPoints
		{
			class HitHull;
			class HitEngine;
			class HitLTrack;
			class HitRTrack;
		};
	};
	class JSDF_VLA_SUB_Base		 	: JSDF_VLA
	{
		faction 			= JGSDF;
		displayName 			= Type73 APC;
		model 				= "\jsdf_vla\sub\JGSDF_Type73APC_0";
		icon 				= "\jsdf_vla\sub\icomap_t73APC_ca.paa";
		picture 			= "\jsdf_vla\sub\ico_t73APC_ca.paa";
		mapSize 			= 9;
		accuracy 			= 0.7;
		threat[] 			= {1, 1, 0.3};
		armor 				= 210;
		damageResistance 		= 0.01168;
		cost 				= 4000000;

		irScanRangeMin			= 0;
		irScanRangeMax			= 0;

		maxSpeed 			= 60;
		transportSoldier 		= 9;

		tracksSpeed 			= 2.5;
		wheelCircumference 		= 2.0;
//		hiddenSelections[] 		= {"Camo1", "Camo2"};
//		hiddenSelectionsTextures[] 	= {"\ca\tracked2\aav\data\aav_ext_co.paa", "\ca\tracked2\aav\data\aav_ext2_co.paa"};

		forceHideDriver			= 0;
		driverForceOptics 		= 0;
		driverAction 			= "BMP3_Driver_OUT";
		driverInAction 			= "BMP3_Driver";
//		proxyType			= CPGunner;
//		proxyIndex			= 1;

		class Turrets: Turrets
		{
			class FGunner				: FGunner
			{
				minElev=-10; maxElev=+10; initElev=0;
				minTurn=-30; maxTurn=+30; initTurn=0;

				weapons[]			= {JSDF_MG_M1919_veh};
				magazines[]			= {250Rnd_7_62x63, 250Rnd_7_62x63, 250Rnd_7_62x63, 250Rnd_7_62x63, 250Rnd_7_62x63, 250Rnd_7_62x63};//250*6

				gunnerAction			= T72_GunnerOut;
				gunnerInAction			= T72_Gunner;
				gunnerOpticsModel		="\ca\Tracked\optika_M1A1_commander";
				memoryPointGunnerOptics		="hatchF_view";
			};
			class MGunner				: MGunner
			{
				memoryPointGun			="mgturret_gun_pos";
				gunBeg				="mgturret_gun_pos";
				gunEnd				="mgturret_gun_pos_dir";

				weapons[]			= {JSDF_MG_M2};
				magazines[]			= {100Rnd_127x99_M2,100Rnd_127x99_M2,100Rnd_127x99_M2,100Rnd_127x99_M2};//105*8

				gunnerAction			= BMP2_GunnerOut;
				gunnerInAction			= BMP2_Gunner;
				gunnerOpticsModel		="\ca\Tracked\optika_M1A1_commander";

				inGunnerMayFire			= 1;
			};
			class Commander				: Commander
			{
				minElev=  -4; 	maxElev= +20; 	initElev=0;
				minTurn=-360; 	maxTurn=+360; 	initTurn=0;

				gunnerAction			= T72_CommanderOut;
				gunnerInAction			= T72_Commander;
				gunnerOpticsModel		="\ca\Tracked\optika_tank_driver";
			};
		};
		class Sounds_t73APC 	: Sounds
		{
			class Engine
			{
				sound[] = {"\jsdf_vla\sub\JSDF_t60AV_eng.wss", 1.77828, 1.0, 1000};
				frequency = "(randomizer*0.05+0.8)*rpm";
				volume = "engineOn*camPos*(rpm factor[0.4, 0.9])";
			};
		};
		class Damage
		{
			tex[] = {};
			mat[] = {"ca\tracked2\aav\data\aav_ext.rvmat", "ca\tracked2\aav\data\aav_ext_damage.rvmat", "ca\tracked2\aav\data\aav_ext_destruct.rvmat", "ca\tracked2\aav\data\aav_ext2.rvmat", "ca\tracked2\aav\data\aav_ext2_damage.rvmat", "ca\tracked2\aav\data\aav_ext2_destruct.rvmat", "ca\tracked2\aav\data\aav_tracks.rvmat", "ca\tracked2\aav\data\aav_tracks_damage.rvmat", "ca\tracked2\aav\data\aav_tracks_destruct.rvmat"};
		};
		
		class Library
		{
			libTextDesc = $STR_LIB_AAVP7A1;
		};
	};
	class JGSDF_Type73APC_0			: JSDF_VLA_SUB_Base
	{
		scope 				= 2;
		displayName 			= Type73 APC;
//		model 				= "\jsdf_vla\sub\JGSDF_Type73APC_0";
		model 				= "\jsdf_vla\su\JGSDF_Type60APC_0";
	};
	class JGSDF_Type73APC_A			: JSDF_VLA_SUB_Base
	{
		scope 				= 2;
		displayName 			= Type73 APC(New);
		model 				= "\jsdf_vla\sub\JGSDF_Type73APC_0";
		class Turrets: Turrets
		{
			class MGunner				: MGunner{};
			class FGunner				: FGunner
			{
				weapons[]			= {JSDF_MG_M1919_veh};
				magazines[]			= {250Rnd_7_62x63, 250Rnd_7_62x63, 250Rnd_7_62x63, 250Rnd_7_62x63, 250Rnd_7_62x63, 250Rnd_7_62x63};//250*6
			};
			class Commander				: Commander{};
		};
	};
};
