/*
class WeaponFireGun;
class WeaponFireMGun;
class WeaponCloudsGun;
class WeaponCloudsMGun;
*/
class ViewGunner_JSDF_AV_base {};
class ViewOptics_JSDF_AV_base {};
class FDustEffects_none {};

class CfgPatches
{
	class JSDF_VLA_SU
	{
		units[] = {"JGSDF_VLA_SU"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {};
	};
};
class CfgVehicles
{
	class Land;
	class LandVehicle 			: Land
	{
		class NewTurret;
		class ViewPilot;
		class Sounds;
	};
	class JSDF_VLA	 			: LandVehicle
	{
		class Turrets			{class MainTurret;};
		class NewTurret;
		class ViewPilot;
		class AnimationSources;
		
		class Sounds : Sounds
		{
			class Engine;
			class Movement;
		};
		class HitPoints
		{
			class HitHull;
			class HitEngine;
			class HitLTrack;
			class HitRTrack;
		};
/*
		class Turrets;			// External class reference
		class NewTurret;		// External class reference
		class MainTurret;		// External class reference
		class ViewOptics;		// External class reference
		class CommanderOptics;		// External class reference
		class HitPoints;		// External class reference
		class AnimationSources;		// External class reference
		class Sounds;			// External class reference
*/
	};
	class JSDF_VLA_SU_Base		 	: JSDF_VLA
	{
		faction 			= JGSDF;
		displayName 			= Type60 APC;
		model 				= "\jsdf_vla\su\JGSDF_Type60APC_0";
		icon 				= "\jsdf_vla\su\icomap_t60APC_ca.paa";
		picture 			= "\jsdf_vla\su\ico_t60APC_ca.paa";
		mapSize 			= 9;
		accuracy 			= 0.7;
		threat[] 			= {1, 1, 0.3};
		armor 				= 210;
		damageResistance 		= 0.01168;
		cost 				= 4000000;

		irScanRangeMin			= 0;
		irScanRangeMax			= 0;

		maxSpeed 			= 40;
		transportSoldier 		= 7;

		tracksSpeed 			= 2.8;
		wheelCircumference 		= 2.0;
//		hiddenSelections[] 		= {"Camo1", "Camo2"};
//		hiddenSelectionsTextures[] 	= {"\ca\tracked2\aav\data\aav_ext_co.paa", "\ca\tracked2\aav\data\aav_ext2_co.paa"};

		forceHideDriver			= 0;
		driverForceOptics 		= 0;
		driverAction 			= "BMP3_Driver_OUT";
		driverInAction 			= "BMP3_Driver";
//		proxyType			= CPGunner;
//		proxyIndex			= 1;

		class Turrets: Turrets
		{
			class MGunGunner			: NewTurret
			{
				proxyType			= CPGunner;
				proxyIndex			= 1;
				gunnerName			= gunner;
				primaryGunner			= 1;
				primaryObserver			= 0;

				body				="mgturret";
				gun				="mgturret_gun";
//				memoryPointGun			="mgturret_gun_pos";
				gunBeg				="mgturret_gun_beg";
				gunEnd				="mgturret_gun_end";
				selectionFireAnim		="mgturret_gun_fir";

				animationSourceBody		="mgturret";
				animationSourceGun		="mgturret_gun";
				animationSourceHatch		="mgturret_Hatch";

				minElev= -11;	maxElev= +55; 	initElev=0;
				minTurn=-360;	maxTurn=+360; 	initTurn=0;

				weapons[]			= {JSDF_MG_M2};
				magazines[]			= {100Rnd_127x99_M2,100Rnd_127x99_M2,100Rnd_127x99_M2,100Rnd_127x99_M2};//105*8
				startEngine			= 0;

				stabilizedInAxes 		= 0;
				lockWhenDriverOut		= 0;
				outGunnerMayFire		= 1;
				inGunnerMayFire			= 0;
				forceHideGunner			= 0;
				viewGunnerInExternal		= 1;

				gunnerForceOptics		= 0;
				gunnerAction			= BMP2_GunnerOut;
				gunnerInAction			= BMP2_Gunner;
				gunnerOpticsModel		="\ca\Tracked\optika_M1A1_commander";
				memoryPointsGetInGunner		="cargo_pos";
				memoryPointsGetInGunnerDir	="cargo_pos_dir";

				memoryPointGunnerOptics		="Gunnerview";
				memoryPointGunnerOutOptics 	="Gunnerview";
				class ViewOptics		: ViewOptics_JSDF_AV_base {};
				class ViewGunner		: ViewGunner_JSDF_AV_base {};
			};
			class FrontGunner			: NewTurret
			{
				canHideGunner 			= 1;
				proxyType			= CPGunner;
				proxyIndex			= 2;
				gunnerName			= FrontGunner;
				primaryGunner			= 2;
				primaryObserver			= 1;

				body				="turretF";
				gun				="turretF_gun";
				memoryPointGun			="turretF_gun";
				gunBeg				="turretF_gun_beg";
				gunEnd				="turretF_gun_end";
				selectionFireAnim		="turretF_gun_fir";
				animationSourceBody		="FrontGunner_Turret";
				animationSourceGun		="FrontGunner_Gun";
				animationSourceHatch		="FrontGunner_Hatch";

				minElev=-10; maxElev=+10; initElev=0;
				minTurn=-30; maxTurn=+30; initTurn=0;

				weapons[]			= {JSDF_MG_M1919_veh};
				magazines[]			= {250Rnd_7_62x63, 250Rnd_7_62x63, 250Rnd_7_62x63, 250Rnd_7_62x63, 250Rnd_7_62x63, 250Rnd_7_62x63};//250*6
				startEngine			= 0;
				stabilizedInAxes 		= 0;
				lockWhenDriverOut		= 0;

				commanding			= 0;
				outGunnerMayFire		= 1;
				inGunnerMayFire			= 1;
				forceHideGunner			= 0;
				viewGunnerInExternal		= 1;
				gunnerForceOptics		= 0;

				gunnerAction			= T72_GunnerOut;
				gunnerInAction			= T72_Gunner;
				gunnerOpticsModel		="\ca\Tracked\optika_M1A1_commander";
				memoryPointGunnerOptics		="hatchF_view";
				memoryPointGunnerOutOptics 	= "";
				memoryPointsGetInGunner		="FrontGunner_pos";
				memoryPointsGetInGunnerDir	="FrontGunner_pos_dir";
				class ViewOptics		: ViewOptics_JSDF_AV_base {};
				class ViewGunner		: ViewGunner_JSDF_AV_base {};
			};
			class CommanderOptics			: NewTurret
			{
				proxyType			= CPCommander;
				proxyIndex			= 1;
				gunnerName			= commander;
				primaryGunner			= 0;
				primaryObserver			= 1;

				body				="";
				gun				="";
				animationSourceBody		="";
				animationSourceGun		="";
				animationSourceHatch		="hatchCommander";

				soundServo[]			={"", db-50, 1.0};
				startEngine			= 0;

				gunBeg				="";
				gunEnd				="";

				minElev=-4; maxElev=+20; initElev=0;
				minTurn=-360; maxTurn=+360; initTurn=0;

				commanding			= 2;
				outGunnerMayFire		= 1;
				inGunnerMayFire			= 1;
				viewGunnerInExternal		= 1;

				gunnerAction			= T72_CommanderOut;
				gunnerInAction			= T72_Commander;
				gunnerOpticsModel		="\ca\Tracked\optika_M1A1_commander";
				gunnerOutOpticsModel		= \ca\Weapons\optika_empty;
				gunnerOutOpticsColor[]		= {0, 0, 0, 1};
				gunnerOutForceOptics		= 0;
				gunnerOutOpticsShowCursor 	= 0;
				memoryPointGunnerOutOptics	="commander_view_out";
				memoryPointGunnerOptics		="commander_view";
				memoryPointsGetInGunner		="commander_pos";
				memoryPointsGetInGunnerDir	="commander_pos_dir";
				memoryPointGun			="";
				selectionFireAnim		="";
				class ViewOptics		: ViewOptics_JSDF_AV_base {};
				class ViewGunner		: ViewGunner_JSDF_AV_base {};
			};
		};
		class Sounds_t60APC 	: Sounds
		{
			class Engine
			{
				sound[] = {"\jsdf_vla\su\JSDF_t60AV_eng.wss", 1.77828, 1.0, 1000};
				frequency = "(randomizer*0.05+0.8)*rpm";
				volume = "engineOn*camPos*(rpm factor[0.4, 0.9])";
			};
		};
		class Damage
		{
			tex[] = {};
			mat[] = {"ca\tracked2\aav\data\aav_ext.rvmat", "ca\tracked2\aav\data\aav_ext_damage.rvmat", "ca\tracked2\aav\data\aav_ext_destruct.rvmat", "ca\tracked2\aav\data\aav_ext2.rvmat", "ca\tracked2\aav\data\aav_ext2_damage.rvmat", "ca\tracked2\aav\data\aav_ext2_destruct.rvmat", "ca\tracked2\aav\data\aav_tracks.rvmat", "ca\tracked2\aav\data\aav_tracks_damage.rvmat", "ca\tracked2\aav\data\aav_tracks_destruct.rvmat"};
		};
		
		class Library
		{
			libTextDesc = $STR_LIB_AAVP7A1;
		};
	};
	class JGSDF_Type60APC			: JSDF_VLA_SU_Base
	{
		scope 				= 2;
		displayName 			=0 Type60;
		model 				= "\jsdf_vla\su\JGSDF_Type60SU";
		class Turrets: Turrets
		{
			class MGunGunner			: MGunGunner {};
			class FrontGunner			: FrontGunner
			{
				animationSourceBody		="FrontGunner_Turret";
				animationSourceGun		="FrontGunner_Gun";
				animationSourceHatch		="FrontGunner_Hatch";

				body				="turretF";
				gun				="FGun";
				gunBeg				="FGun_beg";
				gunEnd				="FGun_end";
				selectionFireAnim		="FGun_zasleh";

				memoryPointGunnerOptics		="hatchF_view";
			};
			class CommanderOptics			: CommanderOptics {};
		};
	};
	class JGSDF_Type60APC_0			: JSDF_VLA_SU_Base
	{
		scope 				= 2;
		displayName 			= Type60 APC;
		model 				= "\jsdf_vla\su\JGSDF_Type60APC_0";
	};
};
