class CfgPatches
{
	class JSDF_VLA_STA
	{
		units[] = {"JGSDF_VLA_STA"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {};
	};
};
class CfgVehicles
{
	class Land;
	class LandVehicle 			: Land
	{
		class NewTurret;
		class ViewPilot;
		class Sounds;
	};
	class JSDF_VLA	 			: LandVehicle
	{
		class Turrets			{class MainTurret;};
		class NewTurret;
		class ViewPilot;
		class CommanderOptics;
		class LoaderOptics;
		class AnimationSources;
		
		class Sounds : Sounds
		{
			class Engine;
			class Movement;
		};
		class HitPoints
		{
			class HitHull;
			class HitEngine;
			class HitLTrack;
			class HitRTrack;
		};
	};
	class JSDF_VLA_STA_Base			: JSDF_VLA
	{
		scope 				= 2;
		faction 			= JGSDF;
		displayName 			= "Type61 TK";
		model 				= "\JSDF_VLA\STA\JGSDF_Type61TK";
		picture 			= "\ca\tracked2\Data\UI\Picture_t34_CA.paa";
		Icon 				= "\ca\tracked2\Data\UI\Icon_t34_CA.paa";
		mapSize 			= 7;

		driverForceOptics 		= 1;
		driverAction 			= "T90_Driver";
		driverInAction 			= "T90_Driver";

		tracksSpeed 			= 1.0;
		wheelCircumference 		= 2.563;

		maxSpeed 			= 45;
		accuracy 			= 0.8;
		armor 				= 300;
		damageResistance 		= 0.01011;
		cost 				= 1500000;
		
		class HitPoints : HitPoints
		{
			class HitHull	{armor = 0.85;	material = -1;	name = "telo";	visual= "telo";		passThrough 	= 1;	};
		};

//		typicalCargo[] = {"GUE_Soldier_1", "GUE_Soldier_1", "GUE_Soldier_1"};

		class Turrets : Turrets
		{
			class MainTurret : MainTurret
			{
				maxHorizontalRotSpeed		= 0.8;
				maxVerticalRotSpeed		= 0.6;
				minElev				=-8;
				maxElev				=+13;
				soundServo[]			={\ca\Weapons\Data\Sound\gun_elevate,db-50,1.0};
				gunnerAction			= Abrams_Gunner;
				gunnerInAction			= Abrams_Gunner;
				gunnerOpticsModel		="\ca\Tracked\optika_tank_gunner";

				stabilizedInAxes 		= 0;
				forceHideGunner			= 1;

				weapons[]			={JSDF_W_TKG_Type61,JSDF_MG_M1919_coax};
				magazines[]			=
				{
				JSDF_M_TKG_90mm_M318A1_AP_T,	JSDF_M_TKG_90mm_M318A1_AP_T,	JSDF_M_TKG_90mm_M318A1_AP_T,	JSDF_M_TKG_90mm_M318A1_AP_T,	JSDF_M_TKG_90mm_M318A1_AP_T,	JSDF_M_TKG_90mm_M318A1_AP_T,
				JSDF_M_TKG_90mm_M318A1_AP_T,	JSDF_M_TKG_90mm_M318A1_AP_T,	JSDF_M_TKG_90mm_M318A1_AP_T,	JSDF_M_TKG_90mm_M318A1_AP_T,	JSDF_M_TKG_90mm_M318A1_AP_T,	JSDF_M_TKG_90mm_M318A1_AP_T,
				JSDF_M_TKG_90mm_Type70_HEAT_T,	JSDF_M_TKG_90mm_Type70_HEAT_T,	JSDF_M_TKG_90mm_Type70_HEAT_T,	JSDF_M_TKG_90mm_Type70_HEAT_T,	JSDF_M_TKG_90mm_Type70_HEAT_T,	JSDF_M_TKG_90mm_Type70_HEAT_T,
				JSDF_M_TKG_90mm_Type70_HEAT_T,	JSDF_M_TKG_90mm_Type70_HEAT_T,	JSDF_M_TKG_90mm_Type70_HEAT_T,	JSDF_M_TKG_90mm_Type70_HEAT_T,	JSDF_M_TKG_90mm_Type70_HEAT_T,	JSDF_M_TKG_90mm_Type70_HEAT_T,
				4000Rnd_7_62x63
				};
				class Turrets			: Turrets
				{
					class CommanderOptics 		: NewTurret
					{
						memoryPointGunnerOptics	="turretC_view";
						turretAxis		="turretC";
						body			="turretC";
						gunAxis			="turretC_gun";
						gun			="turretC_gun";
						gunnerAction		= Abrams_CommanderOut;
						gunnerInAction		= Abrams_Commander;
						gunnerOpticsModel	="\ca\Tracked\optika_M1A1_commander";

						outGunnerMayFire	= 1;
						inGunnerMayFire		= 1;

						minElev=-11;	maxElev=+55;	initElev=0;
						minTurn=-360;	maxTurn=+360;	initTurn=0;

						gunBeg			="turretC_gun_beg";
						gunEnd			="turretC_gun_end";
						weapons[]		= {M2};
						magazines[]		= {100Rnd_127x99_M2,100Rnd_127x99_M2,100Rnd_127x99_M2,100Rnd_127x99_M2};
					};
					class LoaderOptics 		: LoaderOptics
					{
						gunnerAction		= Abrams_CommanderOut;
						gunnerInAction		= Abrams_Commander;
					};
				};
			};
		};
		type = 1;
		threat[] = {0.4, 0.4, 0.0};
		
		class AnimationSources
		{
			class mainGun_recoil
			{
				source		="user";
				animPeriod 	=0.75;
				initPhase	=0.01;
			};
			class coaxGun_recoil
			{
				source		="reload";
				weapon		="M1919_coax";
			};
			class obsGun_recoil
			{
				source		="reload";
				weapon		="M2";
			};
			class belt_rotation
			{
				source		="reload";
				weapon		="M2";
			};
		};
		class Damage {
			tex[] = {};
			mat[] = {};
		};
	};
};
