class WeaponFireMGun;
class Coaxial_FireMGun		: WeaponFireMGun
{
	cloudletDuration	= 0;
	cloudletAlpha		= 0.75;
	cloudletGrowUp		= 0.06;
	cloudletFadeIn		= 0;
	cloudletFadeOut		= 0.1;
	interval		= 0.05;
	size			= 2;
	sourceSize		= 0.01;
	timeToLive		= 0;
	initT			= 30;
	deltaT			=-30;
};
class WeaponCloudsMGun;
class Coaxial_CloudsMGun	: WeaponCloudsMGun
{
	access			= ReadAndWrite;
	cloudletGrowUp		= 0.05;	///0.05// grow-up time
	cloudletFadeIn		= 0;	///0// fade-in time
	cloudletFadeOut		= 4.1;	///0.1// fade-out time
	cloudletDuration	= 5.0;	///0.05// time to live (not including fades)
	cloudletAlpha		= 0.3;
	cloudletAccY		= 0;	// vertical acceleration
	cloudletMinYSpeed	=-10;	// vertical speed range
	cloudletMaxYSpeed	= 10;
	interval		= 0.2;  ///0.02
	size			= 1.3;	///0.3
	sourceSize		= 0.7;	///0.02
};
class ViewOptics_JSDF_AV_base
{
	initAngleX=0;	minAngleX=-30;	maxAngleX=+30;
	initAngleY=0;	minAngleY=-100;	maxAngleY=+100;
	initFov=0.42;	minFov=0.22;	maxFov=0.64;
};
class ViewGunner_JSDF_AV_base
{
	initAngleX=5;	minAngleX=-30;	maxAngleX=+30;
	initAngleY=0;	minAngleY=0;	maxAngleY=0;
	initFov=0.42;	minFov=0.22;	maxFov=0.64;
};
class CfgVehicles
{
	class Land;
	class LandVehicle : Land
	{
		class NewTurret;
		class ViewPilot;
		class ViewOptics;
		class Sounds;
	};
	class JSDF_VLA	 			: LandVehicle
	{
		scope 				= 0;
		side 				= 1;
		faction 			= JSDF;
		vehicleClass 			= "Armored";
		icon 				= "iconTank";
		displayName 			= $STR_DN_TANK;
		nameSound 			= "tank";
		simulation 			= "tank";
		type 				= VArmor;
		threat[] 			= {0.7, 1, 0.3};
		cost 				= 1000000;
		accuracy 			= 0.12;

		armor 				= 400;
		armorStructural 		= 2.0;
		
		class HitPoints
		{
			class HitEngine 	{armor = 0.35;	material = -1;	name = "motor";		visual = "motor";	passThrough = 0.2;	};
			class HitHull 		{armor = 1;	material = -1;	name = "NEtelo";	visual = "telo";	passThrough = 1;	};
			class HitLTrack 	{armor = 0.15;	material = -1;	name = "pas_L";		visual = "pas_L";	passThrough = 0.3;	};
			class HitRTrack 	{armor = 0.15;	material = -1;	name = "pas_P";		visual = "pas_P";	passThrough = 0.3;	};
		};
/*
		class HitEngine			{armor = 0.8;	material = 60;	name = "engine";	visual = "engine";	passThrough = 0;	};
		class HitHull			{armor = 1;	material = 50;	name = "hull";		visual = "hull";	passThrough = 0;	};
		class HitLTrack			{armor = 0.6;	material = 53;	name = "pasL";		visual = "pasL";	passThrough = 0;	};
		class HitRTrack			{armor = 0.6;	material = 54;	name = "pasP";		visual = "pasP";	passThrough = 0;	};
*/
		selectionLeftOffset 		= "Crawler_L";
		selectionRightOffset 		= "Crawler_R";
		selectionFireAnim 		= "muzzleflash";
		selectionRotorStill 		= "Rotor_Static";
		selectionRotorMove 		= "Rotor_Blurred";
		selectionBackLights 		= "light";
		selectionBrakeLights 		= "light_stop";
		selectionDashboard 		= "light_panel";

		memoryPointCargoLight 		= "light_cargo";

		memoryPointsGetInDriver 	= "driver_pos";
		memoryPointsGetInDriverDir 	= "driver_pos_dir";
		memoryPointsGetInCoDriver 	= "codriver_pos";
		memoryPointsGetInCoDriverDir 	= "codriver_pos_dir";
		memoryPointsGetInGunner 	= "gunner_pos";
		memoryPointsGetInGunnerDir 	= "gunner_pos_dir";
		memoryPointsGetInCargo	 	= "cargo_pos";
		memoryPointsGetInCargoDir	= "cargo_pos_dir";
//		memoryPointsGetInCargo[] 	= {"codriver_pos", 	"cargo_pos"};
//		memoryPointsGetInCargoDir[] 	= {"codriver_pos_dir", 	"cargo_pos_dir"};
		initCargoAngleY 		= 185;

		memoryPointDriverOptics[] 	= {"driver_view","driverview", "pilot"};
		memoryPointGunnerOptics 	= "gunnerview";
		memoryPointGun 			= "gun_pos";
		memoryPointMissile[] 		= {"Missile_pos",	"Rocket_pos"};
		memoryPointMissileDir[] 	= {"Missile_pos_dir",	"Rocket_pos_dir"};
		memoryPointLMissile 		= "Missile_L_pos";
		memoryPointRMissile 		= "Missile_R_pos";
		memoryPointLRocket 		= "Rocket_L_pos";
		memoryPointRRocket 		= "Rocket_R_pos";

		memoryPointTrack1L 		= "Track_FL";
		memoryPointTrack1R 		= "Track_FR";
		memoryPointTrack2L 		= "Track_BL";
		memoryPointTrack2R 		= "Track_BR";
		memoryPointTrackFLL 		= "Track_FLL";
		memoryPointTrackFLR 		= "Track_FLR";
		memoryPointTrackFRL 		= "Track_FRL";
		memoryPointTrackFRR 		= "Track_FRR";
		memoryPointTrackBLL 		= "Track_BLL";
		memoryPointTrackBLR 		= "Track_BLR";
		memoryPointTrackBRL 		= "Track_BRL";
		memoryPointTrackBRR 		= "Track_BRR";

		leftDustEffect 			= "LDustEffects";
		rightDustEffect 		= "RDustEffects";
		leftWaterEffect 		= "LWaterEffects";
		rightWaterEffect 		= "RWaterEffects";

		bounding 			= "turret_gun_pos_dir";
		fireDustEffect 			= "FDustEffects";
		gearBox[] 			= {-7, 0, 11, 8, 5.7, 4.2};
		alphaTracks 			= 0.7;
		textureTrackWheel 		= false;
		camouflage 			= 8;
		audible 			= 6;

		sensitivityEar 			= 0.0075 /3;

		canFloat 			= false;
		precision 			= 5;
		brakeDistance 			= 15;
		maxSpeed 			= 80;
		steerAheadSimul 		= 0.4;
		steerAheadPlan 			= 0.6;
		predictTurnSimul 		= 1.2;
		predictTurnPlan 		= 1.8;
		occludeSoundsWhenIn 		= 0.01;
		obstructSoundsWhenIn 		= 0.177828;

		crew 				= "USMC_Soldier_Crew";
		crewVulnerable 			= false;
		hideProxyInCombat 		= true;
		getInRadius 			= 3.5;
		getInAction 			= "GetInMedium";
		getOutAction 			= "GetOutMedium";
		hasGunner 			= 0;
		hasCommander 			= 0;
		gunnerCanSee 			= 30;
		commanderCanSee 		= 31;
		commanderUsesPilotView 		= 1;

		viewDriverShadow 		= 1;
		viewDriverShadowDiff 		= 0.05;
		viewGunnerShadow 		= 1;
		viewGunnerShadowDiff 		= 0.05;
		viewCargoShadow 		= 1;
		viewCargoShadowDiff 		= 0.05;

		driverOpticsModel 		= "\ca\Tracked\optika_tank_driver";
		driverOpticsColor[] 		= {1, 1, 1, 1};
		driverAction 			= "";
		driverInAction 			= "";
		animationSourceHatch 		= "DriverHatch";

		cargoGetInAction[] 		= {"GetInLow"};
		cargoGetOutAction[] 		= {"GetOutLow"};

		transportMaxMagazines 		= 100;
		transportMaxWeapons 		= 10;
		enableGPS 			= 1;
		nightVision 			= 0;
		weapons[] 			= {"FakeWeapon"};
		magazines[] 			= {"FakeWeapon"};

		smokeLauncherGrenadeCount 	= 6;
		smokeLauncherVelocity 		= 15;
		smokeLauncherOnTurret 		= 1;
		smokeLauncherAngle 		= 120;

		supplyRadius 			= 1.5;
		fuelCapacity 			= 700;
		irScanToEyeFactor 		= 1;
		irScanRangeMin 			= 500;
		irScanRangeMax 			= 4000;

		formationX 			= 20;
		formationZ 			= 30;

		extCameraPosition[] 		= {0, 1.5, -9};
		class ViewPilot : ViewPilot
		{
			initAngleX = 7;		minAngleX = -15;	maxAngleX = 25;
			initAngleY = 0;		minAngleY = -90;	maxAngleY = 90;
		};
		class ViewOptics : ViewOptics
		{
			initAngleX = 0;		minAngleX = -30;	maxAngleX = 30;
			initAngleY = 0;		minAngleY = -100;	maxAngleY = 100;
			initFov = 0.466;	minFov = 0.466;		maxFov = 0.466;
		};
		class Turrets
		{
			class FGunner				: NewTurret
			{
				animationSourceBody		="FGunner_Turret";
				animationSourceGun		="FGunner_Gun";
				animationSourceHatch		="FGunner_Hatch";

				body				="turretF";
				gun				="turretF_gun";
				gunBeg				="turretF_gun_beg";
				gunEnd				="turretF_gun_end";
				selectionFireAnim		="turretF_gun_fir";
				memoryPointGun			="turretF_gun_pos";
				memoryPointGunnerOptics		="FGunner_view";
				memoryPointsGetInGunner		="FGunner_pos";
				memoryPointsGetInGunnerDir	="FGunner_pos_dir";

				minElev=-10; maxElev=+10; initElev=0;
				minTurn=-30; maxTurn=+30; initTurn=0;

				weapons[]			= {JSDF_MG_M1919_veh};
				magazines[]			= {250Rnd_7_62x63, 250Rnd_7_62x63, 250Rnd_7_62x63, 250Rnd_7_62x63, 250Rnd_7_62x63, 250Rnd_7_62x63};//250*6
				startEngine			= 0;
				stabilizedInAxes 		= 0;
				lockWhenDriverOut		= 0;

				gunnerName			= FrontGunner;
				gunnerAction			= T72_GunnerOut;
				gunnerInAction			= T72_Gunner;
				gunnerGetInAction 		="GetInMedium";
				gunnerGetOutAction 		="GetOutMedium";
				commanding			= 0;
				primaryGunner			= 0;
				primaryObserver			= 0;
				proxyType			= CPGunner;
				proxyIndex			= 2;
				canHideGunner 			= 1;
				outGunnerMayFire		= 1;
				inGunnerMayFire			= 1;
				forceHideGunner			= 0;
				viewGunnerInExternal		= 1;
				gunnerForceOptics		= 0;
				gunnerOpticsModel		="\ca\Tracked\optika_M1A1_commander";
				class ViewOptics		: ViewOptics_JSDF_AV_base {};
				class ViewGunner		: ViewGunner_JSDF_AV_base {};
			};
			class MGunner				: NewTurret
			{
				animationSourceBody		="MGunner_Turret";
				animationSourceGun		="MGunner_Gun";
				animationSourceHatch		="MGunner_Hatch";

				body				="mgturret";
				gun				="mgturret_gun";
				gunBeg				="mgturret_gun_beg";
				gunEnd				="mgturret_gun_end";
				selectionFireAnim		="mgturret_gun_fir";
				memoryPointGun			="mgturret_gun_pos";
				memoryPointGunnerOptics		="MGunner_view";
				memoryPointsGetInGunner		="MGunner_pos";
				memoryPointsGetInGunnerDir	="MGunner_pos_dir";

				minElev= -11;	maxElev= +55; 	initElev=0;
				minTurn=-360;	maxTurn=+360; 	initTurn=0;

				weapons[]			= {JSDF_MG_M2};
				magazines[]			= {100Rnd_127x99_M2,100Rnd_127x99_M2,100Rnd_127x99_M2,100Rnd_127x99_M2};//105*8
				startEngine			= 0;
				stabilizedInAxes 		= 0;

				gunnerName			= MG gunner;
				gunnerAction			= BMP2_GunnerOut;
				gunnerInAction			= BMP2_Gunner;
				gunnerGetInAction 		="GetInMedium";
				gunnerGetOutAction 		="GetOutMedium";
				proxyType			= CPGunner;
				proxyIndex			= 1;
				primaryGunner			= 0;
				primaryObserver			= 0;
				lockWhenDriverOut		= 0;
				outGunnerMayFire		= 1;
				inGunnerMayFire			= 0;
				forceHideGunner			= 0;
				viewGunnerInExternal		= 1;
				gunnerForceOptics		= 0;
				gunnerOpticsModel		="\ca\Tracked\optika_M1A1_commander";
				class ViewOptics		: ViewOptics_JSDF_AV_base {};
				class ViewGunner		: ViewGunner_JSDF_AV_base {};
			};
			class Commander				: NewTurret
			{
				animationSourceBody		="Commander_Turret";
				animationSourceGun		="Commander_Gun";
				animationSourceHatch		="Commander_Hatch";

				commanding			= 2;
				proxyType			= CPCommander;
				proxyIndex			= 1;
				primaryGunner			= 0;
				primaryObserver			= 1;

				body				="";
				gun				="";
				gunBeg				="";
				gunEnd				="";
				minElev=  -4; 	maxElev= +20; 	initElev=0;
				minTurn=-360; 	maxTurn=+360; 	initTurn=0;
				soundServo[]			={"", db-50, 1.0};
				startEngine			= 0;

				outGunnerMayFire		= 1;
				inGunnerMayFire			= 1;
				viewGunnerInExternal		= 1;

				gunnerName			= commander;
				gunnerAction			= T72_CommanderOut;
				gunnerInAction			= T72_Commander;
				gunnerOpticsModel		="\ca\Tracked\optika_tank_driver";
				gunnerOutOpticsModel		= \ca\Weapons\optika_empty;
				gunnerOutOpticsColor[]		= {0, 0, 0, 1};
				gunnerOutForceOptics		= 0;
				gunnerOutOpticsShowCursor 	= 0;
				memoryPointGun			="";
				memoryPointGunnerOutOptics	="commander_view_out";
				memoryPointGunnerOptics		="commander_view";
				memoryPointsGetInGunner		="commander_pos";
				memoryPointsGetInGunnerDir	="commander_pos_dir";
				selectionFireAnim		="";
				class ViewOptics		: ViewOptics_JSDF_AV_base {};
				class ViewGunner		: ViewGunner_JSDF_AV_base {};
			};
			class MainTurret 			: NewTurret
			{
				animationSourceBody 		= "MainTurret";
				animationSourceGun 		= "MainGun";
				animationSourceHatch 		= "GunnerHatch";

				memoryPointGun			= "turret_gun_coaxgun";
				memoryPointGunnerOptics		= "turret_view";
				memoryPointGunnerOutOptics 	= "turret_view_out";
				memoryPointsGetInGunner 	= "gunner_pos";
				memoryPointsGetInGunnerDir 	= "gunner_pos_dir";
				gunnerAction 			= "ManActTestDriverOut";
				gunnerGetInAction 		= "GetInHigh";
				gunnerGetOutAction 		= "GetOutHigh";
				gunnerOpticsModel 		= "\ca\Tracked\optika_tank_gunner";
				gunnerOutOpticsModel 		= "\ca\Weapons\optika_empty";
				gunnerOpticsEffect[] 		={"TankGunnerOptics2", "OpticsBlur1", "OpticsCHAbera1"};
				gunnerOutOpticsEffect[] 	={};
				gunBeg				= "turret_gun_beg";
				gunEnd				= "turret_gun_end";
//				gun				= "turret_gun";
//				body				= "turret";

				commanding 			= 1;
				primaryGunner 			= 1;
				viewGunnerInExternal 		= 0;
				
				class HitPoints
				{
					class HitTurret {armor = 1;	material = -1;	name = "vez";	visual = "vez";		passThrough = 1;	};
					class HitGun 	{armor = 0.3;	material = -1;	name = "zbran";	visual = "zbran";	passThrough = 0;	};
				};
				class ViewOptics		: ViewOptics_JSDF_AV_base {};
				class ViewGunner		: ViewGunner_JSDF_AV_base {};
				
				class Turrets
				{
					class CommanderOptics			: NewTurret
					{
						animationSourceBody 		= "Commander_Turret";
						animationSourceGun 		= "Commander_Gun";
						animationSourceHatch 		= "Commander_Hatch";

						selectionFireAnim 		= "turretC_gun_fir";
						memoryPointGun 			= "turretC_gun";
						memoryPointGunnerOptics 	= "turretC_view";
						memoryPointGunnerOutOptics 	= "turretC_view_out";
						memoryPointsGetInGunner 	= "commander_pos";
						memoryPointsGetInGunnerDir 	= "commander_pos_dir";

						proxyType 			= "CPCommander";
						proxyIndex 			= 1;
						gunnerName 			= $STR_POSITION_COMMANDER;
						primaryGunner 			= 0;
						primaryObserver 		= 1;
						commanding 			= 2;

						stabilizedInAxes 		= "StabilizedInAxesNone";
						soundServo[] 			= {"\ca\sounds\vehicles\servos\turret-1", 0.01, 1.0, 10};
						body 				= "turretC_turret";
						gun 				= "turretC_view";
						gunBeg 				= "";
						gunEnd 				= "";
						minElev = -4;	maxElev = 20;	initElev = 0;
						minTurn = -360;	maxTurn = 360;	initTurn = 0;
						startEngine			= 0;
						outGunnerMayFire 		= 1;
						inGunnerMayFire 		= 0;

						weapons[]			= {};
						magazines[]			= {};

						viewGunnerInExternal 		= 0;
						gunnerOpticsModel 		= "\ca\Tracked\optika_tank_driver";
						gunnerOutOpticsModel 		= "\ca\Weapons\optika_empty";
						gunnerOutOpticsColor[] 		= {0, 0, 0, 1};
						gunnerOutForceOptics 		= 0;
						gunnerOutOpticsShowCursor 	= 0;
						gunnerOpticsEffect[] 		= {};
						gunnerOutOpticsEffect[] 	= {};
						gunnerGetInAction 		= "GetInHigh";
						gunnerGetOutAction 		= "GetOutHigh";
						class ViewOptics		: ViewOptics_JSDF_AV_base {};
						class ViewGunner		: ViewGunner_JSDF_AV_base {};
					};
					class LoaderOptics 			: CommanderOptics
					{
						animationSourceBody		="Loader_Turret";
						animationSourceGun		="Loader_Gun";
						animationSourceHatch		="Loader_Hatch";

						memoryPointGun 			="Loader_gun";
						memoryPointGunnerOptics 	="Loader_view";
						memoryPointGunnerOutOptics 	="Loader_view_out";
						memoryPointsGetInGunner 	="Loader_pos";
						memoryPointsGetInGunnerDir 	="Loader_pos_dir";

						proxyType			= CPcargo;
						proxyIndex 			= 1;
						gunnerCompartments		="Compartment3";
						gunnerName			= loader;
						primaryGunner			= 0;
						primaryObserver			= 0;
						commanding			=-1;

						body				="Loader_Turret";
						gun				="Loader_View";
						gunBeg				="";
						gunEnd				="";
						weapons[]			={};
						magazines[]			={};
						soundServo[]			={"", db-50, 1.0};
						minElev	=  -5; maxElev	= +5; initElev	=0;
						minTurn	= -60; maxTurn	=+60; initTurn	=0;
						startEngine			= 0;
						outGunnerMayFire		= 0;
						inGunnerMayFire			= 0;
						forceHideGunner			= 0;
						viewGunnerInExternal		= 1;
						gunnerAction			= Abrams_CommanderOut;
						gunnerInAction			= Abrams_Commander;
						gunnerForceOptics		= 0;
						gunnerOpticsModel		="\ca\Tracked\optika_M1A1_commander";
						class ViewOptics		: ViewOptics_JSDF_AV_base {};
						class ViewGunner		: ViewGunner_JSDF_AV_base {};
					};
				};
			};
		};
		class CargoLight
		{
			color[] = {0, 0, 0, 0};
			ambient[] = {0.6, 0, 0.15, 1};
			brightness = 0.007;
		};
		class Reflectors
		{
			class Left
			{
				color[] 	= {1.0, 0.5, 0.3, 1.0};
				ambient[] 	= {0.2, 0.2, 0.2, 1.0};
				position 	= "light_FL";
				direction 	= "light_FL_dir";
				hitpoint 	= "light_FL";
				selection 	= "light_FL";
				size 		= 0.5;
				brightness 	= 0.5;
			};
			class Right		: Left
			{
				position 	= "light_FR";
				direction 	= "light_FR_dir";
				hitpoint 	= "light_FR";
				selection 	= "light_FR";
			};
		};
		aggregateReflectors[] 		= {{"Left", "Right"}};
		class Exhausts
		{
			class Exhaust	{effect = "ExhaustsEffectBig";	position = "exhaust";	direction = "exhaust_dir";	};
			class ExhaustL : Exhaust {			position = "exhaust_L";	direction = "exhaust_L_dir";	};
			class ExhaustR : Exhaust {			position = "exhaust_R";	direction = "exhaust_R_dir";	};
		};
		insideSoundCoef = 0.9;
		soundGear[] = {"", 5.62341e-005, 1};
		soundGetIn[] = {"ca\SOUNDS\Vehicles\Tracked\T72\int\int-tank-diesel-door-1", 0.562341, 1};
		soundGetOut[] = {"ca\SOUNDS\Vehicles\Tracked\T72\ext\ext-tank-diesel-door-1", 0.562341, 1, 60};
		soundEngineOnInt[] = {"ca\sounds\Vehicles\Tracked\T72\int\int-tank-diesel-start-2", 1.0, 1.0};
		soundEngineOnExt[] = {"ca\SOUNDS\Vehicles\Tracked\T72\ext\ext-tank-diesel-start-2", 2.51189, 1.0, 500};
		soundEngineOffInt[] = {"ca\sounds\vehicles\Tracked\T72\int\int-tank-diesel-stop-1", 1.0, 1.0};
		soundEngineOffExt[] = {"ca\sounds\vehicles\Tracked\T72\ext\ext-tank-diesel-stop-1", 1.0, 0.8, 500};
		buildCrash0[] = {"Ca\sounds\Vehicles\Crash\tank_building_01", 0.707946, 1, 150};
		buildCrash1[] = {"Ca\sounds\Vehicles\Crash\tank_building_02", 0.707946, 1, 150};
		buildCrash2[] = {"Ca\sounds\Vehicles\Crash\tank_building_03", 0.707946, 1, 150};
		buildCrash3[] = {"Ca\sounds\Vehicles\Crash\tank_building_04", 0.707946, 1, 150};
		soundBuildingCrash[] = {"buildCrash0", 0.25, "buildCrash1", 0.25, "buildCrash2", 0.25, "buildCrash3", 0.25};
		WoodCrash0[] = {"Ca\sounds\Vehicles\Crash\tank_wood_01", 0.707946, 1, 150};
		WoodCrash1[] = {"Ca\sounds\Vehicles\Crash\tank_wood_02", 0.707946, 1, 150};
		WoodCrash2[] = {"Ca\sounds\Vehicles\Crash\tank_wood_03", 0.707946, 1, 150};
		WoodCrash3[] = {"Ca\sounds\Vehicles\Crash\tank_wood_04", 0.707946, 1, 150};
		soundWoodCrash[] = {"woodCrash0", 0.25, "woodCrash1", 0.25, "woodCrash2", 0.25, "woodCrash3", 0.25};
		ArmorCrash0[] = {"Ca\sounds\Vehicles\Crash\tank_vehicle_01", 0.707946, 1, 150};
		ArmorCrash1[] = {"Ca\sounds\Vehicles\Crash\tank_vehicle_02", 0.707946, 1, 150};
		ArmorCrash2[] = {"Ca\sounds\Vehicles\Crash\tank_vehicle_03", 0.707946, 1, 150};
		ArmorCrash3[] = {"Ca\sounds\Vehicles\Crash\tank_vehicle_04", 0.707946, 1, 150};
		soundArmorCrash[] = {"ArmorCrash0", 0.25, "ArmorCrash1", 0.25, "ArmorCrash2", 0.25, "ArmorCrash3", 0.25};
		
		class SoundEvents
		{
			class AccelerationIn {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int-tank-diesel-acceleration-1", 1.77828, 1.0};
				limit = 0.15;
				expression = "engineOn*(1-camPos)*2*gmeterZ*((speed factor[1.5, 5]) min (speed factor[5, 1.5]))";
			};
			class AccelerationOut {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext-tank-diesel-acceleration-1", 1.77828, 1.0, 650};
				limit = 0.15;
				expression = "engineOn*camPos*2*gmeterZ*((speed factor[1.5, 5]) min (speed factor[5, 1.5]))";
			};
		};
		
		class Sounds
		{
			class Engine {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext-tank-diesel-engine3", 1.77828, 1.0, 1000};
				frequency = "(randomizer*0.05+0.8)*rpm";
				volume = "engineOn*camPos*(rpm factor[0.4, 0.9])";
			};
			class IdleOut {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext-tank-diesel-engine3", 0.562341, 1.0, 300};
				frequency = "1";
				volume = "engineOn*camPos*(rpm factor[0.6, 0.15])";
			};
			class NoiseOut {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\noise2", 1.0, 1.0, 150};
				frequency = "1";
				volume = "camPos*(angVelocity max 0.04)*(speed factor[4, 15])";
			};
			class ThreadsOutH0 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_hard_01", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*(1-grass)*((rpm factor[0.3, 0.6]) min (rpm factor[0.6, 0.3]))";
			};
			class ThreadsOutH1 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_hard_02", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*(1-grass)*((rpm factor[0.5, 0.8]) min (rpm factor[0.8, 0.5]))";
			};
			class ThreadsOutH2 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_hard_03", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*(1-grass)*((rpm factor[0.65, 0.9]) min (rpm factor[0.9, 0.65]))";
			};
			class ThreadsOutH3 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_hard_04", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*(1-grass)*((rpm factor[0.8, 1.2]) min (rpm factor[1.2, 0.8]))";
			};
			class ThreadsOutH4 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_hard_05", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*(1-grass)*((rpm factor[1, 2.0]) min (rpm factor[2.0, 1]))";
			};
			class ThreadsOutS0 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_soft_01", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*grass*((rpm factor[0.3, 0.6]) min (rpm factor[0.6, 0.3]))";
			};
			class ThreadsOutS1 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_soft_02", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*grass*((rpm factor[0.5, 0.8]) min (rpm factor[0.8, 0.5]))";
			};
			class ThreadsOutS2 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_soft_03", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*grass*((rpm factor[0.65, 0.9]) min (rpm factor[0.9, 0.65]))";
			};
			class ThreadsOutS3 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_soft_04", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*grass*((rpm factor[0.8, 1.2]) min (rpm factor[1.2, 0.8]))";
			};
			class ThreadsOutS4 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_soft_05", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*grass*((rpm factor[1, 2.0]) min (rpm factor[2.0, 1]))";
			};
			class Movement {
				sound[] = {"", 1.0, 1.0};
				frequency = "0";
				volume = "0";
			};
			class EngineIn {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int-tank-diesel-engine3", 1.0, 1.0};
				frequency = "(randomizer*0.05+0.8)*rpm";
				volume = "engineOn*(1-camPos)*(rpm factor[0.4, 1])";
			};
			class IdleIn {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int-tank-diesel-engine3", 1.77828, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*(rpm factor[0.6, 0.15])";
			};
			class NoiseIn {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\noise2", 0.158489, 1.0};
				frequency = "1";
				volume = "(1-camPos)*(angVelocity max 0.04)*(speed factor[4, 15])";
			};
			class ThreadsInH0 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_hard_01", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*(1-grass)*((rpm factor[0.3, 0.6]) min (rpm factor[0.6, 0.3]))";
			};
			class ThreadsInH1 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_hard_02", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*(1-grass)*((rpm factor[0.5, 0.8]) min (rpm factor[0.8, 0.5]))";
			};
			class ThreadsInH2 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_hard_03", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*(1-grass)*((rpm factor[0.65, 0.9]) min (rpm factor[0.9, 0.65]))";
			};
			class ThreadsInH3 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_hard_04", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*(1-grass)*((rpm factor[0.8, 1.2]) min (rpm factor[1.2, 0.8]))";
			};
			class ThreadsInH4 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_hard_05", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*(1-grass)*((rpm factor[1, 2.0]) min (rpm factor[2.0, 1]))";
			};
			class ThreadsInS0 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_soft_01", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*grass*((rpm factor[0.3, 0.6]) min (rpm factor[0.6, 0.3]))";
			};
			class ThreadsInS1 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_soft_02", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*grass*((rpm factor[0.5, 0.8]) min (rpm factor[0.8, 0.5]))";
			};
			class ThreadsInS2 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_soft_03", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*grass*((rpm factor[0.65, 0.9]) min (rpm factor[0.9, 0.65]))";
			};
			class ThreadsInS3 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_soft_04", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*grass*((rpm factor[0.8, 1.2]) min (rpm factor[1.2, 0.8]))";
			};
			class ThreadsInS4 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_soft_05", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*grass*((rpm factor[1, 2.0]) min (rpm factor[2.0, 1]))";
			};
		};
		soundDammage[] 			= {"\ca\Tracked\Data\Sound\alarm_loop1", 0.000316228, 1};
		class EventHandlers 		: DefaultEventhandlers
		{
			fired		="[_this] exec ""\jsdf_vla\_scripts\_fired\_weapons.sqs""";
		};
		class Library
		{
			libTextDesc = "APC";
		};
	};
};