class WeaponFireMGun;
class Coaxial_FireMGun		: WeaponFireMGun
{
	cloudletDuration	= 0;
	cloudletAlpha		= 0.75;
	cloudletGrowUp		= 0.06;
	cloudletFadeIn		= 0;
	cloudletFadeOut		= 0.1;
	interval		= 0.05;
	size			= 2;
	sourceSize		= 0.01;
	timeToLive		= 0;
	initT			= 30;
	deltaT			=-30;
};
class WeaponCloudsMGun;
class Coaxial_CloudsMGun	: WeaponCloudsMGun
{
	access			= ReadAndWrite;
	cloudletGrowUp		= 0.05;	///0.05// grow-up time
	cloudletFadeIn		= 0;	///0// fade-in time
	cloudletFadeOut		= 4.1;	///0.1// fade-out time
	cloudletDuration	= 5.0;	///0.05// time to live (not including fades)
	cloudletAlpha		= 0.3;
	cloudletAccY		= 0;	// vertical acceleration
	cloudletMinYSpeed	=-10;	// vertical speed range
	cloudletMaxYSpeed	= 10;
	interval		= 0.2;  ///0.02
	size			= 1.3;	///0.3
	sourceSize		= 0.7;	///0.02
};
class ViewOptics_JSDF_AV_base
{
	initAngleX=0;	minAngleX=-30;	maxAngleX=+30;
	initAngleY=0;	minAngleY=-100;	maxAngleY=+100;
	initFov=0.42;	minFov=0.22;	maxFov=0.64;
};
class ViewGunner_JSDF_AV_base
{
	initAngleX=5;	minAngleX=-30;	maxAngleX=+30;
	initAngleY=0;	minAngleY=0;	maxAngleY=0;
	initFov=0.42;	minFov=0.22;	maxFov=0.64;
};
class CfgVehicles
{
	class Land;
	class LandVehicle : Land
	{
		class NewTurret;
		class ViewPilot;
		class ViewOptics;
		class Sounds;
	};
	class JSDF_VLA	 			: LandVehicle
	{
		scope 				= 0;
		side 				= 1;
		faction 			= JSDF;
		vehicleClass 			= "Armored";
		icon 				= "iconTank";
		displayName 			= $STR_DN_TANK;
		nameSound 			= "tank";
		simulation 			= "tank";
		type 				= VArmor;
		threat[] 			= {0.7, 1, 0.3};
		cost 				= 1000000;
		accuracy 			= 0.12;

		armor 				= 400;
		armorStructural 		= 2.0;

		tracksSpeed 			= 2.5;
		wheelCircumference 		= 4.0;
		
		class HitPoints
		{
			class HitEngine 	{armor = 0.35;	material = -1;	name = "motor";		visual = "motor";	passThrough = 0.2;	};
			class HitHull 		{armor = 1;	material = -1;	name = "NEtelo";	visual = "telo";	passThrough = 1;	};
			class HitLTrack 	{armor = 0.15;	material = -1;	name = "pas_L";		visual = "pas_L";	passThrough = 0.3;	};
			class HitRTrack 	{armor = 0.15;	material = -1;	name = "pas_P";		visual = "pas_P";	passThrough = 0.3;	};
		};
/*
		class HitEngine			{armor = 0.8;	material = 60;	name = "engine";	visual = "engine";	passThrough = 0;	};
		class HitHull			{armor = 1;	material = 50;	name = "hull";		visual = "hull";	passThrough = 0;	};
		class HitLTrack			{armor = 0.6;	material = 53;	name = "pasL";		visual = "pasL";	passThrough = 0;	};
		class HitRTrack			{armor = 0.6;	material = 54;	name = "pasP";		visual = "pasP";	passThrough = 0;	};
*/
		selectionLeftOffset 		= "Crawler_L";
		selectionRightOffset 		= "Crawler_R";
		selectionFireAnim 		= "muzzleflash";
		selectionRotorStill 		= "Rotor_Static";
		selectionRotorMove 		= "Rotor_Blurred";
		selectionBackLights 		= "light";
		selectionBrakeLights 		= "light_stop";
		selectionDashboard 		= "light_panel";

		memoryPointCargoLight 		= "light_cargo";

		memoryPointsGetInDriver 	= "driver_pos";
		memoryPointsGetInDriverDir 	= "driver_pos_dir";
		memoryPointsGetInCoDriver 	= "codriver_pos";
		memoryPointsGetInCoDriverDir 	= "codriver_pos_dir";
		memoryPointsGetInGunner 	= "gunner_pos";
		memoryPointsGetInGunnerDir 	= "gunner_pos_dir";
		memoryPointsGetInCargo	 	= "cargo_pos";
		memoryPointsGetInCargoDir	= "cargo_pos_dir";
//		memoryPointsGetInCargo[] 	= {"codriver_pos", 	"cargo_pos"};
//		memoryPointsGetInCargoDir[] 	= {"codriver_pos_dir", 	"cargo_pos_dir"};
		initCargoAngleY 		= 185;

		memoryPointDriverOptics[] 	= {"driver_view","driverview", "pilot"};
		memoryPointGunnerOptics 	= "gunnerview";
		memoryPointGun 			= "gun_pos";
		memoryPointMissile[] 		= {"Missile_pos",	"Rocket_pos"};
		memoryPointMissileDir[] 	= {"Missile_pos_dir",	"Rocket_pos_dir"};
		memoryPointLMissile 		= "Missile_L_pos";
		memoryPointRMissile 		= "Missile_R_pos";
		memoryPointLRocket 		= "Rocket_L_pos";
		memoryPointRRocket 		= "Rocket_R_pos";

		memoryPointTrack1L 		= "Track_FL";
		memoryPointTrack1R 		= "Track_FR";
		memoryPointTrack2L 		= "Track_BL";
		memoryPointTrack2R 		= "Track_BR";
		memoryPointTrackFLL 		= "Track_FLL";
		memoryPointTrackFLR 		= "Track_FLR";
		memoryPointTrackFRL 		= "Track_FRL";
		memoryPointTrackFRR 		= "Track_FRR";
		memoryPointTrackBLL 		= "Track_BLL";
		memoryPointTrackBLR 		= "Track_BLR";
		memoryPointTrackBRL 		= "Track_BRL";
		memoryPointTrackBRR 		= "Track_BRR";

		leftDustEffect 			= "LDustEffects";
		rightDustEffect 		= "RDustEffects";
		leftWaterEffect 		= "LWaterEffects";
		rightWaterEffect 		= "RWaterEffects";

		bounding 			= "turret_gun_pos_dir";
		fireDustEffect 			= "FDustEffects";
		gearBox[] 			= {-7, 0, 11, 8, 5.7, 4.2};
		alphaTracks 			= 0.7;
		textureTrackWheel 		= false;
		camouflage 			= 8;
		audible 			= 6;

		sensitivityEar 			= 0.0075 /3;

		canFloat 			= false;
		precision 			= 5;
		brakeDistance 			= 15;
		maxSpeed 			= 80;
		steerAheadSimul 		= 0.4;
		steerAheadPlan 			= 0.6;
		predictTurnSimul 		= 1.2;
		predictTurnPlan 		= 1.8;
		occludeSoundsWhenIn 		= 0.01;
		obstructSoundsWhenIn 		= 0.177828;

		crew 				= "USMC_Soldier_Crew";
		crewVulnerable 			= false;
		hideProxyInCombat 		= true;
		getInRadius 			= 3.5;
		getInAction 			= "GetInMedium";
		getOutAction 			= "GetOutMedium";
		hasGunner 			= 0;
		hasCommander 			= 0;
		gunnerCanSee 			= 30;
		commanderCanSee 		= 31;
		commanderUsesPilotView 		= 1;

		viewDriverShadow 		= 1;
		viewDriverShadowDiff 		= 0.05;
		viewGunnerShadow 		= 1;
		viewGunnerShadowDiff 		= 0.05;
		viewCargoShadow 		= 1;
		viewCargoShadowDiff 		= 0.05;

		driverOpticsModel 		= "\ca\Tracked\optika_tank_driver";
		driverOpticsColor[] 		= {1, 1, 1, 1};
		driverAction 			= "";
		driverInAction 			= "";
		animationSourceHatch 		= "DriverHatch";

		cargoGetInAction[] 		= {"GetInLow"};
		cargoGetOutAction[] 		= {"GetOutLow"};

		transportMaxMagazines 		= 100;
		transportMaxWeapons 		= 10;
		enableGPS 			= 1;
		nightVision 			= 0;
		weapons[] 			= {"FakeWeapon"};
		magazines[] 			= {"FakeWeapon"};

		smokeLauncherGrenadeCount 	= 6;
		smokeLauncherVelocity 		= 15;
		smokeLauncherOnTurret 		= 1;
		smokeLauncherAngle 		= 120;

		supplyRadius 			= 1.5;
		fuelCapacity 			= 700;
		irScanToEyeFactor 		= 1;
		irScanRangeMin 			= 500;
		irScanRangeMax 			= 4000;

		formationX 			= 20;
		formationZ 			= 30;

		extCameraPosition[] 		= {0, 1.5, -9};
		class ViewPilot : ViewPilot
		{
			initAngleX = 7;		minAngleX = -15;	maxAngleX = 25;
			initAngleY = 0;		minAngleY = -90;	maxAngleY = 90;
		};
		class ViewOptics : ViewOptics
		{
			initAngleX = 0;		minAngleX = -30;	maxAngleX = 30;
			initAngleY = 0;		minAngleY = -100;	maxAngleY = 100;
			initFov = 0.466;	minFov = 0.466;		maxFov = 0.466;
		};
		class Turrets
		{
			class MainTurret 		: NewTurret
			{
				commanding			= 1;
				gunnerAction			="ManActTestDriverOut";
				gunnerOpticsModel		="\ca\Tracked\optika_tank_gunner";
				gunnerOutOpticsModel		= \ca\Weapons\optika_empty;
				gunBeg				= "turret_gun_beg";
				gunEnd				= "turret_gun_end";
				memoryPointGun			= "turret_gun_coaxgun";
				memoryPointGunnerOptics		= "turret_view";
				memoryPointGunnerOutOptics 	= "turret_view_out";
				memoryPointsGetInGunner 	= "gunner_pos";
				memoryPointsGetInGunnerDir 	= "gunner_pos_dir";
				viewGunnerInExternal		= 0;

				class HitTurret	{armor=1;material=55;name="vez";visual="vez";passThrough=1;};
				class HitGun	{armor=0.3;material=55;name="zbran";visual="zbran";passThrough=0;};
				
				class Turrets
				{
					class CommanderOptics		: NewTurret
					{
						proxyType 			= "CPCommander";
						proxyIndex 			= 1;
						gunnerName 			= $STR_POSITION_COMMANDER;
						primaryGunner 			= 0;
						primaryObserver 		= 1;
						stabilizedInAxes 		= "StabilizedInAxesNone";
						body 				= "obsTurret";
						gun 				= "obsGun";
						animationSourceBody 		= "CommanderTurret";
						animationSourceGun 		= "CommanderGun";
						animationSourceHatch 		= "CommanderHatch";
						soundServo[] 			= {"\ca\sounds\vehicles\servos\turret-1", 0.01, 1.0, 10};
						gunBeg 				= "";
						gunEnd 				= "";
						minElev = -4;	maxElev = 20;	initElev = 0;
						minTurn = -360;	maxTurn = 360;	initTurn = 0;
						commanding 			= 2;
						outGunnerMayFire 		= 1;
						inGunnerMayFire 		= 1;
						viewGunnerInExternal 		= 0;
						gunnerOpticsModel 		= "\ca\Tracked\optika_tank_driver";
						gunnerOutOpticsModel 		= "\ca\Weapons\optika_empty";
						gunnerOutOpticsColor[] 		= {0, 0, 0, 1};
						gunnerOutForceOptics 		= 0;
						gunnerOutOpticsShowCursor 	= 0;
						gunnerOpticsEffect[] 		= {};
						gunnerOutOpticsEffect[] 	= {};
						memoryPointGunnerOutOptics 	= "commander_weapon_view";
						memoryPointGunnerOptics 	= "commanderview";
						memoryPointsGetInGunner 	= "pos commander";
						memoryPointsGetInGunnerDir 	= "pos commander dir";
						gunnerGetInAction 		= "GetInHigh";
						gunnerGetOutAction 		= "GetOutHigh";
						memoryPointGun 			= "gun_muzzle";
						selectionFireAnim 		= "zasleh_1";
						
						class ViewOptics {
							initAngleX = 0;
							minAngleX = -30;
							maxAngleX = 30;
							initAngleY = 0;
							minAngleY = -100;
							maxAngleY = 100;
							initFov = 0.155;
							minFov = 0.0625;
							maxFov = 0.466;
						};
						
						class ViewGunner {
							initAngleX = 5;
							minAngleX = -65;
							maxAngleX = 85;
							initAngleY = 0;
							minAngleY = -150;
							maxAngleY = 150;
							initFov = 0.7;
							minFov = 0.25;
							maxFov = 1.1;
						};
					};
				};
			};
		};
		class CargoLight
		{
			color[] = {0, 0, 0, 0};
			ambient[] = {0.6, 0, 0.15, 1};
			brightness = 0.007;
		};
		class Reflectors
		{
			class Left
			{
				color[] 	= {1.0, 0.5, 0.3, 1.0};
				ambient[] 	= {0.2, 0.2, 0.2, 1.0};
				position 	= "light_FL";
				direction 	= "light_FL_dir";
				hitpoint 	= "light_FL";
				selection 	= "light_FL";
				size 		= 0.5;
				brightness 	= 0.5;
			};
			class Right		: Left
			{
				position 	= "light_FR";
				direction 	= "light_FR_dir";
				hitpoint 	= "light_FR";
				selection 	= "light_FR";
			};
		};
		aggregateReflectors[] 		= {{"Left", "Right"}};
		class Exhausts
		{
			class Exhaust	{effect = "ExhaustsEffectBig";	position = "exhaust";	direction = "exhaust_dir";	};
			class ExhaustL : Exhaust {			position = "exhaust_L";	direction = "exhaust_L_dir";	};
			class ExhaustR : Exhaust {			position = "exhaust_R";	direction = "exhaust_R_dir";	};
		};
		insideSoundCoef = 0.9;
		soundGear[] = {"", 5.62341e-005, 1};
		soundGetIn[] = {"ca\SOUNDS\Vehicles\Tracked\T72\int\int-tank-diesel-door-1", 0.562341, 1};
		soundGetOut[] = {"ca\SOUNDS\Vehicles\Tracked\T72\ext\ext-tank-diesel-door-1", 0.562341, 1, 60};
		soundEngineOnInt[] = {"ca\sounds\Vehicles\Tracked\T72\int\int-tank-diesel-start-2", 1.0, 1.0};
		soundEngineOnExt[] = {"ca\SOUNDS\Vehicles\Tracked\T72\ext\ext-tank-diesel-start-2", 2.51189, 1.0, 500};
		soundEngineOffInt[] = {"ca\sounds\vehicles\Tracked\T72\int\int-tank-diesel-stop-1", 1.0, 1.0};
		soundEngineOffExt[] = {"ca\sounds\vehicles\Tracked\T72\ext\ext-tank-diesel-stop-1", 1.0, 0.8, 500};
		buildCrash0[] = {"Ca\sounds\Vehicles\Crash\tank_building_01", 0.707946, 1, 150};
		buildCrash1[] = {"Ca\sounds\Vehicles\Crash\tank_building_02", 0.707946, 1, 150};
		buildCrash2[] = {"Ca\sounds\Vehicles\Crash\tank_building_03", 0.707946, 1, 150};
		buildCrash3[] = {"Ca\sounds\Vehicles\Crash\tank_building_04", 0.707946, 1, 150};
		soundBuildingCrash[] = {"buildCrash0", 0.25, "buildCrash1", 0.25, "buildCrash2", 0.25, "buildCrash3", 0.25};
		WoodCrash0[] = {"Ca\sounds\Vehicles\Crash\tank_wood_01", 0.707946, 1, 150};
		WoodCrash1[] = {"Ca\sounds\Vehicles\Crash\tank_wood_02", 0.707946, 1, 150};
		WoodCrash2[] = {"Ca\sounds\Vehicles\Crash\tank_wood_03", 0.707946, 1, 150};
		WoodCrash3[] = {"Ca\sounds\Vehicles\Crash\tank_wood_04", 0.707946, 1, 150};
		soundWoodCrash[] = {"woodCrash0", 0.25, "woodCrash1", 0.25, "woodCrash2", 0.25, "woodCrash3", 0.25};
		ArmorCrash0[] = {"Ca\sounds\Vehicles\Crash\tank_vehicle_01", 0.707946, 1, 150};
		ArmorCrash1[] = {"Ca\sounds\Vehicles\Crash\tank_vehicle_02", 0.707946, 1, 150};
		ArmorCrash2[] = {"Ca\sounds\Vehicles\Crash\tank_vehicle_03", 0.707946, 1, 150};
		ArmorCrash3[] = {"Ca\sounds\Vehicles\Crash\tank_vehicle_04", 0.707946, 1, 150};
		soundArmorCrash[] = {"ArmorCrash0", 0.25, "ArmorCrash1", 0.25, "ArmorCrash2", 0.25, "ArmorCrash3", 0.25};
		
		class SoundEvents
		{
			class AccelerationIn {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int-tank-diesel-acceleration-1", 1.77828, 1.0};
				limit = 0.15;
				expression = "engineOn*(1-camPos)*2*gmeterZ*((speed factor[1.5, 5]) min (speed factor[5, 1.5]))";
			};
			class AccelerationOut {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext-tank-diesel-acceleration-1", 1.77828, 1.0, 650};
				limit = 0.15;
				expression = "engineOn*camPos*2*gmeterZ*((speed factor[1.5, 5]) min (speed factor[5, 1.5]))";
			};
		};
		
		class Sounds
		{
			class Engine {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext-tank-diesel-engine3", 1.77828, 1.0, 1000};
				frequency = "(randomizer*0.05+0.8)*rpm";
				volume = "engineOn*camPos*(rpm factor[0.4, 0.9])";
			};
			class IdleOut {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext-tank-diesel-engine3", 0.562341, 1.0, 300};
				frequency = "1";
				volume = "engineOn*camPos*(rpm factor[0.6, 0.15])";
			};
			class NoiseOut {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\noise2", 1.0, 1.0, 150};
				frequency = "1";
				volume = "camPos*(angVelocity max 0.04)*(speed factor[4, 15])";
			};
			class ThreadsOutH0 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_hard_01", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*(1-grass)*((rpm factor[0.3, 0.6]) min (rpm factor[0.6, 0.3]))";
			};
			class ThreadsOutH1 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_hard_02", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*(1-grass)*((rpm factor[0.5, 0.8]) min (rpm factor[0.8, 0.5]))";
			};
			class ThreadsOutH2 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_hard_03", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*(1-grass)*((rpm factor[0.65, 0.9]) min (rpm factor[0.9, 0.65]))";
			};
			class ThreadsOutH3 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_hard_04", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*(1-grass)*((rpm factor[0.8, 1.2]) min (rpm factor[1.2, 0.8]))";
			};
			class ThreadsOutH4 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_hard_05", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*(1-grass)*((rpm factor[1, 2.0]) min (rpm factor[2.0, 1]))";
			};
			class ThreadsOutS0 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_soft_01", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*grass*((rpm factor[0.3, 0.6]) min (rpm factor[0.6, 0.3]))";
			};
			class ThreadsOutS1 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_soft_02", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*grass*((rpm factor[0.5, 0.8]) min (rpm factor[0.8, 0.5]))";
			};
			class ThreadsOutS2 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_soft_03", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*grass*((rpm factor[0.65, 0.9]) min (rpm factor[0.9, 0.65]))";
			};
			class ThreadsOutS3 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_soft_04", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*grass*((rpm factor[0.8, 1.2]) min (rpm factor[1.2, 0.8]))";
			};
			class ThreadsOutS4 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\ext\ext_diesel_treads_soft_05", 1.0, 1.0, 200};
				frequency = "1";
				volume = "engineOn*camPos*grass*((rpm factor[1, 2.0]) min (rpm factor[2.0, 1]))";
			};
			class Movement {
				sound[] = {"", 1.0, 1.0};
				frequency = "0";
				volume = "0";
			};
			class EngineIn {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int-tank-diesel-engine3", 1.0, 1.0};
				frequency = "(randomizer*0.05+0.8)*rpm";
				volume = "engineOn*(1-camPos)*(rpm factor[0.4, 1])";
			};
			class IdleIn {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int-tank-diesel-engine3", 1.77828, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*(rpm factor[0.6, 0.15])";
			};
			class NoiseIn {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\noise2", 0.158489, 1.0};
				frequency = "1";
				volume = "(1-camPos)*(angVelocity max 0.04)*(speed factor[4, 15])";
			};
			class ThreadsInH0 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_hard_01", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*(1-grass)*((rpm factor[0.3, 0.6]) min (rpm factor[0.6, 0.3]))";
			};
			class ThreadsInH1 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_hard_02", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*(1-grass)*((rpm factor[0.5, 0.8]) min (rpm factor[0.8, 0.5]))";
			};
			class ThreadsInH2 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_hard_03", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*(1-grass)*((rpm factor[0.65, 0.9]) min (rpm factor[0.9, 0.65]))";
			};
			class ThreadsInH3 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_hard_04", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*(1-grass)*((rpm factor[0.8, 1.2]) min (rpm factor[1.2, 0.8]))";
			};
			class ThreadsInH4 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_hard_05", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*(1-grass)*((rpm factor[1, 2.0]) min (rpm factor[2.0, 1]))";
			};
			class ThreadsInS0 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_soft_01", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*grass*((rpm factor[0.3, 0.6]) min (rpm factor[0.6, 0.3]))";
			};
			class ThreadsInS1 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_soft_02", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*grass*((rpm factor[0.5, 0.8]) min (rpm factor[0.8, 0.5]))";
			};
			class ThreadsInS2 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_soft_03", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*grass*((rpm factor[0.65, 0.9]) min (rpm factor[0.9, 0.65]))";
			};
			class ThreadsInS3 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_soft_04", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*grass*((rpm factor[0.8, 1.2]) min (rpm factor[1.2, 0.8]))";
			};
			class ThreadsInS4 {
				sound[] = {"ca\sounds\Vehicles\Tracked\T72\int\int_diesel_treads_soft_05", 1.0, 1.0};
				frequency = "1";
				volume = "engineOn*(1-camPos)*grass*((rpm factor[1, 2.0]) min (rpm factor[2.0, 1]))";
			};
		};
		soundDammage[] 			= {"\ca\Tracked\Data\Sound\alarm_loop1", 0.000316228, 1};
		class Damage
		{
			tex[]={};
			mat[]={};
		};
		class AnimationSources
		{
			class mainGun_recoil
			{
				source="user";
				animPeriod 	=0.5;
				initPhase	=0.01;
			};
			class obsGun_recoil
			{
				source="reload";
				weapon="M2";
			};
			class belt_rotation
			{
				source="reload";
				weapon="M2";
			};
		};
		class EventHandlers 		: DefaultEventhandlers
		{
//			init		="";
			fired		="[_this] exec ""\jsdf_vla\_scripts\_fired\_weapons.sqs""";
//			killed 		= "";
		};

		class Library {libTextDesc = $STR_LIB_M1A1;};
	};
};