class KD_FireGun;
class KD_CloudsGun;
class Coaxial_FireMGun;
class Coaxial_CloudsMGun;
class CfgPatches
{
	class JSDF_VLA_89FV
	{
		units[] = {"JGSDF_VLA_89FV"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {};
	};
};
class CfgVehicles
{
	class Land;
	class LandVehicle 			: Land
	{
		class NewTurret;
		class ViewPilot;
		class Sounds;
	};
	class JSDF_VLA	 			: LandVehicle
	{
		class Turrets			{class MainTurret;};
		class NewTurret;
		class ViewPilot;
		class CommanderOptics;
		class AnimationSources;
		
		class Sounds : Sounds
		{
			class Engine;
			class Movement;
		};
		class HitPoints
		{
			class HitHull;
			class HitEngine;
			class HitLTrack;
			class HitRTrack;
		};
	};
	class JSDF_VLA_89FV_Base		: JSDF_VLA
	{
		faction 			= JGSDF;
		displayName 			= Type89 FV;
		model 				="\jsdf_vla\89FV\JGSDF_Type89FV_2";
		icon 				="\jsdf_vla\89FV\icomap_t89FV_ca.paa";
		picture 			="\jsdf_vla\89FV\ico_t89FV_ca.paa";
		mapSize 			= 9;
		accuracy 			= 0.7;
		threat[] 			= {1, 1, 0.3};
		armor 				= 155;
		damageResistance 		= 0.01168;
		cost 				= 4000000;

		irScanRangeMin			= 0;
		irScanRangeMax			= 0;

		maxSpeed 			= 70;
		transportSoldier 		= 11;

		tracksSpeed 			= 2.5;

		forceHideDriver			= 0;
		driverForceOptics 		= 0;
		driverAction 			= "BMP3_Driver_OUT";
		driverInAction 			= "BMP3_Driver";

		class Turrets: Turrets
		{
			class MainTurret: MainTurret
			{
				maxHorizontalRotSpeed		= 0.83;
				maxVerticalRotSpeed		= 0.66;
				gunnerAction			= Abrams_CommanderOut;
				gunnerInAction			= Abrams_Gunner;
    				gunnerCanSee			= 31;
				insideSoundCoef 		= 0.5;

				weapons[]			={JSDF_W_AAG_KBA_B02_AP,JSDF_W_AAG_KBA_B02_HE,JSDF_MG_Type74_coax};
				magazines[]			=
				{
								JSDF_M_AAG_KBA_AP_T,JSDF_M_AAG_KBA_AP_T,JSDF_M_AAG_KBA_AP_T,JSDF_M_AAG_KBA_AP_T,JSDF_M_AAG_KBA_AP_T,JSDF_M_AAG_KBA_AP_T,
								JSDF_M_AAG_KBA_HE_T,JSDF_M_AAG_KBA_HE_T,JSDF_M_AAG_KBA_HE_T,JSDF_M_AAG_KBA_HE_T,JSDF_M_AAG_KBA_HE_T,JSDF_M_AAG_KBA_HE_T,
								1000Rnd_7_62x51_M13,
								 200Rnd_7_62x51_M13,
								 200Rnd_7_62x51_M13,
								 200Rnd_7_62x51_M13,
								 200Rnd_7_62x51_M13,
								 200Rnd_7_62x51_M13,
				};//35*217 7.62=1000

				stabilizedInAxes 		= 0;
				soundServo[]			={\ca\Weapons\Data\Sound\gun_elevate,db-50,1.0};
				outGunnerMayFire		= 0;
				inGunnerMayFire			= 1;
				forceHideGunner			= 0;
				viewGunnerInExternal		= 0;
				gunnerUsesPilotView		= 1;
				gunnerForceOptics		= 0;
				gunnerOpticsModel		="\ca\Tracked\optika_tank_gunner";
				memoryPointGunnerOptics		="turret_view";
				memoryPointGunnerOutOptics 	= "";
				minElev=-10; maxElev=+35; initElev=0;
//				class GunFire			: KD_FireGun		{};
//				class GunClouds			: KD_CloudsGun		{};
//				class MGunFire			: Coaxial_FireMGun	{};
//				class MGunClouds		: Coaxial_CloudsMGun	{};
				class ViewOptics
				{
					initAngleX=0;	minAngleX=-30;	maxAngleX=+30;
					initAngleY=0;	minAngleY=-100;	maxAngleY=+100;
					initFov=0.166;	minFov=0.025;	maxFov=0.333;
				};
				class ViewGunner
				{
					initAngleX=0;	minAngleX=-60;	maxAngleX=+60;
					initAngleY=0;	minAngleY=-100;	maxAngleY=+100;
					initFov=0.42;	minFov=0.22;	maxFov=0.64;
				};
				class Turrets: Turrets
				{
					class CommanderOptics			: CommanderOptics
					{
						body				="turretC_view";
						gun				="ATM";

						outGunnerMayFire		= 0;
						inGunnerMayFire			= 1;
						forceHideGunner			= 0;
						gunnerForceOptics		= 0;
						insideSoundCoef 		= 0.0;

						gunnerAction			= Abrams_CommanderOut;
						gunnerInAction			= Abrams_Commander;
						gunnerOpticsModel		="\ca\Tracked\optika_tank_gunner";
						minElev=-10;	maxElev=+35;	initElev=0;
						minTurn=10;	maxTurn=10;	initTurn=0;
					};
				};
			};
		};
		class Sounds_t89FV 	: Sounds
		{
			class Engine
			{
				sound[] = {"\jsdf_vla\t89FV\t89AV_eng.wss", 1.77828, 1.0, 1000};
				frequency = "(randomizer*0.05+0.8)*rpm";
				volume = "engineOn*camPos*(rpm factor[0.4, 0.9])";
			};
		};
		
		class Library
		{
			libTextDesc = Type89 IFV;
		};
	};
	class JGSDF_Type89FV			: JSDF_VLA_89FV_Base
	{
		scope 				= 2;
		displayName 			= Type89 FV;
		model 				= "\jsdf_vla\89FV\JGSDF_Type89FV_2";
	};
};
