class WeaponFireGun;
class WeaponFireGun_KDA		: WeaponFireGun
{
	cloudletDuration	= 0;
	cloudletAlpha		= 0.75;
	cloudletGrowUp		= 0.06;
	cloudletFadeIn		= 0;
	cloudletFadeOut		= 0.1;
	interval		= 0.05;
	size			= 2;
	sourceSize		= 0.01;
	timeToLive		= 0;
	initT			= 30;
	deltaT			=-30;
};
class WeaponCloudsGun;
class WeaponCloudsGun_KDA	: WeaponCloudsGun
{
	access 			= ReadAndWrite;
	cloudletGrowUp 		= 0.05;	// grow-up time
	cloudletFadeIn 		= 0;	// fade-in time
	cloudletFadeOut 	= 0.1;	// fade-out time
	cloudletDuration 	= 0.05;	// time to live (not including fades)
	cloudletAlpha 		= 0.3;
	cloudletAccY 		= 0;	// vertical acceleration
	cloudletMinYSpeed 	= -100;	// vertical speed range
	cloudletMaxYSpeed 	= 100;
	interval 		= 0.02;
	size 			= 0.3;
	sourceSize 		= 0.02;
};
class CfgPatches
{
	class JSDF_VLA_87AW
	{
		units[] = {"JGSDF_VLA_87AW"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {};
	};
};
class FDustEffects_KDA
{	
	class FDust_KDA
	{
		simulation	= "particles";
		type		= "FDust_KDA";
	};
};
class CfgVehicles
{
	class Land;
	class LandVehicle 			: Land
	{
		class NewTurret;
		class ViewPilot;
		class Sounds;
	};
	class JSDF_VLA 				: LandVehicle
	{
		class Turrets			{class MainTurret;};
		class NewTurret;
		class ViewPilot;
		class CommanderOptics;
		class LoaderOptics;
		class AnimationSources;
		
		class Sounds : Sounds
		{
			class Engine;
			class Movement;
		};
		class HitPoints
		{
			class HitHull;
			class HitEngine;
			class HitLTrack;
			class HitRTrack;
		};
	};
	class JSDF_VLA_87AW_Base	: JSDF_VLA
	{
		scope 			= 2;
		faction 		= JGSDF;
		displayName 		= "Type87 AW";
		model 			= "\JSDF_VLA\87AW\JGSDF_Type87AW";
		picture 		= "\ca\tracked2\Data\UI\Picture_t34_CA.paa";
		Icon 			= "\ca\tracked2\Data\UI\Icon_t34_CA.paa";
		mapSize 		= 7;

		driverForceOptics 	= 1;
		driverAction 		= "T90_Driver";
		driverInAction 		= "T90_Driver";

		tracksSpeed 		= 2.5;
		wheelCircumference 	= 4.0;

		maxSpeed 		= 45;
		accuracy 		= 0.8;
		armor 			= 300;
		damageResistance 	= 0.01011;
		cost 			= 1500000;
		
		class HitPoints : HitPoints
		{
			class HitHull	{armor = 0.85;	material = -1;	name = "telo";	visual= "telo";		passThrough 	= 1;	};
		};

//		typicalCargo[] = {"GUE_Soldier_1", "GUE_Soldier_1", "GUE_Soldier_1"};
		
		class Turrets : Turrets
		{
			class MainTurret			: MainTurret
			{
				gunnerAction			=Abrams_Gunner;
				gunnerInAction			=Abrams_Gunner;
				soundServo[]			={\ca\Weapons\Data\Sound\gun_elevate,db-50,1.0};
				maxHorizontalRotSpeed		= 1.5625;
				maxVerticalRotSpeed		= 1.1875;
				gun				= "AAG";
				minElev=-5; maxElev=+85; initElev=0;
				gunnerForceOptics		= 0;
				gunnerOpticsModel		="\ca\Tracked\optika_tank_gunner";
				forceHideGunner			=1;

				weapons[]			={JSDF_W_AAG_KDA_HE,JSDF_W_AAG_KDA_AP};
				magazines[]			=
				{
JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,
JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,
JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,
JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,
JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,
JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,
JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,
JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,
JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,
JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,

JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,
JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,
JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,
JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,
JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,
JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,
JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,
JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,
JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,
JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,

JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,JSDF_M_AAG_KDA_HE_T,

JSDF_M_AAG_KDA_AP_T,JSDF_M_AAG_KDA_AP_T,JSDF_M_AAG_KDA_AP_T,JSDF_M_AAG_KDA_AP_T,JSDF_M_AAG_KDA_AP_T,JSDF_M_AAG_KDA_AP_T,JSDF_M_AAG_KDA_AP_T,JSDF_M_AAG_KDA_AP_T,JSDF_M_AAG_KDA_AP_T,JSDF_M_AAG_KDA_AP_T,
JSDF_M_AAG_KDA_AP_T,JSDF_M_AAG_KDA_AP_T,JSDF_M_AAG_KDA_AP_T,JSDF_M_AAG_KDA_AP_T,JSDF_M_AAG_KDA_AP_T,JSDF_M_AAG_KDA_AP_T,JSDF_M_AAG_KDA_AP_T,JSDF_M_AAG_KDA_AP_T,JSDF_M_AAG_KDA_AP_T,JSDF_M_AAG_KDA_AP_T
				};
				class GunFire			: WeaponFireGun_KDA	{};
				class GunClouds			: WeaponCloudsGun_KDA	{};
				class Turrets			: Turrets
				{
					class CommanderOptics		: CommanderOptics
					{
						animationSourceHatch	="Turret_hatch";
						inGunnerMayFire 	= 1;

						minElev=-5;	maxElev=+85;	initElev=0;

						gunnerAction		= Abrams_CommanderOut;
						gunnerInAction		= Abrams_Commander;
						gunnerOpticsModel	="\ca\Tracked\optika_M1A1_commander";
					};
				};
			};
		};
		fireDustEffect		="FDustEffects_KDA";
		class AnimationSources
		{
			class KDA_HE				{weapon="JSDF_W_AAG_KDA_HE";	source="revolving";		};
			class KDA_AP		:KDA_HE		{weapon="JSDF_W_AAG_KDA_AP";					};
			class radar				{animPeriod= 1;	initPhase= 0;	source="user";			};
			class radars		:radar		{								};
			class radars_fold	:radar		{								};
		};
		class UserActions
		{
			class radars_down
			{
				displayName	="radars down";
				position	="radar_pos";
				radius		= 5;
				condition	="this animationPhase ""radars_switch"" == 0";
				statement	="this exec""\JSDF_VLA\87AW\87aw_radars_down.sqs"";";
				onlyForPlayer	= 0;
			};
			class radars_up		:radars_down
			{
				displayName	="radars up";
				condition	="this animationPhase ""radars_switch"" == 1";
				statement	="this exec""\JSDF_VLA\87AW\87aw_radars_up.sqs"";";
			};
			class radar_on		:radars_down
			{
				displayName	="radar ON";
				condition	="this animationPhase ""radars_switch"" == 0";
				statement	="this exec""\JSDF_VLA\87AW\87aw_radar_on.sqs"";";
			};
			class radar_off		:radar_on
			{
				displayName	="radar OFF";
				condition	="this animationPhase ""radars_switch"" ==-1";
				statement	="this exec""\JSDF_VLA\87AW\87aw_radar_off.sqs"";";
			};
		};
	};
};