#define TEast 0
#define TWest 1
#define TGuerrila 2
#define TCivilian 3
#define TSideUnknown 4
#define TEnemy 5
#define TFriendly 6
#define TLogic 7

#define true 1
#define false 0

#define private 0
#define protected 1
#define public 2

class CfgPatches
{
	class JMSDF_PS1
        {
		units[] = {"PS1","US1","US2","BOHFloat"};
		weapons[] = {};
			requiredVersion = 1.00;
			requiredAddons[] = {};
	};
};

class CfgTextureToMaterial
{
  class PS1
  {
     textures[]=
     {
	"JMSDF_PS1\PS1body.pac",
     };
     material="#PS1";
  };
  class US1
  {
     textures[]=
     {
	"JMSDF_PS1\US1body.pac",
     };
     material="#US1";
  };
  class US2
  {
     textures[]=
     {
	"JMSDF_PS1\US2body.pac",
     };
     material="#US2";
  };  
};

class CfgMaterials
{
	class PS1
  	{
		ambient[] = {1, 1, 1, 1};
		diffuse[] = {1, 1, 1, 1};
		forcedDiffuse[] = {0, 0, 0, 0};
		emmisive[] = {0, 0, 0, 1};
		specular[] = {1, 1, 1, 0.000000};
		specularPower = 20;
		PixelShaderID = "NormalMapSpecularDIMap";
		VertexShaderID = "NormalMap";
		class Stage1
		{
			texture = "JMSDF_PS1\PS1body_nohq.paa";
			uvSource = "tex";
			class uvTransform
			{
				aside[] = {1, 0, 0};
				up[] = {0, 1, 0};
				dir[] = {0, 0, 0};
				pos[] = {0, 0, 0};
			};
		};
		class Stage2
		{
			texture = "JMSDF_PS1\PS1body_smdi.paa";
			uvSource = "tex";
			class uvTransform
			{
				aside[] = {1, 0, 0};
				up[] = {0, 1, 0};
				dir[] = {0, 0, 0};
				pos[] = {0, 0, 0};
			};
		};
	};
	class US1
  	{
		ambient[] = {1, 1, 1, 1};
		diffuse[] = {1, 1, 1, 1};
		forcedDiffuse[] = {0, 0, 0, 0};
		emmisive[] = {0, 0, 0, 1};
		specular[] = {1, 1, 1, 0.000000};
		specularPower = 20;
		PixelShaderID = "NormalMapSpecularDIMap";
		VertexShaderID = "NormalMap";
		class Stage1
		{
			texture = "JMSDF_PS1\US1body_nohq.paa";
			uvSource = "tex";
			class uvTransform
			{
				aside[] = {1, 0, 0};
				up[] = {0, 1, 0};
				dir[] = {0, 0, 0};
				pos[] = {0, 0, 0};
			};
		};
		class Stage2
		{
			texture = "JMSDF_PS1\US1body_smdi.paa";
			uvSource = "tex";
			class uvTransform
			{
				aside[] = {1, 0, 0};
				up[] = {0, 1, 0};
				dir[] = {0, 0, 0};
				pos[] = {0, 0, 0};
			};
		};
	};
	class US2
  	{
		ambient[] = {1, 1, 1, 1};
		diffuse[] = {1, 1, 1, 1};
		forcedDiffuse[] = {0, 0, 0, 0};
		emmisive[] = {0, 0, 0, 1};
		specular[] = {1, 1, 1, 0.000000};
		specularPower = 20;
		PixelShaderID = "NormalMapSpecularDIMap";
		VertexShaderID = "NormalMap";
		class Stage1
		{
			texture = "JMSDF_PS1\US2body_nohq.pac";
			uvSource = "tex";
			class uvTransform
			{
				aside[] = {1, 0, 0};
				up[] = {0, 1, 0};
				dir[] = {0, 0, 0};
				pos[] = {0, 0, 0};
			};
		};
		class Stage2
		{
			texture = "JMSDF_PS1\US2body_smdi.paa";
			uvSource = "tex";
			class uvTransform
			{
				aside[] = {1, 0, 0};
				up[] = {0, 1, 0};
				dir[] = {0, 0, 0};
				pos[] = {0, 0, 0};
			};
		};
	};
}; 
class CfgVehicles
{
	class All {};
	class AllVehicles: All {};
	class Air: AllVehicles {};
	class Plane: Air {};
	class US1: Plane
	{
crew = "USMC_Soldier_Pilot";
		faction 		= JMSDF;
		Icon = "\JMSDF_PS1\icon.paa";
		picture = "\JMSDF_PS1\pic.paa";
		model="\JMSDF_PS1\US1";
		soundEngine[]={"\JMSDF_PS1\eng.ogg",4,1.2};
		displayName="US1A";
		side=1;
		maxSpeed=490;
		armor=50;
		scope=public;
		transportSoldier = 1;
		driverAction="Mi17_Pilot";
		cargoAction[]={"Mi17_Pilot","MH6_Cargo01"};
		accuracy=0.30;
		gearRetracting = false; 
		nameSound="plane";
		soundEnviron[]={"Objects\noise",db-60,1.0};			// Cessna sound
		soundServo[]={"Vehicles\gun_elevate",db-40,0.4};		// Cessna sound
		maneuvrability=30.0;
		ejectSpeed[]={0,0,0};
		flapsFrictionCoef = 0.5;
		cost=20000;
		type=VAir;
		threat[]={0.1, 1, 0.7};
		aileronSensitivity = 0.8; // relative aileron sensitivity
		elevatorSensitivity = 0.8; // relative elevator sensitivity
		noseDownCoef = 0.2; // how much goes nose down during turns
		landingAoa = 7*3.1415/180;
		brakeDistance=500; // vehicle movement precision
		steerAheadSimul=1.0;
		steerAheadPlan=2.0;
		hiddenSelections[]={"light"};
		extCameraPosition[]={0,8,-30};		// 0,5,-30 is standard Air class 
		class Reflectors {
			class Left {
				color[] = {0.5, 0.8, 1.0, 1.0};
				ambient[] = {0.07, 0.07, 0.07, 1.0};
				position = "L svetlo";
				direction = "konec L svetla";
				hitpoint = "L svetlo";
				selection = "L svetlo";
				size = 1;
				brightness = 0.7;
			};
			
			class Right {
				color[] = {0.5, 0.8, 1.0, 1.0};
				ambient[] = {0.07, 0.07, 0.07, 1.0};
				position = "P svetlo";
				direction = "konec P svetla";
				hitpoint = "P svetlo";
				selection = "P svetlo";
				size = 1;
				brightness = 0.7;
			};
		};
		// Radar stuff
		irTarget=true;
		irScanRange = 2000;
		irScanGround = true;
		// Weapon and ammo
		weapons[]={}; // none
		magazines[]={}; // none
		class AnimationSources
		{
			class gearL
			{
				animPeriod = 4;
			};
			class gearR
			{
				animPeriod = 4;
			};
			class gearL2
			{
				animPeriod = 2;
			};
			class gearR2
			{
				animPeriod = 2;
			};
			class gearF
			{
				animPeriod = 1;
			};
			class R_doorF
			{
				animPeriod = 1;
			};
			class L_doorF
			{
				animPeriod = 1;
			};
			class Rland
			{
				animPeriod = 4;
			};
			class Fland
			{
				animPeriod = 4;
			};
			class planebody
			{
				animPeriod = 1;
			};
		};
		class UserActions
		{
			class GearDown
			{
				displayName = "Gear down";
				position = "zamerny";
				radius = 10;
				onlyForPlayer= 0;
				condition = "this animationphase ""gearR"" == 0";
				statement = "this exec""\JMSDF_PS1\geardown.sqs"";";
			};
			class GearUp
			{
				displayName = "Gear up";
				position = "zamerny";
				radius = 10;
				onlyForPlayer= 0;
				condition = "this animationphase ""gearR"" == 1";
				statement = "this exec""\JMSDF_PS1\gearup.sqs"";";
			};
		};
		class EventHandlers
		{
			gear = "";
			init = "[_this select 0] exec""\JMSDF_PS1\init.sqs"";[_this select 0] exec ""\JMSDF_PS1\float.sqs"";";
			engine="";
			killed = "";
		};  
	};
	class US2 : US1 
	{
		model="\JMSDF_PS1\US2";
		displayName="US1Akai";
		maxSpeed=555;
	}; 
	class PS1 : US1 
	{
		model="\JMSDF_PS1\PS1";
		displayName="PS1";
		maxSpeed=545;
	}; 
	class land;
	class Static : land {};
	class BOHFloat: Static
      	{
		scope=public;
		hideUnitInfo=1;
		cost=0;
		mapSize=1;
		IRtarget = 0;
		displayName="BOHFloat";
		model="\JMSDF_PS1\BOHFloat.p3d";
	};
};


