class CfgPatches
{
	class JSDF_Air_P3
	{
		units[] = {"JMSDF_P3C"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {};
	};
};
class CfgVehicles
{
	class JSDF_Air				;
	class JSDF_Air_P3_Base			: JSDF_Air
	{
		faction 			= JMSDF;
		displayName			= P-3C;
		model				= jsdf_air\P3\jmsdf_p3c;
		picture				="jsdf_air\P3\p3c_ico1_ca.paa";
		Icon				="jsdf_air\P3\ico_P3C_ca.paa";
		mapSize				= 35.5;

		accuracy			=0.30;
		cost				=20000000;
		type				=2;

		extCameraPosition[] 		= {0, 3, -30};
		typicalCargo[]			={"USMC_Soldier_Pilot", "USMC_Soldier"};
		crew 				= "USMC_Soldier_Pilot";
		driverAction 			= "C130_Pilot";
		cargoAction[] 			= {HMMWV_Cargo01};
		hasGunner 			= 1;
		driverIsCommander 		= 1;
		transportSoldier 		= 1;
		transportMaxMagazines 		= 150;
		transportMaxWeapons 		= 30;
		
		irScanRangeMin			= 3500;
		laserScanner			= 0;
		threat[] 			= {0.1, 0.5, 0.8};
		gunAimDown			= 0.07;
		weapons[]			={};
		magazines[]			={};
		
		armor				= 50;
		damageResistance		= 0.01246;
		armorStructured			= 1;

		maxSpeed			= 745;
		fov 				= 0.5;
		precision			= 200;
		brakeDistance			= 500;
		steerAheadSimul			= 1.0;
		steerAheadPlan			= 2.0;
		wheelSteeringSensitivity	= 1.0;
		gearUpTime			= 5;
		gearDownTime			= 5;
		aileronSensitivity		= 0.85;
		elevatorSensitivity		= 0.92;
		flapsFrictionCoef		= 0.6;
		envelope[] 			= {0.0, 0.1, 0.5, 1.5, 3.1, 4.3, 4.9, 5, 4.4, 2.8, 1.6, 0.8, 0};
		landingAoa 			= "rad 7";
		landingSpeed 			= 200;
				
		soundGetIn[]			={\ca\air\Data\Sound\heli_door1,db-20,1};
		soundGetOut[]			={\ca\air\Data\Sound\heli_door1,db-20,1};
		soundEngine[]			={"\JSDF_Air\P3\eng.wss", 4, 1};
		insideSoundCoef			= 0.2;
		class Sounds
		{
			class EngineLowOut {
				sound[] = {"ca\sounds\Air\C130\ext_engine_low", 1.77828, 1, 900};
				frequency = "1.0 min (rpm + 0.5)";
				volume = "camPos*engineOn*(rpm factor[0.85, 0])";
			};
			
			class EngineHighOut {
				sound[] = {"ca\sounds\Air\C130\ext_engine_hi", 1.77828, 1, 1100};
				frequency = "1";
				volume = "camPos*engineOn*(rpm factor[0.55, 1.0])";
			};
			
			class ForsageOut {
				sound[] = {"ca\sounds\Air\C130\ext_forsage_1", 1.41254, 1, 1500};
				frequency = "1";
				volume = "camPos*engineOn*(thrust factor[0.5, 1.0])";
				cone[] = {1.14, 3.92, 2.0, 0.4};
			};
			
			class WindNoiseOut {
				sound[] = {"ca\sounds\Air\C130\ext-wind1", 0.001, 0.6, 150};
				frequency = "(0.1+(1.2*(speed factor[1, 100])))";
				volume = "camPos*(speed factor[1, 100])";
			};
			
			class EngineLowIn {
				sound[] = {"ca\sounds\Air\C130\int_engine_low", 1.0, 1.0};
				frequency = "1.0 min (rpm + 0.5)";
				volume = "(1-camPos)*(engineOn*(rpm factor[0.85, 0]))";
			};
			
			class EngineHighIn {
				sound[] = {"ca\sounds\Air\C130\int_engine_hi", 1.0, 1.0};
				frequency = "1";
				volume = "(1-camPos)*(engineOn*(rpm factor[0.55, 1.0]))";
			};
			
			class ForsageIn {
				sound[] = {"ca\sounds\Air\C130\int_forsage_1", 1.41254, 1.1};
				frequency = "1";
				volume = "(1-camPos)*(engineOn*(thrust factor[0.5, 1.0]))";
			};
			
			class WindNoiseIn {
				sound[] = {"ca\sounds\Air\C130\int-wind1", 0.001, 0.6};
				frequency = "(0.1+(1.2*(speed factor[1, 100])))";
				volume = "(1-camPos)*(speed factor[1, 100])";
			};
		};
		
		hiddenselections[]		= {"bangou_1","bangou_2"};
		dammageHalf[]			={};
		dammageFull[]			={};
		class Damage
		{
			tex[] = {};
			mat[] = {
				"jsdf_air\p3\p3c_0101.rvmat", 
				"jsdf_air\p3\p3c_0101_damage.rvmat", 
				"jsdf_air\p3\p3c_0101_destruct.rvmat", 
				"jsdf_air\p3\p3c_0102.rvmat", 
				"jsdf_air\p3\p3c_0102_damage.rvmat", 
				"jsdf_air\p3\p3c_0102_destruct.rvmat",
				"jsdf_air\p3\p3c_0103.rvmat", 
				"jsdf_air\p3\p3c_0103_damage.rvmat", 
				"jsdf_air\p3\p3c_0103_damage.rvmat", 
			};
		};
		class EventHandlers 
		{
		init = "[_this select 0] exec ""\jsdf_air\p3\script\P3Cno.sqs"";";
		};
		class AnimationSources
		{
			class bombbay_R
			{
				source = "user";
				animPeriod = 1;
				initPhase=0;
			};
			class bombbay_L : bombbay_R
			{
			};
		};
		class Reflectors
		{
			class Left
			{
				color[] = {1, 1, 0.8, 1.0};
				//color[] = {0.8, 0.8, 1.0, 1.0};
				ambient[] = {0.07, 0.07, 0.07, 1.0};
				position = "light_L";
				direction = "light_L_end";
				hitpoint = "svetloPL";
				selection = "svetloPL";
				size = 1;
				brightness = 0.5;
			};
			class right : left
			{
				color[] = {0.8, 0.8, 1.0, 1.0};
				ambient[] = {0.07, 0.07, 0.07, 1.0};
				position = "light_R";
				direction = "light_R_end";
				hitpoint = "svetloPP";
				selection = "svetloPP";
				size = 1;
				brightness = 0.5;
			};
			class LeftW
			{
				color[] = {1, 1, 0.8, 1.0};
				ambient[] = {0.07, 0.07, 0.07, 1.0};
				position = "light_L_W";
				direction = "light_L_W_end";
				hitpoint = "L svetlo"; 
				selection = "L svetlo";
				size = 1;
				brightness = 2.5;
			};
			class rightW : leftW
			{
				color[] = {1, 1, 0.8, 1.0};
				position = "light_R_W";
				direction = "light_R_W_end";
				hitpoint = "P svetlo"; 
				selection = "P svetlo";
				size = 1;
				brightness = 2.5;
			};
		};
		class Library
		{
		  	libTextDesc = $STR_LIB_AV8B;
		};
	};
	class JMSDF_P3C 			: JSDF_Air_P3_Base
	{
		scope 				= 2;
		model 				= "\JSDF_Air\P3\JMSDF_P3C";
	};
};
