class CfgMovesBasic
{
	class DefaultDie;
	class ManActions{JSDF_F2_pilot = "JSDF_F2_pilot";};
};
class CfgMovesWomen : CfgMovesBasic
{
	class DefaultDie;
	class ManActions{JSDF_F2_pilot = "";	};
};
class CfgMovesMaleSdr : CfgMovesBasic
{
	class States
	{
		class JSDF_F2_pilot_dead : DefaultDie
		{
			actions 	= "DeadActions";
			file 		= "\JSDF_Air\F_2\F2_Pilot_dead";
			speed 		= 0.5;
			terminal 	= 1;
			soundEnabled 	= 0;
			looped 		= 0;
			connectTo[] 	= {"DeadState", 0.1};
		};
		class Crew;
		class JSDF_F2_pilot 	: Crew
		{
			file 		= "\JSDF_Air\F_2\F2_pilot";
			connectTo[] 	= {"JSDF_F2_pilot_dead", 1};
		};
	};
};
class CfgPatches
{
	class JSDF_Air_F2
	{
		units[] = {"JASDF_XF2","JASDF_F2A","JASDF_F2B"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {};
	};
};
class cfgWeapons
{
	class JSDF_W_SRM		;
	class JSDF_W_LAMS6x4		: JSDF_W_SRM
	{
		magazines[]		=
		{
			JSDF_M_AIM_9Lx4,
			JSDF_M_AIM_9Lnx4,
			JSDF_M_AAM_3x4,
			JSDF_M_AAM_5x4,
		};
		minRange=10;minRangeProbab=0.10;
		midRange=3400;midRangeProbab=0.7;
		maxRange=6000;maxRangeProbab=0.001;
	};
	class JSDF_W_MRM		;
	class JSDF_W_LAMS5x4		: JSDF_W_MRM
	{
		magazines[]		=
		{
			JSDF_M_AIM_7Mx4,
			JSDF_M_AAM_4x4
		};
		minRange=  200;minRangeProbab=0.10;
		midRange= 9000;midRangeProbab=0.7;
		maxRange=70000;maxRangeProbab=0.001;
	};
};
class CfgVehicles
{
	class JSDF_Air				;
	class JSDF_Air_F2_Base			: JSDF_Air
	{
		cost 				= 10000000;
		faction 			= JASDF;
		displayName 			= F-2;
		model 				="\jsdf_air\F_2\jasdf_F2.p3d";
		picture 			="\jsdf_air\F_2\pic_F2_ca.paa";
		Icon 				="\jsdf_air\F_2\ico_F2_ca.paa";
		mapSize 			= 15.5;

		threat[] 			= {0.3, 0.1, 0.1};
		accuracy 			= 1000;

		weapons[] 			= {"JSDF_W_AAG_M61A1_F2",	"JSDF_W_LAMS5x4",	"JSDF_W_LAMS6x4"	};
		magazines[] 			= {"JSDF_M_AAG_20mm_F2",	"JSDF_M_AIM_7Mx4",	"JSDF_M_AIM_9Lnx4"	};
		laserScanner 			= 0;

		crew 				= "USMC_Soldier_Pilot";
		typicalCargo[] 			= {"USMC_Soldier_Pilot"};
		transportSoldier 		= 0;
		getInAction 			= "GetInHigh";
		getOutAction 			= "GetOutHigh";
		driverCompartments 		= 1;
		driverAction 			=  "JSDF_F2_pilot";
//		cargoAction[] 			= {"UH60_Pilot", "Mi17_Cargo02"};
//		cargoCompartments[] 		= {2, 4};
//		cargoIsCoDriver[] 		= {1, 0};
//		typicalCargo[] 			= {"USMC_Soldier_Pilot", "USMC_Soldier_Pilot"};

		armor 				= 60;
		armorStructured 		= 1;
		damageResistance 		= 0.00336;

		maxSpeed 			= 900;
		acceleration 			= 510;
		envelope[] 			= {0.0, 0.4, 1.90, 4.0, 6.8, 8.3, 8.5, 8.0, 7.2, 5.8, 4.0, 1.8, 0.5, 0};
		flapsFrictionCoef 		= 0.38;
		aileronSensitivity 		= 1.0;
		elevatorSensitivity 		= 1.0;
		landingAoa 			= "rad 5";
		landingSpeed 			= 235;
		gearUpTime 			= 4.5;
		gearDownTime 			= 3;

		soundEngine[]			={"\JSDF_Air\F_2\F2_eng.wss", 4, 1};
		class Sounds
		{
			class Engine
			{
				sound[] 	= {"JSDF_Air\F_2\F2_eng.wss", db10, 1.0, 800};
				frequency 	= "rotorSpeed";
				volume 		= "camPos*((rotorSpeed-0.72)*4)";
			};
			class EngineLowOut
			{
				sound[] 	= {"JSDF_Air\F_2\F2_ext_eng.wss", 2.5, 1.0, 1200};//start
				frequency 	= "1.0 min (rpm + 0.5)";
				volume 		= "engineOn*camPos*(rpm factor[0.85, 0])";
			};
			class EngineHighOut
			{
				sound[] 	= {"JSDF_Air\F_2\F2_ext_eng.wss", 2.5, 1.3, 1500};
				frequency 	= "1";
				volume 		= "engineOn*camPos*(rpm factor[0.55, 1.0])";
			};
			class ForsageOut
			{
				sound[] 	= {"JSDF_Air\F_2\F2_ext_for.wss", 2.5, 1.1, 3000};
				frequency 	= "1";
				volume 		= "engineOn*camPos*(thrust factor[0.5, 1.0])";
				cone[] 		= {3.14, 3.92, 2.0, 0.4};
			};
			class WindNoiseOut
			{
				sound[] 	= {"JSDF_Air\F_2\F2_ext_win.wss", 1.0, 1.0, 100};
				frequency 	= "(0.1+(1.2*(speed factor[1, 150])))";
				volume 		= "camPos*(speed factor[1, 150])";
			};
			class EngineLowIn {
				sound[] = {"ca\sounds\Air\AV8\int\int-av8b-engine-low", 0.794328, 1.0};
				frequency = "1.0 min (rpm + 0.5)";
				volume = "(1-camPos)*(engineOn*(rpm factor[0.85, 0]))";
			};
			
			class EngineHighIn {
				sound[] = {"ca\sounds\Air\AV8\int\int-av8b-engine", 0.794328, 1.0};
				frequency = "1";
				volume = "(1-camPos)*(engineOn*(rpm factor[0.55, 1.0]))";
			};
			
			class ForsageIn {
				sound[] = {"ca\sounds\Air\AV8\int\int-av8b-forsage-1", 0.794328, 1.1};
				frequency = "1";
				volume = "(1-camPos)*(engineOn*(thrust factor[0.8, 1.0]))";
			};
			
			class WindNoiseIn {
				sound[] = {"ca\sounds\Air\AV8\int\int-jetair-wind1", 0.707946, 1.0};
				frequency = "(0.1+(1.2*(speed factor[1, 150])))";
				volume = "(1-camPos)*(speed factor[1, 150])";
			};
		};
		class Reflectors
		{
			class Left
			{
				color[] 	= {1.0, 0.9, 0.9, 1.0};
				ambient[] 	= {0.8, 0.8, 0.8, 1.0};
				position 	= "light_FL";
				direction 	= "light_FL_dir";
				hitpoint 	= "light_FL";
				selection 	= "light_FL";
				size 		= 0.5;
				brightness 	= 0.8;
			};
			class Right		: Left
			{
				position 	= "light_FR";
				direction 	= "light_FR_dir";
				hitpoint 	= "light_FR";
				selection 	= "light_FR";
			};
		};
		aggregateReflectors[] 		= {{"Left", "Right"}};
	};
	class JASDF_F2A 			: JSDF_Air_F2_Base
	{
		scope 				= 2;
		model 				= "\JSDF_Air\F_2\JASDF_F2A";
	};
};
