class CfgMovesBasic
{
	class DefaultDie;
	class ManActions{JSDF_F1_pilot = "JSDF_F1_pilot";};
};
class CfgMovesWomen : CfgMovesBasic
{
	class DefaultDie;
	class ManActions{JSDF_F1_pilot = "";	};
};
class CfgMovesMaleSdr : CfgMovesBasic
{
	class States
	{
		class JSDF_F1_pilot_dead : DefaultDie
		{
			actions 	= "DeadActions";
			file 		= "\JSDF_Air\F_1\F1_Pilot_dead";
			speed 		= 0.5;
			terminal 	= 1;
			soundEnabled 	= 0;
			looped 		= 0;
			connectTo[] 	= {"DeadState", 0.1};
		};
		class Crew;
		class JSDF_F1_pilot 	: Crew
		{
			file 		= "\JSDF_Air\F_1\F1_pilot";
			connectTo[] 	= {"JSDF_F1_pilot_dead", 1};
		};
	};
};
class CfgPatches
{
	class JSDF_Air_F1
	{
		units[] = {"JASDF_F1"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {};
	};
};
class cfgWeapons
{
	class JSDF_W_SRM		;
	class JSDF_W_SRM_F1x2		: JSDF_W_SRM
	{
		magazines[]		=
		{
			JSDF_M_AIM_9Bx2,
			JSDF_M_AIM_9Ex2,
			JSDF_M_AIM_9Lx2,
			JSDF_M_AIM_9Lnx2,
			JSDF_M_AAM_3x2,
		};
		minRange=10;minRangeProbab=0.10;
		midRange=3400;midRangeProbab=0.7;
		maxRange=6000;maxRangeProbab=0.001;
	};
	class JSDF_W_SRM_F1x4		: JSDF_W_SRM_F1x2
	{
		magazines[]		=
		{
			JSDF_M_AIM_9Bx4,
			JSDF_M_AIM_9Ex4,
			JSDF_M_AIM_9Lx4,
			JSDF_M_AIM_9Lnx4,
			JSDF_M_AAM_3x4,
		};
	};
};
class CfgVehicles
{
	class JSDF_Air				;
	class JSDF_Air_F1_Base			: JSDF_Air
	{
		cost 				= 10000000;
		faction 			= JASDF;
		displayName 			= F-1;
		model 				= "\ca\air\ah1z";
		picture 			="\ca\air\data\ico\ah1z_CA.paa";
		Icon 				="\JSDF_Air\F_1\ico_F1_ca.paa";
		mapSize 			= 18.25;

		threat[] 			= {0.3, 0.1, 0.1};
		accuracy 			= 1000;

		weapons[] 			= {"JSDF_W_AAG_M61A1_F1",	"JSDF_W_SRM_F1x2"	};
		magazines[] 			= {"JSDF_M_AAG_20mm_F1",	"JSDF_M_AIM_9Lnx2"	};
		laserScanner 			= 0;

		crew 				= "USMC_Soldier_Pilot";
		typicalCargo[] 			= {"USMC_Soldier_Pilot"};
		transportSoldier 		= 0;
		getInAction 			= "GetInHigh";
		getOutAction 			= "GetOutHigh";
		driverCompartments 		= 1;
		driverAction 			=  "JSDF_F1_pilot";
//		cargoAction[] 			= {"UH60_Pilot", "Mi17_Cargo02"};
//		cargoCompartments[] 		= {2, 4};
//		cargoIsCoDriver[] 		= {1, 0};
//		typicalCargo[] 			= {"USMC_Soldier_Pilot", "USMC_Soldier_Pilot"};

		armor 				= 60;
		armorStructured 		= 1;
		damageResistance 		= 0.00336;

		maxSpeed 			= 900;
		acceleration 			= 310;
		envelope[] 			= {0.0, 0.4, 1.90, 4.0, 6.8, 8.3, 8.5, 8.0, 7.2, 5.8, 4.0, 1.8, 0.5, 0};
		flapsFrictionCoef 		= 0.38;
		aileronSensitivity 		= 1.0;
		elevatorSensitivity 		= 1.0;
		landingAoa 			= "rad 5";
		landingSpeed 			= 235;
		gearUpTime 			= 4.5;
		gearDownTime 			= 3;

		class Sounds
		{
			class Engine
			{
				sound[] 	= {"JSDF_Air\F_1\F1_eng.wss", db10, 1.0, 800};
				frequency 	= "rotorSpeed";
				volume 		= "camPos*((rotorSpeed-0.72)*4)";
			};
			class EngineLowOut
			{
				sound[] 	= {"JSDF_Air\F_1\F1_ext_eng.wss", 2.51189, 1.0, 1200};//start
				frequency 	= "1.0 min (rpm + 0.5)";
				volume 		= "engineOn*camPos*(rpm factor[0.85, 0])";
			};
			class EngineHighOut
			{
				sound[] 	= {"JSDF_Air\F_1\F1_ext_eng.wss", 2.51189, 1.3, 1500};
				frequency 	= "1";
				volume 		= "engineOn*camPos*(rpm factor[0.55, 1.0])";
			};
			class ForsageOut
			{
				sound[] 	= {"JSDF_Air\F_1\F1_ext_for.wss", 2.5, 1.1, 3000};
				frequency 	= "1";
				volume 		= "engineOn*camPos*(thrust factor[0.5, 1.0])";
				cone[] 		= {3.14, 3.92, 2.0, 0.4};
			};
			class WindNoiseOut
			{
				sound[] 	= {"JSDF_Air\F_1\F1_ext_win.wss", 1.0, 1.0, 100};
				frequency 	= "(0.1+(1.2*(speed factor[1, 150])))";
				volume 		= "camPos*(speed factor[1, 150])";
			};
			class EngineLowIn {
				sound[] = {"ca\sounds\Air\AV8\int\int-av8b-engine-low", 0.794328, 1.0};
				frequency = "1.0 min (rpm + 0.5)";
				volume = "(1-camPos)*(engineOn*(rpm factor[0.85, 0]))";
			};
			
			class EngineHighIn {
				sound[] = {"ca\sounds\Air\AV8\int\int-av8b-engine", 0.794328, 1.0};
				frequency = "1";
				volume = "(1-camPos)*(engineOn*(rpm factor[0.55, 1.0]))";
			};
			
			class ForsageIn {
				sound[] = {"ca\sounds\Air\AV8\int\int-av8b-forsage-1", 0.794328, 1.1};
				frequency = "1";
				volume = "(1-camPos)*(engineOn*(thrust factor[0.8, 1.0]))";
			};
			
			class WindNoiseIn {
				sound[] = {"ca\sounds\Air\AV8\int\int-jetair-wind1", 0.707946, 1.0};
				frequency = "(0.1+(1.2*(speed factor[1, 150])))";
				volume = "(1-camPos)*(speed factor[1, 150])";
			};
		};
		class Reflectors
		{
			class Left
			{
				color[] 	= {1.0, 0.5, 0.3, 1.0};
				ambient[] 	= {0.7, 0.7, 0.7, 1.0};
				position 	= "light_L";
				direction 	= "light_L_dir";
				hitpoint 	= "light_L";
				selection 	= "light_L";
				size 		= 0.7;
				brightness 	= 0.7;
			};
			class Right		: Left
			{
				position 	= "light_R";
				direction 	= "light_R_dir";
				hitpoint 	= "light_R";
				selection 	= "light_R";
			};
		};
		aggregateReflectors[] 		= {{"Left", "Right"}};
	};
	class JASDF_F1	 			: JSDF_Air_F1_Base
	{
		scope 				= 2;
		model 				= "\JSDF_Air\F_1\JASDF_F1";
	};
};
