class CfgMovesBasic
{
	class DefaultDie;
	class ManActions
	{
		JSDF_F4_pilot	= "JSDF_F4_pilot";
		JSDF_F4_gunner	= "JSDF_F4_gunner";
	};
};
class CfgMovesWomen 	: CfgMovesBasic
{
	class DefaultDie;
	class ManActions
	{
		JSDF_F4_pilot	= "";
		JSDF_F4_gunner	= "";
	};
};
class CfgMovesMaleSdr 	: CfgMovesBasic
{
	class States
	{
		class JSDF_F4_pilot_dead : DefaultDie
		{
			actions 	= "DeadActions";
			file 		= "\JSDF_Air\F4\F4_Pilot_dead";
			speed 		= 0.5;
			terminal 	= 1;
			soundEnabled 	= 0;
			looped 		= 0;
			connectTo[] 	= {"DeadState", 0.1};
		};
		class Crew;
		class JSDF_F4_pilot 	: Crew
		{
			file 		= "\JSDF_Air\F4\F4_pilot";
			connectTo[] 	= {"JSDF_F4_pilot_dead", 1};
		};
		class JSDF_F4_gunner_dead : DefaultDie
		{
			actions 	= "DeadActions";
			file 		= "\JSDF_Air\F4\F4_gunner_dead";
			speed 		= 0.5;
			terminal 	= 1;
			soundEnabled 	= 0;
			looped 		= 0;
			connectTo[] 	= {"DeadState", 0.1};
		};
		class JSDF_F4_gunner 	: Crew
		{
			file 		= "\JSDF_Air\F4\F4_gunner";
			connectTo[] 	= {"JSDF_F4_gunner_dead", 1};
		};
	};
};
class CfgPatches
{
	class JSDF_Air_F4
	{
		units[] = {"JASDF_F4EJ"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {};
	};
};
class cfgWeapons
{
	class JSDF_W_SRM		;
	class JSDF_W_LAU_42Ax4		: JSDF_W_SRM
	{
		magazines[]		={JSDF_M_AIM_4Dx4,JSDF_M_ATM_4Dx4,JSDF_M_AAM_2x4};
		weaponLockSystem 	= 8;
		cmImmunity 		= 0.1;
		weaponLockDelay 	= 5;
	};
	class JSDF_W_AERO_3Bx4		: JSDF_W_SRM
	{
		htMin = 1;
		htMax = 420;
		afMax = 0;
		mfMax = 0;
		mFact = 1;
		tBody = 100;
		magazines[]		={JSDF_M_AIM_9Bx4,JSDF_M_AIM_9Ex4,JSDF_M_AIM_9Jx4,JSDF_M_AIM_9Lx4,JSDF_M_AIM_9Lnx4,};
	};
	class JSDF_W_LAMS4x4		: JSDF_W_SRM
	{
		magazines[]		={JSDF_M_AIM_9Bx4,JSDF_M_AIM_9Ex4,JSDF_M_AIM_9Jx4,JSDF_M_AIM_9Lx4,JSDF_M_AIM_9Lnx4,JSDF_M_AAM_1x4,JSDF_M_AAM_2x4,JSDF_M_AAM_3x4,JSDF_M_AAM_5x4,	};
		weaponLockSystem 	= 8;
		cmImmunity 		= 0.8;
		weaponLockDelay 	= 5;
	};

	class JSDF_W_MRM		;
	class JSDF_W_AERO_7Ax4		: JSDF_W_MRM
	{
		magazines[]		={JSDF_M_AIM_7Ex4,JSDF_M_AIM_7Fx4,JSDF_M_AIM_7Fnx4,JSDF_M_AIM_7Mx4};
		weaponLockSystem 	= 4;
		weaponLockDelay 	= 4;
	};
};
class CfgVehicles
{
	class JSDF_Air				;
	class JSDF_Air_F4_Base			: JSDF_Air
	{
		cost 				= 10000000;
		faction 			= JASDF;
		displayName 			= F-4EJ;
		model 				="\ca\air\ah1z";
		picture 			="\JSDF_Air\F4\pic_F4_ca.paa";
		Icon 				="\JSDF_Air\F4\ico_F4_ca.paa";
		mapSize 			= 19.5;

		threat[] 			= {0.3, 0.1, 0.1};
		accuracy 			= 1000;

		laserScanner 			= 0;

		crew 				= "USMC_Soldier_Pilot";
		typicalCargo[] 			= {"USMC_Soldier_Pilot"};
		transportSoldier 		= 1;
		getInAction 			= "GetInHigh";
		getOutAction 			= "GetOutHigh";
		driverCompartments 		= 1;
		driverAction 			=  "JSDF_F4_pilot";
//		cargoAction[] 			= {"JSDF_F4_pilot"};
//		cargoCompartments[] 		= {2, 4};
//		cargoIsCoDriver[] 		= {1, 0};
//		typicalCargo[] 			= {"USMC_Soldier_Pilot", "USMC_Soldier_Pilot"};
//		hasGunner 			= 1;

		class NewTurret;
		class Turrets
		{
			class MainTurret 	: NewTurret
			{
				body 				= "";
				gun 				= "";
				commanding 			= -1;
				memoryPointsGetInGunner 	= "pos_gunner";
				memoryPointsGetInGunnerDir 	= "pos_gunner_dir";
				weapons[] 			= {"JSDF_W_AAG_M61A1_F4",	"JSDF_W_AERO_7Ax4",	"JSDF_W_AERO_3Bx4"	};
				magazines[] 			= {"JSDF_M_AAG_20mm_F4",	"JSDF_M_AIM_7Mx4",	"JSDF_M_AIM_9Lnx4"	};
				castGunnerShadow 		= 1;
				viewGunnerShadow 		= 1;
				gunnerAction 			= "JSDF_F4_Gunner";
				gunnerInAction 			= "JSDF_F4_Gunner";
			};
		};

		armor 				= 60;
		armorStructured 		= 1;
		damageResistance 		= 0.00336;

		maxSpeed 			= 900;
		acceleration 			= 230;
		envelope[] 			= {0.0, 0.4, 3, 5, 8, 8.3, 8.5, 8, 7.2, 5.8, 4, 1.8, 0.5, 0};
		flapsFrictionCoef 		= 0.35;
		aileronSensitivity 		= 1.5;
		elevatorSensitivity 		= 1.3;
		landingAoa 			= "rad 5";
		landingSpeed 			= 235;
		gearUpTime 			= 4.5;
		gearDownTime 			= 3;

		class Sounds
		{
			class EngineLowOut
			{
				sound[] 	= {"ca\sounds\Air\AV8\ext\ext-jetair-engine-low1", 2.51189, 1.0, 1200};
				frequency 	= "1.0 min (rpm + 0.5)";
				volume 		= "engineOn*camPos*(rpm factor[0.85, 0])";
			};
			
			class EngineHighOut
			{
				sound[] 	= {"ca\sounds\Air\AV8\ext\ext-jetair-engine-high3", 2.51189, 1.3, 1500};
				frequency 	= "1";
				volume 		= "engineOn*camPos*(rpm factor[0.55, 1.0])";
			};
			
			class ForsageOut {
				sound[] = {"ca\sounds\Air\AV8\ext\ext-jetair-forsage1", 2.51189, 1.1, 2000};
				frequency = "1";
				volume = "engineOn*camPos*(thrust factor[0.5, 1.0])";
				cone[] = {3.14, 3.92, 2.0, 0.4};
			};
			
			class WindNoiseOut {
				sound[] = {"ca\sounds\Air\AV8\ext\ext-jetair-wind1", 1.0, 1.0, 100};
				frequency = "(0.1+(1.2*(speed factor[1, 150])))";
				volume = "camPos*(speed factor[1, 150])";
			};
			
			class EngineLowIn {
				sound[] = {"ca\sounds\Air\AV8\int\int-av8b-engine-low", 0.794328, 1.0};
				frequency = "1.0 min (rpm + 0.5)";
				volume = "(1-camPos)*(engineOn*(rpm factor[0.85, 0]))";
			};
			
			class EngineHighIn {
				sound[] = {"ca\sounds\Air\AV8\int\int-av8b-engine", 0.794328, 1.0};
				frequency = "1";
				volume = "(1-camPos)*(engineOn*(rpm factor[0.55, 1.0]))";
			};
			
			class ForsageIn {
				sound[] = {"ca\sounds\Air\AV8\int\int-av8b-forsage-1", 0.794328, 1.1};
				frequency = "1";
				volume = "(1-camPos)*(engineOn*(thrust factor[0.8, 1.0]))";
			};
			
			class WindNoiseIn {
				sound[] = {"ca\sounds\Air\AV8\int\int-jetair-wind1", 0.707946, 1.0};
				frequency = "(0.1+(1.2*(speed factor[1, 150])))";
				volume = "(1-camPos)*(speed factor[1, 150])";
			};
		};
		class Reflectors
		{
			class light_Front
			{
				color[] 	= {1.0, 0.8, 0.8, 1.0};
				ambient[] 	= {1.0, 1.0, 1.0, 1.0};
				position 	= "light_F";
				direction 	= "light_F_dir";
				hitpoint 	= "light_F";
				selection 	= "light_F";
				size 		= 0.5;
				brightness 	= 1.0;
			};
			class light_Front_gear	: light_Front
			{
				position 	= "light_Fst";
				direction 	= "light_Fst_dir";
				hitpoint 	= "light_Fst";
				selection 	= "light_Fst";
			};
		};
		aggregateReflectors[] 		= {{"light_Front", "light_Front_gear"}};
	};
	class JASDF_F4J 			: JSDF_Air_F4_Base
	{
		scope 				= 2;
		model 				= "\JSDF_Air\F4\JASDF_F4EJ_a";
	};
/*
	class JASDF_F4J_7e4d 			: JASDF_F4J
	{
		displayName 			= F-4EJ(7E 4D);
		model 				= "\JSDF_Air\F4\JGSDF_UH1B";
		weapons[] 			= {"JSDF_W_AAG_M61A1_F4",	"JSDF_W_AERO_7Ax4",	"JSDF_W_LAU_42Ax4"	};
		magazines[] 			= {"JSDF_M_AAG_20mm_F4",	"JSDF_M_AIM_7Ex4",	"JSDF_M_AIM_4Dx4"	};
	};
	class JASDF_F4J_7e4d_ 			: JASDF_F4J_7e4d
	{
		displayName 			= F-4EJ(7E 4D.TEST);
		magazines[] 			= {"JSDF_M_AAG_20mm_F4",	"JSDF_M_AIM_7Ex4",	"JSDF_M_ATM_4Dx4"	};
	};
	class JASDF_F4J_7e9b 			: JASDF_F4J
	{
		displayName 			= F-4EJ(7F 9B);
		magazines[] 			= {"JSDF_M_AAG_20mm_F4",	"JSDF_M_AIM_7Ex4",	"JSDF_M_AIM_9Bx4"	};
	};
	class JASDF_F4J_7f9e 			: JASDF_F4J
	{
		displayName 			= F-4EJ(7F 9E);
		magazines[] 			= {"JSDF_M_AAG_20mm_F4",	"JSDF_M_AIM_7Fx4",	"JSDF_M_AIM_9Ex4"	};
	};
	class JASDF_F4J_7f9j 			: JASDF_F4J
	{
		displayName 			= F-4EJ(7F 9J);
		magazines[] 			= {"JSDF_M_AAG_20mm_F4",	"JSDF_M_AIM_7Fx4",	"JSDF_M_AIM_9Jx4"	};
	};
	class JASDF_F4J_7f9l 			: JASDF_F4J
	{
		displayName 			= F-4EJ(7F 9L);
		magazines[] 			= {"JSDF_M_AAG_20mm_F4",	"JSDF_M_AIM_7Fnx4",	"JSDF_M_AIM_9Lx4"	};
	};
*/
};
