class CfgMovesBasic
{
	class DefaultDie;
	class ManActions{JSDF_F15_pilot = "JSDF_F15_pilot";};
};
class CfgMovesWomen : CfgMovesBasic
{
	class DefaultDie;
	class ManActions{JSDF_F15_pilot = "";	};
};
class CfgMovesMaleSdr : CfgMovesBasic
{
	class States
	{
		class JSDF_F15_pilot_dead : DefaultDie
		{
			actions 	= "DeadActions";
			file 		= "\JSDF_Air\F15\F15_Pilot_dead";
			speed 		= 0.5;
			terminal 	= 1;
			soundEnabled 	= 0;
			looped 		= 0;
			connectTo[] 	= {"DeadState", 0.1};
		};
		class Crew;
		class JSDF_F15_pilot 	: Crew
		{
			file 		= "\JSDF_Air\F15\F15_pilot";
			connectTo[] 	= {"JSDF_F15_pilot_dead", 1};
		};
	};
};
class CfgPatches
{
	class JSDF_Air_F15
	{
		units[] = {"JASDF_F15J"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {};
	};
};
class cfgWeapons
{
	class JSDF_W_SRM		;
	class JSDF_W_LAU_114A_Ax4	: JSDF_W_SRM
	{
		magazines[]		=
		{
			JSDF_M_AIM_9Bx4,
			JSDF_M_AIM_9Ex4,
			JSDF_M_AIM_9Lx4,
			JSDF_M_AIM_9Lnx4,
			JSDF_M_AAM_3x4,
			JSDF_M_AAM_5x4,
		};
		minRange=10;minRangeProbab=0.10;
		midRange=3400;midRangeProbab=0.7;
		maxRange=6000;maxRangeProbab=0.001;
	};
	class JSDF_W_MRM		;
	class JSDF_W_LAU_128A_Ax4	: JSDF_W_MRM
	{
		magazines[]		=
		{
			JSDF_M_AIM_9Bx4,
			JSDF_M_AIM_9Ex4,
			JSDF_M_AIM_9Lx4,
			JSDF_M_AIM_9Lnx4,
			JSDF_M_AIM_120Bx4,
		};
		minRange=  200;minRangeProbab=0.10;
		midRange= 9000;midRangeProbab=0.7;
		maxRange=70000;maxRangeProbab=0.001;
	};
	class JSDF_W_LAU_106A_Ax4	: JSDF_W_MRM
	{
		magazines[]		=
		{
			JSDF_M_AIM_7Mx4,
			JSDF_M_AAM_4x4
		};
		minRange=  200;minRangeProbab=0.10;
		midRange= 9000;midRangeProbab=0.7;
		maxRange=70000;maxRangeProbab=0.001;
	};
};
class CfgVehicles
{
	class JSDF_Air				;
	class JSDF_Air_F15_Base			: JSDF_Air
	{
		cost 				= 10000000;
		faction 			= JASDF;
		displayName 			= F-15;
		model 				="\ca\air\ah1z";
		picture 			="\ca\air\data\ico\ah1z_CA.paa";
		Icon 				="\JSDF_Air\F15\ico_F15_ca.paa";
		mapSize 			= 19.5;

		threat[] 			= {0.3, 0.1, 0.1};
		accuracy 			= 1000;

		weapons[] 			= {"JSDF_W_AAG_M61A1_F15",	"JSDF_W_LAU_106A_Ax4",	"JSDF_W_LAU_114A_Ax4"	};
		magazines[] 			= {"JSDF_M_AAG_20mm_F15",	"JSDF_M_AIM_7Mx4",	"JSDF_M_AIM_9Lnx4"	};
		laserScanner 			= 0;

		crew 				="USMC_Soldier_Pilot";
		typicalCargo[] 			= {"USMC_Soldier_Pilot"};
		transportSoldier 		= 0;
		getInAction 			="GetInHigh";
		getOutAction 			="GetOutHigh";
		driverCompartments 		= 1;
		driverAction 			="JSDF_F15_pilot";
//		cargoAction[] 			= {"UH60_Pilot", "Mi17_Cargo02"};
//		cargoCompartments[] 		= {2, 4};
//		cargoIsCoDriver[] 		= {1, 0};
//		typicalCargo[] 			= {"USMC_Soldier_Pilot", "USMC_Soldier_Pilot"};

		armor 				= 60;
		armorStructured 		= 1;
		damageResistance 		= 0.00336;

		maxSpeed 			= 900;
		acceleration 			= 230;
		envelope[] 			= {0.0, 0.4, 3, 5, 8, 8.3, 8.5, 8, 7.2, 5.8, 4, 1.8, 0.5, 0};
		flapsFrictionCoef 		= 0.35;
		aileronSensitivity 		= 1.5;
		elevatorSensitivity 		= 1.3;
		landingAoa 			= "rad 5";
		landingSpeed 			= 235;
		gearUpTime 			= 4.5;
		gearDownTime 			= 3;

		class Sounds
		{
			class Engine
			{
				sound[] 	={"JSDF_Air\F15\F15_eng.wss", 2.5, 1.0, 800};
				frequency 	= "rotorSpeed";
				volume 		= "camPos*((rotorSpeed-0.72)*4)";
			};
			class EngineLowOut
			{
				sound[] 	={"JSDF_Air\F15\F15_eng_out_low.wss", 2.5, 1.0, 1200};
				frequency 	= "1.0 min (rpm + 0.5)";
				volume 		= "engineOn*camPos*(rpm factor[0.85, 0])";
			};
			class EngineHighOut
			{
				sound[] 	={"JSDF_Air\F15\F15_eng_out_hi.wss", 2.5, 1.5, 1300};
				frequency 	= "1";
				volume 		= "engineOn*camPos*(rpm factor[0.55, 1.0])";
			};
			class ForsageOut
			{
				sound[] 	= {"JSDF_Air\F15\F15_eng_out_for.wss", 2.5, 1.1, 3000};
				frequency 	= "1";
				volume 		= "engineOn*camPos*(thrust factor[0.5, 1.0])";
				cone[] 		= {3.14, 3.92, 2.0, 0.4};
			};
			
			class WindNoiseOut {
				sound[] = {"ca\sounds\Air\AV8\ext\ext-jetair-wind1", 1.0, 1.0, 100};
				frequency = "(0.1+(1.2*(speed factor[1, 150])))";
				volume = "camPos*(speed factor[1, 150])";
			};
			
			class EngineLowIn {
				sound[] = {"ca\sounds\Air\AV8\int\int-av8b-engine-low", 0.794328, 1.0};
				frequency = "1.0 min (rpm + 0.5)";
				volume = "(1-camPos)*(engineOn*(rpm factor[0.85, 0]))";
			};
			
			class EngineHighIn {
				sound[] = {"ca\sounds\Air\AV8\int\int-av8b-engine", 0.794328, 1.0};
				frequency = "1";
				volume = "(1-camPos)*(engineOn*(rpm factor[0.55, 1.0]))";
			};
			
			class ForsageIn {
				sound[] = {"ca\sounds\Air\AV8\int\int-av8b-forsage-1", 0.794328, 1.1};
				frequency = "1";
				volume = "(1-camPos)*(engineOn*(thrust factor[0.8, 1.0]))";
			};
			
			class WindNoiseIn {
				sound[] = {"ca\sounds\Air\AV8\int\int-jetair-wind1", 0.707946, 1.0};
				frequency = "(0.1+(1.2*(speed factor[1, 150])))";
				volume = "(1-camPos)*(speed factor[1, 150])";
			};
		};
		class Reflectors
		{
			class light_Front
			{
				color[] 	= {1.0, 0.8, 0.8, 1.0};
				ambient[] 	= {0.5, 0.5, 0.5, 1.0};
				position 	= "light_F";
				direction 	= "light_F_dir";
				hitpoint 	= "light_F";
				selection 	= "light_F";
				size 		= 0.5;
				brightness 	= 0.5;
			};
			class light_Front_gear	: light_Front
			{
				position 	= "light_Fst";
				direction 	= "light_Fst_dir";
				hitpoint 	= "light_Fst";
				selection 	= "light_Fst";
			};
		};
		aggregateReflectors[] 		= {{"light_Front", "light_Front_gear"}};
	};
	class JASDF_F15J 			: JSDF_Air_F15_Base
	{
		scope 				= 2;
		model 				= "\JSDF_Air\F15\JASDF_F15J";
	};
};
