/* 
 * Copyright 2009 Kazuhiro Sera. 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language 
 * governing permissions and limitations under the License. 
 */

package jp.sourceforge.jpnvalidator.util.file;

import jp.sourceforge.jpnvalidator.constant.Encoding;
import junit.framework.TestCase;

/**
 * SimpleFileReaderTest<br>
 * <br>
 * 
 * @author Kazuhiro Sera
 * @version 1.0
 */

public class SimpleFileReaderTest extends TestCase
{
	// *** テスト仕様 ***
	//
	// N001 sjis : Shift_JISのファイル内容を正しく読み込める事（128byte未満）
	// N002 sjis : Shift_JISのファイル内容を正しく読み込める事（128byte以上）
	// N003 utf8 : UTF-8のファイル内容を正しく読み込める事（128byte未満）
	// N004 utf8 : UTF-8のファイル内容を正しく読み込める事（128byte以上）
	// N005 euc : EUC-JPのファイル内容を正しく読み込める事（128byte未満）
	// N006 euc : EUC-JPのファイル内容を正しく読み込める事（128byte以上）
	//
	// *** テスト対象 ***
	//
	// SimpleFileReader#read2ByteArray(File)
	// SimpleFileReader#read2ByteArray(String)
	// SimpleFileReader#read2CharArray(File)
	// SimpleFileReader#read2CharArray(String)
	// SimpleFileReader#read2LineArray(File)
	// SimpleFileReader#read2LineArray(String)
	// SimpleFileReader#read2LineList(File)
	// SimpleFileReader#read2LineList(String)

	private static final String TEST_DATA_PATH = "jp/sourceforge/jpnvalidator/util/file/SimpleFileReaderTestData/";

	private SimpleFileReader reader = null;

	@Override
	protected void setUp() throws Exception
	{
		super.setUp();
		reader = new SimpleFileReader();
	}

	public void test_read2ByteArray_String_N001_sjis() throws Exception
	{
		String methodName = new Throwable().getStackTrace()[0].getMethodName();
		String filepath = TEST_DATA_PATH + methodName + ".txt";
		byte[] bytes = reader.read2ByteArray(filepath);
		String actualStr = new String(bytes, Encoding.MS932);
		String expectedStr = "128byte未満\r\n" + "1234567890\r\n" + "abcdedg\r\n" + "あかさたな";
		assertEquals(expectedStr, actualStr);
	}

	public void test_read2CharArray_String_N001_sjis() throws Exception
	{
		String methodName = new Throwable().getStackTrace()[0].getMethodName();
		String filepath = TEST_DATA_PATH + methodName + ".txt";
		char[] chars = reader.read2CharArray(filepath);
		String actualStr = new String(chars);
		String expectedStr = "128byte未満\r\n" + "1234567890\r\n" + "abcdedg\r\n" + "あかさたな";
		assertEquals(expectedStr, actualStr);
	}

	public void test_read2ByteArray_String_N002_sjis() throws Exception
	{
		String methodName = new Throwable().getStackTrace()[0].getMethodName();
		String filepath = TEST_DATA_PATH + methodName + ".txt";
		byte[] bytes = reader.read2ByteArray(filepath);
		String actualStr = new String(bytes, Encoding.MS932);
		String expectedStr = "128byte以上\r\n" + "1234567890\r\n" + "1234567890\r\n"
				+ "1234567890\r\n" + "1234567890\r\n" + "1234567890\r\n"
				+ "1234567890\r\n" + "1234567890\r\n" + "1234567890\r\n"
				+ "1234567890\r\n" + "1234567890\r\n" + "1234567890\r\n"
				+ "1234567890\r\n" + "1234567890\r\n" + "abcdedg\r\n" + "あかさたな";
		assertEquals(expectedStr, actualStr);
	}

	public void test_read2CharArray_String_N002_sjis() throws Exception
	{
		String methodName = new Throwable().getStackTrace()[0].getMethodName();
		String filepath = TEST_DATA_PATH + methodName + ".txt";
		char[] chars = reader.read2CharArray(filepath);
		String actualStr = new String(chars);
		String expectedStr = "128byte以上\r\n" + "1234567890\r\n" + "1234567890\r\n"
				+ "1234567890\r\n" + "1234567890\r\n" + "1234567890\r\n"
				+ "1234567890\r\n" + "1234567890\r\n" + "1234567890\r\n"
				+ "1234567890\r\n" + "1234567890\r\n" + "1234567890\r\n"
				+ "1234567890\r\n" + "1234567890\r\n" + "abcdedg\r\n" + "あかさたな";
		assertEquals(expectedStr, actualStr);
	}
}
