<?php
define('JINRO_ROOT', '../..');
require_once(JINRO_ROOT . '/include/init.php');
OutputInfoPageHeader('新役職情報 - [人狼陣営]', 2, 'new_role');
?>
<div id="main">
<?php include(JINRO_ROOT.'/info/new_role/menu.php'); ?>
<h1>人狼陣営</h1>
<p>
<a href="info/new_role/./" target="_top">&lt;-メニュー</a>
<a href="info/new_role/summary.php">←一覧表</a>
</p>
<p>
<a href="info/new_role/wolf.php#wolf_rule">基本ルール</a>
<a href="info/new_role/wolf.php#wolf_partner">仲間表示</a>
<a href="info/new_role/wolf.php#wolf_howl">遠吠え</a>
</p>
<p>
<a href="info/new_role/wolf.php#wolf_group">人狼系</a>
<a href="info/new_role/wolf.php#mad_group">狂人系</a>
</p>

<h2 id="wolf_rule">基本ルール</h2>
<pre>
夜の襲撃投票は全人狼共通で、最初に投票したものだけが有効になる。
(<a href="info/new_role/wolf.php#silver_wolf">銀狼</a>が先に投票したら他の人狼は投票できない)
人狼と<a href="info/new_role/wolf.php#silver_wolf">銀狼</a>は互いに認識できないので、味方を襲撃する可能性がある。
</pre>
<h3>Ver. 1.4.0 α21〜</h3>
<pre>
狼が狼を襲撃した場合は失敗扱いとなる。
<a href="info/new_role/fox.php">妖狐</a>と違い、襲撃された方にも何も表示されない。
</pre>

<h2 id="wolf_partner">仲間表示</h2>
<pre>
<a href="info/new_role/wolf.php#fanatic_mad">狂信者</a>と全ての人狼は<a href="info/new_role/wolf.php#silver_wolf">銀狼</a>以外の仲間の人狼が誰か分かります。
<a href="info/new_role/wolf.php#silver_wolf">銀狼</a>以外の全ての人狼は<a href="info/new_role/wolf.php#whisper_mad">囁き狂人</a>が誰か分かります。
<a href="info/new_role/human.php#unconscious">無意識</a>は<a href="info/new_role/wolf.php#silver_wolf">銀狼</a>も含めた全ての人狼から分かります。
<a href="info/new_role/sub_role.php#mind_lonely">はぐれ者</a>になると仲間が分からなくなります (<a href="info/new_role/wolf.php#silver_wolf">銀狼</a>と同じ)。
</pre>
<h3>Ver. 1.4.0 β8〜</h3>
<pre>
<a href="info/new_role/sub_role.php#mind_lonely">はぐれ者</a>になると仲間が分からなくなります (<a href="info/new_role/wolf.php#silver_wolf">銀狼</a>と同じ)。
</pre>
<h3>Ver. 1.4.0 α24〜</h3>
<pre>
<a href="info/new_role/human.php#unconscious">無意識</a>の枠に<a href="info/new_role/fox.php#scarlet_fox">紅狐</a>も混ざって表示されます。
</pre>
<h3>Ver. 1.4.0 α21〜</h3>
<pre>
<a href="info/new_role/wolf.php#silver_wolf">銀狼</a>は仲間の人狼、<a href="info/new_role/wolf.php#whisper_mad">囁き狂人</a>がいっさい分かりません。
</pre>

<h2 id="wolf_howl">遠吠え</h2>
<ol>
  <li>人狼視点の遠吠えは<a href="info/new_role/silver_wolf">銀狼</a>か<a href="info/new_role/sub_role.php#mind_lonely">はぐれ者</a>になった狼</li>
  <li><a href="info/new_role/silver_wolf">銀狼</a>・<a href="info/new_role/sub_role.php#mind_lonely">はぐれ者</a>になった狼視点の遠吠えは自分以外の狼 (種類は不明)</li>
  <li>村人視点の遠吠えは<a href="info/new_role/silver_wolf">銀狼</a>も含めた狼 (種類は不明)</li>
</ol>
<h3>Ver. 1.4.0 β8〜</h3>
<pre>
<a href="info/new_role/sub_role.php#mind_lonely">はぐれ者</a>になると夜の発言が独り言になります (<a href="info/new_role/wolf.php#silver_wolf">銀狼</a>と同じ)。
</pre>
<h3>Ver. 1.4.0 α23〜</h3>
<pre>
<a href="info/new_role/wolf.php#silver_wolf">銀狼</a>の独り言が他の人に遠吠えに見えます。
<a href="info/new_role/human.php#mind_scanner">さとり</a>には遠吠えはいっさい見えません。
</pre>
<h3>Ver. 1.4.0 α21〜</h3>
<pre>
<a href="info/new_role/wolf.php#silver_wolf">銀狼</a>の独り言は遠吠えになりません。
</pre>


<h2 id="wolf_group">人狼系</h2>
<p>
<a href="info/new_role/wolf.php#boss_wolf">白狼</a>
<a href="info/new_role/wolf.php#gold_wolf">金狼</a>
<a href="info/new_role/wolf.php#wise_wolf">賢狼</a>
<a href="info/new_role/wolf.php#poison_wolf">毒狼</a>
<a href="info/new_role/wolf.php#resist_wolf">抗毒狼</a>
<a href="info/new_role/wolf.php#cursed_wolf">呪狼</a>
<a href="info/new_role/wolf.php#blue_wolf">蒼狼</a>
<a href="info/new_role/wolf.php#emerald_wolf">翠狼</a>
<a href="info/new_role/wolf.php#sex_wolf">雛狼</a>
<a href="info/new_role/wolf.php#tongue_wolf">舌禍狼</a>
<a href="info/new_role/wolf.php#possessed_wolf">憑狼</a>
<a href="info/new_role/wolf.php#sirius_wolf">天狼</a>
<a href="info/new_role/wolf.php#elder_wolf">古狼</a>
<a href="info/new_role/wolf.php#cute_wolf">萌狼</a>
<a href="info/new_role/wolf.php#scarlet_wolf">紅狼</a>
<a href="info/new_role/wolf.php#silver_wolf">銀狼</a>
</p>

<h3 id="boss_wolf">白狼 (占い結果：村人 / 霊能結果：白狼) [Ver. 1.4.0 α3-7〜]</h3>
<pre>
他の国で言うところの「大狼」。
<a href="info/new_role/human.php#mage_group">占い師</a>を欺けるが、<a href="info/new_role/human.php#necromancer_group">霊能者</a>には見抜かれる。
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
シンプルな能力ですが、効果は絶大です。
占いが怖くないので LW を担うことを前提に立ち回ると効果的でしょう。
</pre>

<h3 id="gold_wolf">金狼 (占い結果：人狼 / 霊能結果：人狼) [Ver. 1.4.0 β8〜]</h3>
<pre>
<a href="info/new_role/human.php#sex_mage">ひよこ鑑定士</a>の判定が<a href="info/new_role/chiroptera.php">蝙蝠</a>になる人狼。
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
ローゼンメイデンの金糸雀がモチーフです。
一見地味ですが存在に気づかないと見事に騙される可能性があります。
<a href="info/new_role/chiroptera.php">蝙蝠陣営</a>不在が確定している場合は逆に<a href="info/new_role/human.php#sex_mage">ひよこ鑑定士</a>が脅威となる事に気をつけましょう。
</pre>

<h3 id="wise_wolf">賢狼 (占い結果：人狼 / 霊能結果：人狼) [Ver. 1.4.0 α24〜]</h3>
<pre>
<a href="info/new_role/fox.php#fox_talk">妖狐の念話</a>が共有者の囁きに変換されて聞こえる人狼。
結果として、念話ができる妖狐が生存していることだけが分かる。
本物の共有者の囁きと混ざって表示されるので本人には区別できない。
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
名称は他の国に実在しますが、仕様はオリジナルです。
狼サイドから妖狐の生存がわかります。
<a href="info/new_role/fox.php#silver_fox">銀狐</a>や<a href="info/new_role/fox.php#child_fox">子狐</a>など、念話できない妖狐の
生存は感知できないので注意してください。
</pre>

<h3 id="poison_wolf">毒狼 (占い結果：人狼 / 霊能結果：人狼) [Ver. 1.4.0 α12〜]</h3>
<h4>[毒能力] 吊り：人狼以外 / 襲撃：不可 / 薬師判定：有り</h4>
<pre>
毒能力を持った人狼。
吊られた時に巻き込む対象の決定時に人狼が除かれるため
投票者ランダムの場合は不発となるケースがある。
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
新役職考案スレ (最下参照) の 31 が原型です。
毒狼 CO した人を吊って誰も巻き込まれなかった場合は以下のケースがありえます。
1. <a href="info/new_role/human.php#pharmacist">薬師</a>が投票していた
2. 投票者ランダムの設定で、投票者が全員狼だった
3. 騙りだった

Ver. 1.4.0 α12 からは毒持ちを吊った時に巻き込まれる対象を設定で制限できます。
(設定は管理者に確認を取ってください)
「投票者ランダム」だった場合、この状況から推理を詰めることが可能になります。
<a href="info/new_role/human.php#pharmacist">薬師</a>が投票していない場合、毒狼を真と見るなら投票者に狼がいる事になります。
しかし、これが騙りの場合は・・・？
</pre>

<h3 id="resist_wolf">抗毒狼 (占い結果：人狼 / 霊能結果：人狼) [Ver. 1.4.0 α17〜]</h3>
<pre>
一度だけ毒に耐えられる(毒に中っても死なない)人狼です。
毒吊りの巻き込み、毒噛み両方に対応しています。
Ver. 1.4.0 α24 からは毒能力者を襲撃した場合はサーバ設定や能力失効の有無に
関わらず毒の対象が襲撃者に固定されます。
</pre>
<h4>Ver. 1.4.0 α24〜</h4>
<pre>
襲撃先が毒能力者で、投票者が抗毒狼だった場合はサーバ設定に関わらず
毒の対象者が投票した抗毒狼に固定されます。
ただし、能力を失効しても固定化処理は有効です。
つまり、<a href="info/new_role/human.php#poison_group">埋毒者</a>を意図的に襲撃して毒を無効化したり、
能力失効後にわざと毒に中りにいく事が可能になります。
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
新役職考案スレ (最下参照) の 25 を参考にしています。
現時点でほぼ無敵の能力を誇る<a href="info/new_role/human.php#poison_guard">騎士</a>への対抗策として作成しました。
安易に CO する騎士・埋毒者を葬ってやりましょう！
</pre>

<h3 id="cursed_wolf">呪狼 (占い結果：人狼(呪返し) / 霊能結果：呪狼) [Ver. 1.4.0 α17〜]</h3>
<pre>
占われたら占ってきた<a href="info/new_role/human.php#mage_group">占い師</a>を呪い殺す人狼です。
呪殺された占い師には襲撃されたときと同じ死亡メッセージが出ます。
</pre>
<h4>Ver. 1.4.0 β3〜</h4>
<pre>
霊能結果を「人狼」から「呪狼」に変更しました (<a href="info/new_role/human.php#necromancer_rule">霊能の基本ルール</a>対応抜け)
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
他の国に実在する役職です。
新役職考案スレ (最下参照) の 69 を参考にしています。
<a href="info/new_role/human.php#soul_mage">魂の占い師</a>や<a href="info/new_role/fox.php#child_fox">子狐</a>も呪い殺せます。
<a href="info/new_role/human.php#mage_group">占い師</a>側の対策は、遺言に占い先をきちんと書いておく事です。
死体の数や状況にもよりますが、残った村人がきっと仇を討ってくれるでしょう。
</pre>

<h3 id="blue_wolf">蒼狼 (占い結果：人狼 / 霊能結果：人狼) [Ver. 1.4.0 β8〜]</h3>
<pre>
噛んだ人が<a href="info/new_role/fox.php#silver_fox">銀狐</a>以外の噛み殺せない妖狐だった場合に<a href="info/new_role/sub_role.php#mind_lonely">はぐれ者</a>を付加する人狼。
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
ローゼンメイデンの蒼星石がモチーフです。
<a href="info/new_role/wolf.php#emerald_wolf">翠狼</a>と対になるように能力をデザインしてあります。
妖狐のコンビプレーによる騙りを妨害するのが主眼ですが、
妖狐は比較的単独行動が多いので活躍する機会を得るのが難しい能力だと思います。
</pre>

<h3 id="emerald_wolf">翠狼 (占い結果：人狼 / 霊能結果：人狼) [Ver. 1.4.0 β8〜]</h3>
<pre>
噛んだ人が狼だった場合に自分と噛んだ人を<a href="info/new_role/sub_role.php#mind_friend">共鳴者</a>にする人狼。
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
ローゼンメイデンの翠星石がモチーフです。
<a href="info/new_role/wolf.php#blue_wolf">蒼狼</a>と対になるように能力をデザインしてあります。
<a href="info/new_role/wolf.php#silver_wolf">銀狼</a>や<a href="info/new_role/sub_role.php#mind_lonely">はぐれ者</a>になった狼のフォローが主眼ですが
噛みを失敗した時の情報が増えるという副次的効果もあります。
</pre>

<h3 id="sex_wolf">雛狼 (占い結果：人狼 / 霊能結果：人狼) [Ver. 1.4.0 β8〜]</h3>
<pre>
噛みに成功した場合、次の日に噛んだ人の性別が分かる。ただし、噛んだ相手は死なない。
</pre>
<ol>
  <li>性別判定能力は<a href="info/new_role/human.php#sex_mage">ひよこ鑑定士</a>と同じ</li>
  <li>身代わり君には無効 (普通に噛み殺せる代わりに性別は分からない)</li>
</ol>
<h4>[作成者からのコメント]</h4>
<pre>
<a href="info/new_role/fox.php#sex_fox.php">雛狐</a>の人狼バージョンです。
能力そのものよりも副次的効果の方が重要です (いわゆる空襲撃が可能になります)。
この狼が LW になると非常に辛い事になるので気をつけましょう。
</pre>

<h3 id="tongue_wolf">舌禍狼 (占い結果：人狼 / 霊能結果：人狼) [Ver. 1.4.0 α13〜]</h3>
<pre>
自ら噛み投票を行った場合のみ、次の日に噛んだ人の役職が分かる。
ただし、村人を噛んだ場合は能力を失ってしまう。
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
新役職考案スレ (最下参照) の 69 の「賢狼」が原型です。
ベーグル(真偽の付かない占い噛み) 時に動くのが一番有効でしょう。
ベーグル後はワンチャンスの狩人確認に使うと良いと思います。
また、村人の場合に能力を失いますが身代わり君を噛むのも面白いですね。
結果が出てから仲間に伝える前に吊られる可能性があるので
事前にブロックサインを決めておくと良いでしょう。
</pre>


<h3 id="possessed_wolf">憑狼 (占い結果：人狼 / 霊能結果：憑狼) [Ver. 1.4.0 α24〜]</h3>
<pre>
噛んだ人を乗っ取る人狼。
乗っ取るのはアイコンと恋人を除くサブ役職全て。
身代わり君・<a href="info/new_role/human.php#revive_priest">天人</a>・<a href="info/new_role/human.php#detective_common">探偵</a>・妖狐は乗っ取れません。
</pre>
<ol>
<li><a href="info/new_role/wolf.php#possessed_wolf_system">基本システム</a></li>
<li><a href="info/new_role/wolf.php#possessed_wolf_vote">投票結果</a></li>
<li><a href="info/new_role/wolf.php#possessed_wolf_necromancer">霊能結果</a></li>
<li><a href="info/new_role/wolf.php#possessed_wolf_last_words">遺言</a></li>
<li><a href="info/new_role/wolf.php#possessed_wolf_sub_role">サブ役職</a></li>
<li><a href="info/new_role/wolf.php#possessed_wolf_lovers">対恋人</a></li>
<li><a href="info/new_role/wolf.php#possessed_wolf_poison">対毒能力者</a></li>
<li><a href="info/new_role/wolf.php#possessed_wolf_mage">対占い能力者</a></li>
<li><a href="info/new_role/wolf.php#possessed_wolf_voodoo_killer">対陰陽師</a></li>
<li><a href="info/new_role/wolf.php#possessed_wolf_anti_voodoo">対厄神</a></li>
<li><a href="info/new_role/wolf.php#possessed_wolf_reporter">対ブン屋</a></li>
<li><a href="info/new_role/wolf.php#possessed_wolf_assassin">対暗殺者</a></li>
<li><a href="info/new_role/wolf.php#possessed_wolf_revive">対蘇生能力者</a></li>
<li><a href="info/new_role/wolf.php#possessed_wolf_revive_priest">対天人・探偵</a></li>
<li><a href="info/new_role/wolf.php#possessed_wolf_evoke_scanner">対イタコ</a></li>
</ol>

<h4 id="possessed_wolf_system">1. 基本システム</h4>
<pre>
噛みが成功した場合は、噛まれた人が霊界に行きますが、
見かけ上は噛んだ憑狼が無残な死体で発見されます。

例1-1) A[憑狼] → B[村人]
死体：A が無残な死体で発見されました (死因：「誰かに憑依した」)
憑依：B[村人](A[憑狼])

実際に死ぬのは B で、B の中の人は霊界へ行く。
下界の人間には A の発言は B が発言したように見える。
狼の仲間リストから A が消えて B が増える (つまり、憑依したことが分かる)。

夜の発言も含めて全て乗っ取った人のものになるので
例えば共有を乗っ取った場合は狼仲間＋共有仲間と
会話できるようになり、他の人からはひそひそ声に見えます。
つまり、憑狼の遠吠えが消える事になります。

発言は乗っ取れてもメイン役職の能力は乗っ取らない仕様です。
占い師を乗っ取った場合は占い騙りをしないと不自然になります。
また、共有と会話できますが共有仲間が誰か分かるわけではありません。

憑依状態の憑狼が他の村人を噛んだ場合は次々と乗り移ります。
一度憑依を始めた憑狼は現在自分が憑依している対象が常に表示されます。
様々な要因で自分の体に戻されるケースがありますが、その場合は
「あなたはあなたに憑依しています」と表記されます。
</pre>

<h4 id="possessed_wolf_vote">2. 投票結果</h4>
<pre>
結果は「投票をした時点の中の人」で判定されます。

例2-1) A[憑狼] → B[村人] ← C[占い師]
占い結果：B は「村人」でした。
死体：A が無残な死体で発見されました (死因：「誰かに憑依した」)
憑依：B[村人](A[憑狼])

例2-2) C[占い師] → B[村人](A[憑狼])
占い結果：B は「人狼」でした。

例2-3) C[<a href="info/new_role/human.php#psycho_mage">精神鑑定士</a>] → B[狂人](A[憑狼])
鑑定結果：B は「正常」でした。

例2-4) C[<a href="info/new_role/human.php#pharmacist">薬師</a>] → B[埋毒者](A[憑狼])
鑑定結果：B は「毒を持っていません」。

例2-5) C[<a href="info/new_role/wolf.php#silver_wolf">銀狼</a>] → B[村人](A[憑狼])
死体：無し
</pre>

<h4 id="possessed_wolf_necromancer">3. 霊能結果</h4>
<pre>
結果は吊られた中の人で判定されます。

例4-1) 吊り：B[村人](A[憑狼])
霊能結果：B は「憑狼」でした。
</pre>

<h4 id="possessed_wolf_last_words">4. 遺言</h4>
<pre>
遺言は憑狼が偽装したものと見かけ上死んだ村人の両方が出ます。
また、憑狼が憑依に成功するたびに憑狼の現在の遺言が空になります。

例4-1) A[憑狼] → B[村人]
A が書いた遺言が A の遺言として表示される。

例4-2) B[村人](A[憑狼]) → C[村人]
B になりすました A の遺言と B 本人が死んだ時点で書いていた遺言の
両方が表示される。
</pre>

<h4 id="possessed_wolf_sub_role">5. サブ役職</h4>
<pre>
<a href="info/new_role/wolf.php#possessed_wolf_lovers">恋人</a>以外のサブは全て乗っ取ります。
憑依している憑狼には現在自分に適用されているサブが表示されます。

例5-1) A[憑狼][<a href="info/new_role/sub_role.php#chicken">小心者</a>] → B[村人][<a href="info/new_role/sub_role.php#perverseness">天邪鬼</a>]
B に憑依している A は天邪鬼になります。
(小心者の表示が消えて天邪鬼が表示されます)

例5-2) C[<a href="info/new_role/human.php#mind_scanner">さとり</a>] → A[憑狼][<a href="info/new_role/sub_role.php#mind_read">サトラレ</a>] → B[村人][<a href="info/new_role/sub_role.php#mind_read">サトラレ</a>] ← D[<a href="info/new_role/human.php#mind_scanner">さとり</a>]
C は 「死亡した」 A の発言が見えなくなります。
D は B になりすましている A の発言が見えます。

例5-3) A[憑狼] → B[<a href="info/new_role/human.php#ghost_common">亡霊嬢</a>]
死体：A が無残な死体で発見されました (死因：「誰かに憑依した」)
憑依：B[亡霊嬢](A[憑狼])
見かけ上の死体：A[憑狼][<a href="info/new_role/sub_role.php#chicken">小心者</a>]
亡霊嬢の能力発動対象は憑狼本体なので、憑依中は適用されません。
何らかの理由で本体に戻されたら有効になります。
</pre>

<h4 id="possessed_wolf_lovers">6. 対恋人</h4>
<pre>
恋人だけは乗っ取りません。
憑狼自身が恋人だった場合は、恋人からは憑依していることが分かります。
もし、後追いした恋人が遺言で「憑依先と恋人である」 と書いていた場合は
状況と矛盾することになります。

例6-1) A[憑狼][恋人] → B[村人]、C[村人][恋人]
死体：A が無残な死体で発見されました (死因：「誰かに憑依した」)
憑依：B[村人](A[憑狼][恋人])
C の恋人の相手が A から B に変わる (C 視点から憑依したことが分かる)

例6-2) A[憑狼] → B[村人][恋人]、C[村人][恋人]
死体：A が無残な死体で発見されました (死因：「誰かに憑依した」)
死体：C が恋人の後を追い自殺しました
憑依：B[村人][恋人](A[憑狼])
後追いした「確定恋人」の恋人が生存している状態になる。

例6-3) A[憑狼] → B[村人][恋人]、D[暗殺者] → C[<a href="info/new_role/lovers.php#self_cupid">求愛者</a>][恋人]
死体：A が無残な死体で発見されました (死因：「誰かに憑依した」)
死体：C が無残な死体で発見されました (死因：「暗殺された」)
憑依：B[村人][恋人](A[憑狼])
C の恋人が生存している状態になるが、C が<a href="info/new_role/chiroptera.php#dummy_chiroptera">夢求愛者</a>だった場合は
無関係の村人が恋人に憑依した憑狼扱いされる可能性がある。
</pre>

<h4 id="possessed_wolf_poison">7. 対毒能力者</h4>
<pre>
憑狼が毒能力者を襲撃して毒に中ったら憑依がキャンセルされます。

例7-1) A[憑狼] → B[埋毒者]、毒死：A[憑狼]
死体：A が無残な死体で発見されました (死因：「毒に中った」)
死体：B が無残な死体で発見されました (死因：「人狼に襲撃された」)

例7-2) A[憑狼] → B[埋毒者]、毒死：C[人狼]
死体：A が無残な死体で発見されました (死因：「誰かに憑依した」)
死体：C が無残な死体で発見されました (死因：「毒に中った」)
憑依：B[埋毒者](A[憑狼])
</pre>

<h4 id="possessed_wolf_mage">8. 対占い能力者</h4>
<pre>
占い師と<a href="info/new_role/human.php#soul_mage">魂の占い師</a>が憑狼を占った場合は、憑依がキャンセルされます。
<a href="info/new_role/human.php#dummy_mage">夢見人</a>や<a href="info/new_role/fox.php#child_fox">子狐</a>が占ってもキャンセルされません。
<a href="info/new_role/human.php#psycho_mage">精神鑑定士</a>や<a href="info/new_role/human.php#sex_mage">ひよこ鑑定士</a>など、「村人 / 人狼」以外を判定するタイプの
占い系能力者が占ってもキャンセルされません。

例8-1) C[占い師] → A[憑狼] → B[村人]
占い結果：A は「人狼」でした。
死体：B が無残な死体で発見されました (死因：「人狼に襲撃された」)
A は憑依処理がキャンセルされて A のまま。

例8-2) C[<a href="info/new_role/human.php#sex_mage">ひよこ鑑定士</a>] → B[<a href="info/new_role/chiroptera.php#chiroptera">蝙蝠</a>](A[憑狼]) → D[村人]
鑑定結果：B は「男性 / 女性」(A の性別) でした。
死体：B が無残な死体で発見されました (死因：「誰かに憑依した」)
憑依：D[村人](A[憑狼])
</pre>

<h4 id="possessed_wolf_voodoo_killer">9. 対<a href="info/new_role/human.php#voodoo_killer">陰陽師</a></h4>
<pre>
陰陽師が憑狼を占った場合は、呪殺します。
陰陽師が憑狼の憑依先を占った場合は、憑依がキャンセルされます。

例9-1) C[陰陽師] → A[憑狼] → B[村人]
占い結果： A の「解呪成功」
死体：A が無残な死体で発見されました (死因：「呪詛に呪われた」)
死体：B が無残な死体で発見されました (死因：「人狼に襲撃された」)

例9-2) A[憑狼] → B[村人] ← C[陰陽師]
占い結果： B の「解呪成功」
死体：B が無残な死体で発見されました (死因：「人狼に襲撃された」)
A は憑依処理がキャンセルされて A のまま。
</pre>

<h4 id="possessed_wolf_anti_voodoo">10. 対<a href="info/new_role/human.php#anti_voodoo">厄神</a></h4>
<pre>
厄神が憑狼か憑狼の憑依先を護衛した場合は、憑依がキャンセルされます。
憑依中の憑狼を護衛するか、憑狼に襲撃されると憑依状態を解くことができます。
憑依を解かれた憑狼は見かけ上は「蘇生した」ように見えます。

例10-1) A[憑狼] → B[村人] ← C[厄神]
護衛結果： B の「厄払い成功」
死体：B が無残な死体で発見されました (死因：「人狼に襲撃された」)
A は憑依処理がキャンセルされて A のまま。

例10-2) C[厄神] → A[憑狼] → B[村人]
護衛結果： A の「厄払い成功」
死体：B が無残な死体で発見されました (死因：「人狼に襲撃された」)
A は憑依処理がキャンセルされて A のまま。

例10-3) C[厄神] → B[村人](A[憑狼]) → D[村人]
護衛結果： B の「厄払い成功」
蘇生：A は生き返りました
死体：B が無残な死体で発見されました (死因：「憑依から開放された」)
死体：D が無残な死体で発見されました (死因：「人狼に襲撃された」)

例10-4) A[憑狼] → B[厄神]
死体：B が無残な死体で発見されました (死因：「人狼に襲撃された」)
A は憑依処理がキャンセルされて A のまま。

例10-5) B[村人](A[憑狼]) → C[厄神]
蘇生：A は生き返りました
死体：B が無残な死体で発見されました (死因：「憑依から開放された」)
死体：C が無残な死体で発見されました (死因：「人狼に襲撃された」)
</pre>

<h4 id="possessed_wolf_reporter">11. 対<a href="info/new_role/human.php#reporter">ブン屋</a></h4>
<pre>
ブン屋が憑狼の憑依先を護衛すると、「生存者は死者に襲撃された」という
尾行結果が表示されることになるので本人視点で憑狼の位置が確定します。

例11-1) A[憑狼] → B[村人] ← C[ブン屋]
尾行結果：B は A に襲撃されました。
死体：A が無残な死体で発見されました (死因：「誰かに憑依した」)
憑依：B[村人](A[憑狼])
</pre>

<h4 id="possessed_wolf_assassin">12. 対<a href="info/new_role/human.php#assassin">暗殺者</a></h4>
<pre>
憑狼を直接狙うことで憑依中でも殺すことができます。
また、自分と暗殺先が同時に生き残っていることはありえないので、
本人視点で憑狼の位置が確定します。

例12-1) C[暗殺者] → B[村人](A[憑狼]) → D[村人]
死体：B が無残な死体で発見されました (死因：「暗殺された」) (実際に死ぬのは A)
死体：D が無残な死体で発見されました (死因：「人狼に襲撃された」)

例12-2) A[憑狼] → B[村人] ← C[暗殺者]
死体：A が無残な死体で発見されました (死因：「誰かに憑依した」)
憑依：B[村人](A[憑狼])
</pre>

<h4 id="possessed_wolf_revive">13. 対<a href="info/new_role/human.php#poison_cat_group">蘇生能力者</a></h4>
<pre>
憑依中に「見かけ上死んでいる」憑狼本体を蘇生されると元の体に戻されます。
実際に生き返るのは憑依先です。

蘇生処理のタイミングの仕様上、同じ夜に殺された人が誤爆蘇生する可能性があります。
暗殺などで憑依中の憑狼が死亡 + 憑依先を誤爆蘇生の場合は憑依されていた本人が生き返ります。

例13-1) C[<a href="info/new_role/human.php#poison_cat">猫又</a>] → A[憑狼](見かけ上の死体)、B[村人](A[憑狼]) → D[村人]
死体：D が無残な死体で発見されました (死因：「人狼に襲撃された」)
蘇生：A は生き返りました (実際に生き返るのは B)

例13-2) C[<a href="info/new_role/human.php#poison_cat">猫又</a>] → A[憑狼](見かけ上の死体)、B[村人](A[憑狼]) → D[村人]
死体：D が無残な死体で発見されました (死因：「人狼に襲撃された」)
蘇生：D は生き返りました (誤爆蘇生：実際に生き返るのも D)
A は B から D への憑依がキャンセルされて B に憑依したまま。

例13-3) C[<a href="info/new_role/human.php#poison_cat">猫又</a>] → A[憑狼](見かけ上の死体)、E[<a href="info/new_role/human.php#assassin">暗殺者</a>] → B[村人](A[憑狼]) → D[村人]
死体：B が無残な死体で発見されました (死因：「暗殺された」) (実際に死ぬのは A)
死体：D が無残な死体で発見されました (死因：「人狼に襲撃された」)
蘇生：A は生き返りました (実際に生き返るのも A)

例13-4) C[<a href="info/new_role/human.php#poison_cat">猫又</a>] → A[憑狼](見かけ上の死体)、E[<a href="info/new_role/human.php#assassin">暗殺者</a>] → B[村人](A[憑狼]) → D[村人]
死体：B が無残な死体で発見されました (死因：「暗殺された」) (実際に死ぬのは A)
死体：D が無残な死体で発見されました (死因：「人狼に襲撃された」)
蘇生：B は生き返りました (誤爆蘇生：実際に生き返るのも B)
</pre>

<h4 id="possessed_wolf_revive_priest">14. 対<a href="info/new_role/human.php#revive_priest">天人</a>・<a href="info/new_role/human.php#detective_common">探偵</a></h4>
<pre>
天人・探偵は憑依対象外なので、生存している該当者は憑狼ではない事が保証されます。
また、霊界視点からは憑依者がはっきり分かるので蘇生した天人の情報は重要です。

例14-1) B[村人](A[憑狼]) → C[天人]
死体：C が無残な死体で発見されました (死因：「人狼に襲撃された」)
A は B に憑依したまま。
</pre>

<h4 id="possessed_wolf_evoke_scanner">15. 対<a href="info/new_role/human.php#evoke_scanner">イタコ</a></h4>
<pre>
基本システムにあるとおり、メイン役職の能力は乗っ取らないので
イタコに憑依しても口寄せ先からのメッセージは届きませんが、
口寄せ先を憑依すると、霊界からイタコにメッセージが届くので
憑依していることがばれます。

例15-1) A[憑狼] → B[イタコ] → C[村人][口寄せ] (死亡中)
死体：A が無残な死体で発見されました (死因：「誰かに憑依した」)
憑依：B[イタコ](A[憑狼])
C が遺言メッセージを送っても B に憑依している A の遺言窓は変わらない。

例15-2) A[憑狼] → B[村人][口寄せ] ← C[イタコ]
死体：A が無残な死体で発見されました (死因：「誰かに憑依した」)
憑依：B[村人](A[憑狼])
B が遺言メッセージを送ると C の遺言窓が変更される。
</pre>

<h4>[作成者からのコメント]</h4>
<pre>
長期に実在する特殊狼です。
単純に「中の人が入れ替わる狼」というだけでも十分にややこしいかと思いますが、
オリジナルの国に存在しない恋人や猫又の存在が複雑さに拍車をかけています。
人狼の楽しみの一つである「RP」をどこまでまねる事ができるか、ぜひ挑戦してみてください。
</pre>

<h3 id="sirius_wolf">天狼 (占い結果：人狼 / 霊能結果：人狼) [Ver. 1.4.0 β9〜]</h3>
<pre>
仲間の狼が減ると特殊能力が発現する狼。
</pre>
<ol>
  <li>狼が残り二人になると、以下の能力を持ちます</li>
  <ol>
    <li><a href="info/new_role/human.php#assassin_spec">暗殺反射</a></li>
    <li><a href="info/new_role/wolf.php#trap_mad">罠師</a>の罠無効</li>
  </ol>
  <li>狼が残り一人になると、さらに以下の能力を持ちます</li>
  <ol>
    <li>毒無効 (吊り・襲撃両対応)</li>
    <li><a href="info/new_role/human.php#guard_group">狩人系</a>の護衛無効</li>
    <li><a href="info/new_role/human.php#fend_guard">忍者</a>の能力無効</li>
    <li><a href="info/new_role/human.php#ghost_common">亡霊嬢</a>の能力無効</li>
    <li><a href="info/new_role/wolf.php#boss_wolf">白狼</a>化 (占い結果が「村人」になる)。ただし、<a href="info/new_role/human.php#soul_mage">魂の占い師</a>は騙せません</li>
  </ol>
</ol>
<h4>[作成者からのコメント]</h4>
<pre>
東方ウミガメ人狼のプレイヤーさんがモデルの、人狼系最終兵器です。
LW になると吊り以外では止められなくなります。
もし、LW になって噛みを失敗したらその人は狐です。
</pre>

<h3 id="elder_wolf">古狼 (占い結果：人狼 / 霊能結果：人狼) [Ver. 1.4.0 β5〜]</h3>
<pre>
投票数が +1 される人狼。詳細は<a href="info/new_role/human.php#elder">長老</a>参照。
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
<a href="info/new_role/human.php#elder">長老</a>の人狼バージョンです。
PP 圏内まで持ち込んだ時に真価を発揮します。
有効な騙り先がほとんど無い為、立ち回りが非常に難しい役職です。
</pre>

<h3 id="cute_wolf">萌狼 (占い結果：人狼 / 霊能結果：人狼) [Ver. 1.4.0 α14〜]</h3>
<pre>
昼の間だけ、低確率で発言が遠吠えに入れ替わってしまう。
</pre>
<h4>Ver. 1.4.0 β7〜</h4>
<pre>
遠吠えの入れ替え発動を昼限定に変更しました。
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
東方ウミガメ人狼のプレイヤーさんが実際にやってしまった失敗がモデルです。
</pre>

<h3 id="scarlet_wolf">紅狼 (占い結果：人狼 / 霊能結果：人狼) [Ver. 1.4.0 α24〜]</h3>
<pre>
<a href="info/new_role/fox.php#child_fox">妖狐陣営</a>から<a href="info/new_role/fox.php#child_fox">子狐</a>に見える人狼。
本物の子狐と混ざって表示されるため、妖狐側からは区別できない。
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
<a href="info/new_role/fox.php#scarlet_fox">紅狐</a>の人狼バージョンです。
<a href="info/new_role/fox.php#child_fox">子狐</a>は念話できないので夜の会話で直接ばれることはありません。
占いを騙ることで妖狐側から子狐に見えるよう振舞う手もありますが
紅狼が妖狐を把握してるわけではないので「味方」に黒を出す可能性も……
</pre>

<h3 id="silver_wolf">銀狼 (占い結果：人狼 / 霊能結果：人狼) [Ver. 1.4.0 α21〜]</h3>
<pre>
<a href="info/new_role/wolf.php#wolf_partner">仲間</a>が分からない人狼。
(他の人狼・<a href="info/new_role/wolf.php#fanatic_mad">狂信者</a>・<a href="info/new_role/wolf.php#whisper_mad">囁き狂人</a>からも仲間であると分からない)
人狼同士の会話もできず、発言は他の人からは<a href="info/new_role/wolf.php#wolf_howl">遠吠え</a>に見える。
</pre>
<h4>Ver. 1.4.0 α23〜</h4>
<pre>
独り言が他の人から<a href="info/new_role/wolf.php#wolf_howl">遠吠え</a>に見える。
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
他の国に実在する役職です。
仲間と連携が取れないので動き方が難しくなると思います。
仲間に襲撃されて狐扱いされて吊られる可能性も……
</pre>

<h2 id="mad_group">狂人系</h2>
<p>
<a href="info/new_role/wolf.php#mad_rule">基本ルール</a>
</p>
<p>
<a href="info/new_role/wolf.php#fanatic_mad">狂信者</a>
<a href="info/new_role/wolf.php#whisper_mad">囁き狂人</a>
<a href="info/new_role/wolf.php#jammer_mad">月兎</a>
<a href="info/new_role/wolf.php#voodoo_mad">呪術師</a>
<a href="info/new_role/wolf.php#corpse_courier_mad">火車</a>
<a href="info/new_role/wolf.php#agitate_mad">扇動者</a>
<a href="info/new_role/wolf.php#miasma_mad">土蜘蛛</a>
<a href="info/new_role/wolf.php#dream_eater_mad">獏</a>
<a href="info/new_role/wolf.php#trap_mad">罠師</a>
<a href="info/new_role/wolf.php#possessed_mad">犬神</a>
</p>

<h3 id="mad_rule">基本ルール</h3>
<pre>
騙りにリスクを与えるために、特殊能力を持った狂人は
<a href="info/new_role/human.php#guard_hunt">狩人に護衛</a>されると殺される仕様となっています。
</pre>

<h3 id="fanatic_mad">狂信者 (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 α3-7〜]</h3>
<pre>
人狼が誰か分かる上位狂人 (人狼からは狂信者は分からない)。
狼にとって完璧な騙りが出来るはず。
</pre>
<h4>Ver. 1.4.0 α8〜</h4>
<pre>
通常闇鍋モードでは16人未満では出現しません。
16人以上で参加人数と同じ割合で出現します。(16人なら16%、50人なら50%)
最大出現人数は1人です。
つまり、狂信者視点、狂信者を名乗る人は偽者です。
狂信者が出現した場合は出現人数と同じだけ狂人が減ります。
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
他の国に実在する役職です。
狼サイドの新兵器です。作った当初は<a href="info/new_role/human.php#soul_mage">魂の占い師</a>や<a href="info/new_role/human.php#poison_guard">騎士</a>と出現率のせいもあって
活躍できなかったようですが、本来はかなり強いはず。
</pre>

<h3 id="whisper_mad">囁き狂人 (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 α17〜]</h3>
<pre>
人狼の夜の相談に参加できる上位狂人です。
人狼と違い、発言が遠吠えに変換されません。
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
通称「C国狂人」、最強クラスの狂人です。「ささやき きょうじん」と読みます。
相談できるので完璧な連携が取れます。
</pre>

<h3 id="jammer_mad">月兎 (邪魔狂人) (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 α19〜]</h3>
<pre>
夜に村人一人を選び、その人の占い行動を妨害する特殊な狂人。
</pre>
<ol>
  <li>妨害可能な役職は<a href="info/new_role/human.php#voodoo_killer">陰陽師</a>と<a href="info/new_role/human.php#dummy_mage">夢見人</a>を除く<a href="info/new_role/human.php#mage_group">占い師系</a>、<a href="info/new_role/fox.php#child_fox">子狐</a>、<a href="info/new_role/chiroptera.php#fairy_group">妖精系</a>です</li>
  <li>妨害された占い能力者には「〜さんの占いに失敗しました」と出ます</li>
  <li>妨害が成功したかどうかは本人には分かりません</li>
  <li>呪われている役職を選んだ場合は呪返しを受けます</li>
  <li><a href="info/new_role/human.php#guard_hunt">狩人系に護衛</a>されると殺されます</li>
</ol>
<h4>Ver. 1.4.0 α21〜</h4>
<pre>
名称を邪魔狂人から月兎に変更しました。
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
実在する役職ですね。狂人系の中でも上位に属します。
うかつに CO する事ができなくなるので占い師は非常につらくなりますね。
</pre>

<h3 id="voodoo_mad">呪術師 (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 α20〜]</h3>
<pre>
夜に村人一人を選び、その人に呪いをかける特殊な狂人。
</pre>
<ol>
  <li>呪われた人を占った<a href="info/new_role/human.php#mage_group">占い師</a>は呪返しを受けます</li>
  <li>呪われている役職を選んだ場合は本人が呪返しを受けます</li>
  <li>呪いをかけた人が他の人にも呪いをかけられていた場合は本人が呪返しを受けます</li>
  <li><a href="info/new_role/human.php#guard_hunt">狩人系</a>に護衛されると殺されます</li>
</ol>
<h4>[作成者からのコメント]</h4>
<pre>
対<a href="info/new_role/human.php#mage_group">占い師系</a>専門の<a href="info/new_role/wolf.php#trap_mad">罠師</a>的存在です。
新役職考案スレ (最下参照) の 13 が原型です。
占い師の占い先を先読みして呪いをかけておくことで呪返しを狙うのが
基本的な立ち回りになると思います。
</pre>

<h3 id="corpse_courier_mad">火車 (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 α21〜]</h3>
<pre>
自分が投票して吊った人の霊能結果を隠蔽できる特殊な狂人。
投票先を吊ることさえ出来れば、投票した日にショック死しようと
その夜に何らかの形で死のうと効果が発動する。

霊能結果が隠蔽されると、霊能者と<a href="info/new_role/human.php#soul_necromancer">雲外鏡</a>の霊能結果が
「〜さんの死体が盗まれた」という趣旨のメッセージになる。
<a href="info/new_role/human.php#dummy_necromancer">夢枕人</a>は火車の影響は受けない。

<a href="info/new_role/human.php#guard_hunt">狩人系に護衛</a>されると殺される。
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
<a href="info/new_role/wolf.php#jammer_mad">月兎</a>の霊能バージョンです。「かしゃ」と読みます。
新役職考案スレ (最下参照) の 48 が原型です。
火車の能力が発動しているのに霊能結果を出す人は
<a href="info/new_role/human.php#dummy_necromancer">夢枕人</a>か騙りになります。
</pre>

<h3 id="agitate_mad">扇動者 (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 β7〜]</h3>
<pre>
再投票の最多得票者に投票していた場合に、投票先を吊り、
それ以外の最多得票者をまとめてショック死させる特殊な狂人。

<a href="info/new_role/human.php#guard_hunt">狩人系に護衛</a>されると殺される。
</pre>
<ol>
  <li>事前に吊り先が決定していた場合は発動しない</li>
  <li>判定は<a href="info/new_role/human.php#saint">聖女</a>の判定の後</li>
  <li>複数の扇動者が最多得票者に投票していた場合は、投票先が一致している場合のみ発動する</li>
  <li>最多得票者に自分が含まれていても有効 (自分の投票先が吊られて、自分はショック死する)</li>
</ol>
<h4>[作成者からのコメント]</h4>
<pre>
他の国に実在する役職です。
オリジナルは「昼の処刑投票を二回発生させる能力」ですが、
より「扇動者」っぽくアレンジしてみました。
</pre>

<h3 id="miasma_mad">土蜘蛛 (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 β9〜]</h3>
<pre>
投票者決定後、投票先が吊られなかった場合に、投票先を<a href="info/new_role/sub_role#febris">熱病</a>にする特殊な狂人。
<a href="info/new_role/human.php#detective_common">探偵</a>には無効。

<a href="info/new_role/human.php#guard_hunt">狩人系に護衛</a>されると殺される。
</pre>
<h4>Ver. 1.4.0 β10〜</h4>
<pre>
<a href="info/new_role/human.php#detective_common">探偵</a>には無効。
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
新役職考案スレ (最下参照) の 33 が原型です。
<a href="info/new_role/sub_role#febris">熱病</a>の仕様と実装が中々決まらず、作成決定から実装まで
かなり間が開いてます。
</pre>

<h3 id="dream_eater_mad">獏 (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 α21〜]</h3>
<pre>
夜に投票した夢系能力者 (<a href="info/new_role/human.php#dummy_mage">夢見人</a>、<a href="info/new_role/human.php#dummy_necromancer">夢枕人</a>、<a href="info/new_role/human.php#dummy_common">夢共有者</a>、<a href="info/new_role/human.php#dummy_poison">夢毒者</a>、<a href="info/new_role/chiroptera.php#dummy_chiroptera">夢求愛者</a>) と
<a href="info/new_role/chiroptera.php#fairy_group">妖精系</a>を殺すことができる狂人。<a href="info/new_role/human.php#guard_hunt">狩人に護衛</a>されると殺される。
<a href="info/new_role/human.php#dummy_poison">夢毒者</a>を吊ると「毒」に中る。

何らかの形で<a href="info/new_role/human.php#dummy_guard">夢守人</a>に接触した場合は殺される。
夢守人に殺される条件は以下。
</pre>
<ol>
  <li>襲撃先が夢守人だった</li>
  <li>夢守人に自分が護衛された</li>
  <li>襲撃先が夢守人に護衛されていた</li>
</ol>
<h4>Ver. 1.4.0 β9〜</h4>
<pre>
<a href="info/new_role/human.php#dummy_poison">夢毒者</a>を吊ると「毒」に中ります (襲撃した場合は中らない)。
<a href="info/new_role/chiroptera.php#fairy_group">妖精系</a>も殺す事ができます
</pre>
<h4>Ver. 1.4.0 α23〜</h4>
<pre>
初日の襲撃はできません (暗殺者系と挙動を揃えました)。
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
対夢系能力者専門の<a href="info/new_role/human.php#assassin">暗殺者</a>という位置づけです。「ばく」と読みます。
夢系は基本的には村陣営なので獏は狂人相当になります。
</pre>

<h3 id="trap_mad">罠師 (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 α18〜]</h3>
<pre>
一度だけ夜に村人一人に罠を仕掛けることができる特殊な狂人。
罠を仕掛けられた人の元に訪れた<a href="info/new_role/wolf.php#wolf_group">人狼系</a>・<a href="info/new_role/human.php#guard_group">狩人系</a>・<a href="info/new_role/human.php#assassin_group">暗殺者</a>は死亡する。
</pre>
<ol>
  <li>罠にかかる<a href="info/new_role/human.php#guard_group">狩人系</a>は狩人・<a href="info/new_role/human.php#poison_guard">騎士</a>・<a href="info/new_role/human.php#fend_guard">忍者</a>・<a href="info/new_role/human.php#reporter">ブン屋</a>です</li>
  <li>自分が人狼に襲撃されたら無効になります</li>
  <li>罠を仕掛けに行った先に他の罠師が罠を仕掛けていた場合は死亡します</li>
  <li>自分にも仕掛けることができます</li>
  <li>自分に仕掛けた場合は人狼に襲撃されても有効です (人狼が死にます)</li>
  <li>自分に仕掛けた場合は他の罠師が罠をかけていても本人は死にません<br>
    (仕掛けに来た他の罠師は死にます)</li>
  <li>狩人系に<a href="info/new_role/human.php#guard_hunt">護衛</a>されると殺されます</li>
  <li>自分に仕掛けて狩人に護衛された場合は相打ちになります</li>
  <li>暗殺者が罠にかかった場合、暗殺は無効になります</li>
</ol>
<h4>[作成者からのコメント]</h4>
<pre>
狼陣営に対暗殺者を何か……と考案してこういう形に落ち着きました。
一行動で多くの能力者を葬れる可能性を秘めています。
人狼の襲撃先を外しつつ狩人の護衛先や暗殺者の襲撃先を読み切って
ピンポイントで罠を仕掛けないといい仕事にならないので活躍するのは
非常に難しいと思いますが、当たればきっと最高の気分になれるはず。
</pre>

<h3 id="possessed_mad">犬神 (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 β9〜]</h3>
<pre>
一度だけ、死体に憑依することができる特殊な狂人。
</pre>
<ol>
  <li>身代わり君・<a href="info/new_role/fox.php">妖狐陣営</a>・<a href="info/new_role/lovers.php">恋人陣営</a>には憑依できません</li>
  <li><a href="info/new_role/human.php#voodoo_killer">陰陽師</a>に占われると殺されます</li>
  <li>憑依を実行した時に<a href="info/new_role/human.php#anti_voodoo">厄神</a>に護衛されると憑依に失敗します</li>
  <li>憑依を実行しなければ<a href="info/new_role/human.php#anti_voodoo">厄神</a>に護衛されても「厄払い成功」とは判定されません</li>
  <li>憑依を実行した時に占い能力者に占われても憑依妨害は受けません</li>
  <li>憑依中に<a href="info/new_role/human.php#anti_voodoo">厄神</a>に護衛されると憑依状態を解かれて元の体に戻されます</li>
  <li>狩人系に<a href="info/new_role/human.php#guard_hunt">護衛</a>されると殺されます</li>
  <li>複数の憑依能力者が同時に同じ人に憑依しようとした場合は全員憑依失敗扱いになります</li>
  <li>死亡した人狼にも憑依できますが、夜の発言は独り言になり、仲間の人狼と会話できません</li>
</ol>
<h4>[作成者からのコメント]</h4>
<pre>
「蘇生された人は本物なのか？」という疑心暗鬼を振りまくための存在です。
<a href="info/new_role/wolf.php#possessed_wolf">憑狼</a>と違い、死体に憑依するので死体の数で見切られやすいのが難点です。
</pre>
</div>
</body>
</html>
