<?php
/**
 * 部屋の状態を更新するトランザクションのベースを提供します。
 * このクラスは以下の処理を実行します。 
 *  1.村オブジェクトの取り出し 
 *  2.ゲーム進行のチェック 
 *  3.廃村、突然死の処理
 */
class UpdateRoomTransaction extends Transaction {
  function _UpdateRoom($db, $room, $update_internal_time) {
    if($room->IsRealTime()){ //リアルタイム制
      //TODO: 以下にターンの経過時間と制限時間から内部時間を更新するコードを追加します。
      $left_time = microtime(true) - $room->last_alarm_time;
      if ($room->IsDay()) {
        $limit = $room->real_time->day;
        $offset_hours = 6;
      }
      elseif ($room->IsNight()) {
        $limit = $room->real_time->night;
        $offset_hours = 18;
      }
      if (isset($limit)) {
        //TODO: 以下に内部時間を生成するコードを追加します。
      }
    }
    else{ //会話で時間経過制
      $left_time = time() - $room->last_updated_time;
      if ($left_time <= 30) { //TODO: タイムアウトを変更可能にする
        $spend_time = floor(strlen($say) / 100); //経過時間
        if($spend_time < 1) $spend_time = 1; //最小は 1
        elseif($spend_time > 4) $spend_time = 4; //最大は 4
      }
      else {
      }
    }
    return false;
  }

  function _KillRoom($db, $room_no) {
    return false;
  }

  function _KillPlayer($db, $user_no) {
    return false;
  }

  function __run($db) {
    return false;
  }
}
