<?php
require_once dirname(__FILE__) . '/../../../../include/init.php';

class FunctionsTest extends PHPUnit_Framework_TestCase {
  /**
   * @dataProvider dp_testFindDangerValue
   */
  public function testFindDangerValue($value, $expected) {
    $this->assertEquals($expected, FindDangerValue($value));
  }
  public static function dp_testFindDangerValue() {
    return array(
        array(null, false),
        array('', false),
        array('sometext', false),
        array(0, false),
        array(100, false),
        array('222507385850720110e-325', true),
        array('222507385850720110.0e-325', true),
        array('22250738585072011e-324', true),
        array('22250738585072011.0e-324', true),
        array('22.250738585072011e-309', true),
        array('2.2250738585072011e-308', true),
        array('02.2250738585072011e-308', true),
        array('2.22507385850720110e-308', true),
        array('2.2250738585072011e-0308', true),
        array('0.22250738585072011e-307', true),
        array('0.022250738585072011e-306', true),
        array(array('', '2.2250738585072011e-308', 100), true),
        array(array('', array('2.2250738585072011e-308', 100)), true),
        array(array('danger'=>'2.2250738585072011e-308', 'safe'=>100), true),
        array(array('', array('danger'=>'2.2250738585072011e-308', 'safe'=>100)), true),
        array(array('', array('notdanger'=>'2.2250738585072011e-307', 'safe'=>100)), false),
    );
  }

  public function testSendQuery() {
    global $DB_CONF;
    $this->assertNotSame(false, $DB_CONF->Connect(), 'データベースへの接続に失敗しました。');
    $stmt = SendQuery('SELECT 2 AS test');
    $this->assertEquals(1, $stmt->rowCount(), 'クエリが予期しない結果を返しました。');
    $this->assertEquals(2, $stmt->fetch(PDO::FETCH_COLUMN, 0), 'クエリが予期しない結果を返しました。');
    $stmt->closeCursor();
  }

  public function testNGSendQuery() {
    global $DB_CONF;
    $this->assertNotSame(false, $DB_CONF->Connect(), 'データベースへの接続に失敗しました。');
    $stmt = SendQuery('SELEC 2 AS test -- 構文ミス');
    $this->assertFalse($stmt, '不正なクエリに対してfalseが返されませんでした');
  }

  public function testSendCommit() {
    global $DB_CONF;
    $this->assertNotSame(false, $DB_CONF->Connect(), 'データベースへの接続に失敗しました。');
    $this->assertFalse(SendCommit());
    $DB_CONF->connection->beginTransaction();
    $this->assertTrue(SendCommit());
  }

  public function testFetchResult() {
    global $DB_CONF;
    $this->assertNotSame(false, $DB_CONF->Connect(), 'データベースへの接続に失敗しました。');
    $this->assertEquals(2, FetchResult('SELECT 2 AS test'));
  }

  public function testNGFetchResult() {
    global $DB_CONF;
    $this->assertNotSame(false, $DB_CONF->Connect(), 'データベースへの接続に失敗しました。');
    $this->assertFalse(FetchResult('SELEC 2 AS test -- 構文ミス'));
  }

  public function testFetchCount() {
    global $DB_CONF;
    $this->assertNotSame(false, $DB_CONF->Connect(), 'データベースへの接続に失敗しました。');
    $this->assertEquals(1, FetchCount('SELECT 2 AS test'));
  }

  public function testNGFetchCount() {
    global $DB_CONF;
    $this->assertNotSame(false, $DB_CONF->Connect(), 'データベースへの接続に失敗しました。');
    $this->assertFalse(FetchCount('SELEC 2 AS test -- 構文ミス'));
  }

  public function testFetchArray() {
    global $DB_CONF;
    $this->assertNotSame(false, $DB_CONF->Connect(), 'データベースへの接続に失敗しました。');
    $this->assertEquals(array(2), FetchArray('SELECT 2 AS test, 3 AS test2'));
  }

  public function testNGFetchArray() {
    global $DB_CONF;
    $this->assertNotSame(false, $DB_CONF->Connect(), 'データベースへの接続に失敗しました。');
    $this->assertEquals(array(), FetchArray('SELEC 2 AS test, 3 AS test2 -- 構文ミス'));
  }

  public function testFetchAssoc() {
    global $DB_CONF;
    $this->assertNotSame(false, $DB_CONF->Connect(), 'データベースへの接続に失敗しました。');
    $this->assertEquals(array(array('test'=>2, 'test2'=>3)), FetchAssoc('SELECT 2 AS test, 3 AS test2'));
    $this->assertEquals(array('test'=>2, 'test2'=>3), FetchAssoc('SELECT 2 AS test, 3 AS test2', true), '結果のシフトに失敗しました。');
  }

  public function testNGFetchAssoc() {
    global $DB_CONF;
    $this->assertNotSame(false, $DB_CONF->Connect(), 'データベースへの接続に失敗しました。');
    $this->assertEquals(array(), FetchArray('SELEC 2 AS test, 3 AS test2 -- 構文ミス'));
  }

  public function testInsertDatabase() {
    global $DB_CONF;
    $this->assertNotSame(false, $DB_CONF->Connect(), 'データベースへの接続に失敗しました。');
    SendQuery('DELETE FROM user_icon WHERE icon_no = 10000000');
    $items = 'icon_no,icon_name,icon_filename,icon_width,icon_height,color';
    $values = "10000000,'test','/dev/null',48,48,'#000000'";
    $this->assertTrue(InsertDatabase('user_icon', $items, $values), 'user_iconにデータを挿入できませんでした:'.print_r($DB_CONF->connection->errorInfo(), true));
    $this->assertFalse(InsertDatabase('user_entry', $items, $values), 'user_entryにデータを挿入できました:'.print_r($DB_CONF->connection->errorInfo(), true));
    $this->assertNotSame(false, SendQuery('DELETE FROM user_icon WHERE icon_no = 10000000'), 'user_iconのクリーンアップに失敗しました:'.print_r($DB_CONF->connection->errorInfo(), true));
  }

  public function testInsertDatabaseEx() {
    global $DB_CONF;
    $this->assertNotSame(false, $DB_CONF->Connect(), 'データベースへの接続に失敗しました。');
    SendQuery('DELETE FROM user_icon WHERE icon_no = 10000001');
    $items = array(
      'icon_no'=>10000001,
      'icon_name'=>'test',
      'icon_filename'=>'/dev/null',
      'icon_width'=>48,
      'icon_height'=>48,
      'color'=>'#000000'
    );
    $this->assertTrue(InsertDatabaseEx('user_icon', $items), 'user_iconにデータを挿入できませんでした:'.print_r($DB_CONF->connection->errorInfo(), true));
    $this->assertFalse(InsertDatabaseEx('user_entry', $items), 'user_entryにデータを挿入できました:'.print_r($DB_CONF->connection->errorInfo(), true));
    $this->assertNotSame(false, SendQuery('DELETE FROM user_icon WHERE icon_no = 10000001'), 'user_iconのクリーンアップに失敗しました:'.print_r($DB_CONF->connection->errorInfo(), true));
  }
}
?>
