<?php

require_once dirname(__FILE__) . '/../../../../../include/chatengine/sql_helpers.php';

class SqlHelperTest extends PHPUnit_Framework_TestCase {
  /**
   * @dataProvider dp_testGeneratePaginationClauses
   */
  public function testGeneratePaginationClauses($order_expr, $is_asc, $limit, $page, $expected) {
    $result = generatePaginationClauses($order_expr, $is_asc, $limit, $page);
    $this->assertEquals($expected, $result);
  }
  public static function dp_testGeneratePaginationClauses() {
    return array(
      array('id', true, 10, 0, array('ORDER BY id ASC', 'LIMIT 10')),
      array('id', false, 10, 0, array('ORDER BY id DESC', 'LIMIT 10')),
      array('id', true, 10, 1, array('ORDER BY id ASC', 'LIMIT 10,10')),
      array('id', false, 10, 1, array('ORDER BY id DESC', 'LIMIT 10,10')),
    );
  }


  /**
   * @dataProvider dp_testGenerateIdSelector
   */
  public function testGenerateIdSelector($table, $id, $prefix, $expected) {
    $result = generateIdSelector($table, $id, $prefix);
    $this->assertEquals($expected, $result);
  }
  public static function dp_testGenerateIdSelector() {
    return array(
      array('jinrou_rooms', 5, null, array('jinrou_rooms.id IN (:jinrou_rooms_0)', array(':jinrou_rooms_0' => 5))),
      array('jinrou_rooms', 5, 'room', array('jinrou_rooms.id IN (:room_0)', array(':room_0' => 5))),
      array('jinrou_rooms', array(1, 5), null, array('jinrou_rooms.id IN (:jinrou_rooms_0,:jinrou_rooms_1)', array(':jinrou_rooms_0' => 1, ':jinrou_rooms_1' => 5))),
      array('jinrou_rooms', array(1, 5), 'room', array('jinrou_rooms.id IN (:room_0,:room_1)', array(':room_0' => 1, ':room_1' => 5))),
      array('jinrou_rooms', '*', null, array('1', array())),
      array('jinrou_rooms', true, null, array('1', array())),
      array('jinrou_rooms', false, null, array('0', array())),
    );
  }


  /**
   * @dataProvider dp_testValidateText
   */
  public function testValidateText($text, $nullable, $min_length, $max_length, $expected) {
    $result = validateText($text, $nullable, $min_length, $max_length);
    $this->assertEquals($expected, $result);
  }
  public static function dp_testValidateText() {
    return array(
      array(null, false, 0, 255, false),
      array(null, true, 0, 255, true),
      array(null, false, -1, -1, false),
      array(null, true, -1, -1, true),
      array('', false, 0, 255, true),
      array('', false, 1, 255, false),
      array('', false, -1, 255, true),
      array('The quick brown fox jumps over the lazy dog.', false, 1, 255, true),
      array('The quick brown fox jumps over the lazy dog.', false, 1, 25, false),
      array('The quick brown fox jumps over the lazy dog.', false, 1, -1, true),
    );
  }
}
?>
