<?php
/*
 * Jeans CMS ver 0.7 (GPL license)
 * $Id: jp_hello.php 148 2010-03-02 20:41:09Z kmorimatsu $
 */

class jp_LatestComments extends plugin{
	static public function name(){
		return 'Latest Comments';
	}
	static public function author(){
		return 'Katsumi';
	}
	static public function url(){
		return 'http://jeanscms.sourceforge.jp/';
	}
	static public function desc(){
		return '_JP_LATESTCOMMENTS_DESC';
	}
	static public function version(){
		return '0.1';
	}
	static public function tag_latestcomments(&$data,$skin=false,$max=false,$gid=false){
		if (!$max) $max=isset($data['max']) ? $data['max']:10;
		if (!$gid && isset($data['gid'])) $gid=$data['gid'];
		$select='SELECT c.id as id, c.itemid as itemid, c.body as body, c.author as author, c.flags as flags, c.xml as xml';
		if ($gid) {
			$query=$select.' FROM jeans_comment as c, jeans_item as i, jeans_group as g 
				WHERE c.itemid=i.id AND NOT i.flags & <%const:sql::FLAG_HIDDEN%> 
				AND i.gid=g.id AND g.id=<%gid%> AND NOT g.flags & <%const:sql::FLAG_HIDDEN%> 
				ORDER BY c.id ASC LIMIT <%max%> ';
		} else {
			$query=$select.' FROM jeans_comment as c, jeans_item as i 
				WHERE c.itemid=i.id AND NOT i.flags & <%const:sql::FLAG_HIDDEN%> 
				ORDER BY c.id DESC LIMIT <%max%> ';
		}
		$array=array('max'=>$max,'gid'=>$gid);
		view::show_using_query($data,$query,$array,$skin,array('jp_LatestComments','cb_latestcomments'));
	}
	static public function cb_latestcomments(&$row){
		$row['link']=view::create_link(array('itemid'=>$row['itemid'])).'#c'.$row['id'];
	}
}