// ライセンス: GPL2

// gzip 圧縮、解凍

#ifndef _MISCGZIP_H
#define _MISCGZIP_H

#include <string>

namespace MISC
{

    //
    // gzip のヘッダチェック
    //
    // 戻り値 : ヘッダサイズ(エラーなら-1)
    //
    const size_t check_gzipheader( const char* buf, const size_t size );

    // gzip作成
    //
    // filename : オリジナルのファイル名
    // gzipfile : 出力する gz ファイル
    // inbuf :  オリジナルデータ
    // inbufsize : オリジナルデータサイズ
    // mtime : 更新時刻(0なら現在の時刻が入る)
    //
    // 戻り値 : 出力サイズ(ヘッダやcrcを除く)
    //
    const size_t gzip( const std::string& filename, const std::string& gzipfile,
                       const char* inbuf, const size_t inbufsize, const time_t mtime );

    //
    // gzip解凍
    //
    // gzipfile : 入力する gz ファイル
    // str : 解凍した文字列
    //
    // 戻り値 : オリジナルのファイルサイズ
    //
    const size_t gunzip( const std::string& gzipfile, std::string& str );
}

#endif
