<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
    version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>
<xsl:output
    method="html"
    version="4.01"
    encoding="UTF-8"
    doctype-public="-//W3C//DTD HTML 4.01//EN"
    doctype-system="http://www.w3.org/TR/html4/strict.dtd"
    include-content-type="yes"
    indent="yes"
    media-type="text/html"
/>


<!--
要素名: /
説　明: ページ全体
その他: 以下の要素と属性を使用
        document/@header
        document( 'history.xml' )//latest/@year
        document( 'YYYY.xml' )//release[last()]/@version
-->
<xsl:template match="/">
    <xsl:variable name="year" select="document( 'history.xml' )//latest/@year" />
    <xsl:variable name="version" select="document( concat( $year, '.xml' ) )//release[last()]/@version" />

    <html lang="ja">
    <head>
    <meta name="description" content="OnlineManual for JD" />
    <meta name="author" content="jdsksy, tamagodake" />
    <title><xsl:value-of select="document/@header" /></title>
    <link rel="stylesheet" type="text/css" href="main.css" />
    <link rel="index" href="http://jd4linux.sourceforge.jp/" />
    <link rel="contents">
        <xsl:attribute name="href">
            <xsl:variable name="dirname" select="translate( substring( $version, 1, 5 ), '.', '' )" />
            <xsl:value-of select="concat( 'http://jd4linux.sourceforge.jp/manual/', $dirname, '/' )" />
        </xsl:attribute>
    </link>
    <link rev="made" href="http://jd4linux.sourceforge.jp/" />
    </head>
    <body>

    <p id="topmenu">
        <a href="index.xml" accesskey="t"><xsl:text>トップに戻る</xsl:text></a>
        <xsl:text>&#x0A;</xsl:text>
        <a href="http://jd4linux.sourceforge.jp/" accesskey="h"><xsl:text>JDホームページ</xsl:text></a>
    </p>

    <p id="header">
        <img src="jd.png" width="96" height="96" alt="JDロゴ" />
        <span id="text"><xsl:value-of select="document/@header" /></span>
    </p>

    <xsl:if test="function-available('document')">
    <p id="version">
        <xsl:text>Version: </xsl:text>
        <xsl:value-of select="$version" />
    </p>
    </xsl:if>

    <xsl:apply-templates select="document" />
    </body>
    </html>
</xsl:template>


<!--
要素名: document
説　明: ページ内コンテンツの親要素
-->
<xsl:template match="document">
    <xsl:if test="block/@subject">
        <ul class="disc">
            <xsl:apply-templates select="block" mode="link" />
        </ul>
    </xsl:if>

    <xsl:apply-templates />
</xsl:template>


<!--
要素名: HTMLと同じ物
説　明: これらの要素はそのままコピーされる
-->
<xsl:template match="a|br|div|h1|h2|h3|hr|li|p|q|span|table|td|th|tr|ul">
    <xsl:element name="{name()}">
        <xsl:for-each select="@*"><xsl:copy /></xsl:for-each>
        <xsl:apply-templates />
    </xsl:element>
</xsl:template>


<!--
要素名: pre
説　明: <pre>と同じだが、最初の改行以前を除外する
-->
<xsl:template match="pre">
    <pre>
        <xsl:for-each select="@*"><xsl:copy /></xsl:for-each>
        <xsl:value-of select="substring-after( ., '&#x0A;' )" />
    </pre>
</xsl:template>


<!--
要素名: block
説　明: <div>と同じだが、属性subjectの値がある場合にページ内ジャンプ
        のリンクをページ上部に追加する
-->
<xsl:template match="block" mode="link">
    <li>
        <a href="#{generate-id()}"><xsl:value-of select="@subject" /></a>
    </li>
</xsl:template>

<xsl:template match="block">
    <div>
    <xsl:copy-of select="@class" />
    <xsl:if test="@subject">
        <h3 class="green"><a name="{generate-id()}"><xsl:value-of select="@subject" /></a></h3>
    </xsl:if>
    <xsl:apply-templates />
    </div>
</xsl:template>


<!--
要素名: array
説　明: <table>と同じ。属性subjectの値がある場合に属性summaryとして追加する
-->
<xsl:template match="array">
    <xsl:if test="@subject">
        <h3 class="green"><xsl:value-of select="@subject" /></h3>
    </xsl:if>
    <table>
    <xsl:if test="@border"><xsl:copy-of select="@border" /></xsl:if>
    <xsl:attribute name="summary"><xsl:value-of select="@summary" /></xsl:attribute>
    <xsl:apply-templates select="item" />
    </table>
</xsl:template>

<!--
要素名: item (key, value)
説　明: <array>の中身。HTMLの<tr>(<td>)などと同じ
-->
<xsl:template match="item">
    <tr>
    <td>
        <xsl:copy-of select="key/@*" />
        <xsl:value-of select="key" />
    </td>
    <td>
        <xsl:copy-of select="value/@*" />
        <xsl:value-of select="value" />
    </td>
    </tr>
</xsl:template>


</xsl:stylesheet>
