// ライセンス: GPL2

#include "playsound.h"

#include <gtkmm.h>
#include <iostream>
#include <string>

class SoundWin : public Gtk::Window
{
    SOUND::Play_Sound m_ps1;
    SOUND::Play_Sound m_ps2;

    std::string m_file1;
    std::string m_file2;

    Gtk::VBox m_vbox;
    Gtk::Button m_button1;
    Gtk::Button m_button2;

    void slot_button1(){
        if( m_ps1.is_playing() ) m_ps1.stop();
        else m_ps1.play( m_file1 );
    }

    void slot_button2(){
        if( m_ps2.is_playing() ) m_ps2.stop();
        else m_ps2.play( m_file2 );
    }

public:

    SoundWin( const std::string& file1, const std::string& file2 )
        : m_file1( file1 ), m_file2( file2 )
        , m_button1( file1 ), m_button2( file2 )
    {
        m_button1.signal_clicked().connect( sigc::mem_fun( *this, &SoundWin::slot_button1 ) );
        m_button2.signal_clicked().connect( sigc::mem_fun( *this, &SoundWin::slot_button2 ) );

        m_vbox.pack_start( m_button1 );
        m_vbox.pack_start( m_button2 );
        add( m_vbox );
        show_all_children();
    }
};


int main( int argc, char* argv[] )
{
    if( argc != 3 ){
        std::cout << "soundtest wav1 wav2\n";
        exit( 1 );
    }

    Glib::thread_init();

    Gtk::Main kit( argc, argv );
    SoundWin sw( argv[1], argv[2] );
    Gtk::Main::run( sw );

    return 0;
}
