// License: GPL2

#ifndef _COMMANDIO_H
#define _COMMANDIO_H

#include <gtkmm.h>
#include <fcntl.h>

namespace CORE
{
    class IOMonitor
    {
        // FIFOのファイルディスクリプタ
        int m_fifo_fd;

        // I/Oの架け橋
        Glib::RefPtr< Glib::IOChannel > m_iochannel;

        // メインプロセスか否か
        bool m_main_process;

      private:

        // 初期化
        int init();

        // FIFOに書き込まれたら呼び出される
        bool slot_ioin( Glib::IOCondition io_condition );

      public:

        IOMonitor();
        ~IOMonitor();

        // メインプロセスか否かを取得
        bool is_main_process(){ return m_main_process; }

        // FIFOに書き込み
        bool send_command( const char* command );
    };
}

#endif
