// GPL2

#define _DEBUG
#include <assert.h>

#include "miscgzip.h"

#define INBUFSIZE ( 1024 * 1024 )

#include <sys/stat.h>
#include <iostream>

time_t get_filemtime( const std::string& path )
{
    struct stat buf_stat;

    if( stat( path.c_str(), &buf_stat ) != 0 ) return 0;
    if( S_ISREG( buf_stat.st_mode ) ) return buf_stat.st_mtime;
    return 0;
}


// -c で圧縮
// -x で解凍
int main( int argc, char *argv[] )
{
    // 圧縮
    if( argv[1][1] == 'c' ){

        assert( argc == 4 );

        time_t mtime = get_filemtime( argv[ 2 ] );

        FILE *fin = fopen( argv[ 2 ], "r");
        assert( fin );

        char inbuf[ INBUFSIZE ];
        size_t N = fread( inbuf, 1, INBUFSIZE, fin );
        fclose(fin);
        assert( N );

        MISC::gzip( argv[ 2 ], argv[ 3 ], inbuf, N, mtime );
    }

    // 解凍
    else if( argv[1][1] == 'x' ){

        assert( argc == 3 );

        std::string str;
        MISC::gunzip( argv[ 2 ], str );
        std::cout << str << std::endl;
    }

    return 0;
}
