<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
    version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>
<xsl:include href="main.xsl" />


<!--
要素名: document
説　明: main.xslのオーバーロード
-->
<xsl:template match="/document">
    <ul class="disc">
        <xsl:apply-templates select="command" mode="link" />
    </ul>

    <ul class="decimal">
        <xsl:apply-templates />
    </ul>
</xsl:template>


<!--
要素名: command
説　明: 各コマンドを表示( main.xslの<block>に近い )
-->
<xsl:template match="command" mode="link">
    <li>
        <a href="#{generate-id()}"><xsl:value-of select="@subject" /></a>
    </li>
</xsl:template>

<xsl:template match="command">
    <li>
    <h3>
        <a name="{generate-id()}"><xsl:value-of select="@subject" /></a>
    </h3>
    
    <div><xsl:apply-templates /></div>
    </li>
</xsl:template>


<!--
要素名: name
説　明: コマンド名を表示
-->
<xsl:template match="name">
    <span class="red"><xsl:value-of select="." /></span><br />
</xsl:template>


<!--
要素名: name
説　明: コマンド自体を表示
-->
<xsl:template match="exec">
    <span class="green"><xsl:value-of select="." /></span>
</xsl:template>


</xsl:stylesheet>
