package jp.igapyon.jcfa.vo;

import java.util.EmptyStackException;
import java.util.Stack;

import jp.igapyon.jcfa.vo.item.JcfaItem;
import jp.igapyon.jcfa.vo.item.JcfaItemReference;

public class JcfaOperandStack {
	protected final Stack<JcfaItem> operandStack = new Stack<JcfaItem>();

	public void push(final JcfaItem operandStackNode) {
		operandStack.push(operandStackNode);
	}

	public JcfaItem pop() {
		try {
			return operandStack.pop();
		} catch (EmptyStackException ex) {
			ex.printStackTrace();
			return new JcfaItemReference();
		}
	}
}
