package jp.igapyon.jcfa.vo;

import java.util.HashMap;
import java.util.Map;

import jp.igapyon.jcfa.vo.item.JcfaItemLocalVariable;

public class JcfaFrame {
	protected final Map<String, JcfaItemLocalVariable> localVariableMap = new HashMap<String, JcfaItemLocalVariable>();

	protected final JcfaOperandStack operandStack = new JcfaOperandStack();

	public JcfaItemLocalVariable getLocalVariable(final int index) {
		JcfaItemLocalVariable lookup = localVariableMap.get(String
				.valueOf(index));
		if (lookup == null) {
			localVariableMap.put(String.valueOf(index),
					new JcfaItemLocalVariable());
		}
		return localVariableMap.get(String.valueOf(index));

	}

	public void setLocalVariable(final int index,
			final JcfaItemLocalVariable localVariable) {
		localVariableMap.put(String.valueOf(index), localVariable);
	}

	public JcfaOperandStack getOperandStack() {
		return operandStack;
	}
}
