package jp.igapyon.jcfa.vo;

import java.util.ArrayList;
import java.util.List;

public class JcfaClass extends JcfaNode {
	protected String access = "public";

	protected String name;

	protected String extendsName;

	protected boolean isMainClass = true;

	// TODO interfaces

	protected final List<JcfaField> fieldList = new ArrayList<JcfaField>();

	protected final List<JcfaMethod> methodList = new ArrayList<JcfaMethod>();

	public String getAccess() {
		return access;
	}

	public String getExtendsName() {
		return extendsName;
	}

	public List<JcfaField> getFieldList() {
		return fieldList;
	}

	/**
	 * 
	 * @return
	 */
	public String getLocalName() {
		final String[] split = name.split("\\.");
		return split[split.length - 1];
	}

	public List<JcfaMethod> getMethodList() {
		return methodList;
	}

	public String getName() {
		return name;
	}

	public boolean isMainClass() {
		return isMainClass;
	}

	public void setAccess(String access) {
		this.access = access;
	}

	public void setExtendsName(String extendsName) {
		this.extendsName = extendsName;
	}

	public void setMainClass(boolean isMainClass) {
		this.isMainClass = isMainClass;
	}

	public void setName(String name) {
		this.name = name;
	}
}
